#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#define inline __inline

#define PI 3.14159265358979324
#define PI_2 1.57079632679489662
typedef double Double;

static inline Double radN(Double a,Double e, Double sinphi){
	Double x=1-e*sinphi*sinphi;
	return a/sqrt(x);
}
static inline Double Nrho(Double a,Double e, Double sinphi){
	Double x;
	x=(1-e*sinphi*sinphi);
	x*=(1-e)*x*x;
	return x*a*a;
}

//e^(2*PHI)
Double e2PHI(Double e, Double sinphi){
	Double d;
	/*d=ee*log{(1+ee*sinphi)/(1-ee*sinphi)};
	 Calculado con un error absoluto de 10^-11*/
	{Double aux, f;
	aux=e*sinphi; f=aux*sinphi;
	d=0.666666666666666;
	d+=f*0.4; d*=f;
	d+=2; d*=aux;}
	d=exp(-d);
	d*=(1+sinphi)/(1-sinphi);
	return d;
}
//e^(PHI) (la estereogrfica es la exponencial de la Mercator)
//phi puede ser pequeo (estero. de -90)
//Para obtener la de +90, pasar -phi. Pero entonces
//tambin hay que cambiar el signo de los valores de lambda
Double ePHI(Double e, Double phi){
	Double sinphi, d;
	sinphi=sin(phi);
	{Double aux, f;
	aux=e*sinphi; f=aux*sinphi;
	d=0.333333333333333;
	d+=f*0.2; d*=f;
	d+=1; d*=aux;}
	d=exp(-d);
	d*=cos(phi)/(1-sinphi);
	return d;
}
//c=e^(2PHI)
//c=0 --> phi=-90; c=infty-->c=90
#define phi sinphiapprox
Double phi_e2PHI(Double e, Double c,Double phi){
	for(;;){	//phi guarda sin(phi)
		Double b,phip;
		{Double aux, f;
		aux=e*phi; f=aux*phi;
		b=0.666666666666666;
		b+=f*0.4; b*=f;
		b+=2; b*=aux;}
		b=c*exp(b);

		phip=phi;
		phi=(b-1)/(b+1);	//sin(phi)
		if(fabs(phi-phip)<1e-8) break;
	}
	return asin(phi);
}
static inline Double PHI_phi(Double e, Double sinphi){
	Double d=e2PHI(e,sinphi);
	return 0.5*log(d);
}
Double phi_e2PHI(Double e, Double c,Double phi);
static inline Double phi_PHI(Double e, Double PHI){
	Double phi,c;
	c=exp(2*PHI);
	phi=(c-1)/(c+1);	//phi guarda sin(phi)
	return phi_e2PHI(e,c,phi);
}

Double phi_lam(Double a, Double e, Double lam){
	Double A,B,C,D;
	Double e4,e6;
	Double phi;
	e4=e*e;
	e6=e4*e;

	A=1+3/4.0*e+45/64.0*e4+175/256.0*e6;
	B=3/4.0*e+15/16.0*e4+525/512.0*e6;
	C=15/64.0*e4+105/256.0*e6;
	D=35/512.0*e6;

	A=1/A;
	B*=A/2;	C*=A/4;	D*=A/6;

	lam*=A/(a*(1-e));
	phi=lam;
	for(;;){
		Double phip=phi;
		phi=lam+B*sin(2*phip)-C*sin(4*phip)+D*sin(6*phip);
		if(fabs(phip-phi)<1e-8) break;
	}
	return phi;
}
Double k_UTM_GRS80(Double X, Double Y, Double a){
	Double factor;
	Double ka,kb;
	Double a0,a2,a4,a6,a8;
	Double b0,b2;
	Double x2, y2, y4;

	//Constantes para los valores a y e del elipsoide GRS80
	a0=0.01237370;
	a2=-4.1275e-6;
	a4=3.546e-8;
	a6=-1.35e-10;
	a8=3.75e-13;
	b0=2.62e-5;
	b2=-3.53e-8;

	factor=6378137.0/a;	//ajustamos a la 'a' del elip. GRS80.
	factor/=1000000;
	X*=factor;	Y*=factor;

	x2=X*X;
	y2=Y*Y;	y4=y2*y2;

	ka=a0+a2*y2+a4*y4+a6*y4*y2+a8*y4*y4;	ka*=x2;
	kb=b0+b2*y2;									kb*=x2*x2;

	return (1 + ka+kb);
}
Double ajuste_kUTM(Double a, Double e, Double x, Double y){
	Double phi,Nrmio,NrGRS80;

	{Double factor=6378137.0/a;
	x*=factor;		y*=factor;}
	
	phi=phi_lam(6378137.0, e, y);
	Nrmio=Nrho(6378137.0,e,phi);
	phi=phi_lam(6378137.0, 0.00669438, fabs(y));
	if(phi>PI_2) phi=PI_2;
	NrGRS80=Nrho(6378137, 0.00669438,phi);

	return 1+0.5*x*x*(1/Nrmio-1/NrGRS80);
}

static inline Double kUTM_x(Double a,Double e, Double x,Double y,Double k0){
	Double k;
	x/=k0;		y/=k0;
	k=k_UTM_GRS80(x,y,a);
	if(e<0.0066 || e>0.00685) k*=ajuste_kUTM(a,e,x,y);
	return k*k0;
}

typedef struct{
	Double x,y;
} Puntoxy_Double;
#define NAN_D(x) (*((int*)&(x) + 1)=0x7FF00000)

Puntoxy_Double UTM_l_x(Double a,Double e,Puntoxy_Double p){
	Double phipri,N,eta,etat,t;
	Double c, sinp;
	Double xN,xNl,xNf,t4,s;
	Puntoxy_Double pl;

	phipri=phi_lam(a,e,p.y);
	if(phipri>=PI_2 || phipri<=-PI_2){
		NAN_D(pl.x); NAN_D(pl.y);
		return pl;
	}
	sinp=sin(phipri);
	c=cos(phipri);
	pl.y=PHI_phi(e,sinp);
	N=radN(a,e,sinp);
	xN=p.x/N;
	xNl=xN/c;
	c*=c;
	xN*=xN;
	xNf=xN*sinp/(2*c);
	sinp*=sinp;

	{Double aux=e/(1-e);
	eta=c*aux;
	etat=sinp*aux;}
	t=sinp/c;
	t4=t*t;

	pl.x=xNl;
	xNl*=xN/6;
	s=1+2*t+eta;
	pl.x-=xNl*s;
	xNl*=xN/20;
	s=5+28*t+24*t4 +8*etat+3*eta*(2-etat);
	pl.x+=xNl*s;

	pl.y-=xNf;
	xNf*=xN/12;
	s=5+6*t+eta*(1-4*eta);
	pl.y+=xNf*s;
	xNf*=xN/30;
	s=61+180*t+120*t4+48*etat+eta*(46-3*etat);
	pl.y-=xNf*s;

	pl.y=phi_PHI(e,pl.y);
	return pl;
}
Double UTM_conv_l(Double e,Double l,Double phi){
	Double c,eta,x,y;
	Double xx,ls;

	c=cos(phi); c*=c;
	eta=c*e/(1-e);
	xx=l*l;
	ls=l*sin(phi);

	x=1+xx*(c*(2+eta)-1)/2;
	y=1+xx*(c*(6+9*eta+4*eta*eta)-1)/6;
	y*=ls;

	return atan(y/x);
}

int wmain(int argc, wchar_t* argv[]){
	Double  a,e,xO,yS,k0, x,y;
	Double k;

	if(argc<3){
		_putws(L"\nUso del programa: kUTM <X> <Y>\n");
		_putws(L"O bien: kUTM <opciones> <X> <Y>\n");
		_putws(L"La primera forma calcula k para las coordenadas indicadas\n"
			L"y los parmetros por defecto: elipsoide GRS80, escala central 0.9996\n"
			L"desplazamiento X = 500000, desplazamiento Y = 0\n");
		_putws(L"La forma con opciones permite modificar estos parmetros.\n"
			L"Las opciones son las siguientes:\n"
			L"-a <nmero>: indica el semieje mayor del elipsoide (a)\n"
			L"-e <nmero>: primera excentricidad al cuadrado (e^2)\n"
			L"-k0 <nmero>: factor de escala de la proyeccin en el meridiano central\n"
			L"-xO <nmero>: coordenada X de los puntos sobre el meridiano central\n"
			L"-yS <nmero>: coordenada Y de los puntos sobre el Ecuador\n");
		return 0;
	}
#ifdef _DEBUG
	_putws(L"Presione una tecla para continuar...");
	getchar();
#endif


	a=6378137.0;
	e=0.00669438;
	k0=0.9996;
	xO=500000.0;
	yS=0.0;

	if(argc>3){
		wchar_t **argv_fin, **ptr;
		argv_fin=argv+ (argc-2);
		ptr=argv+1;
		while(ptr+1<argv_fin){	//+1 porque no hay opciones sin argumentos
			Double ff;
			wchar_t *arg=*ptr;
			if(arg[0]!=L'-'){ptr+=2; continue;}
			ff=_wtof(ptr[1]);
			if(arg[2]==L'\0'){
				if(arg[1]==L'a') a=ff;
				else if(arg[1]==L'e') e=ff;
			}else if(arg[3]==L'\0'){
				if(arg[1]==L'k' && arg[2]==L'0') k0=ff;
				else if(arg[1]==L'x' && arg[2]==L'O') xO=ff;
				else if(arg[1]==L'y' && arg[2]==L'S') yS=ff;
			}
			ptr+=2;
		}
	}

	x=_wtof(argv[argc-2]);
	y=_wtof(argv[argc-1]);
	x-=xO;
	y-=yS;

	k=kUTM_x(a,e, x,y,k0);
	printf("k= %11.9f\n",k);

	{Puntoxy_Double p;
	p.x=x; p.y=y;
	p=UTM_l_x(a*k0,e,p);
	k=UTM_conv_l(e,p.x,p.y);
	k*=180.0/PI;
	printf("conv= %11.9f (grados W)\n",k);}

	return 0;
}
