#include <stddef.h>
#include <stdio.h>
#include <string.h>
#include "relativa\distorsion.h"
#include "defaultextension.h"

s8int log10n_d(Double x){
	s8int log;
	if(x==0) return -127;
	if(x<0) x=-x;

	/*s8int */log=0;
	while(x<1) x*=10,log--;
	if(x>10){Double y; for(y=10; x>=y; y*=10,log++);}
	return log;
}

int wmain(int argc, wchar_t* argv[]){
	int nret;
	char16_t mensaje[512];
	u8int idioma;
	u8int decim,decf;
	OrientacionInterna interna1, interna2, combinada;
	char16_t fichero1[MAX_PATH], fichero2[MAX_PATH], ficherocom[MAX_PATH];

	idioma=0;
	mensaje[0]=0;
	if(argc<4){
		_putws(L"Uso del programa: CombinaInternas <ficheroprimero> <ficherosegundo> <fichero a generar>\n"
					L"La extensin supuesta por defecto es .int\n");
		return 0;
	}
#ifdef _DEBUG
	_putws(L"Presione una tecla para continuar...");
	getchar();
#endif

	wcsncpy((wchar_t*)fichero1,argv[argc-3],MAX_PATH);
	wcsncpy((wchar_t*)fichero2,argv[argc-2],MAX_PATH);
	wcsncpy((wchar_t*)ficherocom,argv[argc-1],MAX_PATH);
	if(fichero1[MAX_PATH-8] | fichero2[MAX_PATH-8] | ficherocom[MAX_PATH-8]){
		fputws(L"Error. Los nombres de los ficheros son demasiado largos",stderr);
		return 10;
	}
	append_default_ext(fichero1,u"int",4,0);
	append_default_ext(fichero2,u"int",4,0);
	append_default_ext(ficherocom,u"int",4,1);

	nret=lee_ficheroint(fichero1,0,&interna1,mensaje,idioma);
	if(nret){
		_putws(L"Error en el primer fichero:\n");
		_putws((wchar_t*)mensaje);
		free_interna(&interna1);
		return nret;
	}
	nret=lee_ficheroint(fichero2,0,&interna2,mensaje,idioma);
	if(nret){
		_putws(L"Error en el segundo fichero:\n");
		_putws((wchar_t*)mensaje);
		free_interna(&interna2);
		free_interna(&interna1);
		return nret;
	}
	nret=combina_internas(&interna1,&interna2, &combinada);
	if(nret==CAL_COMBINA_DISTINTOS_MODELOS){
		_putws(L"Los modelos polinmicos de ambas internas no coinciden.\nAn as las distorsiones se han combinado, pero el resultado no es exacto\n");
	}else if(nret){
		_putws(L"Las internas no se pueden combinar:\n");
		if(nret==CAL_COMBINA_AFIN2) _putws(L"La segunda interna no puede incluir una transformacin de Coordenadas medidas a fotocoordenadas\n");
		else if(nret==CAL_COMBINA_DISTINTAS) _putws(L"Las relaciones semidiagonal/focal son muy distintas.\n");
		else _putws(L"Error desconocido\n");
		goto salida;
	}

	decf=6-log10n_d(combinada.valI.f);
	if(!(combinada.flags & 1)) decim=decf;
	else{
		float f=combinada.afin_1.a*combinada.afin_1.d-combinada.afin_1.b*combinada.afin_1.c;
		if(f<0) f=-f;
		f/=(float)combinada.valI.f*(float)combinada.valI.f;
		decim=6+log10n_d(f)/2;
		if(f>1) decim++;
	}
	if(decf<0) decf=0;
	if(decim<0) decim=0;
	nret=escribe_ficheroint(ficherocom,&combinada,decim,decf,mensaje,idioma);
	if(nret){
		_putws((wchar_t*)mensaje);
		goto salida;
	}
	nret=0;

salida:
	free_interna(&interna2);
	free_interna(&interna1);
	free_interna(&combinada);
	return nret;
}
