#include <ATcrt/ATmemstr.h>
#include <malloc.h>
#include <stdio.h>
#include <math.h>
#include "defaultextension.h"
#include "relativa/Aerotri_defs_internal.h"
#include "relativa/lecturaf.h"
#include "relativa/distorsion_internal.h"

int wmain(int argc, wchar_t* argv[]){
	int nret;
	char16_t mensaje[512];
	u8int idioma;
	Vector_Fotograma fotogramas;
	Vector_Pesopf pesospf;
	char *nombresf, *nombres;
	uint *puntos;
	uint npuntos;
	u8int mar;
	OrientacionInterna interna;
	char16_t fichero1[MAX_PATH], ficheroint[MAX_PATH], fichero2[MAX_PATH];

	idioma=0;
	mensaje[0]=0;
	if(argc<4){
		fputws(L"Uso del programa: AplicaInterna <fichero ftm> <fichero int> <fichero ftm a generar>\n\n"
			L"A las coordenadas del fichero ftm indicado en primer lugar se aplica la intena de fichero int"
			L" (por ejemplo, reducir al punto principal y corregir la distorsin) y se genera el fichero <fichero ftm a generar>", stdout);
		return 0;
	}
#ifdef _DEBUG
	fputws(L"Presione una tecla para continuar...", stdout);
	getchar();
#endif

	fichero2[MAX_PATH-8]=ficheroint[MAX_PATH-8]=fichero1[MAX_PATH-8]='\0';
	strncpy16(fichero1,(char16_t*)argv[argc-3],MAX_PATH);
	strncpy16(ficheroint,(char16_t*)argv[argc-2],MAX_PATH);
	strncpy16(fichero2,(char16_t*)argv[argc-1],MAX_PATH);
	if(fichero1[MAX_PATH-8] | ficheroint[MAX_PATH-8] | fichero2[MAX_PATH-8]){
		fputws(L"Error. Los nombres de los ficheros son demasiado largos",stderr);
		return 10;
	}
	append_default_ext(fichero1,u"ftm",4,0);
	append_default_ext(ficheroint,u"int",4,1);
	append_default_ext(fichero2,u"ftm",4,1);

	lecturaf_set_globals(0,mensaje,1);
	mar=FOTOSFORMAT_Aerotri;
	nret=lee_ficherof(fichero1,&mar,NULL,0,&fotogramas,&nombresf,&pesospf,&nombres,&puntos,&npuntos,-1.F);
	if(fotogramas.ppio==NULL){
		fputws(L"Error en el fichero de fotogramas:\n",stderr);
		fputws((wchar_t*)mensaje,stderr);
		nret=1;
	}
	if(!nret){
		nret=lee_ficheroint(ficheroint,0,&interna,mensaje,idioma);
		if(nret){
			fputws(L"Error en el fichero de interna:\n",stderr);
			fputws((wchar_t*)mensaje,stderr);
			free_interna(&interna);
			nret=2;
		}
	}
	if(nret){
		if(fotogramas.ppio!=NULL){
			free(puntos);	free(nombres);		free(nombresf);
			free(fotogramas.ppio);
		}
		return nret;
	}

	{durchVectori(Fotograma,fotogramas) ptri->nom=nombresf+ptri->index;}
	{durchVectori(Pesopf,pesospf) ptri->nom=nombresf+ptri->index;}
	{durchVectori(Fotograma,fotogramas){
		medida_a_fotocoord_Foto(ptri,&interna);
		ptri->focal=interna.valI.f;
	}}
	nret=escribe_ftm(fichero2,fotogramas.ppio,nombres,puntos,fotogramas.n,pesospf.ppio,pesospf.n,-1.F,1);
	freeif(pesospf.ppio);
	free(puntos); free(nombres); free(nombresf);
	{durchVectori(Fotograma,fotogramas) free(ptri->puntos.ppio);}
	free(fotogramas.ppio);

	if(nret){
		fputws(L"Error al escribir el fichero de fotogramas a generar:\n",stderr);
		fputws((wchar_t*)mensaje,stderr);
		return 3;
	}

	return 0;
}
