#include "hasp_api.h"
#ifndef _WIN64
#pragma comment(lib,"..\\relativa\\Llaves\\hasp_windows_115231.lib")
#else
#pragma comment(lib,"..\\relativa\\Llaves\\hasp_windows_x64_115231.lib")
#endif

#define HASP_POS_ID				0	//ROM
#define HASP_POS_CLIENTE		4	//ROM
#define HASP_SIZEOF_CLIENTE	54	//ROM
#define HASP_LEN_CLIENTE		108 //ROM
#define HASP_POS_EXPIRACION	0
#define HASP_POS_FEATURES	4	//La informacin de cada feature ocupa 4 bytes.
typedef uint Hasp_Feature;	//El ms alto es el nmero de versin -2000.
#define HASP_LEN_FEATURE		4	//El resto, una limitacin especfica.

//HASP_FEATURE_NINGUNA se usa si lo nico que se quiere ver es si hay llave
//Datos de tipo hasp_feature_t (uint)
#define HASP_FEATURE_NINGUNA	0
#define HASP_FEATURE_AEROTRI	1
#define HASP_FEATURE_MAX HASP_FEATURE_AEROTRI
typedef struct{
	hasp_handle_t handle;
	hasp_feature_t feature;	//feature para la cual se hace login a la llave
	hasp_status_t error_code;
} LlaveHasp;

#define HASP_ERROR_LECTURA 10	//Error genrico de lectura en la llave, usado por mis funciones
/* return:
	0: Todo bien
	AT_NOMEM
	1: No se encuentra la llave o los drivers
	2: Hay llave vlida pero no se puede hacer login
	3: La llave no permite el uso de 'feature'
	HASP_ERROR_LECTURA: Error desconocido
	En caso de error se guarda el mensaje de error en mens_err
*/
int AbreLlave(LlaveHasp* llave, const char** mensj){
	int nret;
	if(mensj!=NULL) *mensj=NULL;

	unsigned char vendor_code[]=
"JFFWd+8EQW/kewQY9rtOossQ45DiYhCLp2L6h2Q0zDNDBo06p9OlCEUC2T4/o+/aFHwtV1D+S12OUq0A"
"H/1tAHH/fT0Y5gUMe0y0FyF9txJBuCJiS0ARdDym0ur6X47DStVTM+RWR/ouNgyZZ5xTig2nYFZB+IBQ"
"0/CG9wI14Bb6tbqNwsPCThW8yVA6owr/PuiFDTSBqU/HiG+OfTdRZSvmke/TU3cpfbcCMRTn1n3Dc25x"
//"0/cg9Wi14bB6TBQnWSpctHw8Yva6OWR/pUIfdtsbQu/hIg+oFtDrzsVMKE/tu3CPFBCcmrtN1N3dC25X"
"gh10lZP7zc4P9jfUtp3u/vlq5y/oejFeWIpdszWjvx5LL31r/pDb8IkYYgQW3VlWPfOAamghy6yhdhNM"
"dC5STRaN5soqIVOiKx06Oz+idmwYCXd2DrCOrfFUzU6ZgxxCkM8z/Io6Z3/wEKwaE8uGO/ox0AFKJHYL"
"RBEPi5tx2PMfVsKcETFp+WJyG5ngrJe2+WYKpi9zc8/03cOI4ytTDsrnVJjUGLLgpEQV19YUvOgIuKJV"
"UjpR+bOZAEWdWggk88zN0024f2L2dvx23/6mDXI1egyCCsnvak/ttLmnmXdU746Dr/jsv5qPU4CDgM3m"
"84EtwRi5GYHaw8+8FFSR4tw5BLBKk0RhhF3YZ/R+08ZAQvmtXMC3NlXGcXfHEmlau0wdDRMkcdu/13oY"
"z4iEEG6eAQqa5tXqEiZ+bA3lf96EdDOdvEslExwHLrrtR1IZcUs2nlHKzKYfLMRHNs1MSIyifExsViqM"
"bnP9LmYYehBZ6TLXpGYcBuxDDnPw9CqnYI9OSNQuXnW3NIRWyGxjnKcSUCTayC3IOQETTsvOXmDgKeIg"
"lSc+bOx1VprhiD0N8bXe2D31kXRKGRNOAw8/7aAqbFQsq9zskgbs/cXSWSBtvmb+YCba8mWqTPVdzux6"
"oPZhvz72vnEQZgwET93hah3I6AXEiyb65kvOFlA8eqMhwq+dptcOnTPC0Og=";

	const uint n=64;
	u8int c;
	for(cint i=n-1;i>0;i--){
		uint j=(n|0x80)+i-(n>>1);
		c=vendor_code[j];	//160+i
		c>>=6;	c<<=5;	//100000 si c>=0x40
		vendor_code[j]^=c;
		i+=n;
		if(i!=80) i%=80;
	}

	nret=0;
	llave->error_code=hasp_login(llave->feature, vendor_code, &llave->handle);
	if(llave->error_code != HASP_STATUS_OK){
		const char *s;
		switch(llave->error_code){
		case HASP_INSUF_MEM:	s="El programa se ha quedado sin memoria al intentar acceder a la llave"; nret=AT_NOMEM; break;
		case HASP_HASP_NOT_FOUND:	s="No se encuentra la llave"; nret=1; break;
		case HASP_UNKNOWN_VCODE:
		case HASP_INV_VCODE:	s="La llave de proteccin no es una llave de Aertri"; nret=1; break;
		case HASP_NO_DRIVER:	s="Los drivers de la llave de proteccin no estn instalados"; nret=1; break;
		case HASP_OLD_DRIVER:	s="El driver de la llave de proteccin instalado en el equipo es demasiado antiguo"; nret=1; break;
		case HASP_NO_VLIB:
		case HASP_INV_VLIB:		s="La biblioteca tiempo de ejecucin no est instalada o no es vlida"; nret=1; break;
		case HASP_OLD_VLIB:		s="La biblioteca tiempo de ejecucin es demasiado antigua"; nret=1; break;
		case HASP_OLD_LM:			s="El administrador de licencias de Sentinel Hasp es demasiado antiguo"; nret=1; break;
		case HASP_LOCAL_COMM_ERR:	s="Se produjo un error en la comunicacin entre el programa y el administrador de licencias del equipo.\nTal vez el servicio se encuentre detenido"; nret=1; break;
		case HASP_REMOTE_COMM_ERR:	s="Se produjo un error en la comunicacin entre el administrador de licencias local y un administrador remoto"; nret=1; break;
		case HASP_TMOF:
		case HASP_TOO_MANY_USERS:	s="No se pueden realizar ms conexiones simultneas a la llave de proteccin"; nret=2; break;
		case HASP_TS_DETECTED:			s="Se ha detectado que el programa est ejecutndose remotamente en una sesin de Terminal Server"; nret=2; break;
		case HASP_DEVICE_ERR:			s="Se produjo un error en la comunicacin con la llave a travs del puerto USB"; nret=2; break;
		case HASP_FEATURE_NOT_FOUND:
		case HASP_FEATURE_TYPE_NOT_IMPL: s="Esta llave no permite el uso de este programa"; nret=3; break;
		default: s="Error desconocido al intentar acceder a la llave de proteccin"; nret=HASP_ERROR_LECTURA;
		}
		if(mensj!=NULL) *mensj=s;
	}
	return nret;
}

//Llamar si la funcin AbreLlave devolvi 0 o >=4. En caso contrario devolver HASP_INV_HND
sinline int CierraLlave(LlaveHasp* llave){
	llave->error_code=hasp_logout(llave->handle);
	if(llave->error_code==HASP_STATUS_OK || llave->error_code==HASP_INV_HND) return 0;
	else return 1;
}

//File should be one of HASP_FILEID_RO or HASP_FILEID_RW

sinline uint hasp_lee_uint(LlaveHasp *llave, hasp_fileid_t file, hasp_size_t pos){
	uint data;
	llave->error_code=hasp_read(llave->handle, file, pos, 4, &data);
	return data;
}
//inline void hasp_lee_string8(LlaveHasp *llave, hasp_fileid_t file, hasp_size_t pos, hasp_size_t n, char* s1){
//	llave->error_code=hasp_read(llave->handle, file, pos, n, s1);
//}
sinline void hasp_lee_string16(LlaveHasp *llave, hasp_fileid_t file, hasp_size_t pos, hasp_size_t n, wchar_t* s1){
	llave->error_code=hasp_read(llave->handle, file, pos, n<<1, s1);
}

sinline void hasp_set_uint(LlaveHasp *llave, hasp_size_t pos,uint valor){
	llave->error_code= hasp_write(llave->handle,HASP_FILEID_RW, (hasp_size_t)pos, 2, &valor);		
}

/****  Lectura de datos especficos de las llaves de Aerotri   ****/
/*Id de llave:
<100: Uso interno
101 - 999: Llaves especiales (para universidades u otros organismos). Con fecha de caducidad
1001 - ... : Llaves normales*/
#define hasp_get_Id(llave) hasp_lee_uint(llave,HASP_FILEID_RO,HASP_POS_ID);

sinline void hasp_get_cliente(LlaveHasp *llave, wchar_t* cliente){
	hasp_lee_string16(llave,HASP_FILEID_RO,HASP_POS_CLIENTE,HASP_SIZEOF_CLIENTE,cliente);
	cliente[HASP_SIZEOF_CLIENTE-1]=L'\0';
}
sinline u16int hasp_get_expiracion(LlaveHasp *llave){
	uint k=hasp_lee_uint(llave,HASP_FILEID_RW, HASP_POS_EXPIRACION);
	return (u16int)(k&0xFFFF);
}
sinline Hasp_Feature hasp_get_feature(LlaveHasp *llave, uint i){
	if(i==HASP_FEATURE_NINGUNA || i>HASP_FEATURE_MAX) return 0;
	return hasp_lee_uint(llave,HASP_FILEID_RW, HASP_POS_FEATURES+HASP_LEN_FEATURE*(i-1));
}

void Hasp_inutiliza(LlaveHasp *llave){
	uint k=hasp_lee_uint(llave,HASP_FILEID_RW, HASP_POS_EXPIRACION);
	k|=0x8000;
	hasp_set_uint(llave,HASP_POS_EXPIRACION,k);
}

//enero=1, feb.=2, etc.
//el valor devuelto ha de ser menor de 2^16. En el 2170 Aerotri
//llevar tiempo siendo libre
sinline u16int dias_llave_Aerotri(u16int year, u8int mes, u8int dia){
	return (u16int)((u8int)(year-2000)*384+(mes-1)*32+dia);
}

typedef struct{
	uint Id;	//ROM.
	wchar_t cliente[HASP_SIZEOF_CLIENTE];	//ROM. Nombre del cliente, en Unicode
	u16int expiracion;	//el bit ms alto indica si est anulada. El resto, fecha de expiracin segn dias_llave_Aerotri
	Hasp_Feature features[HASP_FEATURE_MAX+1];
} DatosLlave;

#define Hasp_llave_anulada(llave) (((llave)->expiracion&0x8000)!=0)
#define Hasp_llave_fechalimite(llave) ((u16int)((llave)->expiracion&0x7FFF))
#define Hasp_feature_vermax(feature) ((u8int)((feature)>>24))
#define Hasp_feature_limite(feature) ((feature)&0xFFFFFF)
#define Hasp_feature_set_vermax(feature,ver) (feature)=((feature)&0xFFFFFF)|(ver<<24)

void hasp_obtiene_datosllave(LlaveHasp *haspHl, DatosLlave *llave){
	zeroset(llave,sizeof(DatosLlave));

	llave->Id= hasp_get_Id(haspHl);
	hasp_get_cliente(haspHl,llave->cliente);
	llave->expiracion= hasp_get_expiracion(haspHl);

	Hasp_Feature *ptr=llave->features+1;
	for(uint i=1; i<=HASP_FEATURE_MAX; i++, ptr++){
		*ptr=hasp_get_feature(haspHl,i);
	}
}
