#include <Iphlpapi.h>
#pragma comment(lib, "Iphlpapi")
#pragma comment(lib,"shell32.lib")

//From shlobj.h
#define SHFOLDERAPI     EXTERN_C __declspec(dllimport) HRESULT __stdcall

#define CSIDL_PROGRAM_FILES_COMMON 0x002b     //C:\Program Files\Common
typedef enum{
    SHGFP_TYPE_CURRENT=0,	//current value for user, verify it exists
    SHGFP_TYPE_DEFAULT=1,	//default value, may not exist
} SHGFP_TYPE;

SHFOLDERAPI SHGetFolderPathW(HWND hwnd, int csidl, HANDLE hToken, DWORD dwFlags, LPWSTR pszPath);
//End of code taken from shlobj

bint LocalizaMAC(const BYTE* Address){
	IP_ADAPTER_INFO *pAdptInfo= NULL, *pNextAd= NULL;	
	ULONG ulLen= 0;

	DWORD erradapt;
	erradapt= ::GetAdaptersInfo(pAdptInfo, &ulLen);
	if(erradapt==ERROR_BUFFER_OVERFLOW){
		pAdptInfo= (IP_ADAPTER_INFO*)n_malloc(char,ulLen);
		erradapt= ::GetAdaptersInfo(pAdptInfo, &ulLen);		
	}

	pNextAd = pAdptInfo;
	while(pNextAd){
		if(pNextAd->Type & MIB_IF_TYPE_ETHERNET){
			if( !memcmp(Address, pNextAd->Address, MAX_ADAPTER_ADDRESS_LENGTH*sizeof(BYTE))){
				free(pAdptInfo);
				return true;
			}
		}
		pNextAd = pNextAd->Next;
	}
	free(pAdptInfo);
	return false;
}

DWORD GetNumeroSerieDiscoC(){
	TCHAR VolumeNameBuffer[256];
	TCHAR szFileSystemNameBuffer[256];
	DWORD numero_serie=0,
				maxComponentLength=0,
				flags=0;
	if(!GetVolumeInformation("c:\\", VolumeNameBuffer,256,
		&numero_serie, &maxComponentLength, &flags, 	szFileSystemNameBuffer,256))
		return -1;

	return numero_serie;
}

/*La direccin de la primera tarjeta MAC se guarda en address, que tiene que
tener espacio para MAX_ADAPTER_ADDRESS_LENGTH BYTEs.
Si no se encuentra se devuelve 0xFFFF...*/
void getMACaddress(BYTE* address){
	IP_ADAPTER_INFO *pAdapters= NULL;	
	ULONG k=0;

	GetAdaptersInfo(pAdapters, &k);  //como k es 0, sets k
	pAdapters=(IP_ADAPTER_INFO*)malloc(k);
	if(pAdapters==NULL) goto nomem;
	GetAdaptersInfo(pAdapters, &k);		

	IP_ADAPTER_INFO *ptr=pAdapters;
	while(ptr!=NULL){
		if(ptr->Type & MIB_IF_TYPE_ETHERNET){
			memcpy(address, ptr->Address, MAX_ADAPTER_ADDRESS_LENGTH*usizeof(BYTE));
			free(pAdapters);
			return;
		}
		ptr=ptr->Next;
	}
	free(pAdapters);
nomem:
	oneset(address,MAX_ADAPTER_ADDRESS_LENGTH*usizeof(BYTE));
}

typedef struct{
	DWORD dwVolumeSerialNumber;
	BYTE Address[MAX_ADAPTER_ADDRESS_LENGTH];
} DatosOrdenador;

typedef struct{
	DatosOrdenador ordenador;
	DatosLlave llave;
} LlaveyOrdenador;

typedef struct{
	DatosOrdenador ordenador;
	uint Id;
	Hasp_Feature features[HASP_FEATURE_MAX+1];
} ArchivodeLicencia;

/*Lee los valores del ordenador.*/
void licencia_obtienedeOrdenador(DatosOrdenador *ordenador){
	zeroset(ordenador,sizeof(DatosOrdenador));
	ordenador->dwVolumeSerialNumber=GetNumeroSerieDiscoC();	//-1 si se produce algn error
	getMACaddress(ordenador->Address);
}

/*Carga un archivo de licencia y guarda los datos desencriptados
	0: Todo bien
	1: No se encuentra la llave
	2: No se encuentra el archivo
	3: Error al leer el archivo
	4: Error en la llave o error al desencriptar
*/
int CargaArchivoLicencia(wchar_t* ruta, ArchivodeLicencia *larchivo){
	LlaveHasp llave;
	uint nllave;
	uint encriptado[512];
	wchar_t nombre[MAX_PATH];
	wchar_t *ptr;
	uint* pbase;
	int nret=0;

	llave.feature=HASP_FEATURE_NINGUNA;
	int login=AbreLlave(&llave,NULL);
	if(login){nret=1; goto salida;}
	nllave=hasp_get_Id(&llave);
	if(llave.error_code || nllave>64000){nret=4; goto salida;}

	ptr=_wstrpcpy(nombre,ruta);
	if(ptr+10>nombre+MAX_PATH){nret=3; goto salida;}
	*ptr++=L'.';
	ptr=AT_uitowstr(ptr,nllave);
	*ptr=L'\0';

	pbase=NULL;
	nret=biopen_w(&pbase,nombre);
	if(nret<0){
		freeif(pbase);
		nret=2; goto salida;
	}else{nret=0;}

	memcpy_uint(&encriptado,pbase,sizeof(encriptado)/sizeof(uint));
	free(pbase);

	hasp_decrypt(llave.handle,&encriptado, sizeof(encriptado));
	if(llave.error_code){nret=4; goto salida;}
	memcpy(larchivo,encriptado,sizeof(ArchivodeLicencia));

salida:
	if(login==0 || login>=4) hasp_logout(llave.handle);
	return nret;
}

//Compara los datos del archivo con los provenientes del ordenador y con el nmero de llave
bint ArchivoLicencia_ComparaConHardware(ArchivodeLicencia *larchivo, LlaveyOrdenador *hardware){
	if(hardware->ordenador.dwVolumeSerialNumber!=larchivo->ordenador.dwVolumeSerialNumber) return 1;
	if(!LocalizaMAC(larchivo->ordenador.Address)) return 1;
	if(hardware->llave.Id!=larchivo->Id) return 1;
	return 0;
}
bint ArchivoLicencia_FeaturePermitida(ArchivodeLicencia *larchivo, uint feature){
	if(feature>HASP_FEATURE_MAX) return 1;
	if(VERSION>Hasp_feature_vermax(larchivo->features[feature])) return 1;
	return 0;
}
