using System;
using System.Windows.Forms;
using System.Drawing;
using System.Runtime.InteropServices;
using ControlesAt;

namespace Aerotri
{
	/// <summary>
	/// Genera un fichero .ori aproximado a partir de datos GPS y valores aproximados.
	/// </summary>
	public class FormTrGpsOri : ControlesAt.FormAerotri
	{
		private ControlesAt.BaseLabel Label1, Label2, Label3;
		private ControlesAt.TxtBotAbrir TxtBotfot1;
		private ControlesAt.TxtBotAbrir TxtBotfot2;
		private ControlesAt.TxtBotAbrir TxtBotori;
		private ControlesAt.Labeltf  Tffot1, Tffot2, Tfori, Tfuni2;
		private System.Windows.Forms.OpenFileDialog Open1;
		private System.Windows.Forms.SaveFileDialog Save1;
		private ControlesAt.BotAceptar Transformar;

		byte idioma;
		PanelAerotri PanelPadre;
		public FormTrGpsOri(PanelAerotri Form1)
		{
			InitializeComponent();
			PanelPadre=Form1;
			this.AcceptButton=Transformar;
			Tffot1.tipof=2; Tffot2.tipof=1;
			Tfuni2.tipof=2;
			colores();
		}

	#region InitializeComponent
		private void InitializeComponent()
		{
			Label1= new BaseLabel();
			Label2= new BaseLabel();
			Label3= new BaseLabel();
			TxtBotfot1= new TxtBotAbrir();
			TxtBotfot2= new TxtBotAbrir();
			TxtBotori= new TxtBotAbrir();
			Tffot1= new Labeltf(3);
			Tffot2= new Labeltf(2);
			Tfori= new Labeltf(1);
			Tfuni2= new Labeltf(3);
			Transformar= new BotAceptar();
			Save1= new SaveFileDialog();
			Open1= new OpenFileDialog();
			this.SuspendLayout();
			//
			// Label1, 2, 3
			//
			Label1.RefLocation= new Point(12, 10);			Label1.TabIndex= 0;
			Label2.RefLocation= new Point(248, 10);		Label2.TabIndex= 1;
			Label3.RefLocation= new Point(132, 98);		Label3.TabIndex= 7;
			Label1.Font= new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold);
			Label2.Font= Label1.Font;
			Label3.Font= Label1.Font;
			//
			// TxtBotfot1, 2, ori
			//
			TxtBotfot1.Location= new Point(8, 32);			TxtBotfot1.TabIndex= 2;
			TxtBotfot2.Location= new Point(244, 32);		TxtBotfot2.TabIndex= 3;
			TxtBotori.Location= new Point(128, 120);		TxtBotori.TabIndex= 8;
			TxtBotfot2.Bot.Click+=new EventHandler(TxtBotfot2_Click);
			TxtBotfot1.Bot.Click+=new EventHandler(TxtBotfot1_Click);
			TxtBotori.Bot.Click+=new EventHandler(TxtBotori_Click);
			//
			// Tffot1, 2, ori
			//
			Tffot1.Location= new Point(60, 60);		Tffot1.Width=92;		Tffot1.TabIndex= 4;
			Tffot2.Location= new Point(296, 60);	Tffot2.Width=92;		Tffot2.TabIndex= 5;
			Tfori.Location= new Point(128, 148);	Tfori.Width=92;			Tfori.TabIndex= 9;
			Tfori.Visible=false;
			//
			// Tfuni2
			//
			Tfuni2.Location= new Point(276, 80);	Tfuni2.Width=112;		Tfuni2.TabIndex= 6;
			//
			// Transformar
			//
			Transformar.Location= new Point(176, 164);
			Transformar.Size= new Size(84, 24);
			Transformar.TabIndex= 10;
			Transformar.Click+= new System.EventHandler(Transformar_Click);
			//
			// FormGpsaori
			//
			this.AutoScaleBaseSize= new Size(5, 13);
			this.ClientSize= new Size(436, 207);
			this.Controls.Add(Transformar);
			this.Controls.Add(TxtBotori);
			this.Controls.Add(Label3);
			this.Controls.Add(Tfuni2);
			this.Controls.Add(Tffot1);
			this.Controls.Add(Tffot2);
			this.Controls.Add(TxtBotfot1);
			this.Controls.Add(TxtBotfot2);
			this.Controls.Add(Label1);
			this.Controls.Add(Label2);
			this.FormBorderStyle= FormBorderStyle.FixedSingle;
			this.Icon= new System.Drawing.Icon(System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("Aerotri.Iconos.IconAerotri.ico"));
			this.MaximizeBox= false;
			this.Name= "FormTrGpsOri";
			this.ShowInTaskbar=false;
			this.Load+= new System.EventHandler(FormTrFotogramas_Load);
			this.Closing+=new System.ComponentModel.CancelEventHandler(FormTrFotogramas_Closing);
			this.ResumeLayout(false);
		}
	#endregion

		private void FormTrFotogramas_Load(object sender, System.EventArgs e){
			idioma=PanelPadre.Idioma;
			idiomas();
		}
		private void FormTrFotogramas_Closing(object sender, System.ComponentModel.CancelEventArgs e){
			e.Cancel=true;
			this.Hide();
		}

	#region Abrir
		private void TxtBotfot1_Click(object sender, EventArgs e){
			PanelPadre.ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotfot1,Tffot1,Open1, ref PanelPadre.ConfigPrograma.OpenPath,new SetFilterDelegate(SetFilter1));
			PanelPadre.ahora_no_se_puede_cerrar=0;
		}
		private void TxtBotfot2_Click(object sender, EventArgs e){
			PanelPadre.ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotfot2,Tffot2,Open1, ref PanelPadre.ConfigPrograma.OpenPath,new SetFilterDelegate(SetFilter2));
			PanelPadre.ahora_no_se_puede_cerrar=0;
		}
		private void TxtBotori_Click(object sender, EventArgs e){
			PanelPadre.ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotori,Tfori,Save1, ref PanelPadre.ConfigPrograma.OpenPath,new SetFilterDelegate(SetFilter3));
			PanelPadre.ahora_no_se_puede_cerrar=0;
		}
		private void SetFilter1(FileDialog Open1){
			switch(idioma){
				case 1:  Open1.Filter="Not marked files (*.gps)|*.gps|Marked files (*.gpm)|*.gpm|New marked files (*.gpn)|*.gpn|Text files (*.txt)|*.txt|All files (*.*)|*.*"; break;
				case 2:  Open1.Filter="File senza segnare (*.gps)|*.gps|File segnati (*.gpm)|*.gpm|Nuovi file segnati (*.gpn)|*.gpn|File di Testo (*.txt)|*.txt|Tutti i file (*.*)|*.*"; break;
				default:Open1.Filter="Ficheros sin marcar (*.gps)|*.gps|Ficheros marcados (*.gpm)|*.gpm|Nuevos ficheros marcados (*.gpn)|*.gpn|Ficheros de Texto (*.txt)|*.txt|Todos los ficheros (*.*)|*.*"; break;
			}
		}
		private void SetFilter2(FileDialog Open1){
			switch(idioma){
				case 1:  Open1.Filter="Not marked files (*.apr)|*.apr|Marked prm files (*.prm, *.ajs)|*.prm; *.ajs|Text files (*.txt)|*.txt|All files (*.*)|*.*"; break;
				case 2:  Open1.Filter="File senza segnare (*.apr)|*.apr|File segnati prm (*.prm, *.ajs)|*.prm; *.ajs|File di Testo (*.txt)|*.txt|Tutti i file (*.*)|*.*"; break;
				default:Open1.Filter="Ficheros sin marcar (*.apr)|*.apr|Ficheros marcados prm (*.prm, *.ajs)|*.prm; *.ajs|Ficheros de Texto (*.txt)|*.txt|Todos los ficheros (*.*)|*.*"; break;
			}
		}
		private void SetFilter3(FileDialog Open1){
			switch(idioma){
				case 1:  Open1.Filter="PATB ori files (*.ori)|*.ori|All files (*.*)|*.*"; break;
				case 2:  Open1.Filter="File senza segnare (*.ori)|*.ori|Tutti i file (*.*)|*.*"; break;
				default:Open1.Filter="Ficheros sin marcar (*.ori)|*.ori|Todos los ficheros (*.*)|*.*"; break;
			}
		}
	#endregion

		private void Transformar_Click(object sender, System.EventArgs e){
			int returned;
			System.IntPtr P_fotos1, P_fotos2, P_ori;
			string mensaje;
			System.IntPtr P_mensaje;
			byte tf1, tf2;

			if(TxtBotfot1.Text1.Text=="" || TxtBotfot1.Text1.Text==""){
				PanelPadre.MessageBoxAT.Show(textos(2)); return;
			}
			if(Tffot2.tipof!=2){
				if(System.IO.Path.GetExtension(TxtBotfot2.Text1.Text)==".gpn"){
					PanelPadre.MessageBoxAT.Show(textos(16)); return;
				}
			}
			if(Tffot2.tipof!=1){
				if(System.IO.Path.GetExtension(TxtBotfot2.Text1.Text)==".prm"){
					PanelPadre.MessageBoxAT.Show(textos(14)); return;
				}
			}

			PanelPadre.ahora_no_se_puede_cerrar=1;
			P_mensaje=Marshal.AllocHGlobal(512);
			P_fotos1=Marshal.StringToHGlobalAnsi(TxtBotfot1.Text1.Text);
			P_fotos2=Marshal.StringToHGlobalAnsi(TxtBotfot2.Text1.Text);
			tf1=Tffot1.tipof;
			tf2=Tffot2.tipof;
			P_ori=Marshal.StringToHGlobalAnsi(TxtBotori.Text1.Text);

			try{
				returned=InterComAerotri.Trficheros_gpsori(P_fotos1,tf1, P_fotos2,(sbyte)tf2, (sbyte)Tfuni2.tipof, P_ori, P_mensaje,idioma);
			}catch(System.DllNotFoundException){
				returned=-2;
			}
			PanelPadre.set_message(PanelPadre.mensaje_pordefecto);
			if(returned!=-1){
				if(returned==-2) mensaje=textos(1);
				else if(returned==0) mensaje=textos(0);
				else mensaje=Marshal.PtrToStringAnsi(P_mensaje);
				PanelPadre.MessageBoxAT.Show(mensaje);
			}

			Marshal.FreeHGlobal(P_fotos1);
			Marshal.FreeHGlobal(P_fotos2);
			Marshal.FreeHGlobal(P_ori);
			Marshal.FreeHGlobal(P_mensaje);
			PanelPadre.ahora_no_se_puede_cerrar=0;
		}

		void colores(){
			this.BackColor= Color.FromArgb(Globales.Colores.color0);
			Transformar.BackColor= Color.FromArgb(Globales.Colores.color6);
		}

		void idiomas(){
			switch(PanelPadre.Idioma){
			 case 1:
				this.Text= "Transformation of files: GPS+approximate values --> .ori";
				Label1.Text= "GPS file";
				Label2.Text= "Approximate values file";
				Label3.Text= "Ori file to be created";
				Transformar.Text= "Generate .ori";
				Tffot1.set_textos(new string[]{"Not marked","Marked","Aerotri"});
				Tffot2.set_textos(new string[]{"Not marked","Marked"});
				Tfuni2.set_textos(new string[]{"Radians","Centesimal d.","Sexagesimal d."});
				Transformar.Text= "Generate ori";
				break;
			 case 2:
				this.Text= "Trasformazione di file: GPS+valori approssimati --> .ori";
				Label1.Text= "File di GPS";
				Label2.Text= "File di valori approssimati";
				Label3.Text= "File ori da generare";
				Transformar.Text= "Generare .ori";
				Tffot1.set_textos(new string[]{"No segnato","Segnato","Aerotri"});
				Tffot2.set_textos(new string[]{"No segnato","Segnato"});
				Tfuni2.set_textos(new string[]{"Radianti","G. centesimali","G. sessagesimali"});
				Transformar.Text= "Genera ori";
				break;
			 default:
				this.Text= "Transformacin de ficheros: GPS+valores aproximados --> .ori";
				Label1.Text= "Fichero de GPS";
				Label2.Text= "Fichero de valores aproximados";
				Label3.Text= "Fichero ori a generar";
				Transformar.Text= "Generar .ori";
				Tffot1.set_textos(new string[]{"Sin marcar","Marcado","Aerotri"});
				Tffot2.set_textos(new string[]{"Sin marcar","Marcado"});
				Tfuni2.set_textos(new string[]{"Radianes","G. centesimales","G. sexagesimales"});
				Transformar.Text= "Generar ori";
				break;
			}
			Tffot1.actualiza();
			Tffot2.actualiza();
			Tfuni2.actualiza();
		}
		private string textos(short i){
			string txt="";
			switch(idioma){
			 case 1:
				switch(i){
					case 0 : txt="Task finished"; break;
					case 1:  txt="The file transfficheros.dll couldn't be opened"; break;
					case 2 : txt="The three files have to be specified"; break;
					case 14: txt= "The extension prm can only be used with marked files"; break;
					case 16: txt= "The extension gpn can only be used with new marked files"; break;
				}
				break;
			 case 2:
				switch(i){
					case 0:  txt="Compito finito"; break;
					case 1:  txt="Non  possibile aprire il file transfficheros.dll"; break;
					case 2:  txt="Deve indicare i tre file"; break;
					case 14: txt= "L'estensione prm solo pu utilizzarsi con file segnati"; break;
					case 16: txt= "L'estensione gpn solo pu utilizzarsi con file segnati"; break;
				}
				break;
			 default:
				switch(i){
					case 0:  txt="Tarea terminada"; break;
					case 1:  txt="No se ha podido abrir el fichero transfficheros.dll"; break;
					case 2:  txt="Debe indicar los tres ficheros"; break;
					case 14: txt= "La extensin prm est reservada a ficheros marcados"; break;
					case 16: txt= "La extensin gpn est reservada a ficheros \"marcados nuevos\""; break;
				}
				break;
			}
			return txt;
		}
	}
}
