//#include <iostream>
//#include <tchar.h>
#include "system.h"
#include <cmath>
#include <malloc.h>
#include "Aerotri_defs.h"
#include "clases.h"
#include "correlacion.h"

int main(int argc, char* argv[]){
	char *ficherogps="ARCOS_ETRS89.gpn";
	s8int gpm=2;	//2: Aerotri; 4: AeroOffice
	s8int uni=2;	//0: radianes; 1: Grados centesimales; 2: Grados sexagesimales
	bint signoins=1;
	float ZsobreTerr=4400.0F;
	float focal=100.500;
	Puntoxy_float nw,ne,sw,se;
	nw.x=-33.912F;		nw.y=51.95F;
	ne.x=33.912F;		ne.y=51.95F;
	sw.x=-33.912F;		sw.y=-51.95F;
	se.x=-33.912F;		se.y=-51.95F;
	char mensaje[512];
	Aerotri::Correlacion::lee_gps_Devuelto dev;
	int nret;

	nret=Aerotri::Correlacion::lee_gps_y_organiza(ficherogps, gpm, uni, signoins, ZsobreTerr, focal, nw, ne, sw, se, &dev, mensaje, 0);
	if(nret!=0){
		Aerotri::Correlacion::libera_todo();
	}

	Puntoxy_double zonas[9];
	zonas[0].x=nw.x*0.8;	zonas[0].y=0;
	zonas[1].x=nw.x*0.8;	zonas[1].y=nw.y*0.8;
	zonas[2].x=sw.x*0.8;	zonas[2].y=sw.y*0.8;
	zonas[3].x=0;				zonas[3].y=0;
	zonas[4].x=0;				zonas[4].y=nw.y*0.8;
	zonas[5].x=0;				zonas[5].y=sw.y*0.8;
	zonas[6].x=ne.x*0.8;		zonas[6].y=0;
	zonas[7].x=ne.x*0.8;		zonas[7].y=ne.y*0.8;
	zonas[8].x=se.x*0.8;		zonas[8].y=se.y*0.8;

	durchlaufei(Vector_uint,dev.pares,dev.gpss.n){
		PuntoXYZM C1= *(PuntoXYZM*)&dev.gpss.ppio[ptri-dev.pares].P;
		durchVectorj(uint,*ptri){
			Aerotri::Correlacion::punto_homologo_Devuelto par;
			PuntoXYZM C2= *(PuntoXYZM*)&dev.gpss.ppio[*ptrj].P;
			Aerotri::Correlacion::punto_homologo(&C1,focal,&C2,focal,zonas[0],0,100,300,&par);
			Aerotri::Correlacion::punto_homologo(&C1,focal,&C2,focal,zonas[1],0,100,300,&par);
			Aerotri::Correlacion::punto_homologo(&C1,focal,&C2,focal,zonas[2],0,100,300,&par);
			Aerotri::Correlacion::punto_homologo(&C1,focal,&C2,focal,zonas[3],0,100,300,&par);
			Aerotri::Correlacion::punto_homologo(&C1,focal,&C2,focal,zonas[4],0,100,300,&par);
			Aerotri::Correlacion::punto_homologo(&C1,focal,&C2,focal,zonas[5],0,100,300,&par);
			Aerotri::Correlacion::punto_homologo(&C1,focal,&C2,focal,zonas[6],0,100,300,&par);
			Aerotri::Correlacion::punto_homologo(&C1,focal,&C2,focal,zonas[7],0,100,300,&par);
			Aerotri::Correlacion::punto_homologo(&C1,focal,&C2,focal,zonas[8],0,100,300,&par);
		}
	}

	Aerotri::Correlacion::libera_todo();
	return 0;
}
