namespace Aerotri{
namespace Correlacion{
//Lee un fichero de gps:
//	gpm=2: Fichero de Aerotri
//	gpm=4: fichero de AeroOffice
//	signoins: 0: signo de Aerotri; 1: signo contrario. Normalmente 1.
//
//Devuelve un array de PuntoGPSINS (exactamente un Vector_PuntoGPSINS)
//  El nombre de cada gpss.ppio[i] empieza en nombregps[ gpss.ppio[i].index ]
//y un array de Vecor_uint's. El nmero de elementos de este array es igual a gpss.n.
//El elemento 'i' de este array es un Vector_uint con los nmeros de las fotos (segn
//el orden del array gpss) que es posible que tengan puntos en comn con la foto 'i'.
//
//La ZsobreTerr debe ser la mxima altura de vuelo sobre el terreno
//nw, ne, sw, se son las coordenadas foto de las cuatro esquinas del fotograma
//
//mensaje es un char[512] (o ms)
//idioma:
//	0: Espaol
//	1: Ingls
//	2: Italiano
//Si se produce un error; es decir, si el cdigo devuelto por la funcin es distinto de 0 o -1, mensaje
//se rellena con un mensaje de error
struct lee_gps_Devuelto{
	Vector_PuntoGPSINS gpss;
	char* nombresgps;
	Vector_uint* pares;
};
extern "C" __declspec(dllexport) int lee_gps_y_organiza(const char *ficherogps, s8int gpm, s8int uni, bint signoins, float ZsobreTerr, float focal, Puntoxy_float nw, Puntoxy_float ne, Puntoxy_float sw, Puntoxy_float se, struct lee_gps_Devuelto *dev, char *mensaje, u8int idioma);

extern "C" __declspec(dllimport) void libera_todo();

//En p2 se devuelve el punto homlogo a p1 para una Z igual a ZTerr. Para otros valores de Z,
//el homlogo es    (p2.x -tx*DZ, p2.y -ty*DZ)    (recta epipolar).
//En cosk, sink se devuelve la variacin de p1 en el plano epipolar, de manera que una ventana
//centrada en p1 con giro k, se corresponden con una ventana centrada en algn punto de la
//recta epipolar en la foto 2 y orientada segn dicha recta.
//cosk y sink son proporcionales a los valores coseno y seno, pero no se cumple cosk^2+sink^2=1
struct punto_homologo_Devuelto{
	Puntoxy_double p2min;
	Puntoxy_double p2approx;
	Puntoxy_double p2max;
	double tx, ty;
	double cosk, sink;
};
extern "C" __declspec(dllimport) extern void punto_homologo(PuntoXYZM *C1, double f1, PuntoXYZM *C2, double f2, Puntoxy_double p1, double Zmin, double Zaprox, double Zmax, struct punto_homologo_Devuelto *dev);
}}
