//Compile with /J
#pragma warning(disable:4668) //undefined symbol replaced by 0 for preprocessor #if directive
#pragma warning(disable:4820) //padding bytes
#pragma warning(disable:4245) //assignment of negative constant to unsigned variable
#pragma warning(disable:4010) //Comentario de una sola lnea que se extiende por ms de una lnea del fichero (lo uso para comentar macros)
#pragma warning(disable:4701) //la variable local 'tal' se puede utilizar sin haberse inicializado
#pragma warning(disable:4201) //struct/union annima
#pragma warning(disable:4127) //la expresin condicional es constante (viene de macros)
#undef _MSC_EXTENSIONS
#include "system.h"
#include <cmath>
#include <malloc.h>
#include <cstring>
#include "ATmem.h"
#include "Aerotri_defs.h"
#include "Clases.h"
#include "lecturaf.h"
#include "matematicas.h"
#include "Rotacion.h"
#include "Ajustes.h"
#define dllimport dllexport
#include "correlacion.h"
#undef dllimport

#define ptr ptri
PLIST plist=PLIST_NULL;

const char* const TEXTOS_correl[][3]={\
	{"El fichero de datos gps/ins no contiene ningn grupo","The gps/ins data file doesn't have any group","Il file di gps/ins non include nessun insieme"}, //0
	{"de valores aproximados","approximate values","di valori approssimati"}, //1
};

#define analyze_return(esc_string,ret_code) \
	if(nret==-1) goto salida_esc;\
	if(nret==-2) goto salida_outofmem;\
	if(nret<0) goto salida_error;\
	nret=ret_code; goto salida_mala

#define Point_at_Z(Q,M,P,Zt)\
	GiraPunto_invM(Q,M,P);\
	{float aux=-Zt/Q.Z;\
	Q.X*=aux; Q.Y*=aux; Q.Z=-Zt;}\
	Q+=CPf

namespace Aerotri{
namespace Correlacion{
/*	     1
	 ------- 
	|		| 2
   4	|		|
	 -------
	     3
*/
//para pares de cuadrantes que no son opuestos y tales que ninguno de ellos es el centro (5)
const u8int linea_que_corta[9][9]={
	{0,0,0,0,0,2,0,3,0},
	{0,0,0,1,0,1,1,0,1},
	{0,0,0,4,0,0,0,3,0},
	{0,4,4,0,0,0,0,4,4},
	{0,0,0,0,0,0,0,0,0},
	{2,2,0,0,0,0,2,2,0},
	{0,1,0,0,0,2,0,0,0},
	{3,0,3,3,0,3,0,0,0},
	{0,1,0,4,0,0,0,0,0}
};
//idem
const u8int sentido_avance[9][9]={
	{0,1,1,-1,0,1,-1,-1,0},
	{-1,0,1,-1,0,1,-1,0,1},
	{-1,-1,0,-1,0,1,0,1,1},
	{1,1,1,0,0,0,-1,-1,-1},
	{0,0,0,0,0,0,0,0,0},
	{-1,-1,-1,0,0,0,1,1,1},
	{1,1,0,1,0,-1,0,-1,-1},
	{1,0,-1,1,0,-1,1,0,-1},
	{0,-1,-1,1,0,-1,1,1,0}
};
inline float corte_13(Puntoxy_float c1, Puntoxy_float c2, float y){
	float t=(y-c1.y)/(c2.y-c1.y);
	return c1.x+t*(c2.x-c1.x);
}
inline float corte_24(Puntoxy_float c1, Puntoxy_float c2, float x){
	float t=(x-c1.x)/(c2.x-c1.x);
	return c1.y+t*(c2.y-c1.y);
}

extern "C" __declspec(dllexport) int lee_gps_y_organiza(const char *ficherogps, s8int gpm, s8int uni, bint signoins, float ZsobreTerr, float focal, Puntoxy_float nw, Puntoxy_float ne, Puntoxy_float sw, Puntoxy_float se, struct lee_gps_Devuelto *dev, char *mensaje, u8int idioma){
	if(idioma>Id_It) idioma=0;
	int nret=0;
	mensaje[0]='\0';

	Vector_PuntoGPSINS gpss;
	Vector_GrupoGPSINS grupos;
	char *nombresgps;

	if(plist==PLIST_NULL) plist=get_new_plist();
	lecturaf_set_globals(idioma,mensaje,NULL,0);

	Vector_GrupoGPSextras gextras;
	nret=lee_ficherogps((char*)ficherogps,gpm,signoins,uni,&grupos,&gpss,&nombresgps,NULL,&gextras);
	if(gpss.ppio!=NULL){
		add_to_delete(gpss.ppio);
		add_to_delete(grupos.ppio);
		add_to_delete(gextras.ppio);
		add_to_delete(nombresgps);
	}
	if(nret!=0){
		analyze_return("fichero_gps",nret);
	}
	if(gpss.n==0){
		strcpy(mensaje,TEXTOS_correl[0][idioma]);
		myreturn(2);
	}
	aj_decl_alloc_add(uint,grupos_acum,grupos.n);
	GrupoGPSINS *pungrupo=grupos.ppio;
	for(uint i=0;i<grupos.n;i++,pungrupo++){
		grupos_acum[i]=pungrupo->n;
		if(i) grupos_acum[i]+=grupos_acum[i-1];
		if(gextras.ppio[i].calculaoffsetGPS && pungrupo->tipoGPS==0) pungrupo->tipoGPS=1;
		if(gextras.ppio[i].calculaoffsetINS && pungrupo->tipoINS==0) pungrupo->tipoINS=1;
	}
	if(gpss.ppio!=NULL){free_remove_s(gextras.ppio);}

	aj_decl_alloc_add(Vector_uint,pares,gpss.n);
	{durchlaufei(Vector_uint,pares,gpss.n){
		StdSetup(uint,*ptr,14);
	}}

	float _f=1/focal;
	nw.x*=_f;	nw.y*=_f;
	ne.x*=_f;	ne.y*=_f;
	sw.x*=_f;	sw.y*=_f;
	se.x*=_f;	se.y*=_f;

	//Bsqueda de los pares de fotos con rea comn
	Vector_uint *ppares=pares;
	PuntoGPSINS *pgps=gpss.ppio;
	durchVectori(GrupoGPSINS,grupos){
		fordownj(ptr->n,(pgps++,ppares++)){
			float M[3][3];
			for(cint it=0;it<9;it++) M[0][it]=(float)pgps->M[0][it];
			PuntoXYZ_float CPf, P, Q1,Q2,Q3,Q4;
			CPf.X=(float)pgps->P.X;
			CPf.Y=(float)pgps->P.Y;
			CPf.Z=(float)pgps->P.Z;
			P.Z=-1.0;

			P.X=nw.x;	P.Y=nw.y;	Point_at_Z(Q1,M,P,ZsobreTerr);
			P.X=ne.x;		P.Y=ne.y;		Point_at_Z(Q2,M,P,ZsobreTerr);
			P.X=se.x;		P.Y=se.y;		Point_at_Z(Q3,M,P,ZsobreTerr);
			P.X=sw.x;		P.Y=sw.y;	Point_at_Z(Q4,M,P,ZsobreTerr);

			uint llb=0;
			durchVector(ib,GrupoGPSINS,grupos){
				uint lb=llb;
				llb+=ptrib->n;
				PuntoGPSINS *pgpsb=gpss.ppio+lb;
				fordown(jb,ptrib->n,pgpsb++){
					if(pgpsb==pgps) continue;
					double (*iM)[3];
					PuntoXYZ_float P,Q;
					Puntoxy_double calc;
					double den;
					Puntoxy_float fcalc, c1,c2,c3,c4;
					float fden;

					P.X=(float)pgpsb->P.X;
					P.Y=(float)pgpsb->P.Y;
					P.Z=(float)pgpsb->P.Z;
					iM=pgpsb->M;
					Q=Q1-P;		calculado_nuevo(Q);	c1=fcalc;
					Q=Q2-P;		calculado_nuevo(Q);	c2=fcalc;
					Q=Q3-P;		calculado_nuevo(Q);	c3=fcalc;
					Q=Q4-P;		calculado_nuevo(Q);	c4=fcalc;

					float xmin,ymin, xmax,ymax;
					xmax=xmin=c1.x;
					if(c2.x<xmin) xmin=c2.x;	else if(c2.x>xmax) xmax=c2.x;
					if(c3.x<xmin) xmin=c3.x;	else if(c3.x>xmax) xmax=c3.x;
					if(c4.x<xmin) xmin=c4.x;	else if(c4.x>xmax) xmax=c4.x;

					ymax=ymin=c1.y;
					if(c2.y<ymin) ymin=c2.y;	else if(c2.y>ymax) ymax=c2.y;
					if(c3.y<ymin) ymin=c3.y;	else if(c3.y>ymax) ymax=c3.y;
					if(c4.y<ymin) ymin=c4.y;	else if(c4.y>ymax) ymax=c4.y;

					if(xmax<nw.x || xmin>ne.x || ymax<sw.y || ymin>nw.y) continue;

			#define cuadrante(cuad,p) \
					do{\
						if(p.x<nw.x) cuad=0;\
						else if(p.x<ne.x) cuad=1;\
						else cuad=2;\
						if(p.y<nw.y){\
							if(p.y>=sw.y) cuad+=3;\
							else cuad+=6;\
						}\
					}while(0)

			#define quad_opuesto(i) (8-i)

					s8int cc1,cc2,cc3,cc4;
					cuadrante(cc1,c1);	if(cc1==4) goto found;
					cuadrante(cc2,c2);	if(cc2==4) goto found;
					cuadrante(cc3,c3);	if(cc3==4) goto found;
					cuadrante(cc4,c4);	if(cc4==4) goto found;

					{s8int _c=quad_opuesto(cc1); if(cc2==_c || cc3==_c || cc4==_c) goto found;}
					{s8int _c=quad_opuesto(cc2); if(cc3==_c || cc4==_c) goto found;}
					if(quad_opuesto(cc3)==cc4) goto found;

					//Aqu se llegar poco
					s8int sentido, corte;
					bint bsense=0;	//si el sentido es todo el mismo
					float x,y;
			#define mira_si_corta(p1,p2) \
					if(corte&1){\
						if(corte==1) y=nw.y;\
						else y=sw.y;\
						x=corte_13(p1,p2,y);\
						if(x>=nw.x && x<ne.x) goto found;\
					}else if(corte!=0){\
						if(corte==2) x=ne.x;\
						else x=nw.x;\
						y=corte_24(p1,p2,x);\
						if(y>=sw.y && y<nw.y) goto found;\
					}

					corte=linea_que_corta[cc1][cc2];
					sentido=sentido_avance[cc1][cc2];
					mira_si_corta(c1,c2);

					corte=linea_que_corta[cc2][cc3];
					{u8int ss=sentido_avance[cc2][cc3];
					if(sentido==0) sentido=ss;
					else if(ss!=0 && ss!=sentido) bsense=1;}
					mira_si_corta(c2,c3);

					corte=linea_que_corta[cc3][cc4];
					{u8int ss=sentido_avance[cc3][cc4];
					if(sentido==0) sentido=ss;
					else if(ss!=0 && ss!=sentido) bsense=1;}
					mira_si_corta(c3,c4);

					corte=linea_que_corta[cc4][cc1];
					{u8int ss=sentido_avance[cc4][cc1];
					if(sentido==0) sentido=ss;
					else if(ss!=0 && ss!=sentido) bsense=1;}
					mira_si_corta(c4,c1);

					//Si se llega aqu, ninguna corta
					if(sentido==0 || bsense!=0) continue;

					found:
					Vadd(*ppares,uint,pgpsb-gpss.ppio);
			#undef mira_si_corta
			#undef quad_opuesto
			#undef cuadrante
				}
			}
		}
	}
	{durchlaufei(Vector_uint,pares,gpss.n){
		remove_from_delete_s(ptr->ppio);
	}}
	remove_from_delete_s(pares);
	remove_from_delete_s(nombresgps);
	remove_from_delete_s(gpss.ppio);
	dev->gpss=gpss;
	dev->nombresgps=nombresgps;
	dev->pares=pares;
	myreturn(0);

salida_esc:
	nret=-1; goto salida_mala;
salida_outofmem:
	switch(idioma){
		case Id_Eng:	strcpy(mensaje,"Not enough memory"); break;
		case Id_It:	strcpy(mensaje,"Memoria insuficente"); break;
		default:		strcpy(mensaje,"Memoria insuficiente");
	}
	nret=-2; goto salida_mala;
 salida_error:
	switch(idioma){
		case Id_Eng:	strcpy(mensaje,"Unknown error"); break;
		case Id_It:	strcpy(mensaje,"Errore sconosciuto"); break;
		default:		strcpy(mensaje,"Error desconocido");
	}
	nret=-10; goto salida_mala;

salida_mala:		//el mensaje y el return ya est escrito
	myreturn(nret);
}

extern "C" __declspec(dllexport) void libera_todo(){
	free_plist(plist);
}

extern "C" __declspec(dllexport) void punto_homologo(PuntoXYZM *C1, double f1, PuntoXYZM *C2, double f2, Puntoxy_double p1, double Zmin, double Zaprox, double Zmax, struct punto_homologo_Devuelto *dev){
	PuntoXYZ_double P1,P,P2, Q;
	double den,aX,aY;

	P.X=p1.x;
	P.Y=p1.y;
	P.Z=-f1;
	Q=GiraPunto_inv(P,C1->M);
	P1.Z=Zmin-C1->P.Z;
	P.Z=Zaprox-C1->P.Z;
	P2.Z=Zmax-C1->P.Z;
	aX=Q.X/Q.Z;	
	aY=Q.Y/Q.Z;

	P1.X=aX*P1.Z;
	P1.Y=aY*P1.Z;
	P1+=C1->P-C2->P;

	P.X=aX*P.Z;
	P.Y=aY*P.Z;
	P+=C1->P-C2->P;

	P2.X=aX*P2.Z;
	P2.Y=aY*P2.Z;
	P2+=C1->P-C2->P;

	dev->p2min.x=C2->M[0][0]*P1.X+C2->M[0][1]*P1.Y+C2->M[0][2]*P1.Z;
	dev->p2min.y=C2->M[1][0]*P1.X+C2->M[1][1]*P1.Y+C2->M[1][2]*P1.Z;
	den=C2->M[2][0]*P1.X+C2->M[2][1]*P1.Y+C2->M[2][2]*P1.Z;
	den=-f2/den;
	dev->p2min.x*=den;
	dev->p2min.y*=den;
	//
	dev->p2approx.x=C2->M[0][0]*P.X+C2->M[0][1]*P.Y+C2->M[0][2]*P.Z;
	dev->p2approx.y=C2->M[1][0]*P.X+C2->M[1][1]*P.Y+C2->M[1][2]*P.Z;
	den=C2->M[2][0]*P.X+C2->M[2][1]*P.Y+C2->M[2][2]*P.Z;
	den=-f2/den;
	dev->p2approx.x*=den;
	dev->p2approx.y*=den;
	//
	dev->p2max.x=C2->M[0][0]*P2.X+C2->M[0][1]*P2.Y+C2->M[0][2]*P2.Z;
	dev->p2max.y=C2->M[1][0]*P2.X+C2->M[1][1]*P2.Y+C2->M[1][2]*P2.Z;
	den=C2->M[2][0]*P2.X+C2->M[2][1]*P2.Y+C2->M[2][2]*P2.Z;
	den=-f2/den;
	dev->p2max.x*=den;
	dev->p2max.y*=den;

	P.X=dev->p2approx.x;
	P.Y=dev->p2approx.y;
	P.Z=-f2;
	Q=GiraPunto_inv(P,C2->M);
	P.Z=Zaprox-C2->P.Z;
	aX=Q.X/Q.Z;			P.X=aX*P.Z;
	aY=Q.Y/Q.Z;		P.Y=aY*P.Z;

	P+=C2->P-C1->P;

	den=C1->M[2][0]*P.X+C1->M[2][1]*P.Y+C1->M[2][2]*P.Z;
	den=-1.0/den;
	dev->cosk=(f1*C1->M[0][2]+p1.x*C1->M[2][2]);
	dev->cosk+=aX*(f1*C1->M[0][0]+p1.x*C1->M[2][0]);
	dev->cosk+=aY*(f1*C1->M[0][1]+p1.x*C1->M[2][1]);
	dev->cosk*=den;
	dev->sink=(f1*C1->M[1][2]+p1.y*C1->M[2][2]);
	dev->sink+=aX*(f1*C1->M[1][0]+p1.y*C1->M[2][0]);
	dev->sink+=aY*(f1*C1->M[1][1]+p1.y*C1->M[2][1]);
	dev->sink*=den;
}

extern "C" __declspec(dllexport) Puntoxy_double* obtiene_puntos_para_correlar(double xmin, double wd, double ymin, double ht, uint ntotal, void *puntos_yaestan, uint sizeof_struct, uint offsetof_x, uint npuntos){
	aj_decl_alloc_add(Puntoxy_double,puntos,ntotal);
	{Puntoxy_double *ptr=puntos;
	pCharDbl ptr_b;
	ptr_b.pdouble=(double*)((char*)puntos_yaestan+offsetof_x);
	for(uint i=npuntos;i--;ptr++,ptr_b.pint8+=sizeof_struct){
		ptr->x=*ptr_b.pdouble;
		ptr->y=*(ptr_b.pdouble+1);
	}
	}
	if(ntotal==npuntos) return puntos;

	if(ntotal==1){
		puntos[0].x=xmin+0.5*wd;
		puntos[0].y=ymin+0.5*ht;
		return puntos;
	}
	uint ndivx, ndivy;							//2:  3 x 2
	ndivy=ndivx=(int)sqrt((float)(ntotal-1))+1;		//3:  3 x 3
	if(ntotal &1){									//4:  2 x 2
		if(!(ndivx&1)) ndivx++, ndivy++;		//5:  3 x 3
	}else{											//6:  3 x 2
		if(ndivx &1) ndivx--;					//7:  3 x 3
		if((ntotal ^ ndivx)&2) ndivy++;		//8:  4 x 2
		if(ndivy*ndivx<ntotal) ndivx+=2;		//9:  3 x 3
	}												//n^2:  n x n
								//n impar; n^2-1:  (n+1) x (n-1)
	double incx, incy;
	incx=wd/ndivx;
	incy=ht/ndivy;
	aj_decl_alloc_add(double,distancias,ndivx*ndivy);
	zeroset_double(distancias,ndivx*ndivy);

	if(npuntos==0){
		uint t=ntotal;
		if(ntotal & 1){
			puntos[0].x=xmin+0.5*wd;
			puntos[0].y=ymin+0.5*ht;
			npuntos=1;
			t--;
		}
		puntos[npuntos].x=xmin+incx;
		puntos[npuntos].y=ymin+incy;		npuntos++;
		puntos[npuntos].x=xmin+wd-incx;
		puntos[npuntos].y=ymin+ht-incy;	npuntos++;
		if(!(t&2)){
			puntos[npuntos].x=xmin+incx;
			puntos[npuntos].y=ymin+ht-incy;		npuntos++;
			puntos[npuntos].x=xmin+wd-incx;
			puntos[npuntos].y=ymin+incy;			npuntos++;
		}
	}

	free_remove_s(distancias);
	return puntos;

salida_outofmem:
	return NULL;
}
}}
