using System;
using System.Windows.Forms;
using System.Drawing;

namespace Calibracion
{
	/// <summary>
	/// Descripcin breve de FormAfinidad.
	/// </summary>
	public class FormAfinidad : System.Windows.Forms.Form
	{
		internal System.Windows.Forms.Button Cancelar;
		internal System.Windows.Forms.Button Aceptar;
		internal System.Windows.Forms.CheckBox CheckBox2;
		internal System.Windows.Forms.CheckBox CheckBox1;
		internal System.Windows.Forms.Label Label5;
		internal System.Windows.Forms.Label Label1;
		internal System.Windows.Forms.Label Label3;

		private PanelCalibracion PanelPadre;
		internal const byte nparametros=2;
		private bool[] checkeds;
		internal CheckBox[] checkboxes;
		public byte npar;
		public FormAfinidad(PanelCalibracion Form1)
		{
			InitializeComponent();
			this.ShowInTaskbar=false;
			PanelPadre=Form1;

			checkeds=new bool[nparametros+1];
			checkboxes=new CheckBox[nparametros+1];

			checkboxes[1]=CheckBox1;
			checkboxes[2]=CheckBox2;

			for(int i=1;i<=nparametros;i++){
				if(checkboxes[i].Checked) npar++;
			}
			colores();
		}

	#region InitializeComponent
		private void InitializeComponent()
		{
			Cancelar= new Button();
			Aceptar= new Button();
			CheckBox2= new CheckBox();
			CheckBox1= new CheckBox();
			Label5= new Label();
			Label1= new Label();
			Label3= new Label();
			this.SuspendLayout();
			//
			// CheckBox2
			//
			CheckBox2.Checked= true;
			CheckBox2.CheckState= System.Windows.Forms.CheckState.Checked;
			CheckBox2.Font= new Font("Tahoma", 8.25F);
			CheckBox2.Location= new Point(192, 140);
			CheckBox2.Size= new Size(52, 16);
			CheckBox2.TabIndex= 32;
			CheckBox2.Text= "b";
			CheckBox2.CheckedChanged+= new System.EventHandler(CheckBox2_CheckedChanged);
			//
			// CheckBox1
			//
			CheckBox1.Checked= true;
			CheckBox1.CheckState= System.Windows.Forms.CheckState.Checked;
			CheckBox1.Font= new Font("Tahoma", 8.25F);
			CheckBox1.Location= new Point(88, 140);
			CheckBox1.Size= new Size(52, 16);
			CheckBox1.TabIndex= 31;
			CheckBox1.Text= "a";
			CheckBox1.CheckedChanged+= new System.EventHandler(CheckBox1_CheckedChanged);
			//
			// Label5
			//
			Label5.Font= new Font("Microsoft Sans Serif", 9.75F);
			Label5.Location= new Point(36, 112);
			Label5.Size= new Size(88, 20);
			Label5.TabIndex= 30;
			//
			// Label1
			//
			Label1.BackColor= Color.Ivory;
			Label1.Dock= DockStyle.Top;
			Label1.FlatStyle= System.Windows.Forms.FlatStyle.System;
			Label1.Font= new Font("Arial", 8.25F);
			Label1.Location= new Point(0, 0);
			Label1.Size= new Size(314, 104);
			Label1.TabIndex= 29;
			//
			// Label3
			//
			Label3.BackColor= Color.Ivory;
			Label3.FlatStyle= System.Windows.Forms.FlatStyle.System;
			Label3.Font= new Font("Arial", 8.25F);
			Label3.Location= new Point(108, 35);
			Label3.Size= new Size(76, 32);
			Label3.TabIndex= 35;
			Label3.Text= "   Dx= ax+by\r   Dy= bx-ay";
			//
			// Cancelar
			//
			Cancelar.BackColor= Color.FromArgb(((System.Byte)(224)), ((System.Byte)(224)), ((System.Byte)(224)));
			Cancelar.Font= new Font("Microsoft Sans Serif", 8F);
			Cancelar.Location= new Point(196, 168);
			Cancelar.Size= new Size(56, 24);
			Cancelar.TabIndex= 34;
			Cancelar.Click+= new System.EventHandler(Cancelar_Click);
			//
			// Aceptar
			//
			Aceptar.BackColor= Color.FromArgb(((System.Byte)(224)), ((System.Byte)(224)), ((System.Byte)(224)));
			Aceptar.Location= new Point(68, 168);
			Aceptar.Size= new Size(56, 24);
			Aceptar.TabIndex= 33;
			Aceptar.Click+= new System.EventHandler(Aceptar_Click);
			//
			// FormAfinidad
			//
			this.AutoScaleBaseSize= new Size(5, 13);
			this.BackColor= Color.FromArgb(((System.Byte)(248)), ((System.Byte)(248)), ((System.Byte)(248)));
			this.ClientSize= new Size(314, 203);
			this.Controls.Add(Label3);
			this.Controls.Add(Cancelar);
			this.Controls.Add(Aceptar);
			this.Controls.Add(CheckBox2);
			this.Controls.Add(CheckBox1);
			this.Controls.Add(Label5);
			this.Controls.Add(Label1);
			this.FormBorderStyle= FormBorderStyle.FixedSingle;
			this.Icon= new System.Drawing.Icon(System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("Calibracion.Iconos.IconCalibracion.ico"));
			this.MaximizeBox= false;
			this.MinimizeBox= false;
			this.Name= "FormAfinidad";
			this.Load+= new System.EventHandler(FormAfinidad_Load);
			this.ResumeLayout(false);
		}
	#endregion

		private void FormAfinidad_Load(object sender, System.EventArgs e){
			short i;

			checkeds[1]= CheckBox1.Checked;
			checkeds[2]= CheckBox2.Checked;
			npar= 0;
			for(i=1;i<=nparametros;i++){
				if(checkeds[i]) npar++;
			}
			idiomas();
		}

		private void Aceptar_Click(object sender, System.EventArgs e){
			this.Hide();
		}
		private void Cancelar_Click(object sender, System.EventArgs e){
			CheckBox1.Checked= checkeds[1];
			CheckBox2.Checked= checkeds[2];
			this.Hide();
		}

	#region CheckedChanged
		private void CheckBox1_CheckedChanged(object sender, System.EventArgs e){
			if(CheckBox1.Checked) npar++;
			else npar--;
		}
		private void CheckBox2_CheckedChanged(object sender, System.EventArgs e){
			if(CheckBox2.Checked) npar++;
			else npar--;
		}
	#endregion

		void colores(){
			this.BackColor=Color.FromArgb(Globales.Colores.color1);
			this.Label1.BackColor=Color.FromArgb(Globales.Colores.color7);
			this.Label3.BackColor=Color.FromArgb(Globales.Colores.color7);
			this.Aceptar.BackColor=Color.FromArgb(Globales.Colores.color5);
			this.Cancelar.BackColor=Color.FromArgb(Globales.Colores.color5);
		}
		void idiomas(){
			switch(PanelPadre.idioma){
			  case 1:
				this.Text="Affine Distortion";
				Label1.Text="\n    The affine distortion is as follows:\n\n\n\n" +
							"    In this model, (1+2a) is la ratio between the x scale and\n" +
							" the y scale, and 2b the difference to 90 of the angle contained.";
				Label5.Text="Parameters:";
				Aceptar.Text="OK";
				Cancelar.Text="Cancel";
				break;
			  case 2:
				this.Text="Distorsione Affine";
				Label1.Text="\n    La distorsione affine  cos:\n\n\n\n" +
							"    In questo modello (1+2a)  la relazione tra le scale degli \n" +
							"    assi x/y, e 2b la differenza a 90 dell'angolo che formano.";
				Label5.Text="Parametri:";
				Aceptar.Text="OK";
				Cancelar.Text="Annulla";
				break;
			  default:
				this.Text="Distorsin Afn";
				Label1.Text="\n    La distorsin afn es la siguiente:\n\n\n\n" +
							"    En este modelo (1+2a) es la relacin entre las escalas de \n" +
							"    los ejes x/y, y 2b la diferencia a 90 del ngulo que forman.";
				Label5.Text="Parmetros:";
				Aceptar.Text="Aceptar";
				Cancelar.Text="Cancelar";
				break;
			}
		}
	}
}
