char16_t** split_cmdline(char16_t *cmdline){
	char16_t** argv;
	char16_t *pc;
	uint n=0;	//incremented at beginning of word
	pc=cmdline;
	for(;;){
		while(*pc==u' ' || *pc==u'\t' || *pc==u'\n') pc++;
		if(*pc==0) break;
		n++;
		if(*pc==u'"'){
falseend:	pc++;
			while(*pc!=u'"' && *pc!=0) pc++;		//within ", \ represents itself, except before "
			if(*(pc-1)==u'\\' && *pc==u'"') goto falseend;
			if(*pc!=0) pc++;
			continue;
		}
		while(*pc!=u' ' && *pc!=u'\t' && *pc!=u'\n' && *pc!=u'"' && *pc!=0){
			if(*pc==u'\\'){
				if(*(pc+1)==0) *pc=0;
				else pc+=2;				
			}else pc++;
		}
	}
	//n may be one greater if \0 (literally) appears at beginning-of-word position.
	argv=n_malloc(char16_t*,n+1);
	if(argv==NULL) return NULL;
	char16_t **ptr=argv;
	pc=cmdline;
	for(;;){
		while(*pc==u' ' || *pc==u'\t' || *pc==u'\n') pc++;
		if(*pc==0) break;
		if(*pc==u'"'){
			*pc++=0;	//It may be the end of the previous word
			*ptr++=pc;
			while(*pc!=u'"' && *pc!=0) pc++;
			char16_t *jc=pc;
			goto test_end;
falseend_2:	*(jc-1)=u'"'; pc++;
			while(*pc!=u'"' && *pc!=0) *jc++=*pc++;
test_end:		if(*(jc-1)==u'\\' && *pc==u'"') goto falseend_2;
			if(*pc!=0 && *(jc-1)==u' ') *(jc-1)=0;	//Last space removed so that it is possible to end a "" arg with \ 
			else *jc=0;
			*pc++;
			continue;
		}
		*ptr++=pc;
		while(*pc!=u' ' && *pc!=u'\t' && *pc!=u'\n' && *pc!=u'"' && *pc!=0){
			if(*pc==u'\\') pc++;				
			pc++;
		}
		if(*pc!=0 && *pc!=u'"') *pc++=0;
	}
	*ptr=NULL;
	return argv;
}
