#ifdef __cplusplus_cli
#define PUBLIC public
#else
#define PUBLIC
#endif

PUBLIC class IVentanaModule{
public:
	virtual HWND get_hwnd(void) =0;
	virtual bint is_sizable(void) =0;
	virtual SIZE get_minsize(void){SIZE p={0,0}; return p;}
	virtual ~IVentanaModule(){}
};

PUBLIC struct ModuleNames{
	char16_t* base_dir;	//of the entry module. Like full_path, with the file name removed
	char16_t* name;
	char16_t* internal_name;
};

//Modos de las ventanas subordinadas
#define MODOSUB_STANDALONE	0
#define MODOSUB_YOKEDMAIN	1
#define MODOSUB_YOKED			2
#define MODOSUB_CUTDOWN		3

PUBLIC struct InitDependent_Info{
	int mode;	//Un MODOSUB_
	HWND parent;
	int threadid;
	u8int idioma;
	POINT location;
	bool visible;
};

PUBLIC class IEnlace{
public:
	char16_t* name;
	virtual IVentanaModule* get_ventana(void){return nullptr;}
};

#define INFORET_FREE_Version 1
#define INFORET_FREE_Fecha 2
PUBLIC struct InfoRetrived{	//of the target componenet
	uint needfree_flags;
	char16_t* version;
	char16_t* fecha;
};

struct InfoComienzo;

//enlaces puede ser NULL. Si no es NULL, un enlace con name=NULL cierra la serie
typedef IVentanaModule* __cdecl TypeF_CreateVentana(const InfoComienzo *infocomie, InfoRetrived *inforetrived, IEnlace** enlaces);
typedef void __cdecl TypeF_MuestraVentana(IVentanaModule *ventana, bint visible);
typedef int __cdecl TypeF_Suordinanda_MsgLoop(IVentanaModule *ventana);
typedef void __cdecl TypeF_DestruyeVentana(IVentanaModule *ventana);

PUBLIC struct ModuleFuncs{
	TypeF_CreateVentana *creaventana;
	TypeF_MuestraVentana *muestraventana;
	TypeF_Suordinanda_MsgLoop *msgloop;
	TypeF_DestruyeVentana *destruyeventana;
};

PUBLIC struct InfoComienzo{
	ModuleNames paths;
	char16_t* cmdline;
	InitDependent_Info yokeddata;
	ModuleFuncs funcs;
};
