using namespace System::Runtime::InteropServices;

typedef KeyVal* FicheroMaster;

const char16_t* const MasterClaves[]={
	u"Version", //0
	u"Type", //1
	u"InternalName", //2
	u"EntryModule", //3
	u"FuncCreateVentana", //4
	u"FuncShowVentana", //5
	u"FuncMsgLoop", //6
	u"FuncDestroyVentana", //7
	u"Enlaces", //8
	u"Nombre0", //9
	u"Nombre1", //10
	u"Nombre2", //11
	u"Info0", //12
	u"Info1", //13
	u"Info2", //14
	u"IconAll", //15
	NULL, //16
};
#define MASTER_CLAVES_Version 0
#define MASTER_CLAVES_Type 1
#define MASTER_CLAVES_InternalName 2
#define MASTER_CLAVES_EntryModule 3
#define MASTER_CLAVES_FuncCreateVentana 4
#define MASTER_CLAVES_FuncShowVentana 5
#define MASTER_CLAVES_FuncMsgLoop 6
#define MASTER_CLAVES_FuncDestroyVentana 7
#define MASTER_CLAVES_Enlaces 8
#define MASTER_CLAVES_Nombre0 9
#define MASTER_CLAVES_Nombre1 10
#define MASTER_CLAVES_Nombre2 11
#define MASTER_CLAVES_Info0 12
#define MASTER_CLAVES_Info1 13
#define MASTER_CLAVES_Info2 14
#define MASTER_CLAVES_IconAll 15

#define N_MASTERCLAVES 16

template<typename Type, int size>
[StructLayout(LayoutKind::Explicit, Size=(sizeof(Type)*size))]
public value struct PODArray{
private:
	[FieldOffset(0)] Type member0;
public:
	Type% operator[](int i){return *((&member0)+i);}
	static operator interior_ptr<Type>(PODArray<Type,size>% Arr){
		return &Arr.member0;
	}
};

struct Modulo{
	u8int type;	//0: Desconocido; 1: Nativo; 2: Windows Forms
	char16_t* full_path; //First used for the .master file, then for the entry module path & name.
	char16_t *filename; //pointer to the filename at full_path
	char16_t* modulename;	//name specified at the command line.
	HMODULE handle;	//of the entry module
};

struct PerThreadData : public IEnlace{
	u8int type;
	char16_t texto[120];		//El que se muestra en cada momento. Depende del idioma
	HANDLE handle;	//Handle del thread
	u8int step;	//0, 1, 2, 3,.
	IVentanaModule *ventana;
	HWND hventana;
	InfoComienzo *infocomie;
	InfoRetrived inforet;
	IEnlace ** enlaces;
	virtual IVentanaModule* get_ventana(void){return ventana;}
};
