using namespace System::Drawing;

bool read_reg_language(char* skey, char* field, interior_ptr<u8int> pidioma){
	HKEY key;
	BYTE Idioma[sizeof(DWORD)];
	DWORD varsize;
	DWORD typeread;
	DWORD nret;

	RegOpenKeyEx(HKEY_LOCAL_MACHINE,skey,0,KEY_QUERY_VALUE,&key);
	if(key==NULL) return false;
	varsize=sizeof(DWORD);
	nret=RegQueryValueEx(key,field,0,&typeread,Idioma,&varsize);
	RegCloseKey(key);
	if(nret==ERROR_SUCCESS && typeread==REG_DWORD_LITTLE_ENDIAN){
		*pidioma=Idioma[0]; return true;
	}
	return false;
}

#define Bitmap System::Drawing::Bitmap
void aclara_imagen(Bitmap ^bitm,char k){
	int l;
	unsigned int c;
	unsigned char R,G,B;
	for(unsigned int i=0;i<32;i++){
		for(unsigned int j=0;j<32;j++){
			c=bitm->GetPixel(i,j).ToArgb();
			R=(char)((c&0x00FF0000)>>16);
			G=(char)((c&0x0000FF00)>>8);
			B=(char)(c&0x000000FF);
			for(l=0;l<k;l++){
				R=51+(R*4)/5; G=51+(G*4)/5; B=51+(B*4)/5;
			}
			c=(c&0xFF000000)+(R<<16)+(G<<8)+B;
			bitm->SetPixel(i,j,Color::FromArgb(c));
	}}
}
void aclara_imagen(Bitmap ^bitm){
	aclara_imagen(bitm,1);
}
void image_enabled(Bitmap ^bitm){
	for(unsigned int i=0;i<32;i++)
		for(unsigned int j=(1-i)%4;j<32;j+=4)
			bitm->SetPixel(i,j,Color::Black);
}
void image_enabled_xor(Bitmap ^bitm){
	int c;	//ARGB
	for(int i=0;i<32;i++){
		for(int j=(2-i)%5;j<32;j+=5){
			c=bitm->GetPixel(i,j).ToArgb() ^ 0x00FFFFFF;
			bitm->SetPixel(i,j,Color::FromArgb(c));
	}}
}
#undef Bitmap

char16_t* get_key(KeyVal *keys, const char16_t* key){
	goto first;
loop:	keys++;
first:	if(keys->key==ZeroPtr) return NULL;
		if((void*)keys->key!=(void*)key) goto loop;
	return (char16_t*)(keys->val.ptr);
}

//Se devuelve !=0 si se debe detener la lectura del fichero.
//Y el valor devuelto ser el que devuelva la funcin leefile_keyvals
typedef int ProcessKeyval(const char16_t* key,const char16_t* val, void **data);

#define pkey (*(KeyVal**)data)
int keyval_appmaster(const char16_t* key,const char16_t* val, void **data){
	const char16_t* const *ptr=MasterClaves;
	while(*ptr!=NULL){if(strcmp16(key,*ptr)==0) break; ptr++;}
	if(*ptr==NULL) return 0;
	pkey->key=(uintptr_t)*ptr;
	pkey->val.ptr=malloc((strlen16(val)+1)*usizeof(char16_t));
	if(pkey->val.ptr==NULL){pkey->key=ZeroPtr; return AT_NOMEM;}
	Addto_delete(pkey->val.ptr);
	strcpy16((char16_t*)pkey->val.ptr,val);
	pkey++; pkey->key=ZeroPtr;
	return 0;
}
#undef pkey

int procesa_linea_config(const char16_t* key,const char16_t* val, void**){
	if(strcmp16(key,u"Idioma")==0){
		uint i=uint___str16(&val);
		if((*val=='\0' || *val==' ' || *val=='\t' || *val=='\n') && i<200) idioma=(u8int)i;
	}
	return 0;
}
int leefile_keyvals(char16_t* fname, ProcessKeyval *proc, void *data){
	Bufferti16 buffer;
	int nret=tiopen16(&buffer,fname);
	if(nret<0) return nret;
	nret=0;

	Advance(buffer);
	while(*buffer.pc!=u'\0'){
		const char16_t *key;
		string_advancecare(buffer,key);
		ifnlpassed(buffer) continue;
		Prepare_line(buffer);
		if(*buffer.pc=='\"' && buffer.next!=(buffer.pc+1) && *(buffer.next-1)=='\"'){
			buffer.pc++;
			*buffer.next--=buffer.savedchar;
			*buffer.next='\0'; buffer.savedchar=' ';
		}
		ifnz(nret=proc(key,buffer.pc,&data)) break;
		resume(buffer);
		finishline_Advance(buffer);
	}
	ticlose(buffer);
	return nret;
}

void guarda_ficheroConfiguracion(){
	char16_t sconfig[MAX_PATH+20];
	strbuild16(sconfig,appdata,u"Master.config",NULL);
	Buffer_bo fconfig;
	char16_t texto[20]=u"Idioma 0\n";

	boopen16(&fconfig,sconfig,ATFILE_ENDIAN_UNSET);
	texto[7]+=(char16_t)idioma;
	bowrite_wstring(&fconfig,texto);
	boclose(&fconfig);
}
