using namespace System;
using namespace System::Reflection;
using namespace System::Runtime::InteropServices;
using namespace System::Windows::Forms;
using namespace ControlesAt;

namespace FormSub{
	array<String^>^ convert_to_strings(char16_t** argv){
		char16_t** ptr=argv;
		uint n=0;
		while(*ptr!=NULL){ptr++; n++;}
		array<String^>^ Argv=gcnew array<String^>(n);
		ptr=argv;
		uint i=0;
		while(*ptr!=NULL){
			Argv[i]=Marshal::PtrToStringUni(IntPtr(*ptr));
			i++; ptr++;
		}
		return Argv;
	}

	private value struct DuennoP{
		HWND parent;
		int ThreadId;
	};

	public ref class FormSubAerotri : ControlesAt::FormBorde{
	private:
		DuennoP duenno;
	public:
		PanelesSub::PanelSubordinado^ Panel1;
		FormSubAerotri(Type^ tipoPanel, const InitDependent_Info *owner,char16_t** argv, IEnlace** enlaces){
			duenno.parent=owner->parent;
			duenno.ThreadId=owner->threadid;
			this->CreateHandle();	//Parece que CreateHandle ya funciona
			this->ShowInTaskbar=false;
			this->Location=System::Drawing::Point(owner->location.x,owner->location.y);
			this->Visible=owner->visible;

			PanelesSub::Duenno dueno_panel;
			dueno_panel.modo=owner->mode;
			dueno_panel.parent=owner->parent;
			dueno_panel.ThreadId=owner->threadid;

			ConstructorInfo^ Panelctor= tipoPanel->GetConstructor(gcnew array<Type^>{PanelesSub::Duenno::typeid,Globales::Idioma::typeid,IntPtr::typeid});
			array<Object^>^ args=gcnew array<Object^>{dueno_panel,owner->idioma,(IntPtr)(void*)enlaces};
			ConstruyePanel(Panelctor,args,convert_to_strings(argv));
			if(!this->Panel1->sizable) this->BorderMode= ControlesAt::BorderMode::PanelFixed;
			else this->BorderMode= ControlesAt::BorderMode::PanelSizable;
			comun();
		}
		FormSubAerotri(Type^ tipoPanel, array<String^>^ argv){
			duenno.parent=NULL;
			ConstructorInfo^ Panelctor= tipoPanel->GetConstructor(gcnew array<Type^>{});
			array<Object^>^ args=gcnew array<Object^>(0){};
			ConstruyePanel(Panelctor,args,argv);
			if(!this->Panel1->sizable) this->BorderMode=ControlesAt::BorderMode::FormFixed;
			else this->BorderMode=ControlesAt::BorderMode::FormSizable;
			comun();
		}
	private:
		void comun(){
			this->StartPosition= FormStartPosition::Manual;
			this->Location= System::Drawing::Point(75,141);
			this->BackColor=Globales::Colores::NETColor(Globales::Colores::cForm);
			this->ResumeLayout(false);
			this->Icon=Panel1->icono;
		}
		void ConstruyePanel(ConstructorInfo^ Panelctor, array<Object^>^ args, array<String^>^ argv){
			Panel1=dynamic_cast<PanelesSub::PanelSubordinado^>(Panelctor->Invoke(args));
			Panel1->Location=System::Drawing::Point(0, 0);
			Panel1->TabIndex=0;
			this->PanelTotal->Controls->Add(Panel1);
			Panel1->Setup(argv);
			this->ClientSize=System::Drawing::Size(Panel1->Width,Panel1->Height);
			Panel1->Dock=DockStyle::Fill;
		}

	protected:
		virtual void LabelsBorde_MouseUp(Object^ sender, MouseEventArgs^ e) override{
			this->FormBorde::LabelsBorde_MouseUp(sender,e);
			if(duenno.parent!=NULL){
				::SendMessage((HWND)duenno.parent,MASTERM_RESIZE,duenno.ThreadId,0);
			}
		}

	protected:
		virtual void WndProc(Message% m) override{
			if(m.Msg>=MASTERA_BASE){evento(m); return;}
			Form::WndProc(m);
			switch(m.Msg){
			case WM_SIZE:
				::PostMessage((HWND)this->duenno.parent,MASTERM_RESIZE,this->duenno.ThreadId,0);
				break;
			case WM_NCACTIVATE:
				::PostMessage((HWND)this->duenno.parent,MASTERM_ACTIVATED,this->duenno.ThreadId,m.WParam.ToInt32());
				break;
			}
		}
	public:
		void evento(Message% m){
			switch(m.Msg){
			  case MASTERA_CIERRA: Cerrar(); return;
			  case MASTERA_CIERRA2: Cerrar_Cerrar(); return;
			  case MASTERA_IDIOMA:
				Panel1->set_idioma((Globales::Idioma)(System::Byte)m.WParam.ToInt32());
				return;
			}
		}

	private: void Cerrar(){
			if(Panel1->cerrando) return;
			Panel1->cerrando=true;
			int nret=Panel1->cierra_panel();
			if(nret==2){
				::PostMessage((HWND)duenno.parent,MASTERM_ESTADO,duenno.ThreadId,Panel1->P_mensaje_estado.ToInt32());
				return;
			}
			if(nret==1){
				Panel1->cerrando=false;
				::PostMessage((HWND)duenno.parent,MASTERM_RESPUESTA_CERRAR,duenno.ThreadId,1);
				return;
			}
			if(Panel1->P_mensaje_estado!=IntPtr::Zero) Marshal::FreeHGlobal(Panel1->P_mensaje_estado);
			::PostQuitMessage(0);
		}
	protected:
		virtual void Cerrar_Cerrar(){
			Panel1->cerrando=false;
			if(Panel1->P_mensaje_estado!=IntPtr::Zero) Marshal::FreeHGlobal(Panel1->P_mensaje_estado);
			Panel1->P_mensaje_estado=IntPtr::Zero;
			::PostQuitMessage(0);
		}
	};

	public class wVentanaSubordinada : public IVentanaModule{
	private:
		uintptr_t uVentana;
	public:
		//This must be virtual so that the address can be retrived from the vtable
		//and the linker in another dll need not find the function address at link time.
		//It would fail to do so because of another flaw in the desing of managed/unmanged interop.
		//But the constructor cannot be virtual
		__declspec(dllexport) wVentanaSubordinada() : uVentana(ZeroPtr) {};	//Must be set soon for asyncronous calls
					//to get_ManagedVentana, between the completion of the constructor and the asignment of uVentana
					//below. This would not be needed if the constructor could include the code below
		virtual void wV(Type ^tipoPanel, const InitDependent_Info *initinfo, char16_t **argv, IEnlace** enlaces){
			FormSubAerotri^ ventana=gcnew FormSubAerotri(tipoPanel,initinfo,argv,enlaces);
			GCHandle gch= GCHandle::Alloc(ventana,GCHandleType::Normal);
			uVentana=(uintptr_t)GCHandle::ToIntPtr(gch).ToPointer();
		}
		virtual ~wVentanaSubordinada(){
			GCHandle gch= GCHandle::FromIntPtr(IntPtr((Int64)uVentana));
			if(gch.Target!=nullptr) gch.Free();
		}

	public:
		//get_ManagedVentana may return NULL if the construction has not completed
		virtual FormSubAerotri^ get_ManagedVentana(){
			if(uVentana==ZeroPtr) return nullptr;
			GCHandle gch= GCHandle::FromIntPtr(IntPtr((Int64)uVentana));
			return dynamic_cast<FormSubAerotri^>(gch.Target);
		}
	public:
		virtual HWND get_hwnd(void){
			FormSubAerotri^ V=get_ManagedVentana();
			if(V==nullptr) return NULL;
			return (HWND)V->Handle.ToPointer();
		}
		virtual bint is_sizable(void){
			FormSubAerotri^ V=get_ManagedVentana();
			if(V==nullptr) return false;
			return V->BorderMode==BorderMode::PanelSizable;
		}
		virtual SIZE get_minsize(void) override{
			SIZE p;
			FormSubAerotri^ V=get_ManagedVentana();
			p.cx=V->MinimumSize.Width;
			p.cy=V->MinimumSize.Height;
			return p;
		}
	};
}
