#define BOTSIZE 48

using namespace System;
using namespace System::Windows;
using namespace System::Windows::Forms;
using namespace System::Drawing;
using namespace System::Runtime::InteropServices;
using namespace System::Reflection;
using namespace ControlesAt;
using Globales::Colores;

#ifndef GET_X_LPARAM
#define GET_X_LPARAM(lparam) ((short)LOWORD(lparam))
#define GET_Y_LPARAM(lparam) ((short)HIWORD(lparam))
#endif

typedef void (*Evento)(unsigned int codigo, int par1, int par2);
IVentanaModule* get_ventana();
HWND get_vhwnd();

private ref class FormMaster : public System::Windows::Forms::Form{
public:
	Windows::Forms::Label ^label1;
	Windows::Forms::Label ^label2;
	Windows::Forms::MainMenu	^mainMenu1;
	Windows::Forms::MenuItem	^Herramientas,
										^HAdministrador,
										^AAcercade,
										^AManual;
	Windows::Forms::Label ^LblMaster;

public:
	HWND hwnd;
	array<Button^>^ OtherButtons;
	System::Drawing::Size BotSize;
	ToolTip^ ToolTip1;
	PODArray<char16_t,120> ApplicationTitle;
	int sizemin;

	/*POINT*/ ::Point pressed_point;
	Drawing::Size PressedSize;
	bool moving;
	unsigned char this_resizing;

	u8int idioma;

public:
	FormMaster(u8int notros){
		this->Icon=::Icon::FromHandle(IntPtr((void*)MasterIcon));
		BotSize= System::Drawing::Size(48,44);
		OtherButtons=gcnew array<Button^>(notros);
		for(u8int i=0;i<notros;i++){
			OtherButtons[i]=gcnew ControlesAt::BotAceptar;
			OtherButtons[i]->FlatStyle=FlatStyle::Standard;
			OtherButtons[i]->Size=BotSize;
			OtherButtons[i]->Top=10;
			OtherButtons[i]->TabIndex=3+i;
		}
		ToolTip1= gcnew ToolTip();
		ToolTip1->InitialDelay=700;
		ToolTip1->ReshowDelay=300;
		ToolTip1->AutoPopDelay=5000;
		ToolTip1->ShowAlways=true;

		mainMenu1= gcnew Forms::MainMenu();
		Herramientas= gcnew Forms::MenuItem();
		HAdministrador= gcnew Forms::MenuItem();
		AAcercade= gcnew Forms::MenuItem();
		AManual= gcnew Forms::MenuItem();
		LblMaster= gcnew Label();
		label1= gcnew Label();
		label2= gcnew Label();
		this->SuspendLayout();

		//
		// LblMaster
		//
		LblMaster->Image=Image::FromHbitmap(IntPtr((void*)LoadBitmap(GetModuleHandle(NULL),(LPCTSTR)2)));
		LblMaster->Location= ::Point(100, 6);
		LblMaster->Size= ::Size(316, 48);
		LblMaster->TabIndex= 8;
		//
		// label1
		//
		label1->BackColor= SystemColors::ControlDark;
		label1->Location=::Point(2, 60);
		label1->Size= ::Size(652, 1);
		label1->TabIndex= 9;
		//
		// label2
		//
		label2->BackColor= Drawing::Color::White;
		label2->Location= Drawing::Point(2, 61);
		label2->Size= Drawing::Size(652, 1);
		label2->TabIndex= 10;
		//
		// mainMenu1
		//
		{array<Forms::MenuItem^>^ mcTemp={Herramientas};
		mainMenu1->MenuItems->AddRange(mcTemp);}
		//
		// Herramientas
		//
		Herramientas->Index= 0;
		Herramientas->MenuItems->AddRange(gcnew array<Forms::MenuItem^>(3){HAdministrador,AAcercade,AManual});
		//
		HAdministrador->Index= 0;
		AAcercade->Index= 1;
		AManual->Index= 2;

		sizemin=BOTSIZE*notros;
		if(sizemin<280) sizemin=280;
		if(notros) this->Controls->AddRange(OtherButtons);
		{int naux=BOTSIZE*notros; naux+=naux>>2; if(naux<280) naux=280;
		this->ClientSize= Drawing::Size(naux,63);}

		float h=BOTSIZE>>2;
		for(uint i=0;i<notros;i++,h+=BOTSIZE){
			OtherButtons[i]->Left=(int)h;
		}

		//
		// this
		//
		this->AutoScaleBaseSize= Drawing::Size(5, 13);
		this->Controls->Add(label2);
		this->Controls->Add(label1);
		this->Controls->Add(LblMaster);
		this->FormBorderStyle= ::FormBorderStyle::FixedSingle;
		this->MaximizeBox= false;
		this->Menu= mainMenu1;
		//this->ClientSize= Drawing::Size(400, 63);
		this->MinimumSize=Drawing::Size(sizemin,this->Height);
		this->BackColor=Color::FromArgb(Colores::cForm);
		this->Text= "Aerotri Manager";
		this->ResumeLayout(false);

		moving=false;
		this_resizing=0;
		this->CreateHandle();
	}

	protected: virtual void WndProc(Message% msg) override{
		LRESULT msg_result;
		POINT ppunto;
		RECT rect;
		Windows::Forms::Cursor^ movCursor;
		IVentanaModule *ventana;
		HWND vhwnd;
		unsigned int lparam;

		vhwnd=NULL;
		switch(msg.Msg){
			case WM_DESTROY: PostQuitMessage(0); return;
			case WM_NCACTIVATE:
			case WM_KEYDOWN:
			case WM_NCHITTEST:
			case WM_NCMOUSEMOVE:
			case WM_NCLBUTTONDOWN:
			case WM_MOUSEMOVE:
			case WM_LBUTTONUP:
				ventana=get_ventana();
				vhwnd=get_vhwnd();
		}
		if(vhwnd==NULL){
			Form::WndProc(msg);
			return;
		}

		lparam=(UInt32)(msg.LParam.ToInt64());
		switch(msg.Msg){
			case WM_NCACTIVATE:
				if(msg.WParam.ToInt32()==TRUE){
					this->Text="Aerotri Manager";
				}
				break;
			case WM_KEYDOWN:
				/*if(msg.WParam==VK_ESCAPE){
					this->Text=S"Tecla esc";
					::PostMessage(vhwnd,WM_KEYDOWN,VK_ESCAPE,lparam);
					return;
				}*/
				break;
			case WM_NCHITTEST:
			case WM_NCMOUSEMOVE:
				if(!ventana->is_sizable()) break;
				{WINDOWPLACEMENT wpos;
				wpos.length=sizeof(wpos);
				GetWindowPlacement(vhwnd,&wpos);
				if(wpos.showCmd!=SW_SHOWNORMAL) break;
				}
				{__int16 x,y;
				x=GET_X_LPARAM(lparam);
				y=GET_Y_LPARAM(lparam);
				msg_result=DefWindowProc((HWND)msg.HWnd.ToPointer(),msg.Msg,msg.WParam.ToInt32(),msg.LParam.ToInt32());
				if(((uintptr_t)msg.WParam.ToPointer()==HTBORDER || (uintptr_t)msg.WParam.ToPointer()==HTCAPTION) && y<this->Top+12){
					if(x<this->Left+4) msg_result=HTTOPLEFT;
					else if(x>this->Right-4) msg_result=HTTOPRIGHT;
					else if(y<this->Top+4) msg_result=HTTOP;
				}}
				msg.Result=IntPtr(msg_result);
				if(msg.Msg==WM_NCHITTEST) return;

				if(msg_result==HTTOPLEFT) this->Cursor=Cursors::SizeNWSE;
				else if(msg_result==HTTOPRIGHT) this->Cursor=Cursors::SizeNESW;
				else if(msg_result==HTTOP) this->Cursor=Cursors::SizeNS;
				else this->Cursor=Cursors::Default;
				break;
			case WM_NCLBUTTONDOWN:
				if(this->Cursor==Cursors::Default) break;
				SetCapture(hwnd);
				movCursor=this->Cursor;
				if(movCursor==Cursors::SizeNWSE) this_resizing=1;
				else if(movCursor==Cursors::SizeNS) this_resizing=2;
				else if(movCursor==Cursors::SizeNESW) this_resizing=3;
				pressed_point.X=(__int16)(lparam & 0xFFFF);
				pressed_point.Y=(__int16)(lparam>>16);
				if(vhwnd!=NULL){
					GetWindowRect(vhwnd,&rect);
					PressedSize.Width=rect.right-rect.left;
					PressedSize.Height=rect.bottom-rect.top;
				}
				this->Cursor=movCursor;
				break;
			case WM_MOUSEMOVE:
				if(!this_resizing) break;
				POINT diff_point;
				SIZE prov, minsize;
				RECT rect;
				ppunto.x=GET_X_LPARAM(lparam);
				ppunto.y=GET_Y_LPARAM(lparam);
				ClientToScreen(hwnd,&ppunto);
				diff_point.x=ppunto.x-pressed_point.X;
				diff_point.y=ppunto.y-pressed_point.Y;

				prov.cx=PressedSize.Width;
				prov.cy=PressedSize.Height;
				prov.cy-=diff_point.y;
				minsize=ventana->get_minsize();
				if(prov.cy<minsize.cy) prov.cy=minsize.cy;
				if(this_resizing!=2){
					if(this_resizing==3) prov.cx+=diff_point.x;
					else /*1*/ prov.cx-=diff_point.x;
					if(prov.cx<minsize.cx) prov.cx=minsize.cx;
				}
				GetWindowRect(vhwnd,&rect);
				rect.top=rect.bottom-prov.cy;
				if(this_resizing==1) rect.left=rect.right-prov.cx;
				moving=true;
				SetWPos(hwnd,rect.left,rect.top-this->Height);
				SetWRect(vhwnd,rect.left,rect.top,prov.cx,prov.cy);
				moving=false;
				break;
			case WM_LBUTTONUP:
				if(this_resizing){
					this_resizing=0;
					ReleaseCapture();
					GetWindowRect(vhwnd,&rect);
					this->Width=rect.right-rect.left;
					this->Cursor=Cursors::Default;
					this->Text="Aerotri Manager";
				}
		}
		Form::WndProc(msg);
	}

	public:
		System::Void FormMaster_SizeChanged(System::Object^, System::EventArgs^){
			//if(inizialized==false) return;
			if(this->WindowState==FormWindowState::Minimized) return;

			int X=this->ClientSize.Width;
			if(X<sizemin){
				this->ClientSize=::Size(sizemin,this->ClientSize.Height);
				return;
			}

			this->SuspendLayout();
			this->label1->Width=X-4;
			this->label2->Width=X-4;

			/*float h,intervalo;
			h=X-BOTSIZE*notros;
			if(h>BOTSIZE>>2) h=BOTSIZE>>2;
			intervalo=BOTSIZE;
			for(uint i=0;i<notros;i++,h+=intervalo){
				OtherButtons[i]->Left=h;
			}*/
			this->LblMaster->Left=(X-this->LblMaster->Width)/2;
			this->ResumeLayout(false);
		}

		void set_idioma(u8int _idioma){
			if(_idioma==idioma) return;
			etiquetas(idioma);
		}
		void etiquetas(u8int _idioma){
			idioma=_idioma;
			switch(_idioma){
				case 1: etiquetas_eng(); break;
				case 2: etiquetas_it(); break;
				default:etiquetas_esp(); break;
			}
		}

		void etiquetas_esp(){
			Herramientas->Text= "Manager";
			HAdministrador->Text= "Visor de procesos";
			AAcercade->Text= "Acerca de Aerotri Manager";
			AManual->Text= "Manual";
		}
		void etiquetas_eng(){
			Herramientas->Text= "Manager";
			HAdministrador->Text= "Process viewer";
			AAcercade->Text= "About Aerotri Manager";
			AManual->Text= "Manual";
		}
		void etiquetas_it(){
			Herramientas->Text= "Manager";
			HAdministrador->Text= "Visore di processi";
			AAcercade->Text= "Su Aerotri Manager";
			AManual->Text= "Manuale";
		}
};
