using namespace System;
using namespace System::Windows;
using namespace System::Windows::Forms;
using namespace System::Drawing;
using namespace System::Runtime::InteropServices;
using Globales::Colores;

#define STACK_FLAG STACK_SIZE_PARAM_IS_A_RESERVATION
#define THREADS_UNSTARTED 0
#define THREADS_ENDED 1
#define THREADS_RUNNING 2

#define texto(i) TEXTOS_master[idioma][i]
#define strncmp16(str1,str2,n) wcsncmp((wchar_t*)str1,(wchar_t*)str2,n)

System::Void FormMaster_LocationChanged(System::Object^ sender, System::EventArgs^ e);

inline void InitInitInfo(InitDependent_Info *info1, bool visible){
	info1->parent=app_hwnd;
	info1->idioma=idioma;
	info1->location.x=MC::MasterM->Left;
	info1->location.y=MC::MasterM->Top+MC::MasterM->Height;
	info1->visible=visible;
}
//Copia todo menos threadid y mode
static void copia_initinfo(InitDependent_Info *info1, InitDependent_Info *info2){
	int k=info1->threadid;
	int m=info1->mode;
	*info1=*info2;
	info1->threadid=k;
	info1->mode=m;
}

u8int get_runningstate(u8int i){
	PerThreadData *pth=&Tabs.threaddata[i];
	if(pth->handle==NULL){
		if(pth->step!=0) return THREADS_ENDED;
		return THREADS_UNSTARTED;
	}else{
		DWORD code;
		GetExitCodeThread(pth->handle,&code);
		if(code==STILL_ACTIVE) return THREADS_RUNNING;
		else return THREADS_ENDED;
	}
}

inline IVentanaModule* get_ventana(int Id){
	if(Id==0) return NULL;
	return Tabs.threaddata[Id-1].ventana;
}
inline IVentanaModule* get_ventana(){
	return get_ventana(CurrentApplication);
}
inline HWND get_vhwnd(int Id){
	if(Id==0) return NULL;
	return Tabs.threaddata[Id-1].hventana;
}
inline HWND get_vhwnd(){
	return get_vhwnd(CurrentApplication);
}

int SetupApp(char16_t** argv){
	notros=0;
	idioma=0;

	aj_malloc_add(exepath,char16_t,strlen16((char16_t*)_wpgmptr)+1);
	strcpy16(exepath,(char16_t*)_wpgmptr);
	{char16_t *s; path_get_filename16(exepath,s); *s=u'\0';}

	SHGetFolderPathW(NULL,CSIDL_APPDATA,NULL,SHGFP_TYPE_CURRENT,(wchar_t*)appdata);
	{char16_t *s=appdata; while(*s) s++; strcpy16(s,u"\\Aerotri\\");}
	{String^ AppData=gcnew String((wchar_t*)appdata);
	if(!System::IO::Directory::Exists(AppData)) System::IO::Directory::CreateDirectory(AppData);}

	idioma=-1;
	{char16_t fconfig[MAX_PATH+20];
	strbuild16(fconfig,appdata,u"Master.config",NULL);
	leefile_keyvals(fconfig,&procesa_linea_config,NULL);
	}
	if(idioma==-1) read_reg_language("SOFTWARE\\Aerotri","InstallLanguage",&idioma);
	if(idioma>Id_It) idioma=0;

	char16_t** ptr=argv;
	//if(*ptr!=NULL) ptr++;
	while(*ptr!=NULL){
		char16_t *s=*ptr;
		if(s[0]==u'-' && s[1]==u'-'){
			ptr++; if(*ptr!=NULL) ptr++;
			continue;
		}
		ptr++;
		notros++;
	}
	CurrentApplication=0;

	aj_malloc_add(Tabs.comie,InfoComienzo,notros);
	aj_malloc_add(Tabs.modulos,Modulo,notros);
	MasterNewPlain_add(Tabs.threaddata,PerThreadData,notros);
	aj_malloc_add(Tabs.Images32,HICON,notros);
	aj_malloc_add(Tabs.Images16,HICON,notros);
	{typedef char16_t* Tipo[3];
	aj_malloc_add(Tabs.nombres,Tipo,notros);
	aj_malloc_add(Tabs.tooltips,Tipo,notros);}

	cerrando=false;
	if(notros==0) return 0;

	aj_decl_alloc_add(FicheroMaster,ficheros_master,notros);
	ptr=argv/*+1*/;
	Tabs.comie[0].cmdline=NULL;
	//Tabs.comie[0].yokeddata.mode=MODOSUB_YOKEDMAIN;
	for(u8int i=0;;){
		char16_t *s=*ptr;
		if(s[0]==u'-' && s[1]==u'-'){
			if(strncmp16(s,u"--args",6)==0 && (s[6]==0 || (s[6]==u'=' && s[7]==0))){
				ptr++;
				Tabs.comie[i].cmdline=*ptr;
			}else if(strncmp16(s,u"--mode",6)==0 && (s[6]==0 || (s[6]==u'=' && s[7]==0))){
				ptr++;
				Tabs.comie[i].yokeddata.mode=(*ptr)[0]-u'0';
			}else ptr++;
			if(*ptr!=NULL) ptr++;
			continue;
		}
		Tabs.modulos[i++].full_path=*ptr++;
		if(i==notros) break;
		Tabs.comie[i].cmdline=NULL;
		Tabs.comie[i].yokeddata.mode=MODOSUB_YOKED;
	}
	Tabs.comie[0].yokeddata.mode=MODOSUB_YOKEDMAIN;

	uint lenexec=strlen16(exepath);
	for(u8int i=0;i<notros;i++){
		char16_t *name, *ext;
		name=Tabs.modulos[i].full_path;
		if(Path_isabs(name)){
			aj_malloc_add(Tabs.modulos[i].full_path,char16_t,strlen16(name)+strlen16(u".master")+1);
			strcpy16(Tabs.modulos[i].full_path,name);
		}else{
			uint k=lenexec+strlen16(name)+strlen16(u".master")+1;
			aj_malloc_add(Tabs.modulos[i].full_path,char16_t,k);
			makepath16(Tabs.modulos[i].full_path,k,exepath,name);
		}
		for(ext=Tabs.modulos[i].full_path;*ext!=u'\0';ext++);

		path_get_filename16(Tabs.modulos[i].full_path,Tabs.modulos[i].filename);
		aj_malloc_add(Tabs.comie[i].paths.base_dir,char16_t,(pdif)(Tabs.modulos[i].filename-Tabs.modulos[i].full_path)+1);
		char16_t c=*Tabs.modulos[i].filename;
		*Tabs.modulos[i].filename=u'\0';
		strcpy16(Tabs.comie[i].paths.base_dir,Tabs.modulos[i].full_path);
		*Tabs.modulos[i].filename=c;
		//modulename ha de ser un nombre puro
		{uint k=strlen16(Tabs.modulos[i].filename)+1;
		aj_malloc_add(Tabs.modulos[i].modulename,char16_t,k);
		aj_malloc_add(Tabs.comie[i].paths.name,char16_t,k);}
		strcpy16(Tabs.modulos[i].modulename,Tabs.modulos[i].filename);
		strcpy16(Tabs.comie[i].paths.name,Tabs.modulos[i].filename);
		Tabs.comie[i].paths.internal_name=Tabs.comie[i].paths.name;

		aj_malloc_add(ficheros_master[i],KeyVal,N_MASTERCLAVES);
		ficheros_master[i][0].key=ZeroPtr;
		strcpy16(ext,u".master");
		if(leefile_keyvals(Tabs.modulos[i].full_path, &keyval_appmaster, ficheros_master[i])){
			for(KeyVal *ptrj=ficheros_master[i];ptrj->key!=ZeroPtr;ptrj++){Free_remove(ptrj->val.ptr);}
			Free_remove(ficheros_master[i]);
			ficheros_master[i]=NULL;
		}
		strcpy16(ext,u".dll");
	}
	Free_remove(exepath);

	for(u8int i=0;i<notros;i++){
		Tabs.modulos[i].type=1;	//Default type
		if(ficheros_master[i]==NULL) continue;
		//Addto_delete(ficheros_master[i]);
		for(KeyVal *pkey=ficheros_master[i]; pkey->key!=ZeroPtr; pkey++){
			//Addto_delete(pkey->val.ptr);
			u8int k;
			bint elimina=0;
			for(k=0; k<N_MASTERCLAVES; k++){if(pkey->key==(uintptr_t)MasterClaves[k]) break;}
			switch(k){
			case MASTER_CLAVES_InternalName: Tabs.comie[i].paths.internal_name=(char16_t*)pkey->val.ptr; break;
			case MASTER_CLAVES_EntryModule:
				if(strlen16(Tabs.modulos[i].filename)<strlen16((char16_t*)pkey->val.ptr)){
					uint k=(pdif)(Tabs.modulos[i].filename-Tabs.modulos[i].full_path);
					uint k1=k+strlen16((char16_t*)pkey->val.ptr)+1;
					Free_remove(Tabs.modulos[i].full_path);
					aj_malloc_add(Tabs.modulos[i].full_path,char16_t,k1);
					strcpy16(Tabs.modulos[i].full_path,Tabs.comie[i].paths.base_dir);
					Tabs.modulos[i].filename=Tabs.modulos[i].full_path+k;
				}
				strcpy16(Tabs.modulos[i].filename,(char16_t*)pkey->val.ptr);
			case MASTER_CLAVES_Version:
			case MASTER_CLAVES_Type:
				elimina=1;
				break;
			default: continue;
			}
			if(elimina){Free_remove(pkey->val.ptr);}
			pkey->val.ptr=NULL;		//NULL, to skip it faster and not to remove it again
		}
	}

	//MessageBox::Show("");
	{PerThreadData *pthread=Tabs.threaddata;
	for(u8int i=0;i<notros;i++,pthread++){
		pthread->type=Tabs.modulos[i].type;
		pthread->name=Tabs.modulos[i].modulename;
		pthread->texto[0]='\0';
		pthread->handle=NULL;
		pthread->step=0;
		pthread->ventana=NULL;
		pthread->hventana=NULL;
		pthread->infocomie=Tabs.comie+i;
		pthread->inforet.needfree_flags=0;
		pthread->inforet.version=NULL;
		pthread->inforet.fecha=NULL;
		pthread->enlaces=NULL;
		Tabs.comie[i].yokeddata.threadid=i+1;
		Tabs.modulos[i].handle=NULL;
		if(Tabs.modulos[i].type==0) continue;
		if(fileclass16(Tabs.modulos[i].full_path)!=0) Tabs.modulos[i].handle=LoadLibraryW((wchar_t*)Tabs.modulos[i].full_path);
		if(Tabs.modulos[i].handle==NULL) continue;

		KeyVal *pkey=ficheros_master[i];
		char16_t* funcname;
		char func_c[100];
		funcname=get_key(pkey,MasterClaves[MASTER_CLAVES_FuncCreateVentana]);
		if(funcname==NULL) funcname=u"CreateVentana";
		chars___chars16(func_c,funcname);
		Tabs.comie[i].funcs.creaventana=(TypeF_CreateVentana*)GetProcAddress(Tabs.modulos[i].handle,func_c);
		//
		funcname=get_key(pkey,MasterClaves[MASTER_CLAVES_FuncShowVentana]);
		if(funcname==NULL) Tabs.comie[i].funcs.muestraventana=NULL;
		else{chars___chars16(func_c,funcname);
			Tabs.comie[i].funcs.muestraventana=(TypeF_MuestraVentana*)GetProcAddress(Tabs.modulos[i].handle,func_c);}
		//
		funcname=get_key(pkey,MasterClaves[MASTER_CLAVES_FuncMsgLoop]);
		if(funcname==NULL) Tabs.comie[i].funcs.msgloop=NULL;
		else{chars___chars16(func_c,funcname);
			Tabs.comie[i].funcs.msgloop=(TypeF_Suordinanda_MsgLoop*)GetProcAddress(Tabs.modulos[i].handle,func_c);}
		//
		funcname=get_key(pkey,MasterClaves[MASTER_CLAVES_FuncDestroyVentana]);
		if(funcname==NULL) Tabs.comie[i].funcs.destruyeventana=NULL;
		else{chars___chars16(func_c,funcname);
			Tabs.comie[i].funcs.destruyeventana=(TypeF_DestruyeVentana*)GetProcAddress(Tabs.modulos[i].handle,func_c);}

		if(Tabs.comie[i].funcs.creaventana==NULL){
			FreeLibrary(Tabs.modulos[i].handle);
			Tabs.modulos[i].handle=NULL;
		}
	}}

	for(u8int i=0;i<notros;i++){
		Tabs.nombres[i][2]=Tabs.nombres[i][1]=Tabs.nombres[i][0]=Tabs.comie[i].paths.internal_name;
		Tabs.tooltips[i][2]=Tabs.tooltips[i][1]=Tabs.tooltips[i][0]=u"Descripcin no disponible";
		Tabs.Images16[i]=Tabs.Images32[i]=NULL;

		if(ficheros_master[i]!=NULL){
			for(KeyVal *pkey=ficheros_master[i]; pkey->key!=ZeroPtr; pkey++){
				if(pkey->val.ptr==NULL) continue;
				bint elimina=0;
				const char16_t *ppkey=(const char16_t*)pkey->key;
				if(ppkey==MasterClaves[MASTER_CLAVES_Enlaces]){ //Enlaces
					elimina=1;
					if(Tabs.modulos[i].handle==NULL){pkey++; continue;}

					PerThreadData *thdata=&Tabs.threaddata[i];
					char16_t** enlaces=(char16_t**)Basicas::_nogcVarios::split_cmdline((wchar_t*)pkey->val.ptr);
					if(enlaces==NULL) goto salida_outofmem;
					Addto_delete(enlaces);
					uint n;
					char16_t** ptr;
					for(ptr=enlaces;*ptr!=NULL;ptr++); n=(pdif)(ptr-enlaces);
					aj_malloc_add(thdata->enlaces,IEnlace*,n+1);
					IEnlace* *pen=thdata->enlaces;
					for(ptr=enlaces;*ptr!=NULL;ptr++){
						for(u8int k=0;k<notros;k++){
							if(k==i) continue;
							if(strcmp16(*ptr,Tabs.comie[k].paths.name)==0){
								*pen++=Tabs.threaddata+k;
								break;
							}
						}
					}
					*pen=NULL;
					Free_remove(enlaces);
				}else if(ppkey[0]==u'N'){
					if(ppkey==MasterClaves[MASTER_CLAVES_Nombre0]) Tabs.nombres[i][0]=(char16_t*)pkey->val.ptr;
					else if(ppkey==MasterClaves[MASTER_CLAVES_Nombre1]) Tabs.nombres[i][1]=(char16_t*)pkey->val.ptr;
					else if(ppkey==MasterClaves[MASTER_CLAVES_Nombre2]) Tabs.nombres[i][2]=(char16_t*)pkey->val.ptr;
				}else if(ppkey[0]==u'I'){
					if(ppkey==MasterClaves[MASTER_CLAVES_Info0]) Tabs.tooltips[i][0]=(char16_t*)pkey->val.ptr;
					else if(ppkey==MasterClaves[MASTER_CLAVES_Info1]) Tabs.tooltips[i][1]=(char16_t*)pkey->val.ptr;
					else if(ppkey==MasterClaves[MASTER_CLAVES_Info2]) Tabs.tooltips[i][2]=(char16_t*)pkey->val.ptr;
					else if(ppkey==MasterClaves[MASTER_CLAVES_IconAll]){
						elimina=1;
						aj_decl_alloc_add(char16_t,ficono,strlen16(Tabs.comie[i].paths.base_dir)+strlen16((char16_t*)pkey->val.ptr)+1);
						strbuild16(ficono,Tabs.comie[i].paths.base_dir,(char16_t*)pkey->val.ptr,NULL);
						ExtractIconExW((wchar_t*)ficono,0,&Tabs.Images32[i],&Tabs.Images16[i],1);
						Free_remove(ficono);
					}
				}else{	//Last time keys are looked for
					elimina=1;
				}
				if(elimina){Free_remove(pkey->val.ptr);}
			}
		}

		if(Tabs.Images16[i]==NULL){Tabs.Images16[i]=(HICON)CopyImage(MasterIcon,IMAGE_ICON,16,16,0);}
		if(Tabs.Images32[i]==NULL){Tabs.Images32[i]=(HICON)CopyImage(MasterIcon,IMAGE_ICON,32,32,0);}
		if(Tabs.modulos[i].handle==NULL){
			const char16_t *nomorig=Tabs.nombres[i][0];
			aj_malloc_add(Tabs.nombres[i][0],char16_t,strlen16(nomorig)+strlen16(u" (n.d.)")+1);
			strbuild16(Tabs.nombres[i][0],nomorig,u" (n.d.)",NULL);
			if(Tabs.nombres[i][1]==nomorig) Tabs.nombres[i][1]=Tabs.nombres[i][0];
			else{
				char16_t *pnombre=Tabs.nombres[i][1];
				aj_malloc_add(Tabs.nombres[i][1],char16_t,strlen16(pnombre)+strlen16(u" (n.d.)")+1);
				strbuild16(Tabs.nombres[i][1],pnombre,u" (n.d.)",NULL);
			}
			if(Tabs.nombres[i][2]==nomorig) Tabs.nombres[i][2]=Tabs.nombres[i][0];
			else{
				char16_t *pnombre=Tabs.nombres[i][2];
				aj_malloc_add(Tabs.nombres[i][2],char16_t,strlen16(pnombre)+strlen16(u" (n.d.)")+1);
				strbuild16(Tabs.nombres[i][2],pnombre,u" (n.d.)",NULL);
			}
		}
		wcsncpy((wchar_t*)Tabs.threaddata[i].texto,(const wchar_t*)Tabs.nombres[i][idioma],120);
	}

	//Eliminar cada fichero_master. Los val.ptr que quedan sin eliminar estn en uso, as que no se eliminan
	{durchlaufei(KeyVal*,ficheros_master,notros){if(*ptri!=NULL){Free_remove(*ptri);}}}
	Free_remove(ficheros_master);
	return 0;

salida_outofmem:
	return AT_NOMEM;
}

void anula(int i){
	/*image_enabled(Tabs.Images32[i]);
	Tabs.Images32[i]=static_cast<Image^>(bmp);*/
	MC::MasterM->OtherButtons[i]->Enabled=false;
}

inline void BeginThread(PerThreadData *thread){
	thread->handle=(void*)_beginthreadex(NULL, 0x10000, &RunThread, thread, STACK_FLAG | CREATE_SUSPENDED, NULL);
	if(thread->handle!=NULL) ResumeThread(thread->handle);
}
void StartupThreads(void){
	if(!notros) return;
	InitDependent_Info Info0;
	InitInitInfo(&Info0,false);
	for(u8int i=notros;;){
		i--;
		if(Tabs.modulos[i].handle==NULL) anula(i);
		if(i==0) break;
		if(Tabs.modulos[i].handle==NULL) continue;
		PerThreadData *thread=&Tabs.threaddata[i];
		copia_initinfo(&thread->infocomie->yokeddata,&Info0);
		BeginThread(thread);
	}
}

void set_administrador(bool enable){
	u8int n;
	u8int* sel;
	array<String^>^ estados;
	unsigned int* cerrar;
	sel=n_malloc(u8int,notros);
	estados=gcnew array<String^>(notros);
	cerrar=n_malloc(unsigned int,notros);

	n=0;
	for(u8int i=0;i<notros;i++){
		int running=get_runningstate(i);
		if(running!=THREADS_UNSTARTED){
			sel[n]=i;
			if(running==THREADS_RUNNING){
				estados[n]=gcnew String((wchar_t*)texto(2));
				if(enable) cerrar[n]=2;
				else cerrar[n]=1;
			}else{
				estados[n]=gcnew String((wchar_t*)texto(0));
				cerrar[n]=0;
			}
			n++;
		}
	}

	MC::Visor1->actualiza_todo(sel,n,estados,cerrar);
	free(cerrar);
}
inline void set_administrador(){set_administrador(true);}

void oculta(){
	int Id=CurrentApplication;
	if(CurrentApplication==0) return;
	HWND vhwnd=get_vhwnd(Id);
	//for(HWND *ptr=&owneds[0]; *ptr!=NULL; ptr++) \
		SetWindowLongPtr(*ptr,GWL_HWNDPARENT,(uintptr_t)MC::MasterM->hwnd);
	ShowOwnedPopups(vhwnd,FALSE);
	ShowWindowAsync(vhwnd,SW_HIDE);
	CurrentApplication=0;
}
void muestra(int Id){
	RECT rect;
	HWND vhwnd=get_vhwnd(Id);
	GetWindowRect(MC::MasterM->hwnd,&rect);
	SetWPos(vhwnd,rect.left,rect.bottom);
	CurrentApplication=Id;
	ShowWindowAsync(vhwnd,SW_SHOW);
	ShowOwnedPopups(vhwnd,TRUE);
	//for(HWND *ptr=&owneds[0]; *ptr!=NULL; ptr++) \
		SetWindowLongPtr(*ptr,GWL_HWNDPARENT,(uintptr_t)vhwnd);
	GetWindowRect(vhwnd,&rect);
	MC::MasterM->Width=rect.right-rect.left;
	if(!cerrando) set_administrador();
}

void fuerza_cierre(int id, int grado){
	uint Id=(uint)id;
	if(get_runningstate(Id-1)!=THREADS_RUNNING) return;
	PerThreadData *thdata=&Tabs.threaddata[Id-1];
	if(thdata->step==3) return;
	HWND vhwnd=get_vhwnd(Id);
	if(vhwnd==NULL) return;

	if(thdata->step<2){
		if(grado==0){
			PostMessage(vhwnd,MASTERA_CIERRA,0,0);
			MC::Visor1->actualiza(Id,texto(1),3);
			return;
		}
		if(grado==1){
			MC::Visor1->actualiza(Id,texto(1),4);
			PostMessage(vhwnd,WM_KEYDOWN,VK_ESCAPE,0);
			SendMessage(vhwnd,MASTERA_CIERRA2,0,0);
			return;
		}
		if(grado==2){
			//PostThreadMessage((DWORD)thdata->handle,WM_QUIT,0,0);	//Doest not work
			PostMessage(vhwnd,WM_QUIT,0,0);//I would use PostQuitMessage, where it possible to send it to the thread
			return;
		}
	}
	if(thdata->step<2){
		thdata->step=2;		//The code here should be executed in the thread
		if(CurrentApplication==Id) CurrentApplication=0;
		if(thdata->infocomie->funcs.destruyeventana!=NULL) thdata->infocomie->funcs.destruyeventana(thdata->ventana);
		else delete thdata->ventana;
	}
	thdata->step=3;
	ThreadData_clean(thdata);
	PostMessage(app_hwnd,MASTERM_RESPUESTA_CERRAR,Id,MASTERM_RCERRAR_CERRNORMAL);
	TerminateThread(thdata->handle,0);	//I supose this will DestroyWindow(vhwnd);
}

System::Void FormMaster_Closing(System::Object^, System::ComponentModel::CancelEventArgs^ e){
	cerrando=true;
	e->Cancel=true;

	set_administrador(false);
	MC::Visor1->Show();

	u8int i;
	for(i=0;i<notros;i++){
		if(get_runningstate(i)==THREADS_RUNNING) break;
	}
	if(i<notros){
		HWND vhwnd=get_vhwnd(i+1);
		MC::Visor1->actualiza(i+1,texto(1),3);
		//CurrentApplication=0;
		::PostMessage(vhwnd,MASTERA_CIERRA,0,0);
		return;
	}

	guarda_ficheroConfiguracion();
	e->Cancel=false;
}

void button_click(u8int Id){
	if(CurrentApplication!=(int)Id) oculta();
	PerThreadData *thread=&Tabs.threaddata[Id-1];
	u8int estado=get_runningstate(Id-1);
	if(estado==THREADS_ENDED || estado==THREADS_UNSTARTED){
		InitInitInfo(&thread->infocomie->yokeddata,true);
		BeginThread(thread);
	}else{
		muestra(Id);
	}
}
System::Void BotOtros_Click(System::Object^ sender, System::EventArgs^){
	button_click((u8int)((static_cast<Windows::Forms::Control^>(sender))->TabIndex-2));
}

void set_idioma(u8int _idioma){
	if(_idioma==idioma) return;
	idioma=_idioma;
	etiquetas(idioma);

	for(u8int i=0;i<notros;i++){
		if(get_runningstate(i)!=THREADS_RUNNING) continue;
		HWND hwnd=get_vhwnd(i);
		::PostMessage(hwnd,MASTERA_IDIOMA,idioma,0);
	}
}

void evento(unsigned int codigo, uint par1, intptr_t par2){ //par1 es el id de la aplicacin involucrada
	IVentanaModule *ventana;
	HWND vhwnd;
	interior_ptr<Modulo> modulo=&Tabs.modulos[par1-1];
	switch(codigo){
		case MASTERM_INIT:	//Terminado de inicializar
		if(par2==MASTERM_INIT_NA || par2==MASTERM_INIT_FAILURE){
			par1--;
			CloseHandle(Tabs.threaddata[par1].handle);
			Tabs.threaddata[par1].handle=NULL;
			if(par2==MASTERM_INIT_NA){
				IEnlace** e=Tabs.threaddata[par1-1].enlaces;
				if(e!=NULL){Free_remove(e); Tabs.threaddata[par1-1].enlaces=NULL;}
				Tabs.threaddata[par1].handle=NULL;
				anula(par1);
			}
			return;
		}
		ventana=get_ventana(par1);
		if(par2==MASTERM_INIT_VISIBLE){
			if(CurrentApplication!=0 && CurrentApplication!=par1) oculta();
			muestra(par1);
			MC::MasterM->Text=gcnew String((wchar_t*)Tabs.threaddata[par1-1].texto); //WM_NCACTIVATE is not sent, I don't know why
		}
		if(MC::Visor1->Visible) set_administrador();
		break;
		case MASTERM_RESPUESTA_CERRAR:	//Respuesta a mandar cerrarse
		if(par2!=MASTERM_RCERRAR_CANCELAR){	//Se ha cerrado o se ha producido una excepcin
			if(CurrentApplication==par1) CurrentApplication=0;
			WaitForSingleObject(Tabs.threaddata[par1-1].handle,INFINITE);
			CloseHandle(Tabs.threaddata[par1-1].handle);
			if(cerrando){	//Continua cerrando
				PostMessage(app_hwnd,MASTERM_CIERRA,1,0);	//1 slo para que no sea 0
				return;
			}

			MC::Visor1->actualiza(par1,texto(0),0);
			if(CurrentApplication==0){
				MC::MasterM->Size=MC::MasterM->MinimumSize;
				MC::MasterM->Activate();
				MC::MasterM->Text="Aerotri Manager";
			}
			if(par2!=MASTERM_RCERRAR_CERRNORMAL){
				char16_t mensaje[200];
				uint ncausa;
				switch(par2){
				case MASTERM_RCERRAR_EXCEPCION: ncausa=6; break;
				case MASTERM_RCERRAR_OUTOFMEM: ncausa=7; break;
				case MASTERM_RCERRAR_ANOMALO_OTRO:
				default:
					ncausa=8;
				}
				strbuild16(mensaje,texto(5),modulo->modulename,texto(ncausa),NULL);
				MC::MessageBox->Show(gcnew String((wchar_t*)mensaje));
			}
		}else{
			if(cerrando) cerrando=false;
			MC::Visor1->actualiza(par1,texto(2),2);
		}
		break;
	case MASTERM_ESTADO:	//Mensaje de estado mientras no se cierra
		if(CurrentApplication!=par1) button_click((u8int)par1);
		MC::Visor1->actualiza(par1,(char16_t*)par2,3);
		break;
	case MASTERM_ACTIVATED:
		if(CurrentApplication!=par1) return;
		//"An owned window is always above its owner in the z-order". If this were true this code would not be needed
		//Again, Windows' dialogs (e.g. OpenFile dialog) behave their own way
		/*if(par2==0){
			HWND hwnd_ac=GetActiveWindow();
			HWND vhwnd=get_vhwnd(par1);
			if(hwnd_ac!=vhwnd && hwnd_ac!=NULL){
				DWORD thread2;
				//GetWindowThreadProcessId(MC::MasterM->hwnd,&process1);
				thread2=GetWindowThreadProcessId(hwnd_ac,NULL);
				//if(process1==process2)	//hwnd_ac is used instead of vhwnd if this is the test
				if(thread2==(DWORD)Tabs.threaddata[par1-1].handle)
					SetWindowPos(MC::MasterM->hwnd,vhwnd,0,0,0,0,SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);
			}
		}*/
		if(par2!=0){
			MC::MasterM->Text=gcnew String((wchar_t*)Tabs.threaddata[par1-1].texto);
		}
		break;
	case MASTERM_RESIZE:	//Terminado de cambiar el tamao
		if(CurrentApplication!=par1) return;
		{RECT rect;
		vhwnd=get_vhwnd(par1);
		GetWindowRect(vhwnd,&rect);
		rect.right-=rect.left;
		if(rect.right<MC::MasterM->sizemin) rect.right=MC::MasterM->sizemin;
		SetWindowPos(MC::MasterM->hwnd,NULL,rect.left,MC::MasterM->Top,rect.right,MC::MasterM->Height, SWP_NOZORDER | SWP_NOACTIVATE);
		}
		break;
		case MASTERM_IDIOMA:
			set_idioma((char)par2);
			break;
		case MASTERM_TITULO:
			{char16_t *ppar=(char16_t*)par2;
			char16_t *ptexto=Tabs.threaddata[par1-1].texto;
			if(ppar==NULL || *ppar==u'\0')  wcsncpy((wchar_t*)ptexto,(wchar_t*)Tabs.nombres[par1-1][idioma],120);
			else strbuild16(ptexto,Tabs.nombres[par1-1][idioma],u": ",ppar,NULL);
			if(CurrentApplication==par1) MC::MasterM->Text=gcnew String((wchar_t*)ptexto);}
			break;
		case MASTERM_CIERRA:	//Cerrar y salir
			MC::MasterM->Close();
			break;
	}
}

LRESULT __stdcall AppControler_WndProc(HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam){
	if(msg>=MASTERM_BASE && msg<=MASTERM_TOP){
		evento(msg,(uint)wParam,lParam); //wParam es el Id de la aplicacin que lo enva
		return 0;
	}
	return DefWindowProc(hwnd,msg,wParam,lParam);
}

void etiquetas(u8int _idioma){
	if(MC::MasterM!=nullptr) MC::MasterM->etiquetas(_idioma);
	if(MC::Acercade1!=nullptr) MC::Acercade1->etiquetas(_idioma);
	if(MC::Visor1!=nullptr) MC::Visor1->etiquetas(_idioma);
	for(uint i=0;i<notros;i++)
		MC::MasterM->ToolTip1->SetToolTip(MC::MasterM->OtherButtons[i],gcnew String((wchar_t*)Tabs.tooltips[i][_idioma]));
			
	if(_idioma==0) MC::ManualPath= "Manuales_html\\esp\\AerotriManager.htm";
	else if(_idioma==1) MC::ManualPath= "Manuales_html\\eng\\AerotriManager_eng.htm";
	else MC::ManualPath= "Manuales_html\\it\\AerotriManager_it.htm";
}

System::Void Acercade_Closing(System::Object^, System::ComponentModel::CancelEventArgs^ e){
	e->Cancel=true;
	MC::Acercade1->Hide();
}
System::Void AAcercade_Click(System::Object^, System::EventArgs^){
	bint b=false;
	if(MC::Acercade1==nullptr){
		b=true;
		aj_decl_alloc_add(char16_t*,nombres,notros);
		for(uint i=0;i<notros;i++){
			nombres[i]=Tabs.nombres[i][idioma];
		}
		MC::Acercade1= gcnew AcercadeMaster(idioma,Tabs.modulos,Tabs.threaddata,notros,Tabs.Images32,nombres);
		MC::Acercade1->Closing+= gcnew System::ComponentModel::CancelEventHandler(&Acercade_Closing);
	}
	MC::Acercade1->Show();
	/*if(b){
		HWND ahwnd, hwnd;
		ahwnd=(HWND)(void*)MC::Acercade1->Handle;
		if(CurrentApplication==0) hwnd=MC::MasterM->hwnd;
		else hwnd=get_vhwnd(CurrentApplication);
		SetWindowLongPtr(ahwnd,GWL_HWNDPARENT,(uintptr_t)hwnd);
		HWND *ptr=&owneds[0];
		while(*ptr) *ptr++; *ptr=ahwnd;
	}*/
	return;

salida_outofmem:
	MC::MessageBox->Show("El sistema se ha quedado sin memoria. No se puede mostrar la ventana");
}

System::Void HAdministrador_Click(System::Object^, System::EventArgs^){
	set_administrador();
	MC::Visor1->Show();
}

System::Void AManual_Click(System::Object^, System::EventArgs^){
	String^ ManualRoute=String::Concat(Application::StartupPath,"\\",MC::ManualPath);
	try{
		System::Diagnostics::Process::Start(ManualRoute);
	}catch(System::ComponentModel::Win32Exception^){
		int n=ManualRoute->LastIndexOf('\\')+1;
		String^ ManualName=ManualRoute->Substring(n);
		ManualRoute=ManualRoute->Substring(0,n);
		String^ sss=String::Concat(gcnew String((wchar_t*)texto(3)),ManualName,",");
		sss=String::Concat(sss,"\n\n",gcnew String((wchar_t*)texto(4)),ManualRoute);
		MC::MessageBox->Show(sss);
	}
}

System::Void FormMaster_LocationChanged(System::Object^, System::EventArgs^){
	if(MC::MasterM->moving==true || IsIconic(MC::MasterM->hwnd)) return;

	HWND vhwnd=get_vhwnd(CurrentApplication);
	if(vhwnd==NULL) return;
	RECT rect;
	GetWindowRect(MC::MasterM->hwnd,&rect);
	SetWPos(vhwnd,rect.left,rect.bottom);
}

void CreateFormMaster(u8int notros){
	MC::MasterM=gcnew FormMaster(notros);
	for(u8int i=0;i<notros;i++){
		MC::MasterM->OtherButtons[i]->Image=System::Drawing::Bitmap::FromHicon((IntPtr)(void*)Tabs.Images32[i]);
		MC::MasterM->OtherButtons[i]->Click+= gcnew System::EventHandler(&BotOtros_Click);
	}

	MC::MasterM->HAdministrador->Click+= gcnew System::EventHandler(&HAdministrador_Click);
	MC::MasterM->AAcercade->Click+= gcnew System::EventHandler(&AAcercade_Click);
	MC::MasterM->AManual->Click+= gcnew System::EventHandler(&AManual_Click);

	MC::MasterM->Closing+= gcnew System::ComponentModel::CancelEventHandler(&FormMaster_Closing);
	MC::MasterM->SizeChanged+= gcnew System::EventHandler(MC::MasterM, &FormMaster::FormMaster_SizeChanged);
	MC::MasterM->LocationChanged+= gcnew System::EventHandler(&FormMaster_LocationChanged);

	MC::MasterM->hwnd=(HWND)MC::MasterM->Handle.ToPointer();

	MC::Visor1= gcnew Administrador(gcnew Administrador::CerrarProceso_delegate(&fuerza_cierre));
	MC::Visor1->TopMost=true;
}
