	private ref class Administrador : public System::Windows::Forms::Form{
	public: delegate void CerrarProceso_delegate(int, int grado);
	private:
		ref class grupothread : public System::Windows::Forms::ContainerControl{
			public:
				int ThreadId;
				Label ^lblicono, ^lblnombre, ^lblestado;
				Button^ botcerrar;
				CerrarProceso_delegate^ avisa_cerrar;
				int grado;

			public: 
			grupothread(HICON image, const char16_t* nombre){
				lblicono= gcnew Label();
				lblnombre= gcnew Label();
				lblestado= gcnew Label();
				botcerrar= gcnew Button();
				grado=0;
				// 
				// lblicono
				// 
				lblicono->Image= System::Drawing::Bitmap::FromHicon(IntPtr((void*)image));
				lblicono->Location= Drawing::Point(0, 2);
				lblicono->Size= Drawing::Size(20, 20);
				lblicono->TabIndex= 0;
				// 
				// lblnombre
				// 
				lblnombre->Location= Drawing::Point(28, 0);
				lblnombre->Size= Drawing::Size(92, 24);
				lblnombre->TabIndex= 1;
				lblnombre->TextAlign=ContentAlignment::MiddleCenter;
				if(nombre!=NULL) lblnombre->Text=gcnew String((wchar_t*)nombre);
				else	lblnombre->Text= "";
				// 
				// lblestado
				//
				lblestado->Location= Drawing::Point(120, -4);
				lblestado->Size= Drawing::Size(220, 34);
				lblestado->TabIndex= 2;
				lblestado->TextAlign=ContentAlignment::MiddleCenter;
				lblestado->Text= "";
				//
				// botcerrar
				//
				botcerrar->Location= Drawing::Point(340, 2);
				botcerrar->Size= Drawing::Size(80,20);
				botcerrar->TextAlign=ContentAlignment::MiddleCenter;
				botcerrar->Text= "Cerrar";
				botcerrar->FlatStyle=FlatStyle::Popup;
				botcerrar->BackColor=Drawing::Color::FromArgb(Globales::Colores::cFlatPopUp);
				botcerrar->TabIndex=3;
				botcerrar->Click+= gcnew EventHandler(this, &Administrador::grupothread::botcerrar_Click);
				botcerrar->EnabledChanged+= gcnew EventHandler(this, &Administrador::grupothread::botcerrar_EnabledChanged);
				//
				//this
				//
				this->Size=Drawing::Size(420,28);
				this->Controls->Add(lblicono);
				this->Controls->Add(lblnombre);
				this->Controls->Add(lblestado);
				this->Controls->Add(botcerrar);
			}
			System::Void botcerrar_Click(Object^, System::EventArgs^){
				if(avisa_cerrar!=nullptr)
					avisa_cerrar->Invoke(ThreadId,grado);
			}
			System::Void botcerrar_EnabledChanged(Object^, System::EventArgs^){
				if(botcerrar->Enabled==false) botcerrar->BackColor=Color::FromArgb(Globales::Colores::cForm);
				else this->botcerrar->BackColor=Color::FromArgb(Globales::Colores::cFlatPopUp);
			}
		};

	private:
		CerrarProceso_delegate^ parent_cierra;
		array<grupothread^>^ grupos;
		unsigned int n;
		static Drawing::Font ^TextoBold, ^TextoFuerzaBold;
		String ^textocierra, ^textofuerza;
	public: 
		Administrador(CerrarProceso_delegate^ _delegado){
			parent_cierra=_delegado;
			TextoBold=gcnew Drawing::Font("Microsoft Sans Serif", 9.25F, FontStyle::Bold);
			TextoFuerzaBold=gcnew Drawing::Font("Microsoft Sans Serif", 8.25F, FontStyle::Bold);
			InitializeComponent();
			this->Icon= ::Icon::FromHandle((IntPtr)(void*)MasterIcon);
			n=0;
			this->AcceptButton=nullptr;
			colores();
		}

	private:
		void InitializeComponent(void)	{
			this->AutoScaleBaseSize= Drawing::Size(5, 13);
			this->ClientSize= Drawing::Size(440, 273);
			this->Name= "Administrador";
			this->Text= "Visor de procesos";
			this->Closing+= gcnew System::ComponentModel::CancelEventHandler(this, &Administrador::Administrador_Closing);
		}
	public: void actualiza_todo(u8int selec[], u8int _n, array<String^>^ estados, unsigned int cerrar[]){
				unsigned int i;
				grupothread^ gp;
				int y;

				for(i=n;i--;){
					this->Controls->Remove(grupos[i]);
					delete grupos[i];
				}
				n=_n;
				grupos= gcnew array<grupothread^>(n);
				y=12;
				for(i=0;i<n;i++){
					u8int ib=selec[i];
					gp=gcnew grupothread(Tabs.Images16[ib],Tabs.nombres[ib][idioma]);
					gp->ThreadId=Tabs.threaddata[ib].infocomie->yokeddata.threadid;
					gp->lblestado->Text=estados[i];
					gp->botcerrar->Text=textocierra;
					if(cerrar[i]==0) gp->botcerrar->Visible=false;
					else if(cerrar[i]==1) gp->botcerrar->Enabled=false;
					gp->avisa_cerrar+=gcnew CerrarProceso_delegate(this,&Administrador::cierre_forzado);
					if(cerrar[i]>=3){
						gp->lblestado->Font=TextoBold;
						grupos[i]->grado=cerrar[i]-2;
					}
					gp->Location= Point(8,y);
					y+=32;
					grupos[i]=gp;
					this->Controls->Add(gp);
				}
				this->ClientSize=Drawing::Size(this->ClientSize.Width,y+12);
			}

	private: void __actualiza(int j,String^ estado, unsigned int cerrar){
				grupos[j]->lblestado->Text=estado;
				if(cerrar==0) grupos[j]->botcerrar->Visible=false;
				else{
					grupos[j]->botcerrar->Visible=true;
					grupos[j]->botcerrar->Font=Button::DefaultFont;
					if(cerrar==1) grupos[j]->botcerrar->Enabled=false;
					else grupos[j]->botcerrar->Enabled=true;
				}
				if(cerrar<3){
					grupos[j]->lblestado->Font=Label::DefaultFont;
					grupos[j]->grado=0;
					grupos[j]->botcerrar->Text=textocierra;
				}else{
					grupos[j]->lblestado->Font=TextoBold;
					grupos[j]->botcerrar->Text=textofuerza;
					grupos[j]->grado=cerrar-2;
					if(cerrar>3) grupos[j]->botcerrar->Font=TextoFuerzaBold;
				}
			}
	public: void actualiza(int Id,const char16_t* estado, unsigned int cerrar){
				unsigned int j;
				for(j=0;j<n;j++)
					if(grupos[j]->ThreadId==Id) break;
				if(j==n) return;
				__actualiza(j,gcnew String((wchar_t*)estado),cerrar);
			}
			void actualiza(int Id,unsigned int cerrar){
				unsigned int j;
				for(j=0;j<n;j++)
					if(grupos[j]->ThreadId==Id) break;
				if(j==n) return;
				__actualiza(j,grupos[j]->lblestado->Text,cerrar);
			}
	private:
		System::Void Administrador_Closing(System::Object^, System::ComponentModel::CancelEventArgs^ e){
			 e->Cancel=true;
			 this->Hide();
		 }
		 void cierre_forzado(int Id, int grado){
			 parent_cierra->Invoke(Id, grado);
		 }

	private: void colores(){
			this->BackColor=Color::FromArgb(Globales::Colores::cForm);
		}

	public: void etiquetas(u8int _idioma){
			switch(_idioma){
				case 1:  etiquetas_eng(); break;
				case 2:  etiquetas_it(); break;
				default:etiquetas_esp(); break;
			}
		}
	private:
		void etiquetas_esp(){
			this->Text= "Visor de procesos";
			textocierra= "Cerrar";
			textofuerza="Forzar salida";
		}
		void etiquetas_eng(){
			this->Text= "Process viewer";
			textocierra= "Close";
			textofuerza="Force exit";
		}
		void etiquetas_it(){
			this->Text="Visore di processi";
			textocierra="Uscita";
			textofuerza="Forza l'uscita";
		}
};
