using namespace ControlesAt;

private ref class AcercadeMaster : public System::Windows::Forms::Form{
	public:
		static ::Font^ FontProducto=gcnew ::Font("Verdana", 8.25F);

		AcercadeMaster(u8int idioma, Modulo* modulos, PerThreadData* threads, u8int n, HICON* images, char16_t** nombres){
			grupoproducto^ gp;
			uint y;
			array<String^>^ Todos;
			u8int ntodos,notros;

			this->Icon= ::Icon::FromHandle((IntPtr)(void*)MasterIcon);
			InitializeComponent();
			etiquetas(idioma);

			notros=0;
			y=160;
			for(u8int i=0;i<n;i++){
				char16_t* s=nombres[i];
				for(u8int j=0;j<i;j++){
					if(!strcmp16(s,nombres[j])) goto next;
				}
				gp=gcnew grupoproducto(&modulos[i],&threads[i].inforet,images[i],s);
				gp->Location=Point(40,y);
				this->Controls->Add(gp);
				y+=40;
				notros++;
			next:;
			}

			bool b=false;
			String^ AppPath=String::Concat(Application::StartupPath,"\\");
			Todos=System::IO::Directory::GetFiles(AppPath, "*.master");
			ntodos=(u8int)Todos->Length;
			for(u8int i=0;i<ntodos;i++){
				Todos[i]=System::IO::Path::GetFileNameWithoutExtension(Todos[i]);
				String^ s=String::Concat(AppPath,Todos[i],".dll");
				if(!System::IO::File::Exists(s)) continue;
				s=Todos[i];
				IntPtr P_s=Marshal::StringToHGlobalUni(s);
				for(u8int j=0;j<n;j++){if(strcmp16((char16_t*)P_s.ToPointer(),modulos[j].modulename)==0) goto next2;}
				for(u8int j=0;j<i;j++){if(String::Compare(s,Todos[j])==0) goto next2;}

				if(!b){
					y+=16;
					label3->RefLocation=System::Drawing::Point(20, y);
					label3->Visible=b=true;
					y+=32;
				}
				ControlesAt::BaseLabel^ gp=gcnew BaseLabel();
				gp->Font=FontProducto;
				gp->TextAlign=ControlesAt::TwoDimAlignment(0.5F,0);
				gp->Text=s;
				gp->RefLocation=Point(150,y);
				this->Controls->Add(gp);
				y+=24;
			next2:
				Marshal::FreeHGlobal(P_s);
			}

			y+=16;
			this->ClientSize=Drawing::Size(this->ClientSize.Width,y);
			colores();
		}

	private:
		Label ^LblFecha, ^LblVersion;
		ControlesAt::BaseLabel ^label2, ^label3;
		Label ^LblTitulo0, ^LblIcono, ^LblTitulo1;
		ContainerControl^ GBox1;

		void InitializeComponent(void)	{
			int wd=342;
			LblTitulo0= gcnew Label();
			LblIcono= gcnew Label();
			LblTitulo1= gcnew Label();
			LblFecha= gcnew Label();
			LblVersion= gcnew Label();
			label2= gcnew BaseLabel();
			label3= gcnew BaseLabel();
			GBox1= gcnew ContainerControl();
			GBox1->SuspendLayout();
			this->SuspendLayout();
			//
			// LblTitulo0
			//
			LblTitulo0->Font= gcnew System::Drawing::Font("Sylfaen", 11.25F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			LblTitulo0->Location= System::Drawing::Point(0, 8);
			LblTitulo0->Size= System::Drawing::Size(wd, 24);
			LblTitulo0->TabIndex= 0;
			LblTitulo0->Text= "Aerotri Manager";
			LblTitulo0->TextAlign= System::Drawing::ContentAlignment::TopCenter;
			//
			// LblIcono
			//
			LblIcono->Image= static_cast<Image^>((gcnew System::Drawing::Icon(this->Icon,32,32))->ToBitmap());
			LblIcono->Location= System::Drawing::Point(48, 64);
			LblIcono->Size= System::Drawing::Size(44, 40);
			LblIcono->TabIndex= 1;
			//
			// LblTitulo1
			//
			LblTitulo1->Font= gcnew System::Drawing::Font("Sylfaen", 9.75F, System::Drawing::FontStyle::Regular, System::Drawing::GraphicsUnit::Point, (System::Byte)0);
			LblTitulo1->Location= System::Drawing::Point(0, 28);
			LblTitulo1->Size= System::Drawing::Size(wd, 23);
			LblTitulo1->TabIndex= 2;
			LblTitulo1->TextAlign= System::Drawing::ContentAlignment::TopCenter;
			//
			// LblFecha
			//
			LblFecha->FlatStyle= FlatStyle::System;
			LblFecha->Location= System::Drawing::Point(100, 88);
			LblFecha->Size= System::Drawing::Size(160, 16);
			LblFecha->TabIndex= 3;
			LblFecha->TextAlign= System::Drawing::ContentAlignment::TopCenter;
			//
			// LblVersion
			//
			LblVersion->FlatStyle= FlatStyle::System;
			LblVersion->Location= System::Drawing::Point(100, 64);
			LblVersion->Size= System::Drawing::Size(160, 16);
			LblVersion->TabIndex= 4;
			LblVersion->TextAlign= System::Drawing::ContentAlignment::TopCenter;
			//
			// label2, 3
			//
			label2->Font= gcnew System::Drawing::Font("Verdana", 9.75F, System::Drawing::FontStyle::Bold);
			label2->RefLocation= System::Drawing::Point(20, 132);		label2->TabIndex= 5;
			label3->RefLocation= System::Drawing::Point(20, 172);		label3->TabIndex= 6;
			label3->Font=label2->Font;
			label3->Visible=false;
			//
			// GBox1
			//
			GBox1->Controls->Add(LblFecha);
			GBox1->Controls->Add(LblVersion);
			GBox1->Controls->Add(LblIcono);
			GBox1->Controls->Add(LblTitulo1);
			GBox1->Controls->Add(LblTitulo0);
			GBox1->Location= System::Drawing::Point(0, 0);
			GBox1->Size= System::Drawing::Size(wd, 120);
			GBox1->TabIndex= 34;
			//
			// AcercadeMaster
			//
			this->AutoScaleBaseSize= System::Drawing::Size(5, 13);
			this->ClientSize= System::Drawing::Size(wd, 415);
			this->Controls->Add(this->GBox1);
			this->Controls->Add(label2);
			this->Controls->Add(label3);
			this->FormBorderStyle= ::FormBorderStyle::FixedSingle;
			this->MaximizeBox= false;
			this->MinimizeBox= false;
			this->ShowInTaskbar= false;
			this->GBox1->ResumeLayout(false);
			this->ResumeLayout(false);
		}

		void colores(){
			this->BackColor=Color::FromArgb(Globales::Colores::cForm);
			GBox1->BackColor=Color::FromArgb(Globales::Colores::cBoton);
		}

	public: void etiquetas(u8int _idioma){
			switch(_idioma){
				case 1: etiquetas_eng(); break;
				case 2: etiquetas_it(); break;
				default:etiquetas_esp(); break;
			}
		}

	private:
		void etiquetas_esp(){
			this->Text="Acerca de Aerotri Manager";
			LblTitulo1->Text="Ejecucin simultnea de Aerotri y otros productos";
			LblVersion->Text= "Versin 1.3";
			LblFecha->Text="28 de agosto de 2014";
			label2->Text="Programas cargados";
			label3->Text="Otras componentes instaladas";
		}
		void etiquetas_eng(){
			this->Text="About Aerotri Manager";
			LblTitulo1->Text="Simultaneous execution of Aerotri and other products";
			LblVersion->Text= "Version 1.3";
			LblFecha->Text="28th August, 2014";
			label2->Text="Loaded programs";
			label3->Text="Other installed products";
		}
		void etiquetas_it(){
			this->Text="Su Aerotri Manager";
			LblTitulo1->Text="Esecuzione simultanea di Aerotri e altri prodotti";
			LblVersion->Text= "Versione 1.2.2";
			LblFecha->Text="28 agosto 2014";
			label2->Text="Programmi caricati";
			label3->Text="Altri componenti installati";
		}

	private:
		ref class grupoproducto : public System::Windows::Forms::ContainerControl{
			public:
				Label^ lblicono;
				BaseLabel^ lblproducto;
				BaseLabel^ lblversion;
				BaseLabel^ lblfecha;

		public: grupoproducto(Modulo *modulo, InfoRetrived *inforet, HICON image, char16_t* nombre){
				lblicono=gcnew Label();
				lblproducto=gcnew BaseLabel();
				lblversion=gcnew BaseLabel();
				lblfecha=gcnew BaseLabel();

				lblicono->Image= System::Drawing::Bitmap::FromHicon((IntPtr)(void*)image);
				lblicono->Location= System::Drawing::Point(0, 0);
				lblicono->Size= System::Drawing::Size(36, 36);
				lblicono->TabIndex=0;

				lblproducto->Font=FontProducto;
				lblproducto->RefLocation= System::Drawing::Point(112, 16);
				lblproducto->MaxWidth=124;
				lblproducto->TextAlign= ControlesAt::TwoDimAlignment(0.5F,0.5F);
				lblproducto->TabIndex=1;

				lblproducto->Text=gcnew String((wchar_t*)nombre);
				lblversion->TextAlign= ControlesAt::TwoDimAlignment(0.5F,0);
				lblfecha->TextAlign= ControlesAt::TwoDimAlignment(0.5F,0);
				if(modulo->handle==NULL){
					//lblproducto->Text+=" (n.d.)";
					lblversion->Text="";
					lblfecha->Text="";
				}else{
					if(inforet->version==NULL) lblversion->Text="???";	else lblversion->Text=gcnew String((wchar_t*)inforet->version);
					if(inforet->fecha==NULL) lblfecha->Text="???";			else lblfecha->Text=gcnew String((wchar_t*)inforet->fecha);
				}
				lblversion->RefLocation= System::Drawing::Point(196, 10);	lblversion->MaxWidth=32;	lblversion->TabIndex=2;
				lblfecha->RefLocation= System::Drawing::Point(252, 10);		lblfecha->MaxWidth=72;		lblfecha->TabIndex=3;
				//
				//this
				//
				this->Size=Drawing::Size(288,36);
				this->Controls->AddRange(gcnew array<Control^>{
					lblicono, lblproducto,
					lblversion, lblfecha
				});
			}
		};
	};
