void PanelGrafico::UpdatePanelDibujoCursor(void){
	POINT c;
	GetCursorPos(&c);
	ScreenToClient(panelDibujo->hwnd,&c);
	if(c.x<0 || c.y<0 || c.x>panelDibujo->width || c.y> panelDibujo->height) return;
	SendMessage(panelDibujo->hwnd,WM_SETCURSOR,(WPARAM)panelDibujo->hwnd, HTCLIENT | (WM_MOUSEMOVE<<16));
}

void PanelGrafico::reset_orden_ctr(void){
	int KeyCodes=0;

	if(GetAsyncKeyState(VK_CONTROL)<0) KeyCodes|=VK_CONTROL;
	set_orden_ctr(KeyCodes);
}
void PanelGrafico::set_orden_ctr(int VK_Code){
	ordenctr.estado=0;
	if(VK_Code&VK_CONTROL){
		ordenctr.orden=OrdenCtr_Mano;
		PictureCursor=ordenctr.cur=&Cursor_Mano_nativo;
		ordenctr.mouse_capture=false;
		ReleaseCapture();
		UpdatePanelDibujoCursor();
	}else{
		ordenctr.orden=Orden_None;
		fallto_orden_w();
	}
}

void PanelGrafico::set_orden_ana(u16int orden){
	CLEARORDER(ordenctr);
	CLEARORDER(ordenw);
	ordenana.orden=orden;
}

void PanelGrafico::Ordenes_clearordenana(void){
	if(ordenana.estado==OrdenAnaState_Candidate0){	//Candidate element was unselected
		ConfigEspecial_libera(elementos_candidatos.elementos[elementos_candidatos.t],GraOpcionE_Seleccion,true,NULL);
	}elif(ordenana.estado==OrdenAnaState_Candidate1){	//Candidate element was selected
		ConfigEspecial_inserta(elementos_candidatos.elementos[elementos_candidatos.t],GraOpcionE_Seleccion,GraOpcionE_Seleccion_Seleccionado,true,NULL);
	}
	CLEARORDER(ordenana);
}
void PanelGrafico::escapeorder(void){
	if(titulo==NULL) return;

	if(ordenctr.orden!=Orden_None) return;
	if(ordenw.orden!=Orden_None){
		CLEARORDER(ordenw);
		fallto_orden_ana();
		return;
	}
	if(ordenana.orden!=Orden_None){
		Ordenes_clearordenana();
		fallto_orden_edit();
		return;
	}
	/*if(ordenedit.orden!=Orden_None){
		Ordenes_clearordenedit();
		return;
	}*/
	Seleccionados_elimina();
}
void PanelGrafico::fallto_orden_w(void){
	if(ordenw.orden==Orden_None){fallto_orden_ana(); return;}
	PictureCursor=ordenw.cur;
	if(ordenw.mouse_capture) SetCapture(panelDibujo->hwnd);
	else ReleaseCapture();
	UpdatePanelDibujoCursor();
}
void PanelGrafico::fallto_orden_ana(void){
	if(ordenana.orden==Orden_None){fallto_orden_edit(); return;}
	PictureCursor=ordenana.cur;
	if(ordenana.mouse_capture) SetCapture(panelDibujo->hwnd);
	else ReleaseCapture();
	UpdatePanelDibujoCursor();
}
void PanelGrafico::fallto_orden_edit(void){
	//if(ordenedit.orden==0){
		ReleaseCapture();
		PictureCursor=NULL;
		UpdatePanelDibujoCursor();
		return;
	//}
	/*if(ordenedit.mouse_capture) SetCapture(panelDibujo->hwnd);
	else ReleaseCapture();
	UpdatePanelDibujoCursor();*/
}
