inline void PanelGrafico::dibuja_y_copia(u8int reason){
	RectVentana rect=RectRECT(panelDibujo->get_ClientRect());
	dibuja(reason,rect);
	pinta_rectangulo(rect);
}
inline void PanelGrafico::redibuja(void){
	if(titulo==NULL) return;
	u8int reason;
	if(modoaj) reason=GraDibujar_AllKnown;
	else reason=GraDibujar_AllUnkown;
	dibuja_y_copia(reason);
}
inline void PanelGrafico::redibuja_pOE(Gra_LinkedOpcionE *pOE){
	RectVentana rect=RectRECT(panelDibujo->get_ClientRect());
	dibuja(GraDibujar_Especiales,rect,pOE);
	pinta_rectangulo(rect);
}
//pOE may be NULL; if not, it need not be NULL terminated
inline void PanelGrafico::redibuja_elemento(uint n, Gra_LinkedOpcionE *pOE){
	Gra_LinkedOpcionE OEnula={NULL,NULL,{n,GraOpcionE_None,0}};
	Gra_LinkedOpcionE *last=NULL;
	if(pOE==NULL || pOE->oe.elem!=n) pOE=&OEnula;
	else{
		last=pOE;
		do last=last->next; while(last!=NULL && last->oe.elem==n);
		if(last!=NULL) last->prev->next=NULL;
	}
	redibuja_pOE(pOE);
	if(last!=NULL) last->prev->next=last;
}

inline void PanelGrafico::clear_fondo(void){
	HDC hdc=GetDC(panelDibujo->hwnd);
	tagPAINTSTRUCT lp;
	::FillRect(hdc,&lp.rcPaint,(HBRUSH)GetStockObject(BLACK_BRUSH));
	EndPaint(panelDibujo->hwnd,&lp);
}
inline void PanelGrafico::pinta_todo(void){
	pinta_rectangulo(RectRECT(panelDibujo->get_ClientRect()));
}
void PanelGrafico::pinta_rectangulo(RectVentana rect){
	if(rect.alto<0 || rect.ancho<0) return;
	HDC hdc=GetDC(panelDibujo->hwnd);

	//uint k;
	//HDC hdc_copia;
	//HBITMAP bitmap;
	//color *pmatriz, *seccion_hdc;

	bitmapgra.bmiHeader.biWidth=vista0.lienzo.ncols;
	bitmapgra.bmiHeader.biHeight=-(ssint)rect.alto;
	bitmapgra.bmiHeader.biSizeImage=rect.alto*vista0.lienzo.ncols*usizeof(color);

	//hdc_copia=CreateCompatibleDC(hdc);
	//bitmap=CreateBitmap(bitmapgra.bmiHeader.biWidth,bitmapgra.bmiHeader.biHeight, \
		bitmapgra.bmiHeader.biPlanes,bitmapgra.bmiHeader.biBitCount, \
		vista0.lienzo.matriz+(vista0.ventana.my+rect.y0)*vista0.lienzo.ncols);
	//bitmap=CreateDIBitmap(hdc,&bitmapgra.bmiHeader,CBM_INIT, \
		vista0.lienzo.matriz+(vista0.ventana.my+rect.y0)*vista0.lienzo.ncols,&bitmapgra,0);
	//bitmap=CreateDIBSection(hdc_copia, &bitmapgra, DIB_RGB_COLORS, (void**)&seccion_hdc, NULL, 0x0);
	/*if(bitmap==NULL){
		DeleteDC(hdc_copia);
		ReleaseDC(panelDibujo->hwnd,hdc);
		return;
	}*/
	//SelectObject(hdc_copia,bitmap);
	//BitBlt(hdc,rect.x0,rect.y0,rect.ancho,rect.alto,hdc_copia,vista0.ventana.mx+rect.x0,0,SRCCOPY);

	/*k=vista0.lienzo.ncols-rect.ancho;
	pmatriz=vista0.lienzo.matriz+(vista0.ventana.my+rect.y0)*vista0.lienzo.ncols+(vista0.ventana.mx+rect.x0);
	dontimes(rect.alto,pmatriz+=k){
		dontimes(rect.ancho,) *seccion_hdc++=*pmatriz++;
	}
	seccion_hdc-=rect.alto*rect.ancho;
	BitBlt(hdc,rect.x0,rect.y0,rect.ancho,rect.alto,hdc_copia,0,0,SRCCOPY);*/

	//This seems to be the only function that doesn't force me to copy the color matrix twice
	SetDIBitsToDevice(hdc,rect.x0,rect.y0,rect.ancho,rect.alto,vista0.ventana.mx+rect.x0,0,0,rect.alto,
		vista0.lienzo.matriz+(vista0.ventana.my+rect.y0)*vista0.lienzo.ncols,&bitmapgra,0);

	//DeleteObject(bitmap);
	//DeleteDC(hdc_copia);
	ReleaseDC(panelDibujo->hwnd,hdc);
}

void PanelGrafico::desplaza(int dx, int dy, int DX, int DY){
	modoaj=false;
	vista0.cambia_tamanno_ventana(dx,dy,DX,DY);
	if(panelDibujo->width<=0 || panelDibujo->height<=0) return;

	RectVentana rect, rect0;
	if(dy<0){
		rect.x0=0; rect.y0=0;
		rect.alto=-dy;
		rect.ancho=panelDibujo->width;
		obtiene_invalido(&vista0,rect,&rect0);
		if(rect0.alto!=0) dibuja(GraDibujar_RectIn,rect0);
	}
	if(DY>0){
		rect.x0=0; rect.y0=panelDibujo->height-DY;
		rect.alto=DY;
		rect.ancho=panelDibujo->width;
		obtiene_invalido(&vista0,rect,&rect0);
		if(rect0.alto!=0) dibuja(GraDibujar_RectIn,rect0);
	}
	if(dx<0 || DX>0){
		if(dy<0) rect.y0=-dy;	else rect.y0=0;
		rect.alto=panelDibujo->height-rect.y0;
		if(DY>0) rect.alto-=DY;
		if(rect.alto<=0) return;
		if(dx<0){
			rect.x0=0;
			rect.ancho=-dx;
			obtiene_invalido(&vista0,rect,&rect0);
			if(rect0.alto!=0) dibuja(GraDibujar_RectIn,rect0);
		}
		if(DX>0){
			rect.x0=panelDibujo->width-DX;
			rect.ancho=DX;
			obtiene_invalido(&vista0,rect,&rect0);
			if(rect0.alto!=0) dibuja(GraDibujar_RectIn,rect0);
		}
	}
}
