﻿LRESULT PanelGrafico::HandleKeys(HWND _unused(hwnd), UINT message, WPARAM wParam, LPARAM lParam){
	switch(message){
	case WM_KEYDOWN:
		if(titulo==NULL) break;
		if(lParam&(1<<30)) break;
		if(wParam==VK_CONTROL) reset_orden_ctr();
		elif(wParam==VK_ESCAPE) escapeorder();
		return 0;
	case WM_KEYUP:
		if(titulo==NULL) break;
		if(ordenctr.estado==0) reset_orden_ctr();
	}
	return 1;
}

LRESULT PanelGrafico::HostedWndProc(UINT message, WPARAM wParam, LPARAM lParam){
	switch(message){
	case WM_CREATE:
		break;
	case WM_CLOSE:
		//Si hay algo sin guardar, preguntar y pedir confirmación
		//if(cancelado){
		//	return 0;
		//}else{
			PostQuitMessage(0);
			return 0;
		//}
	case WM_MOUSEWHEEL:
		if(this->titulo==NULL) return 0;
		{float X,Y, x1,y1,x2,y2;
		float k;
		RECT rpanel;
		short wheel;
		GetWindowRect(panelDibujo->hwnd,&rpanel);
		wheel=(short)HIWORD(wParam);
		if(wheel>0){
			k=0.840896F;
			X=(float)(LOWORD(lParam)-rpanel.left)+0.5F;
			Y=(float)(HIWORD(lParam)-rpanel.top)+0.5F;
			x2=(panelDibujo->width-X)*k;		x1=X*k;
			y2=(panelDibujo->height-Y)*k;		y1=Y*k;
		}else{
			k=1.189207F;
			X=0.5F*panelDibujo->width;
			Y=0.5F*panelDibujo->height;
			x2=x1=k*X;
			y2=y1=k*Y;
		}
		this->ZoomVentana_do(X-x1,Y-y1,X+x2,Y+y2);
		}
		return 0;
	case WM_NOTIFY:
		if(wParam!=ID_TreeOnOff && wParam!=ID_TreeOnOff_Textos) break;
		{LPNMHDR ptrnotify=(LPNMHDR)lParam;
		//TVN_ITEMCHANGED Window Vista or later
		//Workaround for older versions.
		if(ptrnotify->code==NM_CLICK){
			TVHITTESTINFO hittest;
			RECT rect;
			DWORD pt=GetMessagePos();
			GetWindowRect(ptrnotify->hwndFrom,&rect);
			hittest.pt.x=(int)(short)LOWORD(pt)-rect.left;
			hittest.pt.y=(int)(short)HIWORD(pt)-rect.top;
			TreeView_HitTest(ptrnotify->hwndFrom,&hittest);

			nmhdr_send=*ptrnotify;
			nmhdr_send.code=TVN_ASYNC_ITEMCHANGED;
			if(hittest.flags&TVHT_ONITEMSTATEICON) PostMessage(this->hwnd, WM_NOTIFY, wParam, (LPARAM)(&nmhdr_send));
		}elif(ptrnotify->code==TVN_ASYNC_ITEMCHANGED){
			if(wParam==ID_TreeOnOff_Textos)this->update_onoff_textos();
			else this->update_onoff();
			return 1;
		}}
		break;
	}
	return this->Control::HostedWndProc(message, wParam, lParam);
}

LRESULT PanelGrafico::this_Resized(Window *_unused(window), WPARAM _unused(wParam), LPARAM _unused(lParam)){
	if(this->height==0 || this->width==0) return 0;
	int ht, tp, aux;
	ht=this->height;
	tp=0;
	mMenu->refy=tp;		mMenu->width=this->width; tp+=mMenu->height;
	panelTop->refy=tp;		panelTop->width=this->width; tp+=panelTop->height;
	ht-=panelBottom->height; panelBottom->refy=ht; panelBottom->width=this->width;
	aux=((ht-tp)>>1)-2;
	SetWRect(TreeOnOff,this->width-160,tp,160,aux); aux+=tp+4;
	SetWRect(TreeOnOff_Textos,this->width-160,aux,160,ht-aux);
	panelDibujo->refy=tp; panelDibujo->width=this->width-166; panelDibujo->height=ht-tp;

	mMenu->Draw(true);
	panelTop->Draw(true);
	panelBottom->Draw(true);
	panelDibujo->Draw(true);
	return 0;
}

inline void PanelGrafico::set_titulo(const char16_t *_titulo){
	titulo=_titulo;
	if(Report!=NULL) Report(this,PGRA_CHANGED_FILE,(uintptr_t)(void*)_titulo);
}
