﻿bool PanelGrafico::PanelDibujo_WndProc(Window *_unused(caller),UINT message, WPARAM wParam, LPARAM lParam, LRESULT *returned){
	int x,y;
	if(message>=WM_MOUSEFIRST && message<=WM_MOUSELAST && this->titulo==NULL) return false;
	x=(int)(short)LOWORD(lParam);
	y=(int)(short)HIWORD(lParam);
	switch(message){
	case WM_SETCURSOR:
		if(this->PictureCursor!=NULL){SetCursor(this->PictureCursor->cur); goto handled;}
		break;
	case WM_LBUTTONDOWN: this->PanelDibujo_Mousedown((int)wParam,true,x,y); goto handled;
	case WM_RBUTTONDOWN: this->PanelDibujo_Mousedown((int)wParam,false,x,y); goto handled;
	case WM_MOUSEMOVE:	this->PanelDibujo_Mousemove((int)wParam,x,y); goto handled;
	case WM_LBUTTONUP:
	case WM_RBUTTONUP: this->PanelDibujo_Mouseup((int)wParam,x,y); goto handled;
	}
	return false;

handled:
	*returned=0;
	return true;
}

void PanelDibujo::Paint(PAINTSTRUCT *ps){
	PanelGrafico *pg=(PanelGrafico*)GetParentPointer(this);
	if(pg->titulo!=NULL){
		RectVentana rect=RectRECT(ps->rcPaint);
		pg->pinta_rectangulo(rect);
	}
}

LRESULT PanelGrafico::panelDibujo_Resized(Window *pcontrol, WPARAM _unused(wParam), LPARAM _unused(lParam)){
	if(titulo==NULL) return 0;
	RECT nuevo;
	ssint dx,dy, DX, DY;

	PanelDibujo *pdibujo=(PanelDibujo*)pcontrol;

	WINDOWPLACEMENT wplace;
	wplace.length=usizeof(WINDOWPLACEMENT);
	GetWindowPlacement(GetParentHwnd(this),&wplace);
	if(wplace.showCmd==SW_SHOWMINIMIZED){
		return 0;
	}

	GetWindowRect(pdibujo->hwnd,&nuevo);
	dx=nuevo.left-pdibujo->FormerPos.left;
	dy=nuevo.top-pdibujo->FormerPos.top;
	DX=nuevo.right-pdibujo->FormerPos.right;
	DY=nuevo.bottom-pdibujo->FormerPos.bottom;
	if(modoaj){
		vista0.cambia_tamanno_ventana(dx,dy,DX,DY);
		calcula_sis_lienzo_ajustado(&vista0,0.1F);
		PAINTSTRUCT lp;
		BeginPaint(pdibujo->hwnd,&lp);
		EndPaint(pdibujo->hwnd,&lp);
		redibuja();
		POINT p;
		p.x=nuevo.left; p.y=nuevo.top;			ScreenToClient(this->hwnd,&p);		nuevo.left=p.x; nuevo.top=p.y;
		p.x=nuevo.right; p.y=nuevo.bottom;		ScreenToClient(this->hwnd,&p);		nuevo.right=p.x; nuevo.bottom=p.y;
		ValidateRect(this->hwnd,&nuevo);
	}else{
		if(dx!=0 || dy!=0) clear_fondo();
		desplaza(dx,dy,DX,DY);
		if(dx!=0 || dy!=0) pinta_todo();
	}
	return 0;
}

void PanelGrafico::PanelDibujo_Mousedown(int ControlKey, bint left, int x, int y){
	SetFocus(panelDibujo->hwnd);
	if(ControlKey&MK_CONTROL){
		if(ordenctr.estado==0) ordenctr.orden=OrdenCtr_Mano;
	}
	if(ordenctr.orden!=Orden_None){
		if(ordenctr.estado!=0) return;
		ordenctr.Xdown=x;
		ordenctr.Ydown=y;
		switch(ordenctr.orden){
		case OrdenCtr_Mano:
			if(left){
				ordenctr.cur=&Cursor_Puno_nativo;
				ordenctr.estado=1;
				ordenctr.mouse_capture=true;
			}
			break;
		}
		if(ordenctr.estado!=0){	//Otherwise either nothing has happended or it was an instantaneous change
			if(ordenctr.mouse_capture) SetCapture(panelDibujo->hwnd);
			PictureCursor=ordenctr.cur;
			UpdatePanelDibujoCursor();
		}
		return;
	}
	if(ordenw.orden!=Orden_None){
		if(ordenw.estado!=0) return;
		ordenw.Xdown=x;
		ordenw.Ydown=y;
		switch(ordenw.orden){
			case OrdenW_Lupa:
				if(left) Zlupa_do(x+0.5F,y+0.5F);
				else{
					float x2,y2;
					x2=(float)panelDibujo->width*0.5F;
					y2=(float)panelDibujo->height*0.5F;
					ZoomVentana_do(-x2,-y2,(float)panelDibujo->width+x2,(float)panelDibujo->height+y2,false);
				}
				break;
			case OrdenW_Ventana:
				/*ordenw.estado=1;*/
				break;
		}
		if(ordenw.estado!=0){
			PictureCursor=ordenctr.cur;
			if(ordenw.mouse_capture) SetCapture(panelDibujo->hwnd);
			UpdatePanelDibujoCursor();
		}
		return;
	}
	if(ordenana.orden!=Orden_None){
		if(ordenana.estado==OrdenState_None){
			if(!left) return;
			ordenana.Xdown=x;
			ordenana.Ydown=y;
			BuscaElementos(x,y);
			if(elementos_candidatos.n==0) return;
			int nret=ConfigEspecial_inserta(elementos_candidatos.elementos[0],GraOpcionE_Seleccion,GraOpcionE_Seleccion_Candidato,true,NULL);
			if(nret==1) ordenana.estado=OrdenAnaState_Candidate1;
			else ordenana.estado=OrdenAnaState_Candidate0;
			if(elementos_candidatos.n!=1) return;
			goto ordenana_accept;
		}
		//estado==OrdenAnaState_Alternating
		if(!left){	//look for the next one
			if(ordenana.estado==OrdenAnaState_Candidate0){	//Candidate element was unselected
				ConfigEspecial_libera(elementos_candidatos.elementos[elementos_candidatos.t],GraOpcionE_Seleccion,true,NULL);
			}else{	//Candidate element was selected
				ConfigEspecial_inserta(elementos_candidatos.elementos[elementos_candidatos.t],GraOpcionE_Seleccion,GraOpcionE_Seleccion_Seleccionado,false,NULL);
			}
			if(++elementos_candidatos.t==elementos_candidatos.n){
				ordenana.estado=0;
			}else{
				int nret=ConfigEspecial_inserta(elementos_candidatos.elementos[elementos_candidatos.t],GraOpcionE_Seleccion,GraOpcionE_Seleccion_Candidato,false,NULL);
				if(nret==1) ordenana.estado=OrdenAnaState_Candidate1;
				else ordenana.estado=OrdenAnaState_Candidate0;
			}
			dibuja_y_copia(GraDibujar_Especiales);
			return;
		}
		//left
	ordenana_accept:
		if(ordenana.estado==OrdenAnaState_Candidate0 || ordenana.orden!=OrdenAna_Seleccion){
			ConfigEspecial_inserta(elementos_candidatos.elementos[elementos_candidatos.t],GraOpcionE_Seleccion,GraOpcionE_Seleccion_Seleccionado,true,NULL);
		}else{
			ConfigEspecial_libera(elementos_candidatos.elementos[elementos_candidatos.t],GraOpcionE_Seleccion,true,NULL);
		}
		EliminaCandidatos();
		if(ordenana.orden==OrdenAna_Seleccion){
			ordenana.estado=OrdenState_None;
			return;
		}else{ //Proceed
			switch(ordenana.orden){
			case OrdenAna_Infor: /*Mostrar_Informacion();*/ break;
			case OrdenAna_Texto: break; //Mostrar_Texto(); break;
			}
		}
		/*if(ordenana.estado!=0){
			if(ordenana.mouse_capture) SetCapture(panelDibujo->hwnd);
			UpdatePanelDibujoCursor();
		}*/
		return;
	}
	/*if(ordeneedit.orden!=Orden_None){
		if(ordeneedit.mouse_capture) SetCapture(panelDibujo->hwnd);
		return;
	}*/
	PanelDibujo_Mousedown(MK_CONTROL,left,x,y);
}

void PanelGrafico::PanelDibujo_Mousemove(int _unused(ControlKey), int x, int y){
	PuntoXYZ_double pp;
	ATFormatter fout;
	SetupFormatter(&fout);
	ifunlike(fout.error_code) return;

	pp=vista0.ventana_a_interno(x+0.5F,y+0.5F);
	terreno___interno(&pp,grafico.fgrafico);

	setbuf_absolute(&fout);
	if(decX>=0) fout.prec.absol=decX;	else fout.prec.absol=3;
	towrite_double(&fout,pp.X); *fout.ptr='\0';
	memcpy_char8(Texto_coordX,fout.base,40); Texto_coordX[39]='\0';
	fout.ptr=fout.base;
	if(decY>=0) fout.prec.absol=decY;	else fout.prec.absol=3;
	towrite_double(&fout,pp.Y); *fout.ptr='\0';
	memcpy_char8(Texto_coordY,fout.base,40); Texto_coordY[39]='\0';
	toclose(&fout);
	RECT rc={0,0,160,panelBottom->height};
	InvalidateRect(panelBottom->hwnd,&rc,true);

	if(ordenctr.orden!=Orden_None){
		if(ordenctr.estado==0) return;
		switch(ordenctr.orden){
		case OrdenCtr_Mano:
			int dx=ordenctr.Xdown-x,
				dy=ordenctr.Ydown-y;
			desplaza(dx,dy,dx,dy);
			pinta_todo();
			break;
		}
		ordenctr.Xdown=x;
		ordenctr.Ydown=y;
		return;
	}
	if(ordenw.orden!=Orden_None){
		if(ordenw.estado==0) return;
		switch(ordenw.orden){
		case OrdenW_Ventana: //ZVentana
			break;
		default: return;
		}
		ordenw.Xdown=x;
		ordenw.Ydown=y;
		return;
	}
	if(ordenana.orden!=Orden_None){
		if(ordenana.estado==0) return;
		switch(ordenana.orden){
			default: return;
		}
		/*ordenana.Xdown=e.X;
		ordenana.Ydown=e.Y;
		return;*/
	}
	//no ordenedit yet
	return;
}
void PanelGrafico::PanelDibujo_Mouseup(int _unused(ControlKey), int _unused(x), int _unused(y)){
	if(titulo==NULL) return;
	if(ordenctr.orden!=Orden_None){
		//No hay órdenes que se repiten
		reset_orden_ctr();
		return;
	}
	if(ordenw.orden!=Orden_None){
		ordenw.estado=0;
		if(ordenw.orden==OrdenW_Lupa) return;		//Órdenes que se repiten
		CLEARORDER(ordenw);
		fallto_orden_ana();
		return;
	}
}
