﻿#include "PanelGraficoN.h"

//Modos de las ventanas subordinadas
#define MODOSUB_STANDALONE	0

#define MODOSUB_YOKEDMAIN	1
#define MODOSUB_YOKED			2
#define MODOSUB_CUTDOWN		3

PanelGrafico* createSetup_PanelGrafico(HWND parent_hwnd, uint index, char16_t* cmdline, CallbackReport *report){
	PanelGrafico *p=new PanelGrafico(parent_hwnd,index);
	p->Report=report;
	p->Setup(MODOSUB_STANDALONE,cmdline);
	return p;
}

extern "C"{
__declspec(dllexport) PanelCompleto* createSetup_Panel(HWND parent_hwnd, uint index, char16_t* cmdline, CallbackReport *report){
	return createSetup_PanelGrafico(parent_hwnd,index, cmdline, report);
}
__declspec(dllexport) PanelCompleto* createPanel(CallbackReport report){
	PanelGrafico *p=new PanelGrafico();
	p->Report=report;
	return p;
}
}
int PanelGrafico::cierra(void){
	if(this->titulo!=NULL) EliminaGrafico();
	Destroy();
	return 0;
}

void PanelGrafico::Destroy(void){
	delete this->Lupa;
	delete this->Zmas;
	delete this->Ajustar;
	delete this->CBoxconfigs;
	delete this->panelDibujo;
	delete this->panelBottom;
	delete this->panelTop;
	delete this->MenuW1;
	delete this->MenuW0;
	delete this->mMenu;
	//delete this;
}

int PanelGrafico::Setup(int mode, char16_t* argv){
	this->mMenu=new MainMenu;
	this->MenuW0=new MenuWindow;
	this->MenuW1=new MenuWindow;
	this->panelTop=new Control;
	this->panelBottom=new Control;
	this->panelDibujo=new PanelDibujo;
	HINSTANCE hInst=GetModuleHandle(NULL);	//Gets the handle of the executable file, but so does passing NULL, so make Windows get it just once

	//MENUS
	mmenus[mmi_Archivo].submenu= submenus+subm_Archivo;
	mmenus[mmi_Buscar].submenu= submenus+subm_Buscar;
	mmenus[mmi_Herramientas].submenu= submenus+subm_Herramientas;
	mmenus[mmi_Ayuda].submenu= submenus+subm_Ayuda;

	//
	//subm_Archivo
	//
	this->submenus[subm_Archivo].Create(6,menuitems+mi_AAbrir,		menuitems+mi_ACerrar,
													menuitems+mi_AAbrirConfig,	menuitems+mi_AGuardarConfig,	menuitems+mi_ADescargarConfig,
													menuitems+mi_AExportar,		menuitems+mi_ASalir);
	menuitems[mi_AAbrir].function=static_cast<pGenericMessageHandler>(&PanelGrafico::AAbrir_Click);
	menuitems[mi_ACerrar].function=static_cast<pGenericMessageHandler>(&PanelGrafico::ACerrar_Click);
	menuitems[mi_AAbrirConfig].function=static_cast<pGenericMessageHandler>(&PanelGrafico::AAbrirConfig_Click);
	menuitems[mi_AGuardarConfig].function=static_cast<pGenericMessageHandler>(&PanelGrafico::AGuardarConfig_Click);
	menuitems[mi_ADescargarConfig].function=static_cast<pGenericMessageHandler>(&PanelGrafico::ADescargarConfig_Click);
	menuitems[mi_AExportar].submenu=&submenus[subm_AExportar];
	menuitems[mi_ASalir].function=static_cast<pGenericMessageHandler>(&PanelGrafico::ASalir_Click);
	if(mode!=MODOSUB_STANDALONE && mode!=MODOSUB_YOKEDMAIN){
		menuitems[mi_ASalir].visible=false;
		if(mode==MODOSUB_CUTDOWN) menuitems[mi_AAbrir].visible=false;
	}
	//
	//subm_AExportar
	//
	this->submenus[subm_AExportar].Create(3,menuitems+mi_AEdgn, menuitems+mi_AEps,menuitems+mi_AEdxf);
	menuitems[mi_AEdgn].text=u"Dgn";
	menuitems[mi_AEbin].text=u"Bin";
	menuitems[mi_AEps].text=u"PostScript";
	menuitems[mi_AEdxf].text=u"Dxf";
	menuitems[mi_AEdgn].function=static_cast<pGenericMessageHandler>(&PanelGrafico::AEdgn_Click);
	menuitems[mi_AEbin].function=static_cast<pGenericMessageHandler>(&PanelGrafico::AEbin_Click);
	menuitems[mi_AEps].function=static_cast<pGenericMessageHandler>(&PanelGrafico::AEps_Click);
	menuitems[mi_AEdxf].function=static_cast<pGenericMessageHandler>(&PanelGrafico::AEdxf_Click);
	menuitems[mi_AEdgn].visible=false;

	this->submenus[subm_Buscar].n=0;

	this->submenus[subm_Herramientas].Create(1,menuitems+mi_HSeleccionar);
	menuitems[mi_HSeleccionar].function=static_cast<pGenericMessageHandler>(&PanelGrafico::HSeleccionar_Click);

	//
	//subm_Ayuda
	//
	this->submenus[subm_Ayuda].Create(3,menuitems+mi_YIdioma,
													menuitems+mi_YAcercade,menuitems+mi_YManual);
	menuitems[mi_YIdioma].submenu=&submenus[subm_YIdioma];
	menuitems[mi_YAcercade].visible=false;
	menuitems[mi_YManual].visible=false;
	//
	//subm_YIdioma
	//
	this->submenus[subm_YIdioma].Create(3,menuitems+mi_YIEspañol, menuitems+mi_YIInglés, menuitems+mi_YIItaliano);
	menuitems[mi_YIEspañol].text=u"Español";
	menuitems[mi_YIInglés].text=u"English";
	menuitems[mi_YIItaliano].text=u"Italiano";
	menuitems[mi_YIEspañol].function=static_cast<pGenericMessageHandler>(&PanelGrafico::YIIdioma_Click);
	menuitems[mi_YIInglés].function=static_cast<pGenericMessageHandler>(&PanelGrafico::YIIdioma_Click);
	menuitems[mi_YIItaliano].function=static_cast<pGenericMessageHandler>(&PanelGrafico::YIIdioma_Click);

	this->mMenu->Create(mmenus, /*mmenus+1,*/ mmenus+2, mmenus+3,NULL);

	MenuW0->hwnd=CreateWindowExA(0,"MenuWindow", NULL, WS_POPUP, 0,0, 120,200, this->hwnd,NULL,hInst,NULL);
	MenuW1->hwnd=CreateWindowExA(0,"MenuWindow", NULL, WS_POPUP, 0,0, 120,200, this->MenuW0->hwnd,NULL,hInst,NULL);
	SetWindowPointer(MenuW0);
	SetWindowPointer(MenuW1);
	mMenu->menuW=this->MenuW0;
	MenuW0->prev=NULL;		MenuW0->next=MenuW1;
	MenuW1->prev=MenuW0;	MenuW1->next=NULL;
	MenuW0->SetWBorderStyle(WBORDER_3D_MFINO);
	MenuW1->SetWBorderStyle(WBORDER_3D_MFINO);
	MenuW1->borderparams=MenuW0->borderparams=(WBorderParams*)&BorderPars_color7;
	MenuW1->whereto=MenuW0->whereto=this;
	//
	//Fin Menus

	int tp=0;
	mMenu->set_Rectangle(0,0,500,mMenu->height);	tp+=mMenu->height;
	panelTop->set_Rectangle(0,tp,500,26); tp+=26;
	panelBottom->set_Rectangle(0,200,500,BOT_WIDTH);
	panelDibujo->set_Rectangle(0,tp,500,400);
	Add_Control(this,mMenu,0);
	Add_Control(this,panelTop,1);
	Add_Control(this,panelBottom,2);
	Add_Control(this,panelDibujo,3);

	this->panelBottom->backcolor=AT_color6;
	this->panelDibujo->backcolor=0;	//black

	//PanelTop
	CBoxconfigs=new StdComboBox();
	CBoxconfigs->set_Rectangle(100,2,160,81);
	CBoxconfigs->AddTo(this->panelTop,ID_CBoxconfigs);
	//SetWFont(CBoxconfigs->hwnd,application_font);
	panelTop->SET_WNDPROC_HOOK(this,&PanelGrafico::PanelTop_WndProc);

	//PanelBottom
	SetToThisFunc(panelBottom->Painting,PanelGrafico::PanelBottom_Painting);
	Ajustar=new StdButton();		Ajustar->set_Rectangle(0,0,BOT_WIDTH,panelBottom->height);
	Zmas=new StdButton();			Zmas->set_Rectangle(0,0,BOT_WIDTH,Ajustar->height);
	Lupa=new StdButton();			Lupa->set_Rectangle(0,0,BOT_WIDTH,Ajustar->height);
	MoveUp=new StdButton();		MoveUp->set_Rectangle(0,0,BOT_WIDTH,Ajustar->height/2);
	MoveDown=new StdButton();	MoveDown->set_Rectangle(0,0,BOT_WIDTH,Ajustar->height/2);
	MoveLeft=new StdButton();		MoveLeft->set_Rectangle(0,0,BOT_WIDTH/2,Ajustar->height);
	MoveRight=new StdButton();	MoveRight->set_Rectangle(0,0,BOT_WIDTH/2,Ajustar->height);
	//
#define BOT_STYLE BS_ICON
	Ajustar->AddTo(this->panelBottom,ID_Ajustar);				FlagOnWStyle(Ajustar->hwnd,BOT_STYLE);
	Zmas->AddTo(this->panelBottom,ID_Zmas);					FlagOnWStyle(Zmas->hwnd,BOT_STYLE);
	//Lupa->AddTo(this->panelBottom,ID_Lupa);					FlagOnWStyle(Lupa->hwnd,BOT_STYLE);
	MoveUp->AddTo(this->panelBottom,ID_MoveUp);			FlagOnWStyle(MoveUp->hwnd,BOT_STYLE);
	MoveDown->AddTo(this->panelBottom,ID_MoveDown);	FlagOnWStyle(MoveDown->hwnd,BOT_STYLE);
	MoveLeft->AddTo(this->panelBottom,ID_MoveLeft);			FlagOnWStyle(MoveLeft->hwnd,BOT_STYLE);
	MoveRight->AddTo(this->panelBottom,ID_MoveRight);		FlagOnWStyle(MoveRight->hwnd,BOT_STYLE);
	//
	SendMessage(Ajustar->hwnd,BM_SETIMAGE,IMAGE_ICON,(LPARAM)ICursor_Ajustar_nativo.cur);
	SendMessage(Zmas->hwnd,BM_SETIMAGE,IMAGE_ICON,(LPARAM)ICursor_Zmas_nativo.cur);
	//SendMessage(Lupa->hwnd,BM_SETIMAGE,IMAGE_ICON,(LPARAM)ICursor_Lupa_nativo.cur);
	SendMessage(MoveUp->hwnd,BM_SETIMAGE,IMAGE_ICON,(LPARAM)ICursor_MoveUp_nativo.cur);
	SendMessage(MoveDown->hwnd,BM_SETIMAGE,IMAGE_ICON,(LPARAM)ICursor_MoveDown_nativo.cur);
	SendMessage(MoveLeft->hwnd,BM_SETIMAGE,IMAGE_ICON,(LPARAM)ICursor_MoveLeft_nativo.cur);
	SendMessage(MoveRight->hwnd,BM_SETIMAGE,IMAGE_ICON,(LPARAM)ICursor_MoveRight_nativo.cur);
	//
#define SWPh(control) control->SET_WNDPROC_HOOK(this,&PanelGrafico::Boton_WndProc);
#define SWPh(control) control->SET_WNDPROC_HOOK(this,&PanelGrafico::Boton_WndProc);
	SWPh(Ajustar);		SWPh(Zmas);			//SWPh(Lupa);
	SWPh(MoveUp);	SWPh(MoveDown);	SWPh(MoveLeft);	SWPh(MoveRight);
#undef SWPh

	//Panel Lateral
	#define STYLE	TVS_CHECKBOXES | TVS_FULLROWSELECT
	AddTreeViewTo(this,TreeOnOff,400,50,100,200);
	AddTreeViewTo(this,TreeOnOff_Textos,400,250,100,200);
	//SetTreeViewImageList();
	//TreeView_SetImageList(TreeOnOff, TreeViewImageList, TVSIL_STATE);
	//TreeView_SetUnicodeFormat(TreeOnOff,TRUE);	//No sirve; lo que cuenta es que el mensaje que se envía sea TVM_INSERTITEMA o TVM_INSERTITEMW
	#undef STYLE

	//panelDibujo
	panelDibujo->SET_WNDPROC_HOOK(this,&PanelGrafico::PanelDibujo_WndProc);

	//OwnedForms
	Guardar_PS=new GuardarPS();
	Guardar_PS->AddTo(this->hwnd);

	//Incializar estructuras
	DlgAbrir.owner=this;
	DlgAbrir.estado=DLGA_SOLOABRIR;
	DlgAbrir.option_flags &= ~DLGA_F_READONLY;
	PictureCursor=NULL;
	Texto_coordX[0]='\0';
	Texto_coordY[0]='\0';

	bitmapgra.bmiHeader.biSize=usizeof(BITMAPINFOHEADER);
	bitmapgra.bmiHeader.biPlanes=1;
	bitmapgra.bmiHeader.biBitCount=CHAR_BIT*usizeof(color);
	bitmapgra.bmiHeader.biCompression=BI_RGB;

	this->res_subpixel=2;
	tipos_presentes=NULL;
	elementos_candidatos.elementos=NULL;
	elementos_candidatos.t=elementos_candidatos.n=0;
	especiales.vector.ppio=NULL;
	especiales.head=NULL;

	config_programa.radio_seleccion=3.5;	//esto debería leerse de un fichero

	EnabledFalse();

	SetToThisFunc(panelBottom->Resized,PanelGrafico::PanelBottom_Resized);
	SetToThisFunc(panelBottom->ButtonClicked,PanelGrafico::PanelBottom_ButtonClicked);
	SetToThisFunc(this->Resized,PanelGrafico::this_Resized);
	panelDibujo->Resized.AddFuncFirst(this,static_cast<pGenericMessageHandler>(&PanelGrafico::panelDibujo_Resized));

	return 0;
}

int PanelGrafico::ProcessCmdLine(char16_t* args){
	if(*args==u'\0') return 0;
	char16_t** argv=split_cmdline(args);
	ifunlike(argv==NULL) return AT_NOMEM;
	ifunlike(*argv==NULL){	//Possible if args only contains spaces
		free(argv);
		return 0;
	}
	char16_t** parg=argv;
	while(*parg!=NULL) parg++;
	parg--;
	PanelGrafico::abre_fichero(*parg,-1);

	free(argv);
	return 0;
}
