using System;
using System.Drawing;
using System.Windows.Forms;

namespace ControlesAt
{
	/// <summary>
	/// Descripcin breve de TresOpciones.
	/// </summary>
	public class TresOpciones : FormAerotri
	{
		private System.Windows.Forms.Label label1;
		private ControlesAt.BotAceptar Aceptar;
		private System.Windows.Forms.RadioButton opt1;
		private System.Windows.Forms.RadioButton opt2;
		private System.Windows.Forms.RadioButton opt3;

		public TresOpciones(short n, Globales.Idioma _idioma)
		{
			InitializeComponent();
			this.AcceptButton=this.Aceptar;

			this.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
			Aceptar.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);

			Opt[1]=opt1;
			Opt[2]=opt2;
			Opt[3]=opt3;

			if(n>3) n=3;
			Opt[n].Checked=true;

			set_idioma(_idioma);
		}

	#region InitializeComponent
		private void InitializeComponent()
		{
			label1= new Label();
			opt1= new RadioButton();
			opt2= new RadioButton();
			opt3= new RadioButton();
			Aceptar= new ControlesAt.BotAceptar();
			//
			// label1
			//
			label1.Font= new Font("Microsoft Sans Serif", 9F);
			label1.Location= new Point(24, 8);
			label1.Size= new Size(116, 20);
			label1.TabIndex= 0;
			label1.TextAlign= ContentAlignment.TopCenter;
			//
			// opt1
			//
			opt1.Checked= true;
			opt1.Location= new Point(40, 36);
			opt1.Size= new Size(88, 16);
			opt1.TabIndex= 1;
			opt1.TabStop= true;
			opt1.Text= "GPS";
			//
			// opt2
			//
			opt2.Location= new Point(40, 56);
			opt2.Size= new Size(88, 16);
			opt2.TabIndex= 2;
			opt2.Text= "INS";
			//
			// opt3
			//
			opt3.Location= new Point(40, 76);
			opt3.Size= new Size(88, 16);
			opt3.TabIndex= 3;
			opt3.Text= "GPS e INS";
			//
			// Aceptar
			//
			Aceptar.Location= new Point(44, 100);
			Aceptar.Size= new Size(75, 20);
			Aceptar.TabIndex= 4;
			Aceptar.Click+= new EventHandler(Aceptar_Click);
			//
			// TresOpciones
			//
			this.ClientSize= new Size(162, 127);
			this.Controls.Add(Aceptar);
			this.Controls.Add(opt3);
			this.Controls.Add(opt2);
			this.Controls.Add(opt1);
			this.Controls.Add(label1);
			this.FormBorderStyle= FormBorderStyle.FixedDialog;
			this.MaximizeBox= false;
			this.MinimizeBox= false;
			this.ShowInTaskbar= false;
			this.Text= "";
		}
	#endregion

		private RadioButton[] Opt=new RadioButton[4];

		private void Aceptar_Click(object sender,System.EventArgs e){
			OnClosing(new System.ComponentModel.CancelEventArgs(false));
		}

		protected override void OnClosing(System.ComponentModel.CancelEventArgs e){
			if(opt1.Checked) this.DialogResult=(DialogResult)1;
			else if(opt2.Checked) this.DialogResult=(DialogResult)2;
			else this.DialogResult=(DialogResult)3;
			base.OnClosing(e);
		}

		protected override void update_idioma(){
			label1.Text=Textos.get_texto(Textos.Cods.Tipo_de_grupo,idioma);
			Aceptar.Text=Globales.Textos.get_texto(Globales.Textos.Cods.Aceptar,idioma);
		}
	}
}
