﻿using System.Collections.Generic;
using static Globales.Textos.Cods;

namespace Globales{
	public class Textos{
		public enum Cods : uint{
			Calcular, Aceptar, Cancelar,
			Sí, No, Síatodos, Noatodos,
			Error_desconocido,
			Todos_los_ficheros,
			Abriendo_un_fichero,
			Guardando_un_fichero,
			Guardando_ficheros,
			Noseha_podido_guardar,
			No_permiso_para_escribir,
			Archivo,Salir,
			Configuración,Idioma,
			Ayuda,Manual,
			Esperando_respuesta_usuario,
			No_se_encuentra_el_manual,
			que_debe_estar_en_el_directorio,
			NENTRIES,
		}
		//public static implicit operator int(Cods n){return (int)n;}

		static readonly string[]
			esp=new string[(int)Cods.NENTRIES],
			eng=new string[(int)Cods.NENTRIES],
			it=new string[(int)Cods.NENTRIES];

		private static readonly string[][] textos=new string[(int)Idioma.NIDIOMAS][];

		static Textos(){
			setup_esp();
			setup_eng();
			setup_it();

			textos[(int)Idioma.Esp]=esp;
			textos[(int)Idioma.Eng]=eng;
			textos[(int)Idioma.It]=it;
		}
		static void setup_esp(){
			esp[(int)Calcular]="Calcular";
			esp[(int)Aceptar]="Aceptar";
			esp[(int)Cancelar]="Cancelar";
			esp[(int)Sí]="Sí";
			esp[(int)No]="No";
			esp[(int)Síatodos]="Sí a todos";
			esp[(int)Noatodos]="No a todos";
			esp[(int)Error_desconocido]="Error desconocido";
			esp[(int)Todos_los_ficheros]="Todos los ficheros";
			esp[(int)Abriendo_un_fichero]="Abriendo un fichero";
			esp[(int)Guardando_un_fichero]="Guardando un fichero";
			esp[(int)Guardando_ficheros]="Guardando ficheros";
			esp[(int)Noseha_podido_guardar]="No se ha podido guardar el fichero";
			esp[(int)No_permiso_para_escribir]="No dispone de permiso para escribir en la carpeta de destino";
			esp[(int)Archivo]="Archivo";
			esp[(int)Salir]="Salir";
			esp[(int)Configuración]="Configuración";
			esp[(int)Cods.Idioma]="Idioma";
			esp[(int)Ayuda]="Ayuda";
			esp[(int)Manual]="Manual";
			esp[(int)Esperando_respuesta_usuario]="Esperando una respuesta del usuario";
			esp[(int)No_se_encuentra_el_manual]="No se encuentra el manual: ";
			esp[(int)que_debe_estar_en_el_directorio]="que debe estar en el directorio ";
		/*[T_Error_f]=u"Error en el fichero de fotogramas: ",
		[T_Error_apr]=u"Error en el fichero de valores aproximados: ",
		[T_Error_ccpp]=u"Error en el fichero de centros de proyección: ",
		[T_Error_apy]=u"Error en el fichero de apoyo: ",
		[T_Error_gps]=u"Error en el fichero de GPS/INS: ",*/
		}
		static void setup_eng(){
			eng[(int)Calcular]="Calculate";
			eng[(int)Aceptar]="OK";
			eng[(int)Cancelar]="Cancel";
			eng[(int)Sí]="Yes";
			eng[(int)No]="No";
			eng[(int)Síatodos]="Yes to all";
			eng[(int)Noatodos]="No to all";
			eng[(int)Error_desconocido]="Unknown error";
			eng[(int)Todos_los_ficheros]="All files";
			eng[(int)Abriendo_un_fichero]="Opening a file";
			eng[(int)Guardando_un_fichero]="Saving a file";
			eng[(int)Guardando_ficheros]="Saving files";
			eng[(int)Noseha_podido_guardar]="The file couldn't be saved";
			eng[(int)No_permiso_para_escribir]="Access to the destination folder has been denied";
			eng[(int)Archivo]="File";
			eng[(int)Salir]="Quit";
			eng[(int)Configuración]="Configuration";
			eng[(int)Cods.Idioma]="Language";
			eng[(int)Ayuda]="Help";
			eng[(int)Manual]="Manual";
			eng[(int)Esperando_respuesta_usuario]="Waiting for the user reply";
			eng[(int)No_se_encuentra_el_manual]="The manual wasn't found: ";
			eng[(int)que_debe_estar_en_el_directorio]="It should be in the directory ";
		}
		static void setup_it(){
			it[(int)Calcular]="Calcola";
			it[(int)Aceptar]="OK";
			it[(int)Cancelar]="Cancela";
			it[(int)Sí]="Si";
			it[(int)No]="Non";
			it[(int)Síatodos]="Si a tutti";
			it[(int)Noatodos]="Non a tutti";
			it[(int)Error_desconocido]="Errore sconosciuto";
			it[(int)Todos_los_ficheros]="Tutti i file";
			it[(int)Abriendo_un_fichero]="Aprendo un file";
			it[(int)Guardando_un_fichero]="Salvando un file";
			it[(int)Guardando_ficheros]="Salvando i file";
			it[(int)Noseha_podido_guardar]="Il file non ha potuto essere salvato";
			it[(int)No_permiso_para_escribir]="Non ha del permesso per scrivere nella cartella di destinazione";
			it[(int)Archivo]="File";
			it[(int)Salir]="Uscita";
			it[(int)Configuración]="Configurazione";
			it[(int)Cods.Idioma]="Idioma";
			it[(int)Ayuda]="Aiuto";
			it[(int)Manual]="Manuale";
			it[(int)Esperando_respuesta_usuario]="Aspettando una risposta dall'utente";
			it[(int)No_se_encuentra_el_manual]= "Non si trova il manuale: ";
			it[(int)que_debe_estar_en_el_directorio]= "che deve trovarsi nel direttorio ";
		}

		public static string[] YesNo(Idioma id){return new string[]{textos[(int)id][(int)Sí],textos[(int)id][(int)No]};}
		public static string[] OKCancel(Idioma id){return new string[]{textos[(int)id][(int)Aceptar],textos[(int)id][(int)Cancelar]};}

		public static string get_texto(Cods cod,Idioma _idioma){
			string s=textos[(int)_idioma][(int)cod];
			if(s!=null) return s;
			return textos[(int)Idioma.Esp][(int)cod];
		}
		public static string get_texto(short i,string s,Idioma _idioma){
			string txt="";
			switch(_idioma){
			 case Idioma.Eng:
				switch(i){
					case 14: txt= "The file '"+s+"' cannot be overritten.\n\nIt is probably opened by other application."; break;
					case 15: txt= "The file '"+s+"' cannot be opened.\n\nIt has been probably opened by other application that doesn't allow other programs to open the file."; break;
					case 16: txt= "The file '"+s+"' doesn't exist"; break;
					case 17: txt= "The file '"+s+"' coudn't be saved."; break;
				}
				break;
			 case Idioma.It:
				switch(i){
					case 14: txt= "Non è possibile soprascrivere il file '"+s+"'.\n\nIl file è probabilmente aperto da un'altra applicazione."; break;
					case 15: txt= "Il file '"+s+"' non si può aprire.\n\nIl file è probabilmente aperto da un'altra applicazione che non permette la sua apertura da altri programmi."; break;
					case 16: txt= "Il file '"+s+"' non esiste"; break;
					case 17: txt= "Il file '"+s+"' non ha potuto essere salvato"; break;
				}
				break;
			 default:
				switch(i){
					case 14: txt= "No es posible sobreescribir el fichero '"+s+"'\n\nProbablemente esté abierto por otra aplicación."; break;
					case 15: txt= "El fichero '"+s+"' no se puede abrir.\n\nProbablemente esté abierto por otra aplicación que no permite su apertura por otros programas."; break;
					case 16: txt= "El fichero '"+s+"' no existe"; break;
					case 17: txt= "No se ha podido guardar el fichero '"+s+"'"; break;
				}
				break;
			}
			return txt;
		}
	}
}
