using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using ControlesAt;
using PanelesSub;

namespace EditorT{
using static Textos.Cods;

	public delegate void DelegadoGrupoIndice(TextoFichero tf,short i);

	internal struct PerTextData{
		public bool modificado;
		public bool cursor_onfocus;
		//public int[] newlines;
		//public int[] doublenewlines;
	}
	public class TextoFichero : IdiomaControl	
{
		protected const byte Esp=(byte)Globales.Idioma.Esp;
		protected const byte Eng=(byte)Globales.Idioma.Eng;
		protected const byte It=(byte)Globales.Idioma.It;
		internal ControlesAt.PanelMenu PanelMenu1;
		internal System.Windows.Forms.Label Label1;
		internal System.Windows.Forms.TabControl TabControl1;
		  public System.Windows.Forms.Splitter Splitter1;
		private System.Windows.Forms.OpenFileDialog Open1;
		private System.Windows.Forms.SaveFileDialog Save1;
		private System.Windows.Forms.FontDialog Font1;
		private System.Windows.Forms.ContextMenu MenuArchivo;
		private System.Windows.Forms.ContextMenu MenuEdicion;
		private System.Windows.Forms.MenuItem	ANueva,		AAbrir,
															ARecargar,	AGuardar,
															AGuardarcomo,	AGuardartodo,
															ACerrar;
		private System.Windows.Forms.MenuItem EBuscar,		EBsiguiente,
															EBtodos,		ESeleccionartodo;
		private System.Windows.Forms.ContextMenu MenuFormato;
		private System.Windows.Forms.MenuItem FAjustelinea,	FFuente;

	#region Variables
		private PanelSubordinado Panel1;
		private Globales.Idioma idiomaPadre;
		public string nombre;
		short n, t, activa;
		internal TabPage[] pestannas;
		internal TextBox[]  texts;
		internal PerTextData[] ptd;
		short nnuevos;
		public FormBuscar FormBuscar1;
		TextBox Textaux;
		internal bool llamada_busca;
		bool la_proxima_vez_no_hagas_nada;

		System.IO.StreamReader filer;
		System.IO.StreamWriter filew;
		internal System.Windows.Forms.Label LabelNombre;
		internal System.Windows.Forms.Label label2;
		internal System.Drawing.Font last_font;
		internal bool last_ajlinea;
		protected bool changing_size;
	#endregion

	#region InitializeComponent
		private void InitializeComponent()
		{
			PanelMenu1= new ControlesAt.PanelMenu();
			Label1= new Label();
			TabControl1= new TabControl();
			Splitter1= new Splitter();
			Open1= new OpenFileDialog();
			Save1= new SaveFileDialog();
			Font1= new FontDialog();
			MenuArchivo= new ContextMenu();
			ANueva= new MenuItem();
			AAbrir= new MenuItem();
			ARecargar= new MenuItem();
			AGuardar= new MenuItem();
			AGuardarcomo= new MenuItem();
			AGuardartodo= new MenuItem();
			ACerrar= new MenuItem();
			MenuEdicion= new ContextMenu();
			EBuscar= new MenuItem();
			EBsiguiente= new MenuItem();
			EBtodos= new MenuItem();
			ESeleccionartodo= new MenuItem();
			MenuFormato= new ContextMenu();
			FAjustelinea= new MenuItem();
			FFuente= new MenuItem();
			LabelNombre= new Label();
			label2= new Label();
			//
			// PanelMenu1
			//
			PanelMenu1.Controls.Add(LabelNombre);
			PanelMenu1.Controls.Add(label2);
			PanelMenu1.AddLabel("Formato",MenuFormato);
			PanelMenu1.AddLabel("Edicion",MenuEdicion);
			PanelMenu1.AddLabel("Archivo",MenuArchivo);
			PanelMenu1.Height=15;
			PanelMenu1.TabIndex= 3;
			PanelMenu1.LabelsFont=Globales.Fuentes.FontTitle2;
			//
			// Label1
			//
			Label1.Dock= DockStyle.Right;
			Label1.Image= new System.Drawing.Bitmap(System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("EditorT.Icono_Cerrar_grueso.bmp"));
			Label1.Location= new Point(249, 0);
			Label1.Size= new Size(15, 16);
			Label1.TabIndex= 2;
			Label1.Click+= new EventHandler(Label1_Click);
			//
			// TabControl1
			//
			TabControl1.Alignment= TabAlignment.Bottom;
			TabControl1.Dock= DockStyle.Bottom;
			TabControl1.Location= new Point(0, 16);
			TabControl1.SelectedIndex= 0;
			TabControl1.Size= new Size(264, 332);
			TabControl1.TabIndex= 1;
			TabControl1.SelectedIndexChanged+= new EventHandler(TabControl1_SelectedIndexChanged);
			//
			// Splitter1
			//
			Splitter1.BackColor= System.Drawing.SystemColors.Control;
			Splitter1.Dock= DockStyle.Right;
			Splitter1.Location= new Point(264, 0);
			Splitter1.Size= new Size(4, 348);
			Splitter1.TabIndex= 0;
			Splitter1.TabStop= false;
			//
			// MenuArchivo
			//
			MenuArchivo.MenuItems.AddRange(new MenuItem[] {ANueva,		AAbrir,
																				ARecargar,	AGuardar,
																				AGuardarcomo,	AGuardartodo,
																				ACerrar});
			//
			// ANueva, Abrir, etc.
			//
			ANueva.Index= 0;			ANueva.Shortcut= Shortcut.CtrlN;		ANueva.Click+= new EventHandler(ANueva_Click);
			AAbrir.Index= 1;			AAbrir.Shortcut= Shortcut.CtrlO;			AAbrir.Click+= new EventHandler(AAbrir_Click);
			ARecargar.Index= 2;		ARecargar.Shortcut= Shortcut.CtrlR;		ARecargar.Click+= new EventHandler(ARecargar_Click);
			AGuardar.Index= 3;		AGuardar.Shortcut= Shortcut.CtrlS;		AGuardar.Click+= new EventHandler(AGuardar_Click);
			AGuardarcomo.Index= 4;	AGuardarcomo.Shortcut=Shortcut.CtrlShiftS;		AGuardarcomo.Click+= new EventHandler(AGuardarcomo_Click);
			AGuardartodo.Index= 5;													AGuardartodo.Click+= new EventHandler(AGuardartodo_Click);
			ACerrar.Index= 6;															ACerrar.Click+= new EventHandler(ACerrar_Click);
			//
			// MenuEdicion
			//
			MenuEdicion.MenuItems.AddRange(new MenuItem[] {	EBuscar,		EBsiguiente,
																				EBtodos,		ESeleccionartodo});
			//
			// EBuscar
			//
			EBuscar.Index= 0;		EBuscar.Shortcut= Shortcut.CtrlF;		EBuscar.Click+= new EventHandler(EBuscar_Click);
			EBsiguiente.Enabled=false;
			EBsiguiente.Index= 1;	EBsiguiente.Shortcut= Shortcut.F3;		EBsiguiente.Click+= new EventHandler(EBsiguiente_Click);
			EBtodos.Index= 2;														EBtodos.Click+= new EventHandler(EBtodos_Click);
			ESeleccionartodo.Index= 3;											ESeleccionartodo.Click+= new EventHandler(ESeleccionartodo_Click);
			//
			// MenuFormato
			//
			MenuFormato.MenuItems.AddRange(new MenuItem[] {FAjustelinea,		 FFuente});
			//
			// FAjustelinea
			//
			FAjustelinea.Index= 0;		FAjustelinea.Click+= new EventHandler(FAjustelinea_Click);
			FFuente.Index= 1;			FFuente.Click+= new EventHandler(FFuente_Click);
			//
			// LabelNombre
			//
			LabelNombre.Dock= DockStyle.Fill;
			LabelNombre.Font= new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			LabelNombre.Location= new Point(156, 0);
			LabelNombre.Size= new Size(93, 15);
			LabelNombre.TabIndex= 9;
			LabelNombre.TextAlign= ContentAlignment.BottomRight;
			//
			// label2
			//
			label2.Dock= DockStyle.Right;
			label2.Font= new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			label2.Location= new Point(245, 0);
			label2.Size= new Size(4, 15);
			label2.TabIndex= 10;
			label2.TextAlign= ContentAlignment.BottomRight;
			//
			// TextoFichero
			//
			this.Controls.Add(this.PanelMenu1);
			this.Controls.Add(Label1);
			this.Controls.Add(TabControl1);
			this.Controls.Add(Splitter1);
		}
		protected override Size DefaultSize{
			get{return new Size(268, 348);}
		}

	#endregion

		public TextoFichero(string _nombre,Globales.Idioma _idioma,PanelSubordinado _Panel1, System.Drawing.Font _font, bool _ajustelinea)
		{
			changing_size=false;
			InitializeComponent();
			Panel1=_Panel1;
			if(Panel1!=null) idiomaPadre=Panel1.Idioma;
			else idiomaPadre=_idioma;
			nombre=_nombre;
			set_idioma(_idioma);
			this.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
			la_proxima_vez_no_hagas_nada=false;
			if(_font!=null) last_font=_font;
			else last_font= new System.Drawing.Font("Courier New", (float)9.75, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point);
			last_ajlinea=_ajustelinea;
			Font1.ScriptsOnly=false;	//Esto est documentado al revs
			//La mier... de .NET slo permite las fuentes TrueType (u OpenType con outlines TrueType).
			//No lo documentan y encima tienen la cara de decir que el font dialog es igual que el de Windows.

			n=4;
			t=0;
			activa=-1;
			nnuevos=0;

			pestannas=new TabPage[4];
			texts=new TextBox[4];
			ptd=new PerTextData[4];

			FormBuscar1=new FormBuscar(Panel1);
			FormBuscar1.Owner=Panel1.ParentForm;
			FormBuscar1.busca+=new EventVoid(busca);
			FormBuscar1.reemplaza+= new EventVoid(reemplaza);
			FormBuscar1.reemplazatodo+= new EventVoid(reemplazatodo);
			FormBuscar1.Closing+= new CancelEventHandler(FormBuscar1_Closing);

			foreach(Control o in this.Controls){
				o.KeyDown+=new KeyEventHandler(o_KeyDown);
				o.KeyUp+=new KeyEventHandler(o_KeyUp);
			}

			string[] palabras;
			palabras=nombre.Split(new char[]{' '});
			if((palabras.Length==3 || palabras.Length==2) && palabras[0]=="Sin" && palabras[1]=="nombre"){}
			else this.LabelNombre.Text=nombre;

			TabControl1.AllowDrop=true;
			TabControl1.DragEnter+=new DragEventHandler(TextoFichero_DragEnter);
			TabControl1.DragDrop+=new DragEventHandler(TextoFichero_DragDrop);
		}

		public event DelegadoGrupoIndice MiTextoChanged;
		private void Text_Changed(object sender,EventArgs e)
		{
			if(la_proxima_vez_no_hagas_nada){ la_proxima_vez_no_hagas_nada=false; return;}
			//Entra aqu cuando le da la gana, en vez de justo cuando se cambia el texto.
			//Entonces, aunque **despus** de cambiar el texto digamos modificado[i]=false, como
			//entra aqu cuando sale de las pelotas, lo har despus de la asignacin, entonces
			//el haber dicho modificado[i]=false no nos vale para nada.
			//Por eso hay que emplear la variable la_proxima... de esta manera asncrona, ponindola
			//a true en alguna parte y "resetendola" a false **aqu** y no el otro lado, con lo
			//inseguro que esto es, pero no queda ms remedio
			MiTextoChanged(this,(short)this.TabControl1.SelectedIndex);
		}

		protected override void OnLoad(System.EventArgs e){
			update_idioma();
			FormBuscar1.Location=new Point(TabControl1.Left+TabControl1.Width,TabControl1.Top);
			if(t<=0) Enabled_false();
			llamada_busca=false;
			base.OnLoad(e);
		}

		protected override void OnSizeChanged(EventArgs e){
			if(changing_size) return;
			changing_size=true;
			if(this.Width<46) this.Width=46;
			if(this.Height<61) this.Height=61;
			TabControl1.Height=this.Height-15;
			changing_size=false;
			base.OnSizeChanged(e);
		}

		private void o_KeyDown(object sender,KeyEventArgs e){
			switch(e.Modifiers){
			  case Keys.Control:
				switch(e.KeyValue){
					case 'N': ANueva_Click(this,EventArgs.Empty); break;
					case 'O': AAbrir_Click(this,EventArgs.Empty); break;
					case 'R': ARecargar_Click(this,EventArgs.Empty); break;
					case 'S': if(AGuardar.Enabled)AGuardar_Click(this,EventArgs.Empty); break;
					case 'W': if(Label1.Enabled)  Label1_Click(this,EventArgs.Empty); break;
					case 'F': if(EBuscar.Enabled) EBuscar_Click(this,EventArgs.Empty); break;
					case 'E': if(ESeleccionartodo.Enabled) ESeleccionartodo_Click(this,EventArgs.Empty); break;
				}
				break;
			  case Keys.Control | Keys.Shift:
				switch(e.KeyValue){
					case 'S': if(AGuardar.Enabled)AGuardarcomo_Click(this,EventArgs.Empty); break;
				}
				break;
			  case Keys.None:
				switch(e.KeyValue){
					case((int)Keys.F3): if(activa!=-1 && EBsiguiente.Enabled) EBsiguiente_Click(this,EventArgs.Empty); break;
					case((int)Keys.F4): if(activa!=-1) reemplaza(); break;
				}
				break;
			}
		}
		private void o_KeyUp(object sender,KeyEventArgs e)
		{
			switch(e.Modifiers){
			  case Keys.Alt:
				switch(e.KeyValue){
					case('A'): PanelMenu1.gLabels("Archivo").doClick(); break;
					case('E'): PanelMenu1.gLabels("Edicion").doClick(); break;
					case('F'): PanelMenu1.gLabels("Formato").doClick(); break;
				}
				break;
			}
		}

		public void annade_pestanna(string fichero, bool nuevo){
			int i;
			string texto="";	//Para que el imbcil no proteste ms abajo
			bool reemplaza;
			short i_r=0;		//Pero mira que eres idiota

			reemplaza=false;
			if(fichero!=""){
				i_r=busca_fichero(fichero);
				if(i_r!=-1){
					if(!ptd[i_r].modificado) reemplaza=true;
					else{
						if(!nuevo){
							string ss=get_texto(Elfichero)+fichero+get_texto(est_abierto_y_modificado);
							if(Panel1.ShowMessageWait(ss,Globales.Textos.YesNo(idioma),1)!=1) return;
							reemplaza=true;
						}else{
							string ss=get_texto(Elfichero_antiguo)+fichero+get_texto(ha_sido_modificado);
							Panel1.MessageBoxAT.Show(ss);
							reemplaza=false;

							string ttulo=System.IO.Path.GetFileNameWithoutExtension(fichero)+get_texto(Antiguo)+System.IO.Path.GetExtension(fichero);
							pestannas[i_r].Text=ttulo;
							pestannas[i_r].Name=System.IO.Path.GetDirectoryName(fichero) + @"\" + ttulo;

							guardarcomo(i_r);
						}
					}
				}
			}

			if(fichero!=""){
				try{
					System.Text.Encoding E=System.Text.Encoding.UTF8;
					filer= new System.IO.StreamReader(fichero,E);
					for(int k=0;k<2000;k++){if(filer.EndOfStream) break;
						if(filer.Read()==65533){E=System.Text.Encoding.Default; break;}
					}
					if(E==System.Text.Encoding.Default){
						filer.Close();
						filer= new System.IO.StreamReader(fichero,E);
						byte a=(byte)filer.Read();
						if(a==0xFE){
							if(filer.Read()==0xFF) E=System.Text.Encoding.BigEndianUnicode;
						}else if(a==0xFF){
							if(filer.Read()==0xFE) E=System.Text.Encoding.Unicode;
						}
					}
					filer.Close();
					filer= new System.IO.StreamReader(fichero,E);
					texto=filer.ReadToEnd();
					filer.Close();
				}catch(System.ArgumentException){	Panel1.MessageBoxAT.Show("'"+fichero+get_texto(nombre_no_vlido)); return;}
				catch(System.IO.FileNotFoundException){	Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(16,fichero,idioma)); return;}
				catch(System.IO.IOException){	Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(15,fichero,idioma)); return;}
			}

			if(reemplaza){
				TabControl1.SelectedIndex=0;
				TabControl1.SelectedIndex=i_r;
				la_proxima_vez_no_hagas_nada=true;
				//Posicin del cursor
				int curpos=texts[i_r].SelectionStart;
				if(curpos==-1) curpos=0;
				int posdbl, posln, pos;	//nmero de prrafo, lnea y posicin dentro de la lnea, comenzando en 0.
				int k;
				if(curpos==0) k=0;
				else if(curpos==texts[i_r].Text.Length) k=texto.Length;
				else{
					char[] s=texts[i_r].Text.ToCharArray(0,curpos+1);
					s[curpos]='\0';
					//prrafo
					for(k=0;s[k]=='\n' || s[k]=='\r';k++);
					posdbl=0;
					do{
						int j;
						for(j=k;s[j]!='\0';){
							if(s[j]=='\r' && s[j+1]=='\n'){
								j+=2;
								if(s[j]=='\r' && s[j+1]=='\n'){
									do{j+=2;} while(s[j]=='\r' && s[j+1]=='\n');
									posdbl++;
									k=j;
									break;
								}
							}else j++;
						}
						if(s[j]=='\0') break;
					}while(true);
					posln=0;
					do{
						int j;
						for(j=k;s[j]!='\0' && s[j]!='\n';) j++;
						if(s[j]=='\0') break;
						posln++;
						k=j+1;
					}while(true);
					pos=curpos-k;
					//
					int nchars=texto.Length;
					s=texto.ToCharArray();
					for(k=0;k<nchars && (s[k]=='\n' || s[k]=='\r');k++);
					while(posdbl!=0){
						int j=k;
						for(j=k; j+3<nchars;){
							if(s[j]=='\r' && s[j+1]=='\n'){
								j+=2;
								if(s[j]=='\r' && s[j+1]=='\n'){
									do{j+=2;} while(s[j]=='\r' && s[j+1]=='\n');
									posdbl--;
									k=j;
									break;
								}
							}else j++;
						}
						if(j+3>=nchars) j=nchars;
						if(j==nchars) break;
					};
					if(posdbl!=0) k=nchars;
					while(posln!=0){
						int j;
						for(j=k; j<nchars && s[j]!='\n';) j++;
						if(j==nchars) break;
						posln--;
						k=j+1;
					}
					if(posln!=0) k=nchars;
					k+=pos; if(k>nchars) k=nchars;
				}
				//
				ptd[i_r].cursor_onfocus=true;
				texts[i_r].Text=texto;
				ptd[i_r].modificado=false;
				texts[i_r].SelectionStart=k;
				Control C=texts[i_r];
				if(activa==i_r){
					while(C!=null){
						if(C.Visible==false) break;
						C=C.Parent;
				}	}
				if(C==null){texts[i_r].ScrollToCaret(); ptd[i_r].cursor_onfocus=false;}
				else texts[i_r].Focus();
				return;
			}

			if(Panel1!=null){
				Panel1.ahora_no_se_puede_cerrar++;
				Panel1.set_message(Globales.Textos.get_texto(Globales.Textos.Cods.Abriendo_un_fichero,idiomaPadre));
			}
			if(t==n){
				TabPage[] tabpage_aux=new TabPage[n];
				TextBox[] textbox_aux=new TextBox[n];
				PerTextData[] ptd_aux=new PerTextData[n];
				for(i=0;i<n;i++)
				{
					tabpage_aux[i]=pestannas[i];
					textbox_aux[i]=texts[i];
					ptd_aux[i]=ptd[i];
				}
				n<<=1;
				pestannas=new TabPage[n];
				texts=new TextBox[n];
				ptd=new PerTextData[n];
				n>>=1;
				for(i=0;i<n;i++)
				{
					pestannas[i]=tabpage_aux[i];
					texts[i]=textbox_aux[i];
					ptd[i]=ptd_aux[i];
				}
				n<<=1;
			}

			pestannas[t]= new TabPage();
			pestannas[t].Name= fichero;
			pestannas[t].Text= System.IO.Path.GetFileName(fichero);

			texts[t]= new TextBox();
			texts[t].MaxLength=0;	//Toma 2^32, el mximo
			texts[t].BorderStyle= BorderStyle.None;
			texts[t].Dock= DockStyle.Fill;
			texts[t].Font= last_font;
			texts[t].Location= new Point(0, 0);
			texts[t].Multiline= true;
			texts[t].ScrollBars= ScrollBars.Both;
			texts[t].WordWrap= last_ajlinea;
			texts[t].HideSelection=false;
			texts[t].AcceptsTab=true;
			if(fichero!="") texts[t].Text=texto;
			texts[t].SelectionLength=0;
			texts[t].SelectionStart=0;

			if(pestannas[t].Name==""){
				nnuevos++;
				pestannas[t].Text=get_texto(Textos.Cods.Sinttulo)+nnuevos.ToString();
			}

			ptd[t].modificado= false;
			ptd[t].cursor_onfocus= false;
			pestannas[t].Controls.Add(texts[t]);
			FAjustelinea.Checked=texts[t].WordWrap;
			TabControl1.TabPages.Add(pestannas[t]);		//This performed O.K. in VS2003. Now is extremely slow in VS2010
			TabControl1.SelectedIndex= t;					//It is the setting of the text withint the TextBox control which is slow.

			texts[t].TextChanged+=new EventHandler(this.Text_Changed);
			texts[t].AllowDrop=true;
			texts[t].DragEnter+=new DragEventHandler(TextoFichero_DragEnter);
			texts[t].DragDrop+=new DragEventHandler(TextoFichero_DragDrop);
			//Segn lo que est documentado debera ser VisibleChanged, pero no funciona
			texts[t].VisibleChanged+=new EventHandler(TextoFichero_FistTimeVisibleChanged);
			//Y en segunda instancia debera ser Enter, pero ese no funciona nunca.

			activa=t;
			t+=1;
			if(t==1) Enabled_true();
			if(Panel1!=null) Panel1.ahora_no_se_puede_cerrar--;
		}

		private void quita_pestanna(short i){
			try{TabControl1.TabPages.Remove(TabControl1.TabPages[i]);} //another instance of the ever the same .NET bug.
			catch(ArgumentOutOfRangeException){}	//If the TabPage has not yet been shown the .NET Framework has not yet created it.
			for(i++;i<t;i++){
				texts[i-1]=texts[i];
				pestannas[i-1]=pestannas[i];
				ptd[i-1]=ptd[i];
			}
			t--;
			texts[t]=null;
			pestannas[t]=null;
			if(t==0){
				Enabled_false();
				FormBuscar1.Hide();
			}
		}

		private void TextoFichero_FistTimeVisibleChanged(object sender,EventArgs e){
			TextBox Txt=(TextBox)sender;
			Txt.VisibleChanged-=new EventHandler(TextoFichero_FistTimeVisibleChanged);
			Txt.GotFocus+=new EventHandler(TextoFichero_VisibleChanged);
			TextoFichero_VisibleChanged(sender,e);
		}
		private void TextoFichero_VisibleChanged(object sender,EventArgs e){
			if(activa==-1 || texts[activa].Visible==false) return;
			if(ptd[activa].cursor_onfocus){
				ptd[activa].cursor_onfocus=false;
				texts[activa].ScrollToCaret();
			}
		}
		private void TabControl1_SelectedIndexChanged(object sender,System.EventArgs e){
			activa=(short)TabControl1.SelectedIndex;
			if(activa==-1) return;
			FAjustelinea.Checked=texts[activa].WordWrap;
			if(ptd[activa].cursor_onfocus){
				ptd[activa].cursor_onfocus=false;
				texts[activa].ScrollToCaret();
			}
		}

		private void TextoFichero_DragEnter(object sender,DragEventArgs e){
			if (e.Data.GetDataPresent(DataFormats.FileDrop)){
				e.Effect= DragDropEffects.Copy;
			}else{
				e.Effect= DragDropEffects.None;
			}

		}
		internal void TextoFichero_DragDrop(object sender,DragEventArgs e){
			String[] files;
			int i,n;
			try{
				files= (string[])e.Data.GetData(DataFormats.FileDrop);
				n=files.Length;
				for(i=0;i<n;i++){
					annade_pestanna(files[i],false);
				}
			}catch(Exception){}
		}

	#region Archivo
		private void ANueva_Click(object sender,System.EventArgs e)
		{
			annade_pestanna("",false);
		}

		private void AAbrir_Click(object sender,System.EventArgs e)
		{
			try{if(activa!=-1) Open1.InitialDirectory=System.IO.Path.GetDirectoryName(pestannas[activa].Name);}
			catch(Exception){}
			if(subOpen.ShowDialog(Panel1,Open1)!=DialogResult.OK) return;
			annade_pestanna(Open1.FileName,false);
		}
		private void ARecargar_Click(object sender,System.EventArgs e){
			if(pestannas[activa].Name=="") return;
			annade_pestanna(pestannas[activa].Name,false);
		}

		private void AGuardar_Click(object sender,System.EventArgs e){
			if(Panel1!=null){
				Panel1.ahora_no_se_puede_cerrar++;
				Panel1.set_message(Globales.Textos.get_texto(Globales.Textos.Cods.Guardando_un_fichero,idiomaPadre));
			}
			guardar(activa);
			if(Panel1!=null) Panel1.ahora_no_se_puede_cerrar--;
		}
		private bool guardar(int a){return guardar(a,false);}
		private bool guardar(int a,bool nombra){
			if(pestannas[a].Name==""){ return guardarcomo(a,nombra);}

			try{
				try{
					filew= new System.IO.StreamWriter(pestannas[a].Name,false,System.Text.Encoding.Default);
				}catch(System.IO.IOException){
					Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(14,pestannas[a].Name,idioma));
					return true;
				}
				filew.Write(texts[a].Text);
				filew.Close();
				ptd[a].modificado=false;
			}catch(System.IO.IOException){
				if(nombra) Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(17,pestannas[a].Name,idioma));
				else Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(Globales.Textos.Cods.Noseha_podido_guardar,idioma));
				return true;
			}
			return false;
		}

		private void AGuardarcomo_Click(object sender,System.EventArgs e)
		{
			if(Panel1!=null){
				Panel1.ahora_no_se_puede_cerrar++;
				Panel1.set_message(Globales.Textos.get_texto(Globales.Textos.Cods.Guardando_un_fichero,idiomaPadre));
			}
			guardarcomo(activa);
			if(Panel1!=null) Panel1.ahora_no_se_puede_cerrar--;
		}
		private bool guardarcomo(int a){return guardarcomo(a,false);}
		private bool guardarcomo(int a,bool nombra){

			string fichero;
			fichero=pestannas[a].Name;
			if(fichero!="") Save1.FileName=fichero;
			else Save1.FileName=pestannas[a].Text;

			if(subSave.ShowDialog(Panel1,Save1)!=DialogResult.OK) return true;
			fichero=Save1.FileName;
			try{
				try{
					filew= new System.IO.StreamWriter(fichero,false,System.Text.Encoding.Default);
				}catch(System.IO.IOException){
					Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(14,fichero,idioma));
					return true;
				}
				filew.Write(texts[a].Text);
				filew.Close();

				pestannas[a].Name=fichero;
				pestannas[a].Text=System.IO.Path.GetFileName(fichero);
				ptd[a].modificado=false;

			}catch(System.IO.IOException){
				if(nombra) Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(17,fichero,idioma));
				else Panel1.MessageBoxAT.Show(Globales.Textos.get_texto(Globales.Textos.Cods.Noseha_podido_guardar,idiomaPadre));
				return true;
			}
			return false;
		}

		private void Label1_Click(object sender,System.EventArgs e){
			if(t==0){cerrar(); return;}
			bool b=false;
			int dr;

			if(Panel1!=null) Panel1.ahora_no_se_puede_cerrar++;
			if(ptd[activa].modificado){
				string[] ss=new string[]{Globales.Textos.get_texto(Globales.Textos.Cods.S,idioma),Globales.Textos.get_texto(Globales.Textos.Cods.No,idioma),Globales.Textos.get_texto(Globales.Textos.Cods.Cancelar,idioma)};
				dr=Panel1.ShowMessageWait(get_texto(Desea_guardar_cambios)+pestannas[activa].Text+get_texto(cambios_cierre),ss,1);
				if(dr==3){
					if(Panel1!=null) Panel1.ahora_no_se_puede_cerrar--;
					return;
				}
				if(dr!=2){
					if(Panel1!=null) Panel1.set_message(Globales.Textos.get_texto(Globales.Textos.Cods.Guardando_un_fichero,idiomaPadre));
					b=guardar(activa);
				}
			}
			if(!b) quita_pestanna(activa);
			if(Panel1!=null) Panel1.ahora_no_se_puede_cerrar--;
		}

		private void AGuardartodo_Click(object sender,System.EventArgs e)
		{
			if(Panel1!=null){
				Panel1.ahora_no_se_puede_cerrar++;
				Panel1.set_message(Globales.Textos.get_texto(Globales.Textos.Cods.Guardando_ficheros,idiomaPadre));
			}
			guardartodo();
			if(Panel1!=null) Panel1.ahora_no_se_puede_cerrar--;
		}
		public void guardartodo(){
			short i;
			bool b=false;

			i=activa;
			for(activa=0;activa<t;activa++){
				if(ptd[activa].modificado)
					b=guardar(activa,true);
			}
			activa=i;
		}

		private void ACerrar_Click(object sender,System.EventArgs e){
			cerrar();
		}
		public void cerrar(){
			ControlesAt.FormSiNo Formsino1;
			short ret=1;
			bool b=false;
			string txt;

			Formsino1=null;
			while(t>0){
				if(ptd[activa].modificado){
					string old_message=null;
					if(Panel1!=null){
						Panel1.ahora_no_se_puede_cerrar++;
						old_message=Panel1.mensaje_estado;
					}
					if(ret!=2){
						if(Panel1!=null) Panel1.set_message(Panel1.mensaje_pordefecto);
						txt=get_texto(Desea_guardar_cambios)+pestannas[activa].Text+get_texto(cambios_cierre);
						if(Formsino1==null){Formsino1=new FormSiNo(txt,idioma); Formsino1.Text=get_texto(MsgCaption);}
						else Formsino1.Message=txt;
						ret=(short)Formsino1.ShowDialog(this.ParentForm);
					}
					if(ret==1 || ret==2){
						if(Panel1!=null) Panel1.set_message(Globales.Textos.get_texto(Globales.Textos.Cods.Guardando_ficheros,idiomaPadre));
						b=guardar(activa);
					}
					if(Panel1!=null){
						Panel1.set_message(old_message);
						Panel1.ahora_no_se_puede_cerrar--;
					}
					if(ret==5) return;
					if(ret==4) break;
				}
				if(b) return;
				quita_pestanna(activa);
			}
			this.Dispose();
		}
	#endregion
	#region Edicin
		private void EBuscar_Click(object sender,System.EventArgs e)
		{
			FormBuscar1.Estado=false;
			FormBuscar1.Show();
			FormBuscar1.Focus();
			if(!EBsiguiente.Enabled) EBsiguiente.Enabled=true;
		}
		private void EBsiguiente_Click(object sender,System.EventArgs e)
		{
			FormBuscar1.Estado=false;
			busca();
		}
		private void EBtodos_Click(object sender,System.EventArgs e)
		{
			FormBuscar1.Estado=true;
			FormBuscar1.Show();
			FormBuscar1.Focus();
			FormBuscar1.Owner=this.ParentForm;
		}
		private void ESeleccionartodo_Click(object sender,System.EventArgs e)
		{
			texts[activa].Select(0,texts[activa].Text.Length);
		}

		private void busca(){
			int i,ib,current,l;
			string txt=FormBuscar1.Tbuscar;
			if(txt=="") return;
			bool b=FormBuscar1.Estado;

			if(b){ i=0; l=t;}
			else{ i=activa; l=i+1;}

			for(;i<l;i++){
				Textaux=texts[i];
				current=Textaux.SelectionStart;
				if(Textaux.SelectionLength>0) current++;

				ib=Textaux.Text.IndexOf(txt,current);
				if(ib==-1)
				{
					ib=current-1+txt.Length;
					if(ib>Textaux.Text.Length) ib=Textaux.Text.Length;
					ib=Textaux.Text.IndexOf(txt,0,ib);
					if(ib==-1 && !b){
						if(Panel1!=null) Panel1.ahora_no_se_puede_cerrar++;
						Panel1.MessageBoxAT.Show(get_texto(No_se_encontr_texto)+txt+get_texto(wasnt_found));
						if(Panel1!=null) Panel1.ahora_no_se_puede_cerrar--;
						return;
					}
				}
				if(ib!=-1){
					Textaux.Select(ib,txt.Length);
					Textaux.ScrollToCaret();
				}
			}
			FormBuscar1.Estado=false;
		}
		private void reemplaza()
		{
			int ib,current;
			string txt=FormBuscar1.Tbuscar;
			Textaux=texts[activa];

			if(Textaux.SelectedText==txt){
				Textaux.SelectedText=FormBuscar1.Treemplazar;
				Textaux.SelectionStart+=Textaux.SelectionLength;
			}

			current=Textaux.SelectionStart;
			if(Textaux.SelectionLength>0) current++;

			ib=Textaux.Text.IndexOf(txt,current);
			if(ib==-1)
			{
				ib=current-1+txt.Length;
				if(ib>Textaux.Text.Length) ib=Textaux.Text.Length;
				ib=Textaux.Text.IndexOf(txt,0,ib);
				if(ib==-1){
					Panel1.MessageBoxAT.Show(get_texto(No_se_encontr_texto)+txt+get_texto(wasnt_found)); return;
				}
			}
			Textaux.Select(ib,txt.Length);
			Textaux.ScrollToCaret();
		}

		private void reemplazatodo()
		{
			int i,ib,current,l;
			string txt=FormBuscar1.Tbuscar;
			bool b=FormBuscar1.Estado;

			if(txt=="") return;
			if(b==true){
				i=Panel1.ShowMessageWait(get_texto(Textos.Cods.Seguro),Globales.Textos.YesNo(idioma),2);
				if(i!=1) return;
			}

			if(b){i=0; l=t;}
			else{ i=activa; l=i+1;}

			for(;i<l;i++)
			{
				Textaux=texts[i];
				current=0;
				for(;(ib=Textaux.Text.IndexOf(txt,current))!=-1;)
				{
					Textaux.Select(ib,txt.Length);
					Textaux.SelectedText=FormBuscar1.Treemplazar;
					current=Textaux.SelectionStart+=Textaux.SelectionLength;
				}
				Textaux.ScrollToCaret();
			}
			FormBuscar1.Estado=false;
		}

		private void FormBuscar1_Closing(object sender,CancelEventArgs e)
		{
			e.Cancel=true;
			FormBuscar1.Hide();
		}
	#endregion
	#region Formato
		private void FAjustelinea_Click(object sender,System.EventArgs e)
		{
			FAjustelinea.Checked=!FAjustelinea.Checked;
			if(activa==-1) return;
			last_ajlinea=texts[activa].WordWrap=!texts[activa].WordWrap;
		}

		private void FFuente_Click(object sender,System.EventArgs e)
		{
			Font1.Font=texts[activa].Font;
			if(Panel1!=null) Panel1.ahora_no_se_puede_cerrar++;
			Font1.ShowDialog();
			if(Panel1!=null) Panel1.ahora_no_se_puede_cerrar--;
			last_font=texts[activa].Font=Font1.Font;
		}
	#endregion
		public short busca_fichero(string s){
			short i;
			string ss;

			if(s=="") return -1;
			try{ss=System.IO.Path.GetFullPath(s);}
			catch(System.ArgumentException){ return -1;}

			for(i=0;i<t;i++){
				if(pestannas[i].Name=="") continue;
				if(System.IO.Path.GetFullPath(pestannas[i].Name)==ss) break;
			}
			if(i==t) i=-1;
			return i;
		}

		private void Enabled_false()
		{
			ARecargar.Enabled=false;
			AGuardar.Enabled=false;
			AGuardarcomo.Enabled=false;
			AGuardartodo.Enabled=false;
			EBuscar.Enabled=false;
			EBsiguiente.Enabled=false;
			EBtodos.Enabled=false;
			ESeleccionartodo.Enabled=false;
			FAjustelinea.Enabled=false;
			FFuente.Enabled=false;
		}
		private void Enabled_true(){
			ARecargar.Enabled=true;
			AGuardar.Enabled=true;
			AGuardarcomo.Enabled=true;
			AGuardartodo.Enabled=true;
			EBuscar.Enabled=true;
			EBsiguiente.Enabled=FormBuscar1.Created;
			EBtodos.Enabled=true;
			ESeleccionartodo.Enabled=true;
			FAjustelinea.Enabled=true;
			FFuente.Enabled=true;
		}

		protected override void update_idioma(){
			PanelMenu1.gLabels("Archivo").Text=Globales.Textos.get_texto(Globales.Textos.Cods.Archivo,idioma);
			ANueva.Text=get_texto(NuevaPestaa);
			AAbrir.Text=get_texto(Abrir);
			ARecargar.Text=get_texto(Recargar);
			AGuardar.Text=get_texto(Guardar);
			AGuardarcomo.Text=get_texto(GuardarComo);
			AGuardartodo.Text=get_texto(GuardarTodo);
			ACerrar.Text=get_texto(Cerrar);

			PanelMenu1.gLabels("Edicion").Text=get_texto(Edicin);
			EBuscar.Text=get_texto(BuscarReemplazar);
			EBsiguiente.Text=get_texto(BuscarSiguiente);
			EBtodos.Text=get_texto(BR_enTodos);
			ESeleccionartodo.Text=get_texto(SeleccionarTodo);

			PanelMenu1.gLabels("Formato").Text=get_texto(Formato);
			FAjustelinea.Text=get_texto(AjustedeLnea);
			FFuente.Text=get_texto(Fuente);
		}

		private string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}

	public class TextoFicheroCollection{
		private TextoFichero[] tf;
		private int i_sinnombre;
		private int ngrupos;
		public string grupo_default;

		public TextoFicheroCollection(){
			grupo_default="Sin nombre";
			tf=new TextoFichero[0];
			ngrupos=0;
			i_sinnombre=0;
		}

		public int Count{
			get{
				return ngrupos;
			}
		}

		public TextoFichero this[int i]{
			get{ return tf[i];}
		}
		public TextoFichero this[string s]{
			get{
				for(int i=0;i<ngrupos;i++){
					if(tf[i].nombre==s)
						return tf[i];
				}
				throw new System.IndexOutOfRangeException("No existe ningn grupo de fichas con nombre '"+s+"'");
			}
		}

		public void Add(string nombre,Globales.Idioma idioma,PanelEditorT Form1, System.Drawing.Font font, bool ajustelinea){
			int i;
			int k;

			if(nombre==""){
				for(;;){
					i_sinnombre++;
					nombre="Sin nombre "+i_sinnombre.ToString();
					k=0;
					for(i=0;i<ngrupos;i++){	//Por si el usuario a aadido algn grupo con el nombre "Sin nombre";
						if(tf[i].nombre==nombre){
							k=1;
							break;
						}
					}
					if(k==0) break;
				}
			}else{
				for(i=0;i<ngrupos;i++){
					if(tf[i].nombre==nombre)
						throw new System.ArgumentException("El grupo '"+nombre+"' ya existe");
				}
			}
			TextoFichero[] tf_aux=new TextoFichero[ngrupos];
			for(i=0;i<ngrupos;i++)
				tf_aux[i]=tf[i];

			tf=new TextoFichero[ngrupos+1];
			for(i=0;i<ngrupos;i++)
				tf[i]=tf_aux[i];
			tf[ngrupos]=new TextoFichero(nombre,idioma,Form1,font,ajustelinea);
			ngrupos++;
		}

		public void Remove(int i){
			if(i>=ngrupos) throw new System.IndexOutOfRangeException();
			for(i++;i<ngrupos;i++)
				tf[i-1]=tf[i];
			ngrupos--;
			tf[ngrupos]=null;
		}
	}

	public sealed class TextoFicheroUtils{
		public static bool isvalid_utf8(byte[] chars){
			int n=chars.Length;
			uint c=0, bytes=0, nbytes=1;	//Assignments of c and nbytes because the compiler is stupid
			for(int i=0; i<n && chars[i]!=0; i++){
				if(bytes==0){
					if(chars[i]<0x80) continue;
					if((chars[i]&0x40)==0) return false;
					if((chars[i]&0xe0)==0xc0){
						nbytes=2;
						c=chars[i]&0x1FU;
					}else if((chars[i]&0xF0)==0xE0){
						nbytes=3;
						c=chars[i]&0x0FU;
					}else if((chars[i]&0xF8)==0xF0){
						nbytes=4;
						c=chars[i]&0x07U;
					}else{
						return false;
					}
					bytes=nbytes-1;
					if(chars[++i]==0) break;	//truncated byte-sequences at the end are accepted as good
				}
				if((chars[i]&0xC0)!=0x80) return false;
				c<<=6; c|=chars[i]&0x3FU;
				if(--bytes!=0) continue;

				if(c<0x80) return false;
				if(nbytes>=3){
					if(c<0x800) return false;
					if(nbytes>=4){
						if(c<0x10000 || c>=110000) return false;
				}	}
			}
			return true;
		}
	}
}