using System;
using System.Windows.Forms;
using System.Drawing;

namespace ControlesAt{
	public class TextBoxPlano : TextBoxFocus{
		protected ControlesAt.NoControl Label1,Label2;

		public TextBoxPlano() : base(){initializeb();}
		public TextBoxPlano(char type) : base(type){initializeb();}
		public TextBoxPlano(KeyPressEventHandler p) : base(p){initializeb();}
		protected new void initializeb(){
			Label1= new NoControl();
			Label2= new NoControl();
			Label1.Height=2;
			Label2.Width=3;

			this.BorderStyle= BorderStyle.None;
		}
		protected override Size DefaultSize{
			get{return new Size(36,15);}
		}

		protected override void OnParentChanged(EventArgs e){
			base.OnParentChanged(e);
			if(this.Parent!=null){
				this.Parent.Controls.Add(Label1);
				this.Parent.Controls.Add(Label2);
			}else{
				Label2.Parent=Label1.Parent=null;
			}
		}
		protected override void OnLocationChanged(EventArgs e){
			base.OnLocationChanged(e);
			Label1.Location= new Point(this.Left,this.Top-2);
			Label2.Location= new Point(this.Right,this.Top);
		}
		protected override void OnSizeChanged(EventArgs e){
			base.OnSizeChanged(e);
			Label1.Width=this.Width+3;
			Label2.Left=this.Right;
			Label2.Height=this.Height;
		}
		protected override void OnBackColorChanged(EventArgs e){
			base.OnBackColorChanged(e);
			Label2.BackColor=Label1.BackColor=this.BackColor;
		}
		protected override void OnEnabledChanged(EventArgs e){
			base.OnEnabledChanged(e);
			Label2.Enabled=Label1.Enabled=this.Enabled;
			if(this.Enabled){Label2.BackColor=Label1.BackColor=this.BackColor;}
			else Label2.BackColor=Label1.BackColor=SystemColors.Control;
		}
	}

	public class DomainUpDownFixed : Panel{
		public DomainUpDown L;

		public DomainUpDownFixed(){
			L= new DomainUpDown();
			L.BorderStyle= BorderStyle.None;
			L.Location= new Point(2, 0);
			L.Wrap=true;
			//
			this.Controls.Add(L);
			this.BorderStyle= BorderStyle.Fixed3D;
			this.OnEnabledChanged(EventArgs.Empty);
			this.OnSizeChanged(EventArgs.Empty);
		}
		protected override Size DefaultSize{
			get{return new Size(108, 17);}
		}
		protected override void OnResize(EventArgs e){
			if(this.Height!=17) this.Height=17;
			base.OnResize(e);
		}
		protected override void OnSizeChanged(EventArgs e){
			base.OnSizeChanged(e);
			L.Width=this.ClientSize.Width-2;
		}
		protected override void OnEnabledChanged(EventArgs e){
			base.OnEnabledChanged(e);
			if(this.Enabled) this.BackColor=SystemColors.Window;
			else this.BackColor=SystemColors.Control;
		}
	}
}
