using System;
using System.Windows.Forms;
using System.Drawing;

namespace ControlesAt{
	public delegate void TabRowTabSelectorDelegate(TabRow C, TabSelector B);
	public delegate void TabSelectorTabSelector(TabSelector P, TabSelector C);

	public interface TabSelector{
		ContainerControl AssociatedPanel{get; set;}
		Control C{get;}
		void SetStyle(object style);
	}

	public class ButtonTabStyle{
		public bool active;
		public FlatStyle FlatStyle;
		public Color BackColor;
	}
	public class ButtonTab : Button, TabSelector{
		protected ContainerControl _panel;
		public ContainerControl AssociatedPanel{
			get{return _panel;}	set{_panel=value;}
		}
		public Control C{    get{return this;}	}

		public ButtonTab(){
			this.TextAlign=ContentAlignment.MiddleCenter;
		}

		public void SetStyle(object style){
			ButtonTabStyle Style=(ButtonTabStyle)style;
			this.FlatStyle= Style.FlatStyle;
			if(Style.active) this.BackColor= Style.BackColor;
			else this.BackColor=this.Parent.BackColor;
		}
	}

	public class LabelTabStyle{
		public bool active;
		public BorderStyle BorderStyle;
		public Color BackColor;
	}
	public class LabelTab : PaddedLabel, TabSelector{
		protected ContainerControl _panel;
		public ContainerControl AssociatedPanel{
			get{return _panel;}
			set{_panel=value;}
		}
		public Control C{    get{return this;}	}

		public LabelTab(){
			this.TextAlign= new TwoDimAlignment(0.5F, 0.5F);
		}

		public void SetStyle(object style){
			LabelTabStyle Style=(LabelTabStyle)style;
			//this.BorderStyle= Style.BorderStyle;
			if(Style.active) this.BackColor= Style.BackColor;
			else this.BackColor=this.Parent.BackColor;
		}
	}

	public class SelectorWithStyles{
		public Type SelectorType;
		public object NormalStyle;
		public object ActiveStyle;
	}

	public class TabRow : ContainerControl{
		public TabRowTabSelectorDelegate TabSelectorAdded;
		public int PreviousWidth, PreviousHeight;

		public TabRow(){
			this.PreviousWidth=0;
			this.PreviousHeight=0;
			this.Height=18;
			this.Width=0;
		}
		protected override void OnSizeChanged(EventArgs e){
			base.OnSizeChanged(e);
			this.PreviousWidth=this.Width;
			this.PreviousHeight=this.Height;
		}


		public void AddTabSelector(TabSelector B)
		{
			B.C.Dock= DockStyle.Left;
			this.Controls.Add(B.C);
			this.Controls.SetChildIndex(B.C,0);
			this.Width+=B.C.Width;
			if(TabSelectorAdded!=null) TabSelectorAdded(this,B);
		}
		public void AddOtherControl(Control C){
			C.Dock= DockStyle.Left;
			this.Controls.Add(C);
			this.Controls.SetChildIndex(C,0);
			this.Width+=C.Width;
		}
	}
	public class TabRowCollection{
		private TabRow[] rows;
		internal int nrows;
		public int Count{
			get{return nrows;}
		}
		public TabRowTabSelectorDelegate TabSelectorAdded;
		private TabRowTabSelectorDelegate del_selector_added;

		public TabRowCollection(){
			rows=new TabRow[0];
			nrows=0;
			del_selector_added=new TabRowTabSelectorDelegate(this._selector_added);
		}

		public TabRow this[int i]{
			get{return rows[i];}
		}

		public void Add(){Add(null);}
		public void Add(TabRow row){
			int i;

			TabRow[] rows_aux=new TabRow[nrows];
			for(i=0;i<nrows;i++)
				rows_aux[i]=rows[i];

			rows=new TabRow[nrows+1];
			for(i=0;i<nrows;i++)
				rows[i]=rows_aux[i];
			if(row==null) rows[nrows]=new TabRow();
			else rows[nrows]=row;
			rows[nrows].TabSelectorAdded+= del_selector_added;
			nrows++;
		}

		public void Remove(int i){
			if(i>=nrows) throw new System.IndexOutOfRangeException();
			for(i++;i<nrows;i++)
				rows[i-1]=rows[i];
			nrows--;
			rows[nrows]=null;
		}

		private void _selector_added(TabRow C, TabSelector B){
			if(TabSelectorAdded!=null) TabSelectorAdded(C,B);
		}
	}

	public class SuperTabControl : ContainerControl{
		protected ContainerControl PanelPage;
		protected TabRowTabSelectorDelegate del_TabSelectorAdded;
		protected EventHandler del_ChangePage;
		protected EventHandler del_RowSizeChanged;

		public TabRowCollection Rows;
		public DockStyle RowsDock;
		public TabSelector CurrentSelector, PreviousSelector;
		public TabSelectorTabSelector PageChanged;

		protected SelectorWithStyles[] RegisteredClasses;
		protected int nclases;
		public ButtonTabStyle DefaultNormalButton, DefaultActiveButton;
		public LabelTabStyle DefaultNormalLabel, DefaultActiveLabel;

		public bool DockFill;
		protected DockStyle SavedDock;
		protected int MinimumWidth;
		private bool adjustheight;
		private bool adjustwidth;
		private int baseheight;
		private int userheight;
		public bool AdjustWidth{
			get{return adjustwidth;}
			set{adjustwidth=value;
				if(value==true) SeekandSetWidth();}
		}
		public bool AdjustHeight{
			get{return adjustheight;}
			set{adjustheight=value;
				if(value && CurrentSelector!=null) this.UserHeight=CurrentSelector.AssociatedPanel.Height;
			}
		}
		protected int BaseHeight{
			get{return baseheight;}
			set{baseheight=value;
				this.Height=baseheight+userheight;}
		}
		public int UserHeight{
			get{return userheight;}
			set{userheight=value;
				this.Height=baseheight+userheight;}
		}

		public SuperTabControl(){
			PanelPage= new ContainerControl();
			PanelPage.Dock= DockStyle.Fill;
			PanelPage.TabIndex= 0;
			del_TabSelectorAdded= new TabRowTabSelectorDelegate(First_TabSelectorAdded);
			del_ChangePage= new EventHandler(ChangePage);
			del_RowSizeChanged= new EventHandler(RowSizeChanged);

			RegisteredClasses= new SelectorWithStyles[0];
			nclases=0;

			PreviousSelector=null;
			CurrentSelector=null;
			DockFill=true;
			adjustheight=true;
			adjustwidth=false;
			MinimumWidth=20;
			baseheight=0;
			UserHeight=100;
			this.Width=100;

			Rows=new TabRowCollection();
			RowsDock=DockStyle.Top;
			this.Controls.Add(this.PanelPage);

			DefaultNormalButton= new ButtonTabStyle();
			DefaultActiveButton= new ButtonTabStyle();
			DefaultNormalLabel= new LabelTabStyle();
			DefaultActiveLabel= new LabelTabStyle();

			DefaultNormalButton.active=false;
			DefaultNormalButton.FlatStyle= FlatStyle.Popup;
			DefaultNormalButton.BackColor= Color.FromArgb(0);
			DefaultActiveButton.active=true;
			DefaultActiveButton.FlatStyle= FlatStyle.Standard;
			DefaultActiveButton.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);

			DefaultNormalLabel.active=false;
			DefaultNormalLabel.BorderStyle= BorderStyle.None;
			DefaultNormalLabel.BackColor= Color.FromArgb(0);
			DefaultActiveLabel.active=true;
			DefaultActiveLabel.BorderStyle= BorderStyle.FixedSingle;
			DefaultActiveLabel.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);

			RegisterClass((new ButtonTab()).GetType(), DefaultNormalButton, DefaultActiveButton);
			RegisterClass((new LabelTab()).GetType(), DefaultNormalLabel, DefaultActiveLabel);
		}

		public void RegisterClass(Type SelectorType, object NormalStyle, object ActiveStyle){
			if(! (typeof(TabSelector)).IsAssignableFrom(SelectorType)){
				throw new System.SystemException("El tipo "+SelectorType.ToString()+" no es un TabSelector");
			}
			int i;

			SelectorWithStyles[] rows_aux=new SelectorWithStyles[nclases];
			for(i=0;i<nclases;i++)
				rows_aux[i]=RegisteredClasses[i];

			RegisteredClasses=new SelectorWithStyles[nclases+1];
			for(i=0;i<nclases;i++)
				RegisteredClasses[i]=rows_aux[i];
			RegisteredClasses[nclases]=new SelectorWithStyles();
			RegisteredClasses[nclases].SelectorType= SelectorType;
			RegisteredClasses[nclases].NormalStyle= NormalStyle;
			RegisteredClasses[nclases].ActiveStyle= ActiveStyle;
			nclases++;
		}

		public void AddRow(){AddRow(null);}
		public void AddRow(TabRow row){
			int nrows=Rows.Count;
			Rows.Add(row);
			Rows[nrows].Dock=RowsDock;
			Rows[nrows].TabIndex=nrows;
			Rows[nrows].TabSelectorAdded+=del_TabSelectorAdded;
			this.Controls.Add(Rows[nrows]);
			this.Controls.SetChildIndex(Rows[nrows],1);

			if(row!=null){
				foreach(Control c in row.Controls){
					if(c is TabSelector) del_TabSelectorAdded(row, (TabSelector)c);
			}	}

			this.BaseHeight+=Rows[nrows].Height;
			if(AdjustWidth && MinimumWidth<Rows[nrows].Width){
				MinimumWidth=Rows[nrows].Width;
				if(this.Width<MinimumWidth) this.Width=MinimumWidth;
			}
			Rows[nrows].SizeChanged+=del_RowSizeChanged;
		}

		protected void RowSizeChanged(object sender,System.EventArgs e){
			TabRow row=(TabRow)sender;
			int d;
			d=row.Height-row.PreviousHeight;
			if(d!=0) this.BaseHeight+=d;

			if(!AdjustWidth) return;
			d=row.Width-row.PreviousWidth;
			if(d==0) return;
			if(d>0){
				if(MinimumWidth<row.Width){
					MinimumWidth=row.Width;
					if(AdjustWidth && this.Width<MinimumWidth) this.Width=MinimumWidth;
				}
			}else if(MinimumWidth>row.PreviousHeight) return;
			else SeekandSetWidth();
		}

		protected void SeekandSetWidth(){
			MinimumWidth=20;
			int nrows=Rows.Count;
			for(int i=0;i<nrows;i++){
				if(Rows[i].Width>MinimumWidth) MinimumWidth=Rows[i].Width;
			}
			if(CurrentSelector!=null && CurrentSelector.AssociatedPanel.Width>MinimumWidth)
				this.Width=CurrentSelector.AssociatedPanel.Width;
			else this.Width=MinimumWidth;
		}

		protected void First_TabSelectorAdded(TabRow C, TabSelector B){
			B.AssociatedPanel.Visible=true;
			this.PanelPage.Controls.Add(B.AssociatedPanel);
			B.C.Click+= del_ChangePage;
			ChangePage(B, EventArgs.Empty);

			del_TabSelectorAdded-= new TabRowTabSelectorDelegate(First_TabSelectorAdded);
			del_TabSelectorAdded+= new TabRowTabSelectorDelegate(TabSelectorAdded);
		}
		protected void TabSelectorAdded(TabRow C, TabSelector B){
			B.AssociatedPanel.Visible=false;
			this.PanelPage.Controls.Add(B.AssociatedPanel);

			int i;
			for(i=0; i<nclases; i++){
				if(RegisteredClasses[i].SelectorType==B.GetType()) break;
			}
			if(i<nclases) B.SetStyle(RegisteredClasses[i].NormalStyle);
			B.C.Click+= del_ChangePage;
		}

		protected void ChangePage(object sender,System.EventArgs e){
			int i;

			PreviousSelector=CurrentSelector;
			CurrentSelector=(TabSelector)sender;

			if(PreviousSelector!=null){
				PreviousSelector.AssociatedPanel.Visible=false;
				for(i=0; i<nclases; i++){
					if(RegisteredClasses[i].SelectorType==PreviousSelector.GetType()) break;
				}
				if(i<nclases) PreviousSelector.SetStyle(RegisteredClasses[i].NormalStyle);
			}

			if(CurrentSelector!=null){
				CurrentSelector.AssociatedPanel.Visible=true;
				for(i=0; i<nclases; i++){
					if(RegisteredClasses[i].SelectorType==CurrentSelector.GetType()) break;
				}
				if(i<nclases) CurrentSelector.SetStyle(RegisteredClasses[i].ActiveStyle);

				if(AdjustHeight) UserHeight=CurrentSelector.AssociatedPanel.Height;
				if(AdjustWidth){
					if(CurrentSelector.AssociatedPanel.Width>MinimumWidth) this.Width=CurrentSelector.AssociatedPanel.Width;
					else this.Width=MinimumWidth;
				}
			}else{
				if(AdjustHeight) UserHeight=0;
				if(AdjustWidth) this.Width=MinimumWidth;
			}
			if(PageChanged!=null) PageChanged(PreviousSelector, CurrentSelector);
		}

		public void SetActiveSelector(TabSelector B){
			ChangePage(B, EventArgs.Empty);
		}
		public TabSelector SelectAny(){
			if(CurrentSelector!=null && CurrentSelector.C.Visible==true) return CurrentSelector;

			TabRow row;
			for(int i=0;i<Rows.Count;i++){
				row=Rows[i];
				if(row==null) continue;
				foreach(Control c in row.Controls){
					if(c is TabSelector && c.Visible==true){
						ChangePage(c,EventArgs.Empty);
						return (TabSelector)c;
				}	}
			}
			return null;
		}
	}
}