using System;
using System.Windows.Forms;
using System.Drawing;

namespace Calibracion{
using static Textos.Cods;

	public class FormSimetrica : Calibracion.FormDistorsiones{
		private System.Windows.Forms.Label Label1, Label3;
		internal System.Windows.Forms.Label Label4;
		private System.Windows.Forms.Label Label2;

		public const byte nparametros=5;
		protected override byte get_nparametros(){return nparametros;}
		protected readonly byte serie;	//1: radial, 2: tangencial.
		protected readonly bool simple;

		public FormSimetrica(ControlesAt.IEntorno _Entorno, byte serie, string letra, bool simple) : base(_Entorno,letra){
			InitializeComponent();
			this.serie=serie;
			this.simple=simple;
			checkboxes[2].Checked=true;
			checkboxes[3].Checked=true;
			if(simple) checkboxes[1].Enabled=false;
		}

	#region InitializeComponent
		private void InitializeComponent()	{
			Label1= new Label();
			Label2= new Label();
			Label3= new Label();
			Label4= new Label();
			//
			// ContainerInfo
			//
			ContainerInfo.Controls.Add(Label1);
			ContainerInfo.Controls.Add(Label2);
			ContainerInfo.Controls.Add(Label3);
			ContainerInfo.Controls.Add(Label4);
			ContainerInfo.Height=132;
			//
			// Label1
			//
			Label1.FlatStyle= FlatStyle.System;
			Label1.Location= new Point(4, 0);
			Label1.Size= new Size(436, 28);
			Label1.TabIndex= 0;
			//
			// Label4
			//
			Label4.FlatStyle= FlatStyle.System;
			Label4.Location= new Point(364, 52);
			Label4.Size= new Size(72, 16);
			Label4.TabIndex= 1;
			Label4.Text= "s= r/semidiag.";
			//
			// Label3
			//
			Label3.FlatStyle= FlatStyle.System;
			Label3.Location= new Point(12, 32);
			Label3.Size= new Size(416, 16);
			Label3.TabIndex= 2;
			//
			// Label2
			//
			Label2.FlatStyle= FlatStyle.System;
			Label2.Location= new Point(4, 72);
			Label2.Size= new Size(436, 56);
			Label2.TabIndex= 3;
			//
			// checkboxes
			//
			int pos=32;
			for(int i=1;i<=nparametros;i++,pos+=20)
				checkboxes[i].Location= new Point(95, pos);
			PanelParams.Height=pos-4;
		}
	#endregion

		protected override void update_idioma(){
			this.Text=get_texto(DistorsinSimtrica);
			if(serie==1){
				this.Text+=get_texto(Radial);
				Label1.Text=get_texto(El_modelo_de_distorsin_radsim);
				if(!simple) Label2.Text=get_texto(Explicaradial);
				else Label2.Text=get_texto(Explicaradial_simple);
				ContainerInfo.Height=Label2.Bottom;
			}else if(serie==2){
				this.Text+=get_texto(Tangencial);
				Label1.Text=get_texto(El_modelo_de_distorsin_tansim);
				if(!simple) Label2.Text=get_texto(Explicatangencial);
				else Label2.Text=get_texto(Explicatangencial_simple);
				ContainerInfo.Height=Label2.Top+16;
			}else{
				Label2.Text="";
				ContainerInfo.Height=Label2.Top;
			}
			switch(modelo){
				case 1: Label1.Text+=get_texto(con_poli_impares); break;
				case 2: Label1.Text+=get_texto(con_poli_completos); break;
			}
			LabelParams.Text=get_texto(Parmetros);
			Aceptar.Text=Globales.Textos.get_texto(Globales.Textos.Cods.Aceptar,idioma);
			Cancelar.Text=Globales.Textos.get_texto(Globales.Textos.Cods.Cancelar,idioma);
		}
		private string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}

		protected override void formulas(){
			checkboxes[1].letter=letra+'1';	checkboxes[1].formula="s";
			checkboxes[2].letter=letra+'2';
			checkboxes[3].letter=letra+'3';
			checkboxes[4].letter=letra+'4';
			checkboxes[5].letter=letra+'5';
			switch(modelo){
				case 1:
					Label3.Text= "       #a1s + #a2(2s^3-s) + #a3(4.8s^5-4.7s^3+0.9s) + ...";
					checkboxes[2].formula="2s^3-s";
					checkboxes[3].formula="4.8s^5-4.7s^3+0.9s";
					checkboxes[4].formula="12.8s^7-19.1s^5+8.2s^3-0.9s";
					checkboxes[5].formula="38.4s^9-76.2s^7+50.5s^5-12.6s^3+0.9s";
					break;
				case 2:
					Label3.Text= "             #a1s + #a2(3s^2-2s) + #a3(9s^3-11.4s^2+3.4s) + ... ";
					checkboxes[2].formula="3s^2-2s";
					checkboxes[3].formula="9s^3-11.4s^2+3.4s";
					checkboxes[4].formula="29.2s^4-53.1s^3+30.1s^2-5.2s";
					checkboxes[5].formula="95.8s^5-225.4s^4+187.1s^3-63.9s^2+7.4s";
					break;
			}
			Label3.Text=Label3.Text.Replace("#a",letra);
		}
	}
}
