using System;
using System.Windows.Forms;
using System.Drawing;
using System.ComponentModel;
using ControlesAt;
using System.Runtime.InteropServices;
using Globales;

namespace PanelesSub{
using static Globales.Textos.Cods;

	unsafe public struct Duenno{
		public int modo;
		public void* parent;	//Handle
		public int ThreadId;
	};

	public abstract class PanelSubordinado : ControlesAt.IdiomaControl, ControlesAt.IEntorno, ControlesAt.IMessageBoxAT{
		protected ControlesAt.PanelMenu PanelMenu1;
		protected ContextMenu MenuArchivo;
		protected MenuItem ASalir;
		protected ContextMenu MenuConfiguracion;
		protected MenuItem CIdioma;
		protected MenuItem IdEsp, IdEng, IdIt;
		protected ContextMenu MenuAyuda;
		protected MenuItem AAcercade, AManual;

		public Duenno Myowner;
		public System.Drawing.Icon icono;
		protected FormAcercade FormAcercade1;
		public ControlesAt.MessageBoxAT MessageBoxAT;
		public MessageBoxAT MessageBox{get{return MessageBoxAT;}}

		private byte _get_1;
		unsafe public byte ahora_no_se_puede_cerrar{ //Debera ser internal para las clases derivadas
			get{return _get_1;}
			set{
				_get_1=value;
				if(value!=0){
					if(mensaje_estado=="") set_message(mensaje_pordefecto);
				}else{
					mensaje_estado="";
					if(cuando_puedas_cierrate==true){
						cuando_puedas_cierrate=false;
						cerrando=false;
						varias.PostMessageW(this.ParentForm.Handle.ToPointer(),0x0401,UIntPtr.Zero,IntPtr.Zero);
						return;
				}	}
			}
		}
		protected bool cuando_puedas_cierrate;
		public bool cerrando;
		public string mensaje_estado;		//Internal en las derivadas
		public string mensaje_pordefecto="Esperando una respuesta del usuario";	//Internal en d.
		public IntPtr P_mensaje_estado;
		public void set_message(string s){	//Internal en d.
			if(mensaje_estado==s) return;
			mensaje_estado=s;
			if(cerrando){unsafe{
				if(P_mensaje_estado!=IntPtr.Zero) Marshal.FreeHGlobal(P_mensaje_estado);
				P_mensaje_estado=Marshal.StringToHGlobalUni(s);
				PostMessage(varias.MASTERM_ESTADO,P_mensaje_estado);
			}}
		}

		protected string ManualPath;
		protected string AppPath, AppData;
		protected int __left,__top;
		protected int __width,__height;
		public bool sizable;
		protected Idioma __idioma;
		protected string __OpenPath;

		unsafe protected void PostMessage(uint msg, System.IntPtr  param){
			varias.PostMessageW(Myowner.parent,msg,new UIntPtr((uint)Myowner.ThreadId),param);
		}
		unsafe protected void SendMessage(uint msg, System.IntPtr param){
			varias.SendMessageW(Myowner.parent,msg,new UIntPtr((uint)Myowner.ThreadId),param);
		}

		protected PanelSubordinado(Duenno _owner, Idioma idioma_inicial){
			sizable=false;
			InitializeComponent();

			Myowner=_owner;
			this.SuspendLayout();
			switch(Myowner.modo){
			case 0: case 1: break;
			  default:
				ASalir.Visible=false;
				ASalir.Enabled=false;
				break;
			}
			this.ResumeLayout();

			idioma=idioma_inicial;
		}
		unsafe protected PanelSubordinado(){
			sizable=false;
			InitializeComponent();
			Myowner.modo=0;
			Myowner.parent=(void*)0;
			idioma=0;	//Idioma no longer passed as a parameter. Must be set at inizializeb, probably from a configuration file
		}

		protected abstract void inizializeb(string[] argv);
		/*
			AppData=Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData)+"\\Aerotri\\";
			if(!System.IO.Directory.Exists(AppData)) System.IO.Directory.CreateDirectory(AppData);
			icono= new System.Drawing.Icon(System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("EditorD.IconoDatos.ico"));
			FormAcercade1=new FormAcercade(typeof(PanelEditorD),idioma);
			FormAcercade1.Icon= icono;
			FormAcercade1.LabelIcono.Image= icono.ToBitmap();
			MessageBoxAT.Caption="Aerotri";

			lee_ficheroConfiguracion(nombrefichero);
			update_idioma();
		*/
		public void Setup(string[] argv){
			this.ParentForm.Closing+=new CancelEventHandler(GranParent_Closing);
			ahora_no_se_puede_cerrar=0;
			cuando_puedas_cierrate=false;
			cerrando=false;
			P_mensaje_estado=IntPtr.Zero;
			AppPath=Application.StartupPath+"\\";
			MessageBoxAT= new MessageBoxAT();
			MessageBoxAT.Owner= ParentForm;
			inizializeb(argv);
		}

	#region Fichero de Configuracion
		protected virtual void inizialize_configuracion(){
			__idioma=0;
			__left=75; __top=141;
			__width=200; __height=240;	//just if someone overrides improperly lee_ficheroConfiguracion
			__OpenPath=".";
		}
		protected virtual void lee_ficheroConfiguracion(string nombre){
			inizialize_configuracion();
			System.IO.StreamReader fconfig=null;

			string ff;
			ff=AppData+nombre;
			if(System.IO.File.Exists(ff)){  try{
				fconfig=new System.IO.StreamReader(ff,System.Text.Encoding.Default);
				string[] palabras;
				for(;fconfig.Peek()>0;){
					palabras=Basicas._gcVarios.split_cmdline(fconfig.ReadLine());
					if(palabras.Length==0) continue;
					procesa_linea_config(palabras[0],palabras);
				}
				fconfig.Close();
			}catch(Exception){
				try{if(fconfig!=null) fconfig.Close();}
				catch(Exception){}
			}}

			if(Myowner.modo==0){
				__left=ParentForm.Left; __top=ParentForm.Top;
			}
			__width=this.ClientSize.Width; __height=this.ClientSize.Height;	//It is not necesary to restrict this to sizable PanelesSub
		}
		protected virtual void procesa_linea_config(string tipo,string[] palabras){
			int count=palabras.Length;
			switch(tipo){
				case "Idioma":
					try{
						if(count>1){
							byte _id=Convert.ToByte(palabras[1]);
							if(_id<(byte)Idioma.NIDIOMAS) __idioma=(Idioma)_id;
							else __idioma=Idioma.Esp;
						}
						if(Myowner.modo==0) idioma=__idioma;
					}catch(System.SystemException){}
					break;
				case "Location":
					if(Myowner.modo==0){
						try{
							if(count>1) __left=Convert.ToInt32(palabras[1]);
							if(count>2) __top=Convert.ToInt32(palabras[2]);
							this.ParentForm.Location=new Point(__left,__top);
						}catch(System.SystemException){}
					}
					break;
				case "ClientSize":
					if(!sizable) break;
					try{
						if(count>1) __width=Convert.ToInt32(palabras[1]);
						if(count>2) __height=Convert.ToInt32(palabras[2]);
						this.ClientSize=new Size(__width,__height);
					}catch(System.SystemException){}
					break;
				case "OpenPath":
					try{
						if(count>1){
							System.IO.Path.GetFullPath(palabras[1]);
							__OpenPath=palabras[1];
						}
					}catch(System.SystemException){}
					break;
			}
		}

		protected void guarda_ficheroConfiguracion(string nombre){
			System.IO.StreamWriter fconfig=new System.IO.StreamWriter(AppData+nombre,false,System.Text.Encoding.Default);
			escribe_fConfiguracion(fconfig);
			fconfig.Close();
		}
		protected virtual void escribe_fConfiguracion(System.IO.StreamWriter fconfig){
			escribe_fConfiguracion_comienzo(fconfig);
		}
		protected void escribe_fConfiguracion_comienzo(System.IO.StreamWriter fconfig){

			if(Myowner.modo==0) __idioma=idioma;
			fconfig.WriteLine("Idioma "+__idioma.ToString());

			if(this.ParentForm.WindowState!=FormWindowState.Minimized){
				__left=ParentForm.Left;
				__top=ParentForm.Top;
			}
			fconfig.Write("Location   ");
			fconfig.Write(__left.ToString());
			fconfig.Write("\t"+__top.ToString());
			fconfig.WriteLine();

			if(sizable){
				if(this.ClientSize.Width>0) __width=this.ClientSize.Width;
				if(this.ClientSize.Height>0) __height=this.ClientSize.Height;
				fconfig.Write("ClientSize ");
				fconfig.Write(__width.ToString());
				fconfig.Write("\t"+__height.ToString());
				fconfig.WriteLine();
			}
		}

	#endregion

		private void InitializeComponent(){
			PanelMenu1= new ControlesAt.PanelMenu();
			MenuArchivo= new ContextMenu();
			ASalir= new MenuItem();
			MenuConfiguracion= new ContextMenu();
			CIdioma= new MenuItem();
			IdEsp= new MenuItem();
			IdEng= new MenuItem();
			IdIt= new MenuItem();
			MenuAyuda= new ContextMenu();
			AAcercade= new MenuItem();
			AManual= new MenuItem();
			//
			// MenuArchivo, ASalir
			//
			ASalir.Index= 0;
			ASalir.Click+= new EventHandler(ASalir_Click);
			MenuArchivo.MenuItems.AddRange(new MenuItem[] {ASalir});
			//
			// MenuConfiguracion
			//
			MenuConfiguracion.MenuItems.AddRange(new MenuItem[] {CIdioma});
			//
			// CIdioma
			//
			CIdioma.Index= 0;
			CIdioma.MenuItems.AddRange(new MenuItem[] {	IdEsp,
																			IdEng,
																			IdIt});
			// IdEsp, etc.
			//
			IdEsp.Index= 0;
			IdEsp.Text= "Espaol";
			IdEsp.Click+=new EventHandler(IdEsp_Click);
			//
			IdEng.Index= 1;
			IdEng.Text= "English";
			IdEng.Click+=new EventHandler(IdEng_Click);
			//
			IdIt.Index= 2;
			IdIt.Text= "Italiano";
			IdIt.Click+=new EventHandler(IdIt_Click);
			//
			// MenuAyuda
			//
			MenuAyuda.MenuItems.AddRange(new MenuItem[] {	AAcercade,
																				AManual});
			// AAcercade, Manual
			AAcercade.Index= 0;
			AAcercade.Click+= new EventHandler(AAcercade_Click);
			//
			AManual.Index= 1;
			AManual.Click+= new EventHandler(AManual_Click);
			//
			// PanelMenu1
			//
			PanelMenu1.TabIndex= 0;
			PanelMenu1.AddLabel("Ayuda",MenuAyuda);
			PanelMenu1.AddLabel("Configuracion",MenuConfiguracion);
			PanelMenu1.AddLabel("Archivo",MenuArchivo);
			//
			// PanelSubordinado
			//
			this.Controls.Add(this.PanelMenu1);
		}


		//Tiene que devolver: 0: se cierra; 1: se cancela;
		//Si ahora_no_se_puede_cerrar tiene que decidir entre cerrar y cancelar
		protected abstract int cierra_todo();

		//devuelve, adems de lo anterior, 2: ahora mismo no se puede (pero en cuanto
		//											se pueda se cerrar, ya que lo contrario significa cancelar)
		public int cierra_panel(){
			if(ahora_no_se_puede_cerrar!=0){
				cuando_puedas_cierrate=true;
				if(P_mensaje_estado!=IntPtr.Zero)
					Marshal.FreeHGlobal(P_mensaje_estado);
				P_mensaje_estado=Marshal.StringToHGlobalUni(mensaje_estado);
				return 2;
			}
			return cierra_todo();
		}

		unsafe private void GranParent_Closing(Object sender,System.ComponentModel.CancelEventArgs e){
			if(Myowner.parent==(void*)0){
				if(cierra_todo()!=0) e.Cancel=true;
			}
		}

		protected void NotificaTitulo(string titulo){
			IntPtr P_titulo=Marshal.StringToHGlobalUni(titulo);
			SendMessage(varias.MASTERM_TITULO,P_titulo);
			Marshal.FreeHGlobal(P_titulo);
		}
	#region Archivo
		unsafe private void ASalir_Click(object sender,System.EventArgs e){
			if(Myowner.parent!=(void*)0){
				PostMessage(varias.MASTERM_CIERRA,IntPtr.Zero);
			}else{
				if(cierra_todo()!=1) Application.Exit();
			}
		}
	#endregion

	#region Configuracion
	#region Idiomas
		unsafe protected void idioma_clicked(Idioma _idioma){
			if(Myowner.parent!=(void*)0){
				PostMessage(varias.MASTERM_IDIOMA,new System.IntPtr((int)_idioma));
			}
			else set_idioma(_idioma);
		}
		private void IdEsp_Click(object sender,System.EventArgs e){	idioma_clicked(Idioma.Esp);}
		private void IdEng_Click(object sender,System.EventArgs e){	idioma_clicked(Idioma.Eng);}
		private void IdIt_Click(object sender,System.EventArgs e){		idioma_clicked(Idioma.It);}
	#endregion
	#endregion

	#region Ayuda
		private void AAcercade_Click(object sender,System.EventArgs e){
			FormAcercade1.ShowDialog();
		}
		private void AManual_Click(object sender,System.EventArgs e){
			try{
				System.Diagnostics.Process.Start(AppPath + ManualPath);
			}catch(System.ComponentModel.Win32Exception){
				ahora_no_se_puede_cerrar++;
				MessageBoxAT.Show(get_texto(No_se_encuentra_el_manual) + System.IO.Path.GetFileName(ManualPath) + "," + "\n\n" + get_texto(que_debe_estar_en_el_directorio) + AppPath + System.IO.Path.GetDirectoryName(ManualPath)+"\\");
				ahora_no_se_puede_cerrar--;
			}
		}
	#endregion

		public int ShowMessageWait(string txt, string[] botones, int Default){
			return subMessageBox.Show(this,MessageBoxAT,txt,botones,Default);
		}

		protected virtual void colores(){
			this.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
			this.PanelMenu1.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
		}

	#region etiquetas_idiomas
		protected override void update_idioma(){
			PanelMenu1.gLabels("Archivo").Text=get_texto(Globales.Textos.Cods.Archivo);
			ASalir.Text=get_texto(Salir);
			PanelMenu1.gLabels("Configuracion").Text=get_texto(Configuracin);
			CIdioma.Text=get_texto(Globales.Textos.Cods.Idioma);
			PanelMenu1.gLabels("Ayuda").Text=get_texto(Globales.Textos.Cods.Ayuda);
			AManual.Text=get_texto(Manual);
			mensaje_pordefecto=get_texto(Esperando_respuesta_usuario);
		}
		private string get_texto(Globales.Textos.Cods cod){return Globales.Textos.get_texto(cod,idioma);}
	#endregion

		public string GetUserOrDefault_File(string path){
			string str=AppData+path;
			if(!System.IO.File.Exists(str)) str=AppPath+path;
			return str;
		}
	}
	public class varias{
		public static readonly uint MASTERM_BASE=0x550,		//v. fichero codigosmensajesMaster.h
			MASTERM_ESTADO=MASTERM_BASE+5,
			MASTERM_IDIOMA=MASTERM_BASE+6,
			MASTERM_CIERRA=MASTERM_BASE+7,
			MASTERM_TITULO=MASTERM_BASE+8;
		[System.Runtime.InteropServices.DllImport("User32.dll")] unsafe internal static extern int PostMessageW(void* hwnd, uint msg, System.UIntPtr wparam, System.IntPtr lparam);
		[System.Runtime.InteropServices.DllImport("User32.dll")] unsafe internal static extern System.IntPtr SendMessageW(void* hwnd, uint msg, System.UIntPtr wparam, System.IntPtr lparam);
		public static bool read_reg_language(string key, string field, ref Idioma idioma){
			bool idioma_read=false;
			try{
				Microsoft.Win32.RegistryKey KeyAerotri;
				object obj;
				KeyAerotri=Microsoft.Win32.Registry.LocalMachine.OpenSubKey("SOFTWARE\\"+key);
				if(KeyAerotri!=null){
					if((obj=KeyAerotri.GetValue(field))!=null){
						byte _id=Convert.ToByte(obj.ToString());
						if(_id<(byte)Globales.Idioma.NIDIOMAS) idioma=(Idioma)_id;
						else idioma=Globales.Idioma.Esp;
						idioma_read=true;
					}
				}
			}catch(Exception){}
			return idioma_read;
		}
		[System.Runtime.InteropServices.DllImport("SubordinadaForms.dll")] unsafe public static extern char* get_enlace_nombre(void* enlace);
		[System.Runtime.InteropServices.DllImport("SubordinadaForms.dll")] unsafe public static extern void* get_enlace_hwnd(void* enlace);
		[System.Runtime.InteropServices.DllImport("SubordinadaForms.dll")] unsafe public static extern UInt64 get_enlace_Panel(void* enlace);
		unsafe public static PanelSubordinado get_Panel(void* enlace){
			IntPtr uptr=(IntPtr)(Int64)PanelesSub.varias.get_enlace_Panel(enlace);
			if(uptr==IntPtr.Zero) return null;
			GCHandle gch= GCHandle.FromIntPtr(uptr);
			return (PanelSubordinado)gch.Target;
		}
	}
}
