using System;
using System.Drawing;
using System.Windows.Forms;

namespace ControlesAt{
	public class PanelMoving : System.Windows.Forms.Panel
	{
		int X0, Y0;
		bool ss;
		int DX, DY;

		public PanelMoving(){
			ss=false;
		}
		protected override void OnMouseDown(MouseEventArgs e){
			if(e.Button==MouseButtons.Left){
				X0= e.X;
				Y0= e.Y;
				ss= true;
			}
			base.OnMouseDown(e);
		}
		protected override void OnMouseMove(MouseEventArgs e){
			if(ss==true){
				DX= e.X - X0;
				DY= e.Y - Y0;
				Form F=this.FindForm();
				F.Location= new Point(F.Left + (int)DX, F.Top + (int)DY);
			}
			base.OnMouseMove(e);
		}
		protected override void OnMouseUp(MouseEventArgs e){
			ss= false;
			base.OnMouseUp(e);
		}
		protected override void OnMouseLeave(EventArgs e){
			ss=false;
			base.OnMouseLeave(e);
		}
		protected override void OnLostFocus(EventArgs e){
			ss=false;
			base.OnLostFocus(e);
		}
		protected override void OnSizeChanged(EventArgs e){
			base.OnSizeChanged(e);
			if(this.Text!="") this.Invalidate();
		}

		protected override void OnPaint(PaintEventArgs e){
			base.OnPaint(e);
			if(this.Text=="") return;
			System.Drawing.SolidBrush b;
			System.Drawing.SizeF sF;
			b= new SolidBrush(this.ForeColor);
			sF=e.Graphics.MeasureString(this.Text,this.Font,this.Width);
			e.Graphics.DrawString(this.Text,this.Font,b,new Point((this.Width-(int)sF.Width)/2,0));
			b.Dispose();
		}
	}
}
