using System;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using ControlesAt;
using Globales;

namespace Modelos{
using static Textos.Cods;

	internal struct ConfiguracionPrograma{
		public string OpenPath;
	}
	/// <summary>
	/// Descripcin breve de PanelModelos.
	/// </summary>
	public class PanelModelos : PanelesSub.PanelSubordinado{
		private System.Windows.Forms.ContextMenu MenuOpciones;
		private System.Windows.Forms.MenuItem ConfigSalida;
		private System.Windows.Forms.MenuItem	OEscala,		OGrandes_rotaciones,
															OForce_apriori;
		private System.Windows.Forms.GroupBox GroupBox1;
		private ControlesAt.LabelTxtBotAbrir TxtBotapr1,	TxtBotapr2;
		private ControlesAt.Labeltf  Tfapr1, Tfapr2;
		private System.Windows.Forms.OpenFileDialog Open1;
		private ControlesAt.MasMenos mmPrecisiones;
		private System.Windows.Forms.GroupBox GBoxPrecisiones;
		private System.Windows.Forms.GroupBox GroupBox3;
		private System.Windows.Forms.GroupBox GroupBox4;
		private System.Windows.Forms.GroupBox GroupBox5;
		private System.Windows.Forms.CheckBox Optfijas1;
		private System.Windows.Forms.GroupBox GroupBox6;
		private ControlesAt.FloatTextBox	Txtsigma1fXY,		Txtsigma1fZ,
													Txtsigma1pXY,		Txtsigma1pZ;
		private System.Windows.Forms.Label Label3;
		private System.Windows.Forms.Label Label4;
		private System.Windows.Forms.GroupBox GroupBox7;
		private System.Windows.Forms.Label Label5;
		private System.Windows.Forms.Label Label6;
		private System.Windows.Forms.CheckBox Optfijas2;
		private System.Windows.Forms.GroupBox GroupBox8;
		private System.Windows.Forms.Label Label7;
		private System.Windows.Forms.Label Label8;
		private ControlesAt.FloatTextBox	Txtsigma2pXY,		Txtsigma2pZ,
													Txtsigma2fXY,		Txtsigma2fZ;
		private System.Windows.Forms.Label Label9;
		private System.Windows.Forms.Label Label10;
		internal System.Windows.Forms.Button Transformar;


	#region Variables
		private bool idioma_read;
		internal ConfiguracionPrograma ConfigPrograma;
		private FormSalida_Mod FormSalida1;
		internal InterComModelos.CConfigSalida CSalida;
	#endregion

	#region Inicializacin
		public PanelModelos(PanelesSub.Duenno _owner, Idioma idioma_inicial, IntPtr _enlaces) : base(_owner,idioma_inicial){
			InitializeComponent();
		}
		unsafe public PanelModelos() : base(){
			InitializeComponent();
		}
		protected override void inizializeb(string[] argv){
			AppData=Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData)+"\\Aerotri\\";
			if(!System.IO.Directory.Exists(AppData)) System.IO.Directory.CreateDirectory(AppData);
			icono= new System.Drawing.Icon(System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("Modelos.IconModelos.ico"));
			ParentForm.AcceptButton=this.Transformar;

			//Los encapsulados
			CSalida=new InterComModelos.CConfigSalida();

			FormAcercade1=new FormAcercade(typeof(PanelModelos),idioma);
			FormAcercade1.Icon= icono;
			FormAcercade1.LabelIcono.Image= icono.ToBitmap();
			FormAcercade1.Width+=48;
			FormSalida1=new FormSalida_Mod(this);

			FormAcercade1.Owner=ParentForm;
			FormSalida1.Owner=ParentForm;

			idioma_read=false;
			Tfapr1.Indice=FileTypes.TipoFichero.Aerotriccpp;
			Tfapr2.Indice=FileTypes.TipoFichero.Aerotriccpp;
			lee_ficheroConfiguracion("Modelos.config");
			if(!idioma_read && Myowner.modo==0){
				idioma_read=PanelesSub.varias.read_reg_language("Aerotri","InstallLanguage",ref base.idioma);
			}

			CSalida.S.SalidaF=3;
			CSalida.S.SalidaAjs.Param=3;
			CSalida.S.SalidaInf.Residuos=0xC;
			CSalida.S.SalidaInf.ParamPrec=0xC;
			CSalida.S.SalidaInf.percent=2.0F;

			mmPrecisiones_Click(this,EventArgs.Empty);

			update_idioma();
			colores();
		}
		protected override void lee_ficheroConfiguracion(string nombre){
			base.lee_ficheroConfiguracion(nombre);
			ConfigPrograma.OpenPath=__OpenPath;
		}
		protected override void procesa_linea_config(string tipo, string[] palabras){
			if(!idioma_read) if(tipo=="Idioma") idioma_read=true;
			base.procesa_linea_config(tipo, palabras);
		}
	#endregion

	#region InitializeComponent
		private void InitializeComponent()	{
			GroupBox1= new GroupBox();
			TxtBotapr1= new ControlesAt.LabelTxtBotAbrir();
			TxtBotapr2= new ControlesAt.LabelTxtBotAbrir();
			mmPrecisiones= new MasMenos();
			GBoxPrecisiones= new GroupBox();
			GroupBox4= new GroupBox();
			GroupBox7= new GroupBox();
			Label5= new Label();
			Label6= new Label();
			Txtsigma2pXY= new FloatTextBox();
			Txtsigma2pZ= new FloatTextBox();
			Optfijas2= new CheckBox();
			GroupBox8= new GroupBox();
			Label7= new Label();
			Label8= new Label();
			Txtsigma2fXY= new FloatTextBox();
			Txtsigma2fZ= new FloatTextBox();
			GroupBox3= new GroupBox();
			GroupBox6= new GroupBox();
			Label4= new Label();
			Label3= new Label();
			Txtsigma1pXY= new FloatTextBox();
			Txtsigma1pZ= new FloatTextBox();
			Optfijas1= new CheckBox();
			GroupBox5= new GroupBox();
			Txtsigma1fXY= new FloatTextBox();
			Txtsigma1fZ= new FloatTextBox();
			Label9= new Label();
			Label10= new Label();
			Tfapr1= new Labeltf(Globales.FileTypes.Filtros[FileTypes.TipoFiltro.PuntosTodos]);
			Tfapr2= new Labeltf(Globales.FileTypes.Filtros[FileTypes.TipoFiltro.PuntosTodos]);
			Transformar= new Button();
			ConfigSalida= new MenuItem();
			MenuOpciones=new ContextMenu();
			OEscala= new MenuItem();
			OGrandes_rotaciones= new MenuItem();
			OForce_apriori= new MenuItem();
			Open1= new OpenFileDialog();

			PanelMenu1.Controls.Remove(PanelMenu1.gLabels("Archivo"));
			PanelMenu1.AddLabel("Opciones",MenuOpciones);
			PanelMenu1.Controls.Add(PanelMenu1.gLabels("Archivo"));
			// MenuOpciones
			//
			MenuOpciones.MenuItems.AddRange(new MenuItem[] {OEscala,
																				  OGrandes_rotaciones,
																				  OForce_apriori});
			//
			// OEscala
			OEscala.Index= 0;
			OEscala.Click+= new EventHandler(OEscala_Click);
			//
			// OGrandes_rotaciones
			OGrandes_rotaciones.Index= 1;
			OGrandes_rotaciones.Click+= new EventHandler(OGrandes_rotaciones_Click);
			//
			// OForce_apriori
			OForce_apriori.Index= 2;
			OForce_apriori.Click+= new EventHandler(OForce_apriori_Click);
			//
			// MenuConfiguracion
			//
			MenuConfiguracion.MenuItems.AddRange(new MenuItem[]{ConfigSalida});
			//
			// ConfigSalida
			ConfigSalida.Index= 1;
			ConfigSalida.Click+= new EventHandler(CSalida_Click);
			//
			// TxtBotapr1, 2
			//
			TxtBotapr1.TextLocation= new Point(116, 16);	TxtBotapr1.TabIndex= 0;		TxtBotapr1.Click+=new EventHandler(Botabrirapr1_Click);
			TxtBotapr2.TextLocation= new Point(424, 16);	TxtBotapr2.TabIndex= 1;		TxtBotapr2.Click+=new EventHandler(Botabrirapr2_Click);
			//
			// Tfapr1, 2
			//
			Tfapr1.Location= new Point(16, 48);		Tfapr1.Width=100;	Tfapr1.TabIndex= 2;
			Tfapr2.Location= new Point(328, 48);	Tfapr2.Width=100;	Tfapr2.TabIndex= 3;
			//
			// GroupBox1
			//
			GroupBox1.Controls.Add(TxtBotapr1);
			GroupBox1.Controls.Add(TxtBotapr2);
			GroupBox1.Controls.Add(Tfapr1);
			GroupBox1.Controls.Add(Tfapr2);
			GroupBox1.Location= new Point(4, 20);
			GroupBox1.Size= new Size(620, 72);
			GroupBox1.TabIndex= 0;
			GroupBox1.TabStop=false;
			//
			// GBoxPrecisiones
			//
			GBoxPrecisiones.Controls.Add(this.GroupBox4);
			GBoxPrecisiones.Controls.Add(this.GroupBox3);
			GBoxPrecisiones.Location= new Point(4, 100);
			GBoxPrecisiones.Size= new Size(620, 180);
			GBoxPrecisiones.TabIndex= 1;
			GBoxPrecisiones.TabStop=false;
			//
			// mmPrecisiones
			mmPrecisiones.Location= GBoxPrecisiones.Location + new Size(2,0);
			mmPrecisiones.State=false;
			mmPrecisiones.Click+=new EventHandler(mmPrecisiones_Click);
			//
			// GroupBox4
			//
			GroupBox4.Controls.Add(this.GroupBox7);
			GroupBox4.Controls.Add(this.Optfijas2);
			GroupBox4.Controls.Add(this.GroupBox8);
			GroupBox4.Location= new Point(312, 16);
			GroupBox4.Size= new Size(300, 156);
			GroupBox4.TabIndex= 1;
			GroupBox4.TabStop=false;
			//
			// GroupBox7
			//
			GroupBox7.Controls.Add(this.Label8);
			GroupBox7.Controls.Add(this.Label7);
			GroupBox7.Controls.Add(this.Txtsigma2pZ);
			GroupBox7.Controls.Add(this.Txtsigma2pXY);
			GroupBox7.Location= new Point(4, 96);
			GroupBox7.Size= new Size(292, 56);
			GroupBox7.TabIndex= 2;
			GroupBox7.TabStop=false;
			//
			// Label7
			//
			Label7.Location= new Point(80, 12);
			Label7.Size= new Size(64, 12);
			Label7.TabIndex= 3;
			Label7.TextAlign= ContentAlignment.TopRight;
			//
			// Label8
			//
			Label8.Location= new Point(216, 12);
			Label8.Size= new Size(64, 12);
			Label8.TabIndex= 4;
			Label8.TextAlign= ContentAlignment.TopRight;
			//
			// Txtsigma2pXY
			//
			Txtsigma2pXY.Location= new Point(68, 28);
			Txtsigma2pXY.TabIndex= 0;
			Txtsigma2pXY.TextChanged+=new EventHandler(Txtsigma2_TextChanged);
			//
			// Txtsigma2pZ
			//
			Txtsigma2pZ.Location= new Point(204, 28);
			Txtsigma2pZ.TabIndex= 1;
			Txtsigma2pZ.TextChanged+=new EventHandler(Txtsigma2_TextChanged);
			//
			// Optfijas2
			//
			Optfijas2.FlatStyle= FlatStyle.System;
			Optfijas2.Location= new Point(116, 16);
			Optfijas2.Size= new Size(176, 16);
			Optfijas2.TabIndex= 0;
			Optfijas2.CheckedChanged+=new EventHandler(Optfijas2_CheckedChanged);
			//
			// GroupBox8
			//
			GroupBox8.Controls.Add(this.Label10);
			GroupBox8.Controls.Add(this.Label9);
			GroupBox8.Controls.Add(this.Txtsigma2fZ);
			GroupBox8.Controls.Add(this.Txtsigma2fXY);
			GroupBox8.Location= new Point(4, 36);
			GroupBox8.Size= new Size(292, 56);
			GroupBox8.TabIndex= 1;
			GroupBox8.TabStop=false;
			//
			// Label10
			//
			Label10.Location= new Point(216, 12);
			Label10.Size= new Size(64, 12);
			Label10.TabIndex= 3;
			Label10.TextAlign= ContentAlignment.TopRight;
			//
			// Label9
			//
			Label9.Location= new Point(80, 12);
			Label9.Size= new Size(64, 12);
			Label9.TabIndex= 2;
			Label9.TextAlign= ContentAlignment.TopRight;
			//
			// Txtsigma2fXY
			//
			Txtsigma2fXY.Location= new Point(68, 28);
			Txtsigma2fXY.TabIndex= 0;
			Txtsigma2fXY.TextChanged+=new EventHandler(Txtsigma2_TextChanged);
			//
			// Txtsigma2fZ
			//
			Txtsigma2fZ.Location= new Point(204, 28);
			Txtsigma2fZ.TabIndex= 1;
			Txtsigma2fZ.TextChanged+=new EventHandler(Txtsigma2_TextChanged);
			//
			// GroupBox3
			//
			GroupBox3.Controls.Add(this.GroupBox6);
			GroupBox3.Controls.Add(this.Optfijas1);
			GroupBox3.Controls.Add(this.GroupBox5);
			GroupBox3.Location= new Point(8, 16);
			GroupBox3.Size= new Size(300, 156);
			GroupBox3.TabIndex= 0;
			GroupBox3.TabStop=false;
			//
			// GroupBox6
			//
			GroupBox6.Controls.Add(this.Label6);
			GroupBox6.Controls.Add(this.Label5);
			GroupBox6.Controls.Add(this.Txtsigma1pZ);
			GroupBox6.Controls.Add(this.Txtsigma1pXY);
			GroupBox6.Location= new Point(4, 96);
			GroupBox6.Size= new Size(292, 56);
			GroupBox6.TabIndex= 2;
			GroupBox6.TabStop=false;
			//
			// Label5
			//
			Label5.Location= new Point(80, 12);
			Label5.Size= new Size(64, 12);
			Label5.TabIndex= 3;
			Label5.TextAlign= ContentAlignment.TopRight;
			//
			// Label6
			//
			Label6.Location= new Point(216, 12);
			Label6.Size= new Size(64, 12);
			Label6.TabIndex= 4;
			Label6.TextAlign= ContentAlignment.TopRight;
			//
			// Txtsigma1pXY
			//
			Txtsigma1pXY.Location= new Point(68, 28);
			Txtsigma1pXY.TabIndex= 0;
			Txtsigma1pXY.TextChanged+=new EventHandler(Txtsigma1pXY_TextChanged);
			//
			// Txtsigma1pZ
			//
			Txtsigma1pZ.Location= new Point(204, 28);
			Txtsigma1pZ.TabIndex= 1;
			Txtsigma1pZ.TextChanged+=new EventHandler(Txtsigma1pZ_TextChanged);
			//
			// Optfijas1
			//
			Optfijas1.Checked= true;
			Optfijas1.CheckState= CheckState.Checked;
			Optfijas1.FlatStyle= FlatStyle.System;
			Optfijas1.Location= new Point(184, 16);
			Optfijas1.Size= new Size(112, 16);
			Optfijas1.TabIndex= 0;
			Optfijas1.CheckedChanged+=new EventHandler(Optfijas1_CheckedChanged);
			//
			// GroupBox5
			//
			GroupBox5.Controls.Add(this.Label4);
			GroupBox5.Controls.Add(this.Label3);
			GroupBox5.Controls.Add(this.Txtsigma1fZ);
			GroupBox5.Controls.Add(this.Txtsigma1fXY);
			GroupBox5.Location= new Point(4, 36);
			GroupBox5.Size= new Size(292, 56);
			GroupBox5.TabIndex= 1;
			GroupBox5.TabStop=false;
			//
			// Label4
			//
			Label4.Location= new Point(216, 12);
			Label4.Size= new Size(64, 12);
			Label4.TabIndex= 3;
			Label4.TextAlign= ContentAlignment.TopRight;
			//
			// Label3
			//
			Label3.Location= new Point(80, 12);
			Label3.Size= new Size(64, 12);
			Label3.TabIndex= 2;
			Label3.TextAlign= ContentAlignment.TopRight;
			//
			// Txtsigma1fXY
			//
			Txtsigma1fXY.Location= new Point(68, 28);
			Txtsigma1fXY.TabIndex= 0;
			Txtsigma1fXY.TextChanged+=new EventHandler(Txtsigma1fXY_TextChanged);
			//
			// Txtsigma1fZ
			//
			Txtsigma1fZ.Location= new Point(204, 28);
			Txtsigma1fZ.TabIndex= 1;
			Txtsigma1fZ.TextChanged+=new EventHandler(Txtsigma1fZ_TextChanged);
			//
			// Transformar
			//
			Transformar.Font= new System.Drawing.Font("Microsoft Sans Serif", 8F);
			Transformar.Location= new Point(274, 296);
			Transformar.Size= new Size(72, 24);
			Transformar.TabIndex= 2;
			Transformar.Click+=new EventHandler(Transformar_Click);
			//
			// PanelModelos
			//
			this.Controls.Add(this.Transformar);
			this.Controls.Add(mmPrecisiones);
			this.Controls.Add(this.GBoxPrecisiones);
			this.Controls.Add(this.GroupBox1);
			this.Size= new Size(628, Transformar.Top+40);
		}
	#endregion

		protected override int cierra_todo(){
			guarda_ficheroConfiguracion("Modelos.config");
			return 0;
		}
		protected override void escribe_fConfiguracion(System.IO.StreamWriter fconfig){
			base.escribe_fConfiguracion_comienzo(fconfig);
			fconfig.WriteLine("OpenPath \"" + ConfigPrograma.OpenPath +"\"");
		}

	#region Abrir
		private void Botabrirapr1_Click(object sender,EventArgs e){
			ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotapr1.T,Tfapr1,Open1,ref ConfigPrograma.OpenPath,FileTypes.buildfiltro(FileTypes.TipoFiltro.PuntosTodos,idioma));
			ahora_no_se_puede_cerrar=0;
		}
		private void Botabrirapr2_Click(object sender,EventArgs e){
			ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotapr2.T,Tfapr2,Open1,ref ConfigPrograma.OpenPath,FileTypes.buildfiltro(FileTypes.TipoFiltro.PuntosTodos,idioma));
			ahora_no_se_puede_cerrar=0;
		}
	#endregion

	#region Configuracion
	#region Unidades de los giros
		void CUnidades_sClick(object sender,System.EventArgs e){
			((MenuItem)sender).Checked=true;
			foreach(MenuItem C in ((MenuItem)sender).Parent.MenuItems){
				C.Checked=false;
			}
			((MenuItem)sender).Checked=true;
		}
	#endregion
		void CSalida_Click(Object sender,System.EventArgs e){
			FormSalida1.ShowDialog();
		}
	#endregion

	#region Opciones
		void OEscala_Click(Object sender,System.EventArgs e)
		{
			OEscala.Checked=!OEscala.Checked;
		}
		void OGrandes_rotaciones_Click(Object sender,System.EventArgs e){
			OGrandes_rotaciones.Checked=!OGrandes_rotaciones.Checked;
		}
		void OForce_apriori_Click(Object sender,System.EventArgs e){
			OForce_apriori.Checked=!OForce_apriori.Checked;
			if(OForce_apriori.Checked){
				Colores_Facil();
				if(!mmPrecisiones.State){
					mmPrecisiones.State=true;
					mmPrecisiones_Click(this,EventArgs.Empty);
				}
			}
			else Optfijas2_CheckedChanged(sender,e);
		}
	#endregion

	#region GotFocus y Precisiones --color de las cajas de texto--
		private void mmPrecisiones_Click(object sender,EventArgs e){
			if(mmPrecisiones.State) GBoxPrecisiones.Height=180;
			else GBoxPrecisiones.Height=16;
		}
	#region Optfijas
		void Optfijas1_CheckedChanged(System.Object sender,System.EventArgs e){
			if(Optfijas1.Checked){
				if(Optfijas2.Checked==false)
					Optfijas2_CheckedChanged(sender,e);
				else Optfijas2.Checked=false;

				Txtsigma1fXY.Enabled=false;
				Txtsigma1fZ.Enabled=false;
				Txtsigma1pXY.Enabled=false;
				Txtsigma1pZ.Enabled=false;

				Txtsigma1fXY.BackColor= Globales.Colores.NETColor(Colores.cOpcional);
				Txtsigma1fZ.BackColor= Txtsigma1fXY.BackColor;
				Txtsigma1pXY.BackColor= Txtsigma1fXY.BackColor;
				Txtsigma1pZ.BackColor= Txtsigma1fXY.BackColor;
			}else{
				Txtsigma1fXY.Enabled=true;
				Txtsigma1fZ.Enabled=true;
				Txtsigma1pXY.Enabled=true;
				Txtsigma1pZ.Enabled=true;

				if(OForce_apriori.Checked)
					Colores_Facil();
				else if(Optfijas2.Checked==false){
					Txtsigma2fXY.Enabled=true;
					Txtsigma2fZ.Enabled=true;
					Txtsigma2pXY.Enabled=true;
					Txtsigma2pZ.Enabled=true;

					Txtsigma1fXY.BackColor= System.Drawing.SystemColors.Window;
					Txtsigma1fZ.BackColor= Txtsigma1fXY.BackColor;
					Txtsigma1pXY.BackColor= Txtsigma1fXY.BackColor;
					Txtsigma1pZ.BackColor= Txtsigma1fXY.BackColor;
					Txtsigma2fXY.BackColor= System.Drawing.SystemColors.Window;
					Txtsigma2fZ.BackColor= Txtsigma2fXY.BackColor;
					Txtsigma2pXY.BackColor= Txtsigma2fXY.BackColor;
					Txtsigma2pZ.BackColor= Txtsigma2fXY.BackColor;
				}else Color_fijas1_0_fijas2_1();
			}
		}

		void Optfijas2_CheckedChanged(System.Object sender,System.EventArgs e){
			if(Optfijas2.Checked){
				if(Optfijas1.Checked==false)
					Optfijas1_CheckedChanged(sender,e);
				else Optfijas1.Checked=false;

				Txtsigma2fXY.Enabled=false;
				Txtsigma2fZ.Enabled=false;
				Txtsigma2pXY.Enabled=false;
				Txtsigma2pZ.Enabled=false;

				Txtsigma2fXY.Text= Txtsigma1fXY.Text;
				Txtsigma2fZ.Text= Txtsigma1fZ.Text;
				Txtsigma2pXY.Text= Txtsigma1pXY.Text;
				Txtsigma2pZ.Text= Txtsigma1pZ.Text;

				Txtsigma2fXY.BackColor= Globales.Colores.NETColor(Colores.cOpcional);
				Txtsigma2fZ.BackColor= Txtsigma2fXY.BackColor;
				Txtsigma2pXY.BackColor= Txtsigma2fXY.BackColor;
				Txtsigma2pZ.BackColor= Txtsigma2fXY.BackColor;
			}else{
				Txtsigma2fXY.Enabled=true;
				Txtsigma2fZ.Enabled=true;
				Txtsigma2pXY.Enabled=true;
				Txtsigma2pZ.Enabled=true;

				if(OForce_apriori.Checked)
					Colores_Facil();
				else if(Optfijas1.Checked==false){
						Txtsigma1fXY.BackColor= System.Drawing.SystemColors.Window;
						Txtsigma1fZ.BackColor= Txtsigma1fXY.BackColor;
						Txtsigma1pXY.BackColor= Txtsigma1fXY.BackColor;
						Txtsigma1pZ.BackColor= Txtsigma1fXY.BackColor;
						Txtsigma2fXY.BackColor= System.Drawing.SystemColors.Window;
						Txtsigma2fZ.BackColor= Txtsigma2fXY.BackColor;
						Txtsigma2pXY.BackColor= Txtsigma2fXY.BackColor;
						Txtsigma2pZ.BackColor= Txtsigma2fXY.BackColor;
				}else Color_fijas1_1_fijas2_0();
			}
		}
	#endregion
	#region Color_...()
		internal void Color_fijas1_0_fijas2_1(){
			if(Txtsigma1fXY.Text=="" && Txtsigma1fZ.Text=="" && Txtsigma1pXY.Text=="" && Txtsigma1pZ.Text==""){
				Txtsigma1fXY.BackColor= Globales.Colores.NETColor(Colores.cOpcional);
				Txtsigma1fZ.BackColor= Txtsigma1fXY.BackColor;
				Txtsigma1pXY.BackColor= Txtsigma1fXY.BackColor;
				Txtsigma1pZ.BackColor= Txtsigma1fXY.BackColor;
			}else{
				Txtsigma1fXY.BackColor= System.Drawing.SystemColors.Window;
				Txtsigma1fZ.BackColor= Txtsigma1fXY.BackColor;
				Txtsigma1pXY.BackColor= Txtsigma1fXY.BackColor;
				Txtsigma1pZ.BackColor= Txtsigma1fXY.BackColor;
			}
		}

		internal void Color_fijas1_1_fijas2_0(){
			if(Txtsigma2fXY.Text=="" && Txtsigma2fZ.Text=="" && Txtsigma2pXY.Text=="" && Txtsigma2pZ.Text==""){
				Txtsigma2fXY.BackColor= Globales.Colores.NETColor(Colores.cOpcional);
				Txtsigma2fZ.BackColor= Txtsigma2fXY.BackColor;
				Txtsigma2pXY.BackColor= Txtsigma2fXY.BackColor;
				Txtsigma2pZ.BackColor= Txtsigma2fXY.BackColor;
			}else{
				Txtsigma2fXY.BackColor= System.Drawing.SystemColors.Window;
				Txtsigma2fZ.BackColor= Txtsigma2fXY.BackColor;
				Txtsigma2pXY.BackColor= Txtsigma2fXY.BackColor;
				Txtsigma2pZ.BackColor= Txtsigma2fXY.BackColor;
			}
		}

		void Colores_Facil(){
			if(Optfijas1.Checked)
				Txtsigma1fXY.BackColor= Globales.Colores.NETColor(Colores.cOpcional);
			else
				Txtsigma1fXY.BackColor= System.Drawing.SystemColors.Window;

			Txtsigma1fZ.BackColor= Txtsigma1fXY.BackColor;
			Txtsigma1pXY.BackColor= Txtsigma1fXY.BackColor;
			Txtsigma1pZ.BackColor= Txtsigma1fXY.BackColor;

			if(Optfijas2.Checked==true)
				Txtsigma2fXY.BackColor= Globales.Colores.NETColor(Colores.cOpcional);
			else
				Txtsigma2fXY.BackColor= System.Drawing.SystemColors.Window;

			Txtsigma2fZ.BackColor= Txtsigma2fXY.BackColor;
			Txtsigma2pXY.BackColor= Txtsigma2fXY.BackColor;
			Txtsigma2pZ.BackColor= Txtsigma2fXY.BackColor;
		}
	#endregion
	#region txt_Change
		void Cambia_txts1(){
			if(Optfijas2.Checked){
				if(OForce_apriori.Checked==false)
					this.Color_fijas1_0_fijas2_1();
				else
					Colores_Facil();
			}
		}
		void Txtsigma1fXY_TextChanged(System.Object sender,System.EventArgs e){
			if(Optfijas2.Checked) Txtsigma2fXY.Text= Txtsigma1fXY.Text;
			Cambia_txts1();
		}
		void Txtsigma1fZ_TextChanged(System.Object sender,System.EventArgs e){
			if(Optfijas2.Checked) Txtsigma2fZ.Text= Txtsigma1fZ.Text;
			Cambia_txts1();
		}
		void Txtsigma1pXY_TextChanged(System.Object sender,System.EventArgs e){
			if(Optfijas2.Checked) Txtsigma2pXY.Text= Txtsigma1pXY.Text;
			Cambia_txts1();
		}
		void Txtsigma1pZ_TextChanged(System.Object sender,System.EventArgs e){
			if(Optfijas2.Checked) Txtsigma2pZ.Text= Txtsigma1pZ.Text;
			Cambia_txts1();
		}

		void Txtsigma2_TextChanged(System.Object sender,System.EventArgs e){
			if(Optfijas1.Checked){
				if(OForce_apriori.Checked==false)
					this.Color_fijas1_1_fijas2_0();
				else
					Colores_Facil();
			}
		}
	#endregion
	#endregion

	#region Transformar
		unsafe private void Transformar_Click(object sender,EventArgs e){
			short nret;
			FileTypes.TipoFichero apr1, apr2;
			InterComModelos.PrecFichero precf1, precf2;
			bool desconocidas;
			string txt;
			string mensaje;
			System.IntPtr P_mensaje= IntPtr.Zero;
			System.IntPtr P_nombrebaseCEx= IntPtr.Zero;
			ushort* extpos;
			System.IntPtr P_aproximadas1= IntPtr.Zero;
			System.IntPtr P_aproximadas2=IntPtr.Zero;

			if(TxtBotapr1.Text==""){
				MessageBoxAT.Show(get_texto(Debe_indicar_referencia)); return;
			}
			if(TxtBotapr2.Text==""){
				MessageBoxAT.Show(get_texto(Debe_indicar_atransformar)); goto @return;
			}

			apr1=Tfapr1.Indice;
			apr2=Tfapr2.Indice;
			if(!Methods.CheckExtension(MessageBoxAT,TxtBotapr1.Text,apr1,FileTypes.TipoFiltro.PuntosTodos,idioma)) return;
			if(!Methods.CheckExtension(MessageBoxAT,TxtBotapr2.Text,apr2,FileTypes.TipoFiltro.PuntosTodos,idioma)) return;

			P_aproximadas1=Marshal.StringToHGlobalUni(TxtBotapr1.Text + new string((char)0, 4));
			P_nombrebaseCEx=Marshal.StringToHGlobalUni(TxtBotapr1.Text+ new string((char)0, 4));
			extpos=pointat((ushort*)P_nombrebaseCEx.ToPointer());
			P_aproximadas2=Marshal.StringToHGlobalUni(TxtBotapr2.Text + new string((char)0, 4));

			txt=get_texto(Precisin_errnea);
			if((uint)Txtsigma1fXY.BackColor.ToArgb()==Colores.cOpcional){
				precf1.cpZ=precf1.cpXY=1;
				precf1.pZ=precf1.pXY=1;
			}else{
				try{precf1.cpXY=Basicas._gcVarios.atofl(Txtsigma1fXY.Text.ToCharArray());}
				catch(System.SystemException){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Fref_fotos_plani));	goto @return;
				}
				if(precf1.cpXY<=0){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Fref_fotos_plani));	goto @return;
				}

				try{precf1.cpZ=Basicas._gcVarios.atofl(Txtsigma1fZ.Text.ToCharArray());}
				catch(System.SystemException){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Fref_fotos_alti));	goto @return;
				}
				if(precf1.cpZ<=0){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Fref_fotos_alti));	goto @return;
				}

				try{precf1.pXY=Basicas._gcVarios.atofl(Txtsigma1pXY.Text.ToCharArray());}
				catch(System.SystemException){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Fref_puntos_plani));	goto @return;
				}
				if(precf1.pXY<=0){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Fref_puntos_plani));	goto @return;
				}

				try{precf1.pZ=Basicas._gcVarios.atofl(Txtsigma1pZ.Text.ToCharArray());}
				catch(System.SystemException){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Fref_puntos_alti));	goto @return;
				}
				if(precf1.pZ<=0){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Fref_puntos_alti));	goto @return;
				}
			}

			if((uint)Txtsigma2fXY.BackColor.ToArgb()==Colores.cOpcional){
				precf2=precf1;
			}else{
				try{precf2.cpXY=Basicas._gcVarios.atofl(Txtsigma2fXY.Text.ToCharArray());}
				catch(System.SystemException){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Ftrans_fotos_plani));	goto @return;
				}
				if(precf2.cpXY<=0){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Ftrans_fotos_plani));	goto @return;
				}

				try{precf2.cpZ=Basicas._gcVarios.atofl(Txtsigma2fZ.Text.ToCharArray());}
				catch(System.SystemException){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Ftrans_fotos_alti));	goto @return;
				}
				if(precf2.cpZ<=0){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Ftrans_fotos_alti));	goto @return;
				}

				try{precf2.pXY=Basicas._gcVarios.atofl(Txtsigma2pXY.Text.ToCharArray());}
				catch(System.SystemException){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Ftrans_puntos_plani));	goto @return;
				}
				if(precf2.pXY<=0){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Ftrans_puntos_plani));	goto @return;
				}

				try{precf2.pZ=Basicas._gcVarios.atofl(Txtsigma2pZ.Text.ToCharArray());}
				catch(System.SystemException){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Ftrans_puntos_alti));	goto @return;
				}
				if(precf2.pZ<=0){
					MessageBoxAT.Show(txt + "\n\n" + get_texto(Ftrans_puntos_alti));	goto @return;
				}
			}

			desconocidas=false;
			if((uint)Txtsigma1fXY.BackColor.ToArgb()==Colores.cOpcional && (uint)Txtsigma2fXY.BackColor.ToArgb()==Colores.cOpcional) desconocidas=true;

			ahora_no_se_puede_cerrar=1;
			set_message("Esperando a que termine el clculo");
			P_mensaje=Marshal.AllocHGlobal(512);
			if(desconocidas){
				nret= InterComModelos.transforma_facil(P_aproximadas1,FileTypes.FileTypeInfos[apr1].aerotri,IntPtr.Zero,P_aproximadas2,FileTypes.FileTypeInfos[apr2].aerotri,IntPtr.Zero,Convert.ToByte(Optfijas1.Checked),Convert.ToByte(!OEscala.Checked),Convert.ToByte(OGrandes_rotaciones.Checked),CSalida.S,P_mensaje,(byte)idioma);
			}else{
				nret= InterComModelos.transforma_completo(P_aproximadas1,FileTypes.FileTypeInfos[apr1].aerotri,IntPtr.Zero,P_aproximadas2,FileTypes.FileTypeInfos[apr2].aerotri,IntPtr.Zero,Convert.ToByte(Optfijas1.Checked),precf1, Convert.ToByte(Optfijas2.Checked), precf2, Convert.ToByte(!OEscala.Checked),Convert.ToByte(OForce_apriori.Checked), Convert.ToByte(OGrandes_rotaciones.Checked),CSalida.S,P_mensaje,(byte)idioma);
			}
			mensaje=Marshal.PtrToStringUni(P_mensaje);
			set_message(mensaje_pordefecto);
			MessageBoxAT.Show(mensaje);

		@return:
			if(P_mensaje!=IntPtr.Zero) Marshal.FreeHGlobal(P_mensaje);
			if(P_nombrebaseCEx!=IntPtr.Zero) Marshal.FreeHGlobal(P_nombrebaseCEx);
			if(P_aproximadas1!=IntPtr.Zero) Marshal.FreeHGlobal(P_aproximadas1);
			if(P_aproximadas2!=IntPtr.Zero) Marshal.FreeHGlobal(P_aproximadas2);
			ahora_no_se_puede_cerrar=0;
		}

		unsafe static ushort* pointat(ushort* fichero){
			ushort *ext, fin;
			ext=fichero; while(*ext!='\0') ext++;
			fin=ext;
			while(*ext!='.' && ext!=fichero) ext--;
			if(*ext!='.' || fin-ext>4) ext=fin;
			return ext;
		}
		unsafe static void extension3(ushort *ext, ushort x1, ushort x2, ushort x3){
			*ext++='.'; *ext++=x1; *ext++=x2; *ext++=x3; *ext='\0';
		}
		unsafe static void extension4(ushort *ext, ushort x1, ushort x2, ushort x3, ushort x4){
			*ext++='.'; *ext++=x1; *ext++=x2; *ext++=x3; *ext++=x4; *ext='\0';
		}
	#endregion

		protected override void colores(){
			base.colores();
			Txtsigma1fXY.BackColor= Globales.Colores.NETColor(Colores.cOpcional);
			Txtsigma1fZ.BackColor= Txtsigma1fXY.BackColor;
			Txtsigma1pXY.BackColor= Txtsigma1fXY.BackColor;
			Txtsigma1pZ.BackColor= Txtsigma1pXY.BackColor;

			Txtsigma2fXY.BackColor= Globales.Colores.NETColor(Colores.cOpcional);
			Txtsigma2fZ.BackColor= Txtsigma2fXY.BackColor;
			Txtsigma2pXY.BackColor= Txtsigma2fXY.BackColor;
			Txtsigma2pZ.BackColor= Txtsigma2pXY.BackColor;

			Transformar.BackColor= Globales.Colores.NETColor(Colores.cBoton);
		}

	#region etiquetas_idiomas
		protected override void update_idioma(){
			string txt;
			base.update_idioma();

			ParentForm.Text=get_texto(Textos.Cods.UniondeModelos);
			MessageBoxAT.Caption=get_texto(Textos.Cods.Modelos);

			PanelMenu1.gLabels("Opciones").Text=get_texto(Textos.Cods.Opciones);
			ConfigSalida.Text=get_texto(Textos.Cods.InfoSalida);
			OEscala.Text=get_texto(Textos.Cods.Sinescala);
			OGrandes_rotaciones.Text=get_texto(Textos.Cods.RotacionesGrandes);
			OForce_apriori.Text=get_texto(Textos.Cods.Forzar_var_apriori);
			AAcercade.Text=get_texto(Textos.Cods.Acercade);
			ManualPath=get_texto(Textos.Cods.Manualpath);
			FormAcercade1.titulo=get_texto(Textos.Cods.Acercade);
			FormAcercade1.cabecera=get_texto(Textos.Cods.FullTitle);

			TxtBotapr1.L.Text=get_texto(Textos.Cods.Ficherodereferencia);
			TxtBotapr2.L.Text=get_texto(Textos.Cods.Ficheroatransformar);
			GBoxPrecisiones.Text=get_texto(Textos.Cods.Precisiones);
			GroupBox3.Text=get_texto(Textos.Cods.Ficherodereferencia);
			GroupBox4.Text=get_texto(Textos.Cods.Ficheroatransformar);
			Optfijas1.Text=get_texto(Textos.Cods.Coordenadas_fijas);
			Optfijas2.Text=get_texto(Textos.Cods.Igual_que_referencia);

			GroupBox5.Text=get_texto(Textos.Cods.Fotogramas);
			GroupBox6.Text=get_texto(Textos.Cods.Puntos);
			GroupBox8.Text=get_texto(Textos.Cods.Fotogramas);
			GroupBox7.Text=get_texto(Textos.Cods.Puntos);

			txt=get_texto(Textos.Cods.Planimetra);
			Label3.Text= txt;
			Label5.Text= txt;
			Label7.Text= txt;
			Label9.Text= txt;
			txt=get_texto(Textos.Cods.Altimetra);
			Label4.Text= txt;
			Label6.Text= txt;
			Label8.Text= txt;
			Label10.Text= txt;

			Transformar.Text=get_texto(Textos.Cods.Transformar);

			switch(idioma){
				case Idioma.Esp: FormAcercade1.fecha="23 de junio de 2011"; break;
				case Idioma.Eng: FormAcercade1.fecha="23rd June 2011"; break;
				case Idioma.It: FormAcercade1.fecha="23 giugno 2011"; break;
				default: goto case Idioma.Esp;
			}

			string[] ss=FileTypes.GetShortNames(FileTypes.TipoFiltro.PuntosTodos,idioma);
			Tfapr1.set_textos(ss);
			Tfapr2.set_textos(ss);
			Tfapr1.actualiza();
			Tfapr2.actualiza();
		}
	#endregion

		internal string global_text(Globales.Textos.Cods cod){
			return Globales.Textos.get_texto(cod,idioma);
		}
		internal string get_texto(Textos.Cods cod){
			return Textos.get_texto(cod,idioma);
		}
	}
}
