using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace ControlesAt
{
	public class LabelMenu : LabelTab
	{
		private ContextMenu menu;
		public LabelMenu(ContextMenu _menu){
			menu=_menu;
		}
		protected override void OnClick(EventArgs e){
			base.OnClick(e);
			int h;
			if(this.Dock==DockStyle.Left || this.Dock==DockStyle.Right)
				h=this.Parent.Height;
			else h=this.Height;
			menu.Show(this,new Point(0,h));
		}
		public void doClick(){
			this.OnClick(EventArgs.Empty);
		}
	}

	public class PanelMenu : System.Windows.Forms.UserControl
	{
		public LabelMenu[] Labels;
		private int n,t;
		private TwoDimAlignment labelsalign;
		public TwoDimAlignment LabelsAlign{
			get{return labelsalign;}
			set{labelsalign=value;
				for(int i=0;i<t;i++)
					Labels[i].TextAlign=labelsalign;
			}
		}
		private int itemsep=8;
		public int ItemSep{
			get{return itemsep;}
			set{itemsep=value;
				for(int i=0;i<t;i++)
					Labels[i].dWidth=itemsep;
			}
		}
		private Font labelsfont;
		public Font LabelsFont{
			get{return labelsfont;}
			set{labelsfont=value;
				for(int i=0;i<t;i++)
					Labels[i].Font=labelsfont;
			}
		}

		public PanelMenu(){
			Labels= new LabelMenu[4];
			n=4;
			t=0;
			this.Location= new Point(0,0);
			this.Dock=DockStyle.Top;
			this.LabelsAlign= new TwoDimAlignment(0.5F,0.5F);
			this.LabelsFont=Globales.Fuentes.FontTitle1;
		}
		protected override Size DefaultSize{
			get{return new Size(600, 17);}
		}

		public void AddLabel(string name, ContextMenu menu){
			if(t==n){
				n<<=1;
				redim(ref Labels,n);
			}
			Labels[t]=new LabelMenu(menu);
			Labels[t].Name=name;
			Labels[t].Dock=DockStyle.Left;
			Labels[t].TextAlign=this.labelsalign;
			Labels[t].dWidth=this.itemsep;
			Labels[t].Text=name;
			Labels[t].Font=labelsfont;
			this.Controls.Add(Labels[t]);
			t++;
		}
		public LabelMenu gLabels(string s){
			int i;
			for(i=0;i<t;i++){
				if(Labels[i].Name==s)
					return Labels[i];
			}
			throw new System.IndexOutOfRangeException("No existe la etiqueta "+s+" en el Menu");
		}
		public int Count(){return t;}

		private static void redim(ref LabelMenu[] cadena,int n){
			int m=cadena.Length;
			LabelMenu[] antiguas=new LabelMenu[m];

			int i;
			for(i=0;i<m;i++) antiguas[i]=cadena[i];
			cadena=new LabelMenu[n];
			if(n<m) m=n;
			for(i=0;i<m;i++) cadena[i]=antiguas[i];
		}
	}
}
