using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using ControlesAt;
using System.Runtime.InteropServices;
using Globales;

namespace EditorT{
using static Textos.Cods;

	public class PanelEditorT : PanelesSub.PanelSubordinado	{
		private System.Windows.Forms.MenuItem ANuevo;
		private System.Windows.Forms.MenuItem AGuardar;

	#region Variables
		private bool idioma_read;
		public delegado_annade rannade_ficheros;

		internal TextoFicheroCollection grupos;
		internal float[] anchos, anchos_aux;
		internal int split_i,split_x;
		bool ss;
		System.Drawing.Font font;
		bool ajustelinea;
	#endregion

	#region inicializacin
		public PanelEditorT(PanelesSub.Duenno _owner, Idioma idioma_inicial, IntPtr _enlaces) : base(_owner,idioma_inicial){
			sizable=true;
			InitializeComponent();
		}
		unsafe public PanelEditorT() : base(){
			sizable=true;
			InitializeComponent();
		}

		protected override void inizializeb(string[] argv){
			AppData=Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData)+"\\Aerotri\\";
			if(!System.IO.Directory.Exists(AppData)) System.IO.Directory.CreateDirectory(AppData);
			icono= new System.Drawing.Icon(System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("EditorT.IconEditorT.ico"));
			MessageBoxAT.MinWidth=160;
			ParentForm.MinimumSize= new System.Drawing.Size(180, 140);

			FormAcercade1=new FormAcercade(typeof(PanelEditorT),idioma);
			FormAcercade1.Icon= icono;
			FormAcercade1.LabelIcono.Image= icono.ToBitmap();
			FormAcercade1.Owner=ParentForm;
			rannade_ficheros=new delegado_annade(annade_ficheros);

			grupos=new TextoFicheroCollection();

			font=null;
			ajustelinea=false;
			idioma_read=false;
			lee_ficheroConfiguracion("EditordeTexto.config");
			if(!idioma_read && Myowner.modo==0){
				idioma_read=PanelesSub.varias.read_reg_language("Aerotri","InstallLanguage",ref base.idioma);
			}
			this.AllowDrop=true;
			update_idioma();

			annade_ficheros(argv);
			colores();
		}

		protected override void procesa_linea_config(string tipo,string[] palabras){
			int count=palabras.Length;
			switch(tipo){
				case "Idioma":
					if(!idioma_read) if(tipo=="Idioma") idioma_read=true;
					base.procesa_linea_config(tipo, palabras);
					break;
				case "Font":
					float f=9.75F;
					if(count>2){try{
						f= Basicas._gcVarios.atofl(palabras[2].ToCharArray());
					}catch(System.SystemException){}}
					if(count>1) font=new Font(palabras[1],f);
					break;
				case "AjusteLinea":
					if(count>1){
						if(palabras[1]=="Si") ajustelinea=true;
						else ajustelinea=false;
					}
					break;
				default:
					base.procesa_linea_config(tipo,palabras); break;
			}
		}
	#endregion

	#region InitializeComponent
		private void InitializeComponent(){
			ANuevo= new MenuItem();
			AGuardar= new MenuItem();
			//
			// MenuArchivo
			//
			MenuArchivo.MenuItems.AddRange(new MenuItem[] {ANuevo,		AGuardar});
			//
			// ANuevo, etc.
			ANuevo.Index= 0;		ANuevo.Click+= new EventHandler(ANuevo_Click);
			AGuardar.Index= 1;	AGuardar.Click+= new EventHandler(AGuardar_Click);
			ASalir.Index= 2;
			//
			PanelMenu1.Height=18;
		}
	#endregion

		protected override Size DefaultSize{
			get{return new Size(396, 368);}
		}
		protected override void OnLoad(System.EventArgs e){
			ss=false;
			base.OnLoad(e);
		}

		protected override int cierra_todo(){
			int i=grupos.Count;
			if(i!=0){
				font= grupos[i-1].last_font;
				ajustelinea= grupos[i-1].last_ajlinea;
			}
			for(i=grupos.Count;i>0;) grupos[--i].cerrar();
			if(grupos.Count!=0){
				return 1;
			}
			guarda_ficheroConfiguracion("EditordeTexto.config");
			return 0;
		}
		protected override void escribe_fConfiguracion(System.IO.StreamWriter fconfig){
			base.escribe_fConfiguracion_comienzo(fconfig);
			if(font!=null) fconfig.WriteLine("Font \t\"" + font.Name +"\"  "+font.SizeInPoints.ToString());
			fconfig.Write("AjusteLinea ");
			if(ajustelinea) fconfig.WriteLine("Si");
			else fconfig.WriteLine("No");
		}

	#region annadir ficheros (procesar cadena)
		public delegate void delegado_annade(string[] argv);

		void annade_ficheros(string[] argv){
			int i,argc,j,code;
			string s;
			string current_grupo="";	//Para que el imbcil del compilador no me de error ms abajo

			argc=argv.Length;
			for(i=0;i<argc;i++){
				if(argv[i]==""){
					for(j=i+1;j<argc;j++)
						argv[j-1]=argv[j];
					argc--;
				}
			}
			if(argc==0 && grupos.Count==0){
				annade_grupo("");
				grupos[0].annade_pestanna("",false);
				return;
			}
			if(argv[0][0]!='-'){
				annade_grupo(grupos.grupo_default);
				current_grupo=grupos.grupo_default;
			}
			code=0;
			for(i=0;i<argc;i++){
				s=argv[i];
				switch(code){
					case 0:
						if(s[0]=='-'){
							switch(s){
								case "-g": code=1; break;
							  //case "- ": code= ; break;
							  // .
							  // .
							  // .
							}
							i--;
							continue;
						}
						grupos[current_grupo].annade_pestanna(s,true);
						break;
					case 1:
						code=2;
						break;
					case 2:
						try{
							annade_grupo(s);
						}catch(System.ArgumentException){}
						if(s=="") current_grupo=grupos[grupos.Count-1].nombre;
						else current_grupo=s;
						code=0;
						break;
				}
			}
		}
	#endregion

		void annade_grupo(string s){
			int n,i;
			float d;
			int ileft;

			n=grupos.Count;
			grupos.Add(s,idioma,this,font,ajustelinea);
			anchos_aux=new float[n];
			for(i=0;i<n;i++)
				anchos_aux[i]=anchos[i];

			anchos=new float[n+1];
			d=(float)n/(n+1);
			ileft=0;
			for(i=0;i<n;i++){
				anchos[i]=anchos_aux[i]*d;

				grupos[i].Left=ileft;
				ileft=(int)(this.ClientSize.Width*anchos[i]);
				grupos[i].Width=ileft-grupos[i].Left;
			}
			anchos[n]=1;
			if(n>0) grupos[n-1].Splitter1.Enabled=true;

			grupos[n].Location= new Point(ileft,18);
			grupos[n].Size= new Size(this.ClientSize.Width-ileft,this.ClientSize.Height-18);
			grupos[n].Dock=DockStyle.None;
			grupos[n].Splitter1.Enabled=false;
			grupos[n].MiTextoChanged+= new DelegadoGrupoIndice(Grupos_MiTextoChanged);
			grupos[n].Disposed+=new EventHandler(Grupos_Disposed);
			grupos[n].Splitter1.MouseDown+=new MouseEventHandler(Splitters_MouseDown);
			grupos[n].Splitter1.MouseMove+=new MouseEventHandler(Splitters_MouseMove);
			grupos[n].Splitter1.MouseUp+=new MouseEventHandler(Splitters_MouseUp);
			this.Controls.Add(grupos[n]);
		}

		private void Grupos_Disposed(object sender,EventArgs e){
			int i,n;
			float d=0;		//Como arriba, para que el tonto no piense que no la habremos asignado
			int ileft;

			n=grupos.Count;
			for(i=0;i<n;i++){
				if(sender.Equals(grupos[i])) break;
			}
			grupos.Remove(i);

			d=anchos[i];
			if(i>0) d-=anchos[i-1];
			for(i++;i<n;i++)
				anchos[i-1]=anchos[i]-d;

			n--;
			if(n==0){
				//Enabled_false();
				//FormBuscar1.Hide();
			}else{
				d=1/(1-d);
				for(n--,i=0;i<n;i++) anchos[i]*=d;
				anchos[n++]=1;

				ileft=0;
				for(i=0;i<n;i++){
					grupos[i].Left=ileft;
					ileft+=(int)(this.ClientSize.Width*anchos[i])-ileft;
					grupos[i].Width=ileft-grupos[i].Left;
				}
				grupos[grupos.Count-1].Splitter1.Enabled=false;
			}
		}

	#region Splitter
		protected override void OnResize(EventArgs e){
			int i;
			int ileft;
			this.SuspendLayout();

			ileft=0;
			for(i=0;i<grupos.Count;i++){
				grupos[i].Left=ileft;
				ileft=(int)(this.ClientSize.Width*anchos[i]);
				grupos[i].Width=ileft-grupos[i].Left;
				grupos[i].Height=this.ClientSize.Height-18;
			}
			this.ResumeLayout(false);

			base.OnResize(e);
		}

		private void Splitters_MouseDown(object sender,MouseEventArgs e){
			if(e.Button!=MouseButtons.Left) return;
			int i;

			for(i=0;i<grupos.Count;i++){
				if(sender.Equals(grupos[i].Splitter1)) break;
			}
			split_i=i;
			split_x=e.X;
			ss=true;
			if(grupos[i].Width<46 && grupos[i+1].Width<46) ss=false;
		}

		private void Splitters_MouseMove(object sender,MouseEventArgs e){
			if(ss==false) return;
			int dx;
			int i=split_i;

		  dx=e.X-split_x;
			if((dx<0 && grupos[i].Width==46) || (dx>0 && grupos[i+1].Width==46)){return;}
			anchos[i]+=(float)dx/this.ClientSize.Width;
			grupos[i].Width=(int)(anchos[i]*this.ClientSize.Width)-grupos[i].Left;
			grupos[i+1].Left+=dx;
			grupos[i+1].Width=(int)(anchos[i+1]*this.ClientSize.Width)-grupos[i+1].Left;
		}

		private void Splitters_MouseUp(object sender,MouseEventArgs e)
		{
			ss=false;
		}
	#endregion
		protected override void OnDragEnter(DragEventArgs e){
			if(e.Data.GetDataPresent(DataFormats.FileDrop)){
				e.Effect= DragDropEffects.Copy;
			}else{
				e.Effect= DragDropEffects.None;
			}
			base.OnDragEnter(e);
		}
		protected override void OnDragDrop(DragEventArgs e){
			annade_grupo("");
			grupos[grupos.Count-1].TextoFichero_DragDrop(this,e);
			base.OnDragDrop(e);
		}

		private void Grupos_MiTextoChanged(TextoFichero e,short i)
		{
			e.ptd[i].modificado=true;
		}

	#region Archivo
		private void ANuevo_Click(object sender,System.EventArgs e){
			annade_grupo("");
		}
		private void AGuardar_Click(object sender,System.EventArgs e)
		{
			ahora_no_se_puede_cerrar=1;
			mensaje_estado=Globales.Textos.get_texto(Globales.Textos.Cods.Guardando_ficheros,idioma);
			for(int i=0;i<grupos.Count;i++) grupos[i].guardartodo();
			ahora_no_se_puede_cerrar=0;
		}
		#endregion

		protected override void update_idioma(){
			base.update_idioma();
			ParentForm.Text=get_texto(Caption);
			MessageBoxAT.Caption=get_texto(MsgCaption);
			ANuevo.Text=get_texto(NuevoGrupo);
			AGuardar.Text=get_texto(GuardarTodo);
			AAcercade.Text=get_texto(Acercade);
			ManualPath=get_texto(Manualpath);
			FormAcercade1.titulo=get_texto(Acercade);
			FormAcercade1.cabecera=get_texto(FullTitle);

			switch(idioma){
				case Idioma.Esp: FormAcercade1.fecha="18 de octubre de 2010"; break;
				case Idioma.Eng: FormAcercade1.fecha="18th October 2010"; break;
				case Idioma.It: FormAcercade1.fecha="18 ottobre 2010"; break;
				default: goto case Idioma.Esp;
			}
		}
		private string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
		
		protected override void colores(){
			base.colores();
		}
	}
}
