﻿using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.IO;
using ControlesAt;
using PanelesSub;
using EditorD.InterComEditorD;

namespace EditorD{
using static Textos.Cods;

	public struct Enlaces{
		public PanelesSub.PanelSubordinado PanelAerotri1;
	}
	internal struct ConfiguracionPrograma{
		public string OpenPath;
	}
	/// <summary>
	/// Descripción breve de PanelEditorD.
	/// </summary>
	public class PanelEditorD : PanelesSub.PanelSubordinado{
		public event EventSender HazAlgo;	//La palabra event podría omitirse, sólo vale
											//para que la componente aparezca con un rayo
		internal System.Windows.Forms.MenuItem AAbrir;
		internal System.Windows.Forms.MenuItem AGtodocalcular;
		internal System.Windows.Forms.MenuItem ACerrar;
		internal System.Windows.Forms.MenuItem CEscalaRes;
		private System.Windows.Forms.OpenFileDialog Open1;

	#region Variables
		private bool idioma_read;
		internal ConfiguracionPrograma ConfigPrograma;
		public delegado_remuestra dRemuestra_obj;
		public delegado_remuestra dRemuestra;

		internal FormEscalaRes FormEscalares1;
		internal float[] Limites;
		internal DataGridTab[] dg;
		internal int ngrupos;
		internal DataTable DT_fotogramas, DT_aproximadas_ccpp,DT_aproximadas_pp, DT_apoyo, DT_GPS;
		internal DataTable DT_res_porfotos, DT_res_porpuntos, DT_res_apoyo, DT_res_GPS;
		internal DataGridTableStyle TStyle_fotogramas, TStyle_pp, TStyle_ccpp, TStyle_apoyo, TStyle_GPS;
		internal DataGridTableStyle TStyle_res_porfotos, TStyle_res_porpuntos, TStyle_res_apoyo, TStyle_res_GPS;
		internal float[] altos;
		internal int split_i,split_y;
		bool ss;
		bool bdata1;
		internal uint nf,ncp, npm, npy, npcontrol, ngps,ngruposGPS,ntot;
		internal System.IntPtr
					centros,puntosM,
					puntosC,
					gpss,grupos,			
					puntosA, pC_a_pA,
					grupos_acum,grupocalc_a_orig,
					mafp,
					p_cp_acum,p_en_cp,
					pm_ppios,pC_a_pM,pA_a_pM,
					orden_cp,orden_pm,
					L,Lp,Lgps,Lins,
					L_norm,Lp_norm,Lgps_norm,Lins_norm,
					Lpc,Lpc_norm;
		string ffotogramas,fapoyo,faproximadas,fgps;
		BnfVarios varios;
		DecimalesResiduos decr;
		double ccpi;
		float fccpi;
		int height_tablas;
	#endregion

	#region inicialización
		public PanelEditorD(PanelesSub.Duenno _owner, Globales.Idioma idioma_inicial, IntPtr _enlaces) : base(_owner,idioma_inicial){
			sizable=true;
			InitializeComponent();
			if(Myowner.modo==2){
				AGtodocalcular.Visible=true;
				AAbrir.Visible=false;
			}
		}
		unsafe public PanelEditorD() : base(){
			sizable=true;
			InitializeComponent();
		}

		protected override void inizializeb(string[] argv){
			AppData=Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData)+"\\Aerotri\\";
			if(!System.IO.Directory.Exists(AppData)) System.IO.Directory.CreateDirectory(AppData);
			icono= new System.Drawing.Icon(System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("EditorD.IconEditorD.ico"));
			MessageBoxAT.MinWidth=160;
			ParentForm.MinimumSize= new System.Drawing.Size(200, 240);

			FormEscalares1=new FormEscalaRes(this);
			FormAcercade1=new FormAcercade(typeof(PanelEditorD),idioma);
			FormAcercade1.Icon= icono;
			FormAcercade1.LabelIcono.Image= icono.ToBitmap();
			FormAcercade1.Width+=56;
			FormAcercade1.Owner=ParentForm;

			FormEscalares1.Escalares.ValueChanged+=new EventHandler(EscalaRes_ValueChanged);
			FormEscalares1.Owner=ParentForm;
			FormAcercade1.Owner=ParentForm;
			unsafe{dRemuestra=new delegado_remuestra(remuestra);
			dRemuestra_obj=new delegado_remuestra(Call_remuestra);}

			ngrupos=2;
			altos=new float[2];
			altos[0]=0.5F;
			altos[1]=1;

			idioma_read=false;
			lee_ficheroConfiguracion("EditordeDatos.config");
			if(!idioma_read && Myowner.modo==0){
				idioma_read=PanelesSub.varias.read_reg_language("Aerotri","InstallLanguage",ref base.idioma);
			}
			update_idioma();
			colores();

			Crea_DataGrids();
			Crea_Tablas();
			Crea_Formatos();
			dg[0].inicializa1();
			dg[0].inicializa2();
			dg[1].inicializa1();
			dg[1].inicializa2();
			dg[0].SeleccionaIndice(0);
			dg[1].SeleccionaIndice(1);

			EnabledFalse();
			oculta_ficheros();

			short n;
			string fichero,ext;
			int nret;

			n=(short)argv.Length;
			if(n==0) goto Finext;
			fichero=argv[n-1];
			try{
				ext=System.IO.Path.GetExtension(fichero);
				ConfigPrograma.OpenPath=System.IO.Path.GetDirectoryName(fichero);
			}catch(ArgumentException){goto Finext;}
			switch(ext.ToLower()){
				case ".bnf":
					nret=abre_ficherobnf(fichero);
					break;
				default:
					nret=lee_otrofichero(fichero);
					break;
			}
			if(nret!=0) EnabledTrue();
		Finext:;
		}

		protected override void lee_ficheroConfiguracion(string nombre){
			base.lee_ficheroConfiguracion(nombre);
			ConfigPrograma.OpenPath=__OpenPath;
		}
		protected override void procesa_linea_config(string tipo,string[] palabras){
			int count=palabras.Length;
			switch(tipo){
				case "Idioma":
					if(!idioma_read) if(tipo=="Idioma") idioma_read=true;
					base.procesa_linea_config(tipo, palabras);
					break;
				case "Altos":
					try{
						if(count>1){ altos[0]=Basicas._gcVarios.atofl(palabras[1].ToCharArray());
							if(altos[0]<=0 || altos[0]>=1) altos[0]=0.5F;
						}
					}catch(System.SystemException){}
					break;
				default:
					base.procesa_linea_config(tipo,palabras); break;
			}
		}
	#endregion

	#region InitializeComponent
		private void InitializeComponent()
		{
			AAbrir= new MenuItem();
			AGtodocalcular= new MenuItem();
			ACerrar= new MenuItem();
			CEscalaRes= new MenuItem();
			Open1= new OpenFileDialog();
			//
			// MenuArchivo
			//
			MenuArchivo.MenuItems.AddRange(new MenuItem[] {AAbrir, AGtodocalcular, ACerrar});
			//
			// AAbrir
			AAbrir.Index= 0;
			AAbrir.Visible= true;
			AAbrir.Click+= new EventHandler(AAbrir_Click);
			//
			// AGtodocalcular
			AGtodocalcular.Index= 1;
			AGtodocalcular.Visible= false;
			AGtodocalcular.Click+= new EventHandler(AGtodocalcular_Click);
			//
			// ACerrar
			ACerrar.Index= 2;
			ACerrar.Visible= true;
			ACerrar.Click+= new EventHandler(ACerrar_Click);
			//
			// Various
			//
			MenuConfiguracion.MenuItems.Add(CEscalaRes);
			CEscalaRes.Index=1;
			CEscalaRes.Click+= new EventHandler(CEscalaRes_Click);
			this.Size= new Size(600, 480);
		}
	#endregion

	#region inizializar
		void Crea_DataGrids(){
			int itop;

			height_tablas=this.ClientSize.Height-16;
			itop=(int)(height_tablas*altos[0]);
			dg=new DataGridTab[2];
			dg[0]=new DataGridTab("Ficheros",5,idioma,this);
			dg[0].Location=new Point(0,16);
			dg[0].Size=new Size(this.ClientSize.Width,itop);
			itop+=16;
			dg[1]=new DataGridTab("Residuos",4,idioma,this);
			dg[1].Location=new Point(0,itop);
			dg[1].Size=new Size(this.ClientSize.Width,this.ClientSize.Height-itop);
			dg[1].Splitter1.Enabled=false;

			dg[0].DataGrid1.CaptionText=get_texto(Ficheros_de_entrada);
			dg[0].ActivaMenu(1);
			dg[0].fotos="";
			dg[0].aproximadas="";
			dg[0].apoyo="";
			dg[0].GPS="";
			dg[0].uni=varios.uni;

			dg[0].tabControl1.TabPages.Add(new TabPage(get_texto(Fotogramas)));
			dg[0].tabControl1.TabPages.Add(new TabPage(get_texto(Valores_aproximados_ccpp)));
			dg[0].tabControl1.TabPages.Add(new TabPage(get_texto(Valores_aproximados_pp)));
			dg[0].tabControl1.TabPages.Add(new TabPage(get_texto(Apoyo)));
			dg[0].tabControl1.TabPages.Add(new TabPage(get_texto(EventosGPS)));
			dg[0].tabControl1.TabPages[0].Name="fotogramas";			dg[0].Tabinfo[0].tipo="fotogramas";			dg[0].Tabinfo[0].fichero=dg[0].fotos;
			dg[0].tabControl1.TabPages[1].Name="aproximadas_ccpp";	dg[0].Tabinfo[1].tipo="aproximadas_ccpp";	dg[0].Tabinfo[1].fichero=dg[0].aproximadas;
			dg[0].tabControl1.TabPages[2].Name="aproximadas_pp";		dg[0].Tabinfo[2].tipo="aproximadas_pp";		dg[0].Tabinfo[2].fichero=dg[0].aproximadas;
			dg[0].tabControl1.TabPages[3].Name="apoyo";					dg[0].Tabinfo[3].tipo="apoyo";					dg[0].Tabinfo[3].fichero=dg[0].apoyo;
			dg[0].tabControl1.TabPages[4].Name="GPS";					dg[0].Tabinfo[4].tipo="GPS";					dg[0].Tabinfo[4].fichero=dg[0].GPS;
			dg[0].Splitter1.MouseDown+=new MouseEventHandler(Splitters_MouseDown);
			dg[0].Splitter1.MouseMove+=new MouseEventHandler(Splitters_MouseMove);
			dg[0].Splitter1.MouseUp+=new MouseEventHandler(Splitters_MouseUp);

			dg[1].DataGrid1.ReadOnly=true;
			dg[1].DataGrid1.CaptionText=get_texto(Residuos_del_ajuste);
			dg[1].ActivaMenu(2);
			dg[1].uni=varios.uni;

			dg[1].tabControl1.TabPages.Add(new TabPage(get_texto(porfotos)));
			dg[1].tabControl1.TabPages.Add(new TabPage(get_texto(porpuntos)));
			dg[1].tabControl1.TabPages.Add(new TabPage(get_texto(ApoyoControl)));
			dg[1].tabControl1.TabPages.Add(new TabPage(get_texto(EventosGPS)));
			dg[1].tabControl1.TabPages[0].Name="porfotos";		dg[1].Tabinfo[0].tipo="res_porfotos";
			dg[1].tabControl1.TabPages[1].Name="porpuntos";		dg[1].Tabinfo[1].tipo="res_porpuntos";
			dg[1].tabControl1.TabPages[2].Name="apoyo";			dg[1].Tabinfo[2].tipo="res_apoyo";
			dg[1].tabControl1.TabPages[3].Name="GPS";				dg[1].Tabinfo[3].tipo="res_GPS";
			dg[1].Splitter1.MouseDown+=new MouseEventHandler(Splitters_MouseDown);
			dg[1].Splitter1.MouseMove+=new MouseEventHandler(Splitters_MouseMove);
			dg[1].Splitter1.MouseUp+=new MouseEventHandler(Splitters_MouseUp);

			this.Controls.Add(dg[0]);
			this.Controls.Add(dg[1]);
		}

		private void Crea_Tablas(){
			int i;

			DT_fotogramas=new DataTable("fotogramas");
			DT_aproximadas_ccpp=new DataTable("aproximadas_ccpp");
			DT_aproximadas_pp=new DataTable("aproximadas_pp");
			DT_apoyo=new DataTable("apoyo");
			DT_GPS=new DataTable("GPS");

			DT_res_porfotos=new DataTable("porfotos");
			DT_res_porpuntos=new DataTable("porpuntos");
			DT_res_apoyo=new DataTable("apoyo");
			DT_res_GPS=new DataTable("GPS");

			//Columnas de fotogramas
			DT_fotogramas.Columns.Add("Fotograma",typeof(string));
			DT_fotogramas.Columns.Add("Punto",typeof(string));	//focal
			DT_fotogramas.Columns.Add("x",typeof(string));		//marca del fotograma
			DT_fotogramas.Columns.Add("y",typeof(string));
			DT_fotogramas.Columns.Add("Marca",typeof(string));
			DT_fotogramas.Columns.Add("Precisión",typeof(string));
			for(i=0;i<6;i++)
				DT_fotogramas.Columns[i].DefaultValue="";
			//Columnas de aproximadas_ccpp
			DT_aproximadas_ccpp.Columns.Add("Nombre",typeof(string));
			DT_aproximadas_ccpp.Columns.Add("X",typeof(double));
			DT_aproximadas_ccpp.Columns.Add("Y",typeof(double));
			DT_aproximadas_ccpp.Columns.Add("Z",typeof(double));
			DT_aproximadas_ccpp.Columns.Add("Ω",typeof(double));
			DT_aproximadas_ccpp.Columns.Add("Φ",typeof(double));
			DT_aproximadas_ccpp.Columns.Add("Κ",typeof(double));
			DT_aproximadas_ccpp.Columns.Add("Marca",typeof(char));
			DT_aproximadas_ccpp.Columns.Add("sort_def",typeof(uint));
			DT_aproximadas_ccpp.Columns[0].DefaultValue="???";
			for(i=1;i<7;i++)
				DT_aproximadas_ccpp.Columns[i].DefaultValue=0;
			DT_aproximadas_ccpp.Columns[7].DefaultValue='1';
			//Columnas de aproximadas_pp
			DT_aproximadas_pp.Columns.Add("Nombre",typeof(string));
			DT_aproximadas_pp.Columns.Add("X",typeof(double));
			DT_aproximadas_pp.Columns.Add("Y",typeof(double));
			DT_aproximadas_pp.Columns.Add("Z",typeof(double));
			DT_aproximadas_pp.Columns.Add("Marca",typeof(char));
			DT_aproximadas_pp.Columns.Add("sort_def",typeof(uint));
			DT_aproximadas_pp.Columns[0].DefaultValue="???";
			for(i=1;i<4;i++)
				DT_aproximadas_pp.Columns[i].DefaultValue=0;
			DT_aproximadas_pp.Columns[4].DefaultValue='1';
			//Columnas de apoyo
			DT_apoyo.Columns.Add("Nombre",typeof(string));
			DT_apoyo.Columns.Add("X",typeof(double));
			DT_apoyo.Columns.Add("Y",typeof(double));
			DT_apoyo.Columns.Add("Z",typeof(double));
			DT_apoyo.Columns.Add("Marca",typeof(string));
			DT_apoyo.Columns.Add("PrecisiónXY",typeof(string));
			DT_apoyo.Columns.Add("PrecisiónZ",typeof(string));
			DT_apoyo.Columns.Add("sort_def",typeof(uint));
			DT_apoyo.Columns[0].DefaultValue="???";
			for(i=1;i<4;i++)
				DT_apoyo.Columns[i].DefaultValue=0;
			DT_apoyo.Columns["Marca"].DefaultValue="111";
			for(i=5;i<7;i++)
				DT_apoyo.Columns[i].DefaultValue="";
			//Columnas de GPS
			DT_GPS.Columns.Add("Grupo",typeof(string));
			DT_GPS.Columns.Add("Nombre",typeof(string));
			DT_GPS.Columns.Add("X",typeof(string));			//offset X
			DT_GPS.Columns.Add("Y",typeof(string));			//offset Y
			DT_GPS.Columns.Add("Z",typeof(string));			//offset Z
			DT_GPS.Columns.Add("Ω",typeof(string));
			DT_GPS.Columns.Add("Φ",typeof(string));
			DT_GPS.Columns.Add("Κ",typeof(string));
			DT_GPS.Columns.Add("t",typeof(string));
			DT_GPS.Columns.Add("Marca GPS",typeof(string));		//marca grupo GPS
			DT_GPS.Columns.Add("Marca INS",typeof(string));		//marca grupo INS
			DT_GPS.Columns.Add("PrecisiónXY",typeof(string));	//Prec. part.
			DT_GPS.Columns.Add("PrecisiónZ",typeof(string));	//Prec. part.
			DT_GPS.Columns.Add("PrecisiónΩΦ",typeof(string));	//Prec. part.
			DT_GPS.Columns.Add("PrecisiónΚ",typeof(string));	//Prec. part.
			for(i=0;i<15;i++)
				DT_GPS.Columns[i].DefaultValue="";

			//Columnas de los residuos por fotogramas
			DT_res_porfotos.Columns.Add("Fotograma",typeof(string));
			DT_res_porfotos.Columns.Add("Punto",typeof(string));
			DT_res_porfotos.Columns.Add("Residuo x",typeof(string));
			DT_res_porfotos.Columns.Add("Residuo y",typeof(string));
			DT_res_porfotos.Columns.Add("Tipo",typeof(string));	//XYZ
			DT_res_porfotos.Columns.Add("Ord. x",typeof(float));
			DT_res_porfotos.Columns.Add("Ord. y",typeof(float));
			DT_res_porfotos.Columns.Add("Aviso",typeof(string));
			DT_res_porfotos.Columns.Add("res. x",typeof(float));
			DT_res_porfotos.Columns.Add("res. y",typeof(float));
			DT_res_porfotos.Columns.Add("sort_def",typeof(uint));
			DT_res_porfotos.Columns.Add("sort_res",typeof(uint));
			DT_res_porfotos.Columns.Add("sort_res_norm",typeof(uint));

			//Columnas de los residuos por puntos
			DT_res_porpuntos.Columns.Add("Punto",typeof(string));
			DT_res_porpuntos.Columns.Add("Fotograma",typeof(string));	//XYZ
			DT_res_porpuntos.Columns.Add("Residuo x",typeof(string));	//!!
			DT_res_porpuntos.Columns.Add("Residuo y",typeof(string));
			DT_res_porpuntos.Columns.Add("Ord. x",typeof(float));
			DT_res_porpuntos.Columns.Add("Ord. y",typeof(float));
			DT_res_porpuntos.Columns.Add("res. x",typeof(float));
			DT_res_porpuntos.Columns.Add("res. y",typeof(float));
			DT_res_porpuntos.Columns.Add("sort_def",typeof(uint));
			DT_res_porpuntos.Columns.Add("sort_res",typeof(uint));
			DT_res_porpuntos.Columns.Add("sort_res_norm",typeof(uint));

			//Columnas de los residuos del apoyo
			DT_res_apoyo.Columns.Add("Nombre",typeof(string));
			DT_res_apoyo.Columns.Add("residuo X",typeof(string));
			DT_res_apoyo.Columns.Add("residuo Y",typeof(string));
			DT_res_apoyo.Columns.Add("residuo Z",typeof(string));
			DT_res_apoyo.Columns.Add("Ord. X",typeof(float));
			DT_res_apoyo.Columns.Add("Ord. Y",typeof(float));
			DT_res_apoyo.Columns.Add("Ord. Z",typeof(float));
			DT_res_apoyo.Columns.Add("res. x",typeof(float));
			DT_res_apoyo.Columns.Add("res. y",typeof(float));
			DT_res_apoyo.Columns.Add("res. z",typeof(float));
			DT_res_apoyo.Columns.Add("sort_def",typeof(uint));
			DT_res_apoyo.Columns.Add("sort_res",typeof(uint));
			DT_res_apoyo.Columns.Add("sort_res_norm",typeof(uint));

			//Columnas de los residuos de GPS
			DT_res_GPS.Columns.Add("Grupo",typeof(string));
			DT_res_GPS.Columns.Add("Nombre",typeof(string));
			DT_res_GPS.Columns.Add("Residuo X",typeof(string));
			DT_res_GPS.Columns.Add("Residuo Y",typeof(string));
			DT_res_GPS.Columns.Add("Residuo Z",typeof(string));
			DT_res_GPS.Columns.Add("Residuo Ω",typeof(string));
			DT_res_GPS.Columns.Add("Residuo Φ",typeof(string));
			DT_res_GPS.Columns.Add("Residuo Κ",typeof(string));
			DT_res_GPS.Columns.Add("Ord. X",typeof(float));
			DT_res_GPS.Columns.Add("Ord. Y",typeof(float));
			DT_res_GPS.Columns.Add("Ord. Z",typeof(float));
			DT_res_GPS.Columns.Add("Ord. Ω",typeof(float));
			DT_res_GPS.Columns.Add("Ord. Φ",typeof(float));
			DT_res_GPS.Columns.Add("Ord. Κ",typeof(float));

			//Añadir a DS_ficheros las tablas
			dg[0].DS.Tables.Add(DT_fotogramas);
			dg[0].DS.Tables.Add(DT_aproximadas_ccpp);
			dg[0].DS.Tables.Add(DT_aproximadas_pp);
			dg[0].DS.Tables.Add(DT_apoyo);
			dg[0].DS.Tables.Add(DT_GPS);
			//Añadir a DS_residuos las tablas
			dg[1].DS.Tables.Add(DT_res_porfotos);
			dg[1].DS.Tables.Add(DT_res_porpuntos);
			dg[1].DS.Tables.Add(DT_res_apoyo);
			dg[1].DS.Tables.Add(DT_res_GPS);

			//Definir las vistas por defecto para los ficheros
			foreach(DataTable DT in dg[0].DS.Tables){
				DT.DefaultView.AllowDelete=false;
				DT.DefaultView.AllowNew=false;
			}
			dg[0].DS.Tables["aproximadas_ccpp"].DefaultView.Sort="sort_def";
			dg[0].DS.Tables["aproximadas_pp"].DefaultView.Sort="sort_def";
			dg[1].DS.Tables["porfotos"].DefaultView.Sort="sort_def";
			dg[1].DS.Tables["porpuntos"].DefaultView.Sort="sort_res_norm ASC";	//el punto con residuo mayor tiene un 0
			dg[1].DS.Tables["apoyo"].DefaultView.Sort="sort_def";
		}

		private void Crea_Formatos(){
			GridColumnStylesCollection GCS;
			int i;

			System.Globalization.NumberFormatInfo Formato=new System.Globalization.NumberFormatInfo();
			Formato.NumberDecimalSeparator=".";
			Formato.NumberGroupSeparator=" ";
			Formato.NumberDecimalDigits=3;
			DataGridTextBoxColumn DGTBC;

			TStyle_fotogramas=new System.Windows.Forms.DataGridTableStyle();
			TStyle_fotogramas.MappingName="fotogramas";
			TStyle_fotogramas.AllowSorting=false;
			TStyle_ccpp=new System.Windows.Forms.DataGridTableStyle();
			TStyle_ccpp.MappingName="aproximadas_ccpp";
			TStyle_pp=new System.Windows.Forms.DataGridTableStyle();
			TStyle_pp.MappingName="aproximadas_pp";
			TStyle_apoyo=new System.Windows.Forms.DataGridTableStyle();
			TStyle_apoyo.MappingName="apoyo";
			TStyle_GPS=new System.Windows.Forms.DataGridTableStyle();
			TStyle_GPS.MappingName="GPS";
			TStyle_GPS.AllowSorting=false;

			TStyle_res_porfotos=new System.Windows.Forms.DataGridTableStyle();
			TStyle_res_porfotos.MappingName="porfotos";
			TStyle_res_porfotos.AllowSorting=false;
			TStyle_res_porpuntos=new System.Windows.Forms.DataGridTableStyle();
			TStyle_res_porpuntos.MappingName="porpuntos";
			TStyle_res_porpuntos.AllowSorting=false;
			TStyle_res_apoyo=new System.Windows.Forms.DataGridTableStyle();
			TStyle_res_apoyo.MappingName="apoyo";
			TStyle_res_apoyo.AllowSorting=false;
			TStyle_res_GPS=new System.Windows.Forms.DataGridTableStyle();
			TStyle_res_GPS.MappingName="GPS";
			TStyle_res_GPS.AllowSorting=false;

			//TStyle_fotogramas
			GCS=TStyle_fotogramas.GridColumnStyles;
			for(i=0;i<6;i++) GCS.Add(new DataGridTextBoxColumn());

			GCS[0].MappingName="Fotograma";	GCS["Fotograma"].HeaderText=get_texto(Fotograma);
			GCS[1].MappingName="Punto";		GCS["Punto"].HeaderText=get_texto(Punto);
			GCS[2].MappingName="x";				GCS["x"].HeaderText="x";
			GCS[3].MappingName="y";				GCS["y"].HeaderText="y";
			GCS[4].MappingName="Marca";		GCS["Marca"].HeaderText=get_texto(Marca);
			GCS["Marca"].Width=52;
			GCS[5].MappingName="Precisión";	GCS["Precisión"].HeaderText=get_texto(PrecisiónParticular);

			GCS["Fotograma"].Alignment=HorizontalAlignment.Center;
			for(i=1;i<=5;i++){
				GCS[i].Alignment=HorizontalAlignment.Right;
				GCS[i].HeaderText="- "+GCS[i].HeaderText+" -";
			}

			//TStyle_ccpp
			GCS=TStyle_ccpp.GridColumnStyles;
			GCS.Add(new DataGridTextBoxColumn());
			for(i=1;i<=7;i++){
				DGTBC=new DataGridTextBoxColumn();
				DGTBC.Format="N";
				DGTBC.FormatInfo=Formato;
				GCS.Add(DGTBC);
			}
			GCS.Add(new DataGridTextBoxColumn());

			GCS[0].MappingName="Nombre";
			GCS[1].MappingName="X";
			GCS[2].MappingName="Y";
			GCS[3].MappingName="Z";
			GCS[4].MappingName="Ω";
			GCS[5].MappingName="Φ";
			GCS[6].MappingName="Κ";
			GCS[7].MappingName="Marca";		GCS["Marca"].Width=52;
			GCS[8].MappingName="sort_def";	GCS["sort_def"].Width=0;

			GCS["Nombre"].HeaderText=get_texto(Nombre);
			for(i=1;i<=6;i++) GCS[i].HeaderText=GCS[i].MappingName;
			GCS["Marca"].HeaderText=get_texto(Marca);

			for(i=0;i<=7;i++) {
				GCS[i].Alignment=HorizontalAlignment.Right;
				GCS[i].HeaderText="- " + GCS[i].HeaderText + " -";
			}

			//TStyle_pp
			GCS=TStyle_pp.GridColumnStyles;
			GCS.Add(new DataGridTextBoxColumn());
			for(i=1;i<5;i++){
				DGTBC=new DataGridTextBoxColumn();
				DGTBC.Format="N";					//La "N" significa que se aplique el formato numérico, que especifico en Formato.
				DGTBC.FormatInfo=Formato;		//Si se omitiera se aplica el formato general ("G") y lo indicado en Formato no tendría efecto.
				GCS.Add(DGTBC);
			}
			GCS.Add(new DataGridTextBoxColumn());

			GCS[0].MappingName="Nombre";
			GCS[1].MappingName="X";
			GCS[2].MappingName="Y";
			GCS[3].MappingName="Z";
			GCS[4].MappingName="Marca";		GCS["Marca"].Width=52;
			GCS[5].MappingName="sort_def";	GCS["sort_def"].Width=0;
			
			GCS["Nombre"].HeaderText=get_texto(Nombre);
			for(i=1;i<=3;i++) GCS[i].HeaderText=GCS[i].MappingName;
			GCS["Marca"].HeaderText=get_texto(Marca);

			for(i=0;i<=4;i++){
				GCS[i].Alignment=HorizontalAlignment.Right;
				GCS[i].HeaderText="- " + GCS[i].HeaderText + " -";
			}

			//TStyle_apoyo
			GCS=TStyle_apoyo.GridColumnStyles;
			GCS.Add(new DataGridTextBoxColumn());
			for(i=1;i<7;i++){
				DGTBC=new DataGridTextBoxColumn();
				DGTBC.Format="N";					//La "N" significa que se aplique el formato numérico, que especifico en Formato.
				DGTBC.FormatInfo=Formato;		//Si se omitiera se aplica el formato general ("G") y lo indicado en Formato no tendría efecto.
				GCS.Add(DGTBC);
			}
			GCS.Add(new DataGridTextBoxColumn());

			GCS[0].MappingName="Nombre";		GCS["Nombre"].HeaderText=get_texto(Nombre);
			GCS[1].MappingName="X";
			GCS[2].MappingName="Y";
			GCS[3].MappingName="Z";
			GCS[4].MappingName="Marca";			GCS["Marca"].HeaderText=get_texto(Marca);
			GCS["Marca"].Width=52;
			GCS[5].MappingName="PrecisiónXY";	GCS["PrecisiónXY"].HeaderText=get_texto(PrecisiónXY);
			GCS[6].MappingName="PrecisiónZ";		GCS["PrecisiónZ"].HeaderText=get_texto(PrecisiónZ);
			GCS[7].MappingName="sort_def";
			GCS["sort_def"].Width=0;

			for(i=1;i<=3;i++) GCS[i].HeaderText=GCS[i].MappingName;
			for(i=0;i<=6;i++){
				GCS[i].Alignment=HorizontalAlignment.Right;
				GCS[i].HeaderText="- " + GCS[i].HeaderText + " -";
			}

			//TStyle_GPS
			GCS=TStyle_GPS.GridColumnStyles;
			for(i=0;i<15;i++) GCS.Add(new DataGridTextBoxColumn());

			GCS[0].MappingName="Grupo";		GCS["Grupo"].HeaderText=get_texto(Grupo);
			GCS[1].MappingName="Nombre";		GCS["Nombre"].HeaderText=get_texto(Nombre);
			GCS[2].MappingName="X";
			GCS[3].MappingName="Y";
			GCS[4].MappingName="Z";
			GCS[5].MappingName="Ω";
			GCS[6].MappingName="Φ";
			GCS[7].MappingName="Κ";
			GCS[8].MappingName="t";
			GCS[9].MappingName="Marca GPS";		GCS["Marca GPS"].HeaderText=get_texto(MarcaGPS);
			GCS["Marca GPS"].Width=52;			
			GCS[10].MappingName="Marca INS";	GCS["Marca INS"].HeaderText=get_texto(MarcaINS);
			GCS["Marca INS"].Width=52;
			GCS[11].MappingName="PrecisiónXY";	GCS["PrecisiónXY"].HeaderText=get_texto(PrecisiónXY);
			GCS[12].MappingName="PrecisiónZ";	GCS["PrecisiónZ"].HeaderText=get_texto(PrecisiónZ);
			GCS[13].MappingName="PrecisiónΩΦ";	GCS["PrecisiónΩΦ"].HeaderText=get_texto(PrecisiónΩΦ);
			GCS[14].MappingName="PrecisiónΚ";	GCS["PrecisiónΚ"].HeaderText=get_texto(PrecisiónΚ);

			for(i=2;i<8;i++) GCS[i].HeaderText=GCS[i].MappingName;
			GCS["Grupo"].Alignment=HorizontalAlignment.Center;
			for(i=1;i<=14;i++){
				GCS[i].Alignment=HorizontalAlignment.Right;
				GCS[i].HeaderText="- " + GCS[i].HeaderText + " -";
			}

			EditorD.DataGridEnhacedTextStyle DGETS;
			//TStyle_res_porfotos
			GCS=TStyle_res_porfotos.GridColumnStyles;
			for(i=0;i<DT_res_porfotos.Columns.Count;i++){
				if(i==5 || i==6){
					DGETS= new DataGridEnhacedTextStyle();
					DGETS.Format="F2";
					DGETS.FormatInfo=dg[1].Tabinfo[0].format_Lnorm;
					GCS.Add(DGETS);
				}
				else GCS.Add(new System.Windows.Forms.DataGridTextBoxColumn());
				GCS[i].NullText="";
			}

			GCS[0].MappingName="Fotograma";	GCS[0].HeaderText=get_texto(Fotograma);
			GCS[1].MappingName="Punto";		GCS[1].HeaderText=get_texto(Punto);
			GCS[2].MappingName="Residuo x";	GCS[2].HeaderText=get_texto(Residuox);
			GCS[3].MappingName="Residuo y";	GCS[3].HeaderText=get_texto(Residuoy);
			GCS[4].MappingName="Tipo";			GCS[4].HeaderText=get_texto(Tipo);			GCS[4].Width=40;
			GCS[5].MappingName="Ord. x";		GCS[5].HeaderText=get_texto(Ordx);			GCS[5].Width=36;
			GCS[6].MappingName="Ord. y";		GCS[6].HeaderText=get_texto(Ordy);			GCS[6].Width=36;
			GCS[7].MappingName="Aviso";		GCS[7].HeaderText=get_texto(Aviso);		GCS[7].Width=36;
			GCS[8].MappingName="res. x";		GCS[8].Width=0;
			GCS[9].MappingName="res. y";		GCS[9].Width=0;
			GCS[10].MappingName="sort_def";	GCS[10].Width=0;
			GCS[11].MappingName="sort_res";	GCS[11].Width=0;
			GCS[12].MappingName="sort_res_norm";	GCS[12].Width=0;

			GCS["Fotograma"].Alignment=HorizontalAlignment.Center;
			GCS["Punto"].Alignment=HorizontalAlignment.Right;
			GCS["Residuo x"].Alignment=HorizontalAlignment.Right;
			GCS["Residuo y"].Alignment=HorizontalAlignment.Right;
			GCS["Tipo"].Alignment=HorizontalAlignment.Center;
			GCS["Ord. x"].Alignment=HorizontalAlignment.Left;
			GCS["Ord. y"].Alignment=HorizontalAlignment.Left;
			GCS["Aviso"].Alignment=HorizontalAlignment.Left;
			for(i=1;i<=3;i++) GCS[i].HeaderText="- " + GCS[i].HeaderText + " -";

			//TStyle_res_porpuntos
			GCS=TStyle_res_porpuntos.GridColumnStyles;
			for(i=0;i<DT_res_porpuntos.Columns.Count;i++){
				if(i==4 || i==5){
					DGETS= new DataGridEnhacedTextStyle();
					DGETS.Format="F2";
					DGETS.FormatInfo=dg[1].Tabinfo[1].format_Lnorm;
					GCS.Add(DGETS);
				}
				else GCS.Add(new System.Windows.Forms.DataGridTextBoxColumn());
				GCS[i].NullText="";
			}

			GCS[0].MappingName="Punto";		GCS[0].HeaderText=get_texto(Punto);
			GCS[1].MappingName="Fotograma";	GCS[1].HeaderText=get_texto(Fotograma);	//XYZ
			GCS[2].MappingName="Residuo x";	GCS[2].HeaderText=get_texto(Residuox);	//!!
			GCS[3].MappingName="Residuo y";	GCS[3].HeaderText=get_texto(Residuoy);
			GCS[4].MappingName="Ord. x";		GCS[4].HeaderText=get_texto(Ordx);			GCS[4].Width=36;
			GCS[5].MappingName="Ord. y";		GCS[5].HeaderText=get_texto(Ordy);			GCS[5].Width=36;
			GCS[6].MappingName="res. x";		GCS[6].Width=0;
			GCS[7].MappingName="res. y";		GCS[7].Width=0;
			GCS[8].MappingName="sort_def";	GCS[8].Width=0;
			GCS[9].MappingName="sort_res";	GCS[9].Width=0;
			GCS[10].MappingName="sort_res_norm";	GCS[10].Width=0;

			GCS["Punto"].Alignment=HorizontalAlignment.Center;
			GCS["Fotograma"].Alignment=HorizontalAlignment.Right;
			GCS["Residuo x"].Alignment=HorizontalAlignment.Right;
			GCS["Residuo y"].Alignment=HorizontalAlignment.Right;
			GCS["Ord. x"].Alignment=HorizontalAlignment.Left;
			GCS["Ord. y"].Alignment=HorizontalAlignment.Left;
			for(i=1;i<=3;i++) GCS[i].HeaderText="- " + GCS[i].HeaderText + " -";

			//TStyle_res_apoyo
			GCS=TStyle_res_apoyo.GridColumnStyles;
			for(i=0;i<DT_res_apoyo.Columns.Count;i++){
				if(i>=4 && i<=6){
					DGETS= new DataGridEnhacedTextStyle();
					DGETS.Format="F2";
					DGETS.FormatInfo=dg[1].Tabinfo[2].format_Lnorm;
					GCS.Add(DGETS);
				}
				else GCS.Add(new System.Windows.Forms.DataGridTextBoxColumn());
				GCS[i].NullText="";
			}

			GCS[0].MappingName="Nombre";	GCS[0].HeaderText=get_texto(Nombre);
			GCS[1].MappingName="Residuo X";	GCS[1].HeaderText=get_texto(ResiduoX);
			GCS[2].MappingName="Residuo Y";	GCS[2].HeaderText=get_texto(ResiduoY);
			GCS[3].MappingName="Residuo Z";	GCS[3].HeaderText=get_texto(ResiduoZ);
			GCS[4].MappingName="Ord. X";		GCS[4].HeaderText=get_texto(OrdX);		GCS[4].Width=44;
			GCS[5].MappingName="Ord. Y";		GCS[5].HeaderText=get_texto(OrdY);		GCS[5].Width=44;
			GCS[6].MappingName="Ord. Z";		GCS[6].HeaderText=get_texto(OrdZ);		GCS[6].Width=44;
			GCS[7].MappingName="res. x";		GCS[7].Width=0;
			GCS[8].MappingName="res. y";		GCS[8].Width=0;
			GCS[9].MappingName="res. z";		GCS[9].Width=0;
			GCS[10].MappingName="sort_def";	GCS[10].Width=0;
			GCS[11].MappingName="sort_res";	GCS[11].Width=0;
			GCS[12].MappingName="sort_res_norm";	GCS[12].Width=0;

			GCS["Nombre"].Alignment=HorizontalAlignment.Center;
			GCS["Residuo X"].Alignment=HorizontalAlignment.Right;
			GCS["Residuo Y"].Alignment=HorizontalAlignment.Right;
			GCS["Residuo Z"].Alignment=HorizontalAlignment.Right;
			GCS["Ord. X"].Alignment=HorizontalAlignment.Center;
			GCS["Ord. Y"].Alignment=HorizontalAlignment.Center;
			GCS["Ord. Z"].Alignment=HorizontalAlignment.Center;
			for(i=1;i<=3;i++) GCS[i].HeaderText="- " + GCS[i].HeaderText + " -";

			//TStyle_res_GPS
			GCS=TStyle_res_GPS.GridColumnStyles;
			for(i=0;i<8;i++) GCS.Add(new DataGridTextBoxColumn());
			for(;i<14;i++){
				DGETS= new DataGridEnhacedTextStyle();
				DGETS.Format="F2";
				DGETS.FormatInfo=dg[1].Tabinfo[3].format_Lnorm;
				GCS.Add(DGETS);
			}
			for(i=0;i<14;i++) GCS[i].NullText="";

			GCS[0].MappingName="Grupo";		GCS[0].HeaderText=get_texto(Grupo);
			GCS[1].MappingName="Nombre";		GCS[1].HeaderText=get_texto(Nombre);
			GCS[2].MappingName="Residuo X";	GCS[2].HeaderText=get_texto(ResiduoX);
			GCS[3].MappingName="Residuo Y";	GCS[3].HeaderText=get_texto(ResiduoY);
			GCS[4].MappingName="Residuo Z";	GCS[4].HeaderText=get_texto(ResiduoZ);
			GCS[5].MappingName="Residuo Ω";	GCS[5].HeaderText=get_texto(ResiduoΩ);
			GCS[6].MappingName="Residuo Φ";	GCS[6].HeaderText=get_texto(ResiduoΦ);
			GCS[7].MappingName="Residuo Κ";	GCS[7].HeaderText=get_texto(ResiduoΚ);
			GCS[8].MappingName="Ord. X";		GCS[8].HeaderText=get_texto(OrdX);		GCS[8].Width=44;
			GCS[9].MappingName="Ord. Y";		GCS[9].HeaderText=get_texto(OrdY);		GCS[9].Width=44;
			GCS[10].MappingName="Ord. Z";		GCS[10].HeaderText=get_texto(OrdZ);		GCS[10].Width=44;
			GCS[11].MappingName="Ord. Ω";		GCS[11].HeaderText=get_texto(OrdΩ);		GCS[11].Width=44;
			GCS[12].MappingName="Ord. Φ";		GCS[12].HeaderText=get_texto(OrdΦ);		GCS[12].Width=44;
			GCS[13].MappingName="Ord. Κ";		GCS[13].HeaderText=get_texto(OrdΚ);		GCS[13].Width=44;
			
			GCS["Grupo"].Alignment=HorizontalAlignment.Center;
			for(i=1;i<=7;i++){
				GCS[i].Alignment=HorizontalAlignment.Right;
				GCS[i].HeaderText="- " + GCS[i].HeaderText + " -";
			}
			for(;i<=13;i++) GCS[i].Alignment=HorizontalAlignment.Center;

			//Añadir los formatos al DataGrid
			dg[0].DataGrid1.TableStyles.Add(TStyle_fotogramas);
			dg[0].DataGrid1.TableStyles.Add(TStyle_ccpp);
			dg[0].DataGrid1.TableStyles.Add(TStyle_pp);
			dg[0].DataGrid1.TableStyles.Add(TStyle_apoyo);
			dg[0].DataGrid1.TableStyles.Add(TStyle_GPS);

			dg[1].DataGrid1.TableStyles.Add(TStyle_res_porfotos);
			dg[1].DataGrid1.TableStyles.Add(TStyle_res_porpuntos);
			dg[1].DataGrid1.TableStyles.Add(TStyle_res_apoyo);
			dg[1].DataGrid1.TableStyles.Add(TStyle_res_GPS);
		}

	#endregion

		protected override void OnLoad(System.EventArgs e){
			ss=false;
			base.OnLoad(e);
		}

		protected override int cierra_todo(){
			if(dg[0].cierra()) return 1;
			guarda_ficheroConfiguracion("EditordeDatos.config");
			return 0;
		}
		protected override void escribe_fConfiguracion(System.IO.StreamWriter fconfig){
			base.escribe_fConfiguracion_comienzo(fconfig);
			fconfig.Write("Altos      ");
			fconfig.WriteLine(altos[0]);
			fconfig.WriteLine("OpenPath \"" + ConfigPrograma.OpenPath +"\"");
		}

		void muestra_ficheros(){
			AGtodocalcular.Visible=true;
			dg[0].Enabled=true;
			dg[0].MINH=dg[1].MINH;
			dg[0].inicializa2(ffotogramas,faproximadas,fapoyo,fgps);
			dg[0].SeleccionaIndice(0);
			if(altos[0]==0){
				altos[0]=0.3F;
				this.OnResize(EventArgs.Empty);
			}
		}
		void oculta_ficheros(){
			AGtodocalcular.Visible=false;
			dg[0].MINH=0;
			if(altos[0]!=0){
				altos[0]=0;
				this.OnResize(EventArgs.Empty);
			}
			dg[0].Enabled=false;
		}

	#region remuestra
		unsafe public delegate void delegado_remuestra(FicheroBnf* datos);
		unsafe public void Call_remuestra(FicheroBnf* datos){
			remuestra(datos);
			//System.IntPtr p= new IntPtr((void*)datos);
			//this.BeginInvoke(dRemuestra,new object[]{p});
		}
		unsafe public void remuestra(FicheroBnf* datos){
			asigna(datos);

			bdata1=false;
			dg[0].uni=varios.uni;
			dg[1].uni=varios.uni;

			dg[0].borra_tablas();
			dg[1].borra_tablas();
			//dg[0].DataGrid1.SuspendLayout();
			//dg[1].DataGrid1.SuspendLayout();
			dg[0].DataGrid1.DataSource=null;
			dg[1].DataGrid1.DataSource=null;
			rellena_datos();
			//dg[0].DataGrid1.ResumeLayout();
			//dg[1].DataGrid1.ResumeLayout();

			dg[1].inicializa2();
			dg[1].SeleccionaIndice(1);
			if(bdata1) muestra_ficheros();
			else oculta_ficheros();
			EnabledTrue();
		}

		//returns -1 if not found
		public int find_string(string[] names, string name){
			int i=0;
			while(names[i]!=null && String.Compare(names[i],name,true)!=0) i++;
			if(names[i]==null) return -1;
			return i;
		}
		unsafe public IntPtr get_pointer(string name, string[] names, NamedPointer* punteros){
			int i=find_string(names,name);
			if(i==-1) return IntPtr.Zero;
			else return new IntPtr((void*)punteros[i].p);
		}
		unsafe public uint get_entero(string name, string[] names, Namedn* enteros){
			int i=find_string(names,name);
			if(i==-1) return 0;
			else return enteros[i].n;
		}
		unsafe private void asigna(FicheroBnf *datos){
			string[] pointernames, enesnames;
			uint npunteros, nenteros;
			NamedPointer *ptrp=datos->punteros;
			Namedn *ptrn=datos->enes;
			while(ptrp->name!=(char*)0) ptrp++;
			npunteros=(uint)(ptrp-datos->punteros);
			while(ptrn->name!=(char*)0) ptrn++;
			nenteros=(uint)(ptrn-datos->enes);

			pointernames=new string[npunteros+1];
			enesnames=new string[nenteros+1];
			for(int i=0;i<npunteros;i++){
				pointernames[i]=Marshal.PtrToStringAnsi(new System.IntPtr((void*)datos->punteros[i].name));
			}
			pointernames[npunteros]=null;
			for(int i=0;i<nenteros;i++){
				enesnames[i]=Marshal.PtrToStringAnsi(new System.IntPtr((void*)datos->enes[i].name));
			}
			enesnames[nenteros]=null;

			//these are not needed
			//nombresf=get_pointer("Nombres fotogramas",pointernames,datos->punteros);
			//nombres=get_pointer("Nombres puntosf",pointernames,datos->punteros);
			//nombresA=get_pointer("Nombres puntosA",pointernames,datos->punteros);
			//nombresgpss=get_pointer("Nombres gpss",pointernames,datos->punteros);

			centros=get_pointer("CentrosProy",pointernames,datos->punteros);
			puntosM=get_pointer("PuntosModelo",pointernames,datos->punteros);
			puntosA=get_pointer("puntosApoyo",pointernames,datos->punteros);
			puntosC=get_pointer("puntosControl",pointernames,datos->punteros);
			gpss=get_pointer("gpss",pointernames,datos->punteros);
			grupos=get_pointer("GruposNAV",pointernames,datos->punteros);
			grupos_acum=get_pointer("Acumulado GruposNAV",pointernames,datos->punteros);
			grupocalc_a_orig=get_pointer("Calc_a_orig GruposNAV",pointernames,datos->punteros);
			mafp=get_pointer("observaciones",pointernames,datos->punteros);
			pC_a_pA=get_pointer("puntosC_a_puntosA",pointernames,datos->punteros);
			pC_a_pM=get_pointer("puntosC_a_PuntosM",pointernames,datos->punteros);
			pA_a_pM=get_pointer("puntosA_a_PuntosM",pointernames,datos->punteros);
			orden_cp=get_pointer("Orden CentrosProy",pointernames,datos->punteros);
			orden_pm=get_pointer("Orden PuntosM",pointernames,datos->punteros);
			p_cp_acum=get_pointer("Acumulado CentrosProy",pointernames,datos->punteros);
			p_en_cp=get_pointer("PuntoM_en_CentroProy",pointernames,datos->punteros);
			pm_ppios=get_pointer("Ppios PuntoM_en_CP",pointernames,datos->punteros);
			L=get_pointer("L puntosf",pointernames,datos->punteros);
			Lp=get_pointer("L puntosA",pointernames,datos->punteros);
			Lgps=get_pointer("L gpss",pointernames,datos->punteros);
			Lins=get_pointer("L inss",pointernames,datos->punteros);
			L_norm=get_pointer("Lnorm puntosf",pointernames,datos->punteros);
			Lp_norm=get_pointer("Lnorm puntosA",pointernames,datos->punteros);
			Lgps_norm=get_pointer("Lnorm gpss",pointernames,datos->punteros);
			Lins_norm=get_pointer("Lnorm inss",pointernames,datos->punteros);
			Lpc=get_pointer("L puntosC",pointernames,datos->punteros);
			Lpc_norm=get_pointer("Lnorm puntosC",pointernames,datos->punteros);

			nf=get_entero("n fotogramas",enesnames,datos->enes);
			ncp=get_entero("n CentrosProy",enesnames,datos->enes);
			npm=get_entero("n PuntosM",enesnames,datos->enes);
			npy=get_entero("n puntosA",enesnames,datos->enes);
			npcontrol=get_entero("n puntosC",enesnames,datos->enes);
			ngps=get_entero("n gpss",enesnames,datos->enes);
			//nins=get_entero("n inss",enesnames,datos->enes);
			ngruposGPS=get_entero("n gruposNAV",enesnames,datos->enes);
			ntot=get_entero("n observaciones",enesnames,datos->enes);

			varios=*datos->varios;
			if(varios.uni==1) ccpi=63.6619772368;
			else if(varios.uni==2) ccpi=57.2957795131;
			else ccpi=1.0;
			fccpi=(float)ccpi;
			calcula_decr();

			IntPtr Ptrf;
			Ptrf=(System.IntPtr)(void*)varios.ficherof;		if(Ptrf==IntPtr.Zero) ffotogramas=null;		else ffotogramas=Marshal.PtrToStringUni(Ptrf);
			Ptrf=(System.IntPtr)(void*)varios.ficheroapr;	if(Ptrf==IntPtr.Zero) faproximadas=null;	else faproximadas=Marshal.PtrToStringUni(Ptrf);
			Ptrf=(System.IntPtr)(void*)varios.ficheroapy;	if(Ptrf==IntPtr.Zero) fapoyo=null;			else fapoyo=Marshal.PtrToStringUni(Ptrf);
			Ptrf=(System.IntPtr)(void*)varios.ficherogps;	if(Ptrf==IntPtr.Zero) fgps=null;				else fgps=Marshal.PtrToStringUni(Ptrf);
		}
		void calcula_decr(){
			decr.im=decimales(0.8F*varios.apriori.im);
			if(decr.im<0) decr.im=0;
			else decr.im=(sbyte)-decr.im;

			float faux=varios.apriori.pXY;
			if(varios.apriori.pZ<faux) faux=varios.apriori.pZ;
			decr.p=decimales(faux*0.5F);
			if(decr.p<0) decr.p=0;
			else decr.p=(sbyte)-decr.p;

			faux=varios.apriori.gpsXY;
			if(varios.apriori.gpsZ<faux) faux=varios.apriori.gpsZ;
			decr.gps=decimales(faux*0.5F);
			if(decr.gps<0) decr.gps=0;
			else decr.gps=(sbyte)-decr.gps;

			decr.ins=-127;
		}

		static sbyte log10n_f(float x){
			if(x==0) return -127;
			if(x<0) x=-x;

			sbyte log=0;
			while(x<1){x*=10; log--;}
			if(x>=10){float y; for(y=10.0F; x>=y; y*=10,log++);}
			return log;
		}
		static sbyte decimales(float f){
			return (sbyte)-log10n_f(f/7);
		}

		unsafe private void rellena_datos(){
			System.IntPtr P_Tabla;
			BnfTabla_ResporFoto Tabla_res_porfoto;
			BnfTabla_ResporPunto Tabla_res_porpunto;
			BnfTabla_ResApoyo Tabla_res_apoyo;
			BnfTabla_ResGPS Tabla_res_gpsins;

			Tabla_res_porfoto.filas=(BnfFila_ResporFoto*)IntPtr.Zero.ToPointer();
			FuncionesC.rellena_res_porfotos(&Tabla_res_porfoto,decr.im,(byte)0,ncp,(uint*)orden_cp,(uint*)p_cp_acum,(int4*)mafp,(CentroProy*)centros,(PuntoM*)puntosM,(float*)L,(float*)L_norm,(uint*)pm_ppios,(PuntoM*)puntosA);
			DT_res_porfotos.BeginLoadData();
			{BnfFila_ResporFoto *pfila;
			pfila=Tabla_res_porfoto.filas;
			for(uint i=0;i<Tabla_res_porfoto.n;i++,pfila++){
				DataRow Rowaux=DT_res_porfotos.NewRow();
				Rowaux[0]=new String(pfila->f1_fotograma);
				Rowaux[1]=new String(pfila->f2_punto);
				Rowaux[2]=new String((sbyte*)&pfila->f3_resx);
				Rowaux[3]=new String((sbyte*)&pfila->f4_resy);
				Rowaux[4]=new String((sbyte*)&pfila->f5_tipo);
				Rowaux[5]=pfila->f6_res_norm_x;
				Rowaux[6]=pfila->f7_res_norm_y;
				Rowaux[7]=new String((sbyte*)&pfila->f8_aviso);
				Rowaux[8]=pfila->v_resx;
				Rowaux[9]=pfila->v_resy;
				Rowaux[10]=pfila->v_orden_def;
				Rowaux[11]=pfila->v_orden_res;
				Rowaux[12]=pfila->v_orden_res_norm;
				DT_res_porfotos.Rows.Add(Rowaux);
			}}
			DT_res_porfotos.EndLoadData();
			DT_res_porfotos.AcceptChanges();
			P_Tabla=(IntPtr)(void*)Tabla_res_porfoto.filas;
			if(P_Tabla!=IntPtr.Zero) FuncionesC.free_filas(P_Tabla);

			Tabla_res_porpunto.filas=(BnfFila_ResporPunto*)IntPtr.Zero.ToPointer();
			FuncionesC.rellena_res_porpuntos(&Tabla_res_porpunto,decr.im,(byte)0,npm,(uint*)orden_pm,(uint*)pm_ppios,(int2*)p_en_cp,(int4*)mafp,ntot,(CentroProy*)centros,(PuntoM*)puntosM,(float*)L,(float*)L_norm,(PuntoM*)puntosA);
			DT_res_porpuntos.BeginLoadData();
			{BnfFila_ResporPunto *pfila;
			pfila=Tabla_res_porpunto.filas;
			for(uint i=0;i<Tabla_res_porpunto.n;i++,pfila++){
				DataRow Rowaux=DT_res_porpuntos.NewRow();
				Rowaux[0]=new String(pfila->f1_punto);
				Rowaux[1]=new String(pfila->f2_fotograma);
				Rowaux[2]=new String((sbyte*)&pfila->f3_resx);
				Rowaux[3]=new String((sbyte*)&pfila->f4_resy);
				Rowaux[4]=pfila->f5_res_norm_x;
				Rowaux[5]=pfila->f6_res_norm_y;
				Rowaux[6]=pfila->v_resx;
				Rowaux[7]=pfila->v_resy;
				Rowaux[8]=pfila->v_orden_def;
				Rowaux[9]=pfila->v_orden_res;
				Rowaux[10]=pfila->v_orden_res_norm;
				DT_res_porpuntos.Rows.Add(Rowaux);
			}}
			DT_res_porpuntos.EndLoadData();
			DT_res_porpuntos.AcceptChanges();
			P_Tabla=(IntPtr)(void*)Tabla_res_porpunto.filas;
			if(P_Tabla!=IntPtr.Zero) FuncionesC.free_filas(P_Tabla);

			if(varios.ncalc.npy!=0 || npcontrol!=0){
				Tabla_res_apoyo.filas=(BnfFila_ResApoyo*)IntPtr.Zero.ToPointer();
				FuncionesC.rellena_res_apoyo(&Tabla_res_apoyo,decr.p,(PuntoM*)puntosA,npy,Convert.ToByte(varios.redun_parciales.apoyo!=0),(uint*)pA_a_pM,(float*)Lp,(float*)Lp_norm, (PuntoM*)puntosC,npcontrol,(uint*)pC_a_pM,(float*)Lpc,(float*)Lpc_norm);
				DT_res_apoyo.BeginLoadData();
				BnfFila_ResApoyo *pfila;
				pfila=Tabla_res_apoyo.filas;
				for(uint i=0;i<Tabla_res_apoyo.n;i++,pfila++){
					DataRow Rowaux=DT_res_apoyo.NewRow();
					Rowaux[0]=new String(pfila->f1_punto);
					Rowaux[1]=new String((sbyte*)&pfila->f2_resx);
					Rowaux[2]=new String((sbyte*)&pfila->f3_resy);
					Rowaux[3]=new String((sbyte*)&pfila->f4_resz);
					Rowaux[4]=pfila->f5_res_norm_x;
					Rowaux[5]=pfila->f6_res_norm_y;
					Rowaux[6]=pfila->f7_res_norm_z;
					Rowaux[7]=pfila->v_resx;
					Rowaux[8]=pfila->v_resy;
					Rowaux[9]=pfila->v_resy;
					Rowaux[10]=pfila->v_orden_def;
					Rowaux[11]=pfila->v_orden_res;
					Rowaux[12]=pfila->v_orden_res_norm;
					DT_res_apoyo.Rows.Add(Rowaux);
				}
				DT_res_apoyo.EndLoadData();
				DT_res_apoyo.AcceptChanges();
				P_Tabla=(IntPtr)(void*)Tabla_res_apoyo.filas;
				if(P_Tabla!=IntPtr.Zero) FuncionesC.free_filas(P_Tabla);
			}

			if(varios.ncalc.ngps!=0 || varios.ncalc.nins!=0){
				Tabla_res_gpsins.filas=(BnfFila_ResGPS*)IntPtr.Zero.ToPointer();
				FuncionesC.rellena_res_gpsins(&Tabla_res_gpsins,decr.gps,decr.ins,(GrupoGPSINS*)grupos,ngruposGPS,(uint*)grupos_acum,(PuntoGPSINS*)gpss,(float*)Lgps,(float*)Lgps_norm,(float*)Lins,(float*)Lins_norm,fccpi);
				DT_res_GPS.BeginLoadData();
				BnfFila_ResGPS *pfila;
				pfila=Tabla_res_gpsins.filas;
				for(uint i=0;i<Tabla_res_gpsins.n;i++,pfila++){
					DataRow Rowaux=DT_res_GPS.NewRow();
					string ss=new String(pfila->f1_grupo);
					if(ss.Length!=0) ss+=" - ...";
					Rowaux[0]=ss;
					Rowaux[1]=new String(pfila->f2_centroproy);
					Rowaux[2]=new String((sbyte*)&pfila->f3_resx);
					Rowaux[3]=new String((sbyte*)&pfila->f4_resy);
					Rowaux[4]=new String((sbyte*)&pfila->f5_resz);
					Rowaux[5]=new String((sbyte*)&pfila->f6_resw);
					Rowaux[6]=new String((sbyte*)&pfila->f7_resfi);
					Rowaux[7]=new String((sbyte*)&pfila->f8_resk);
					Rowaux[8]=pfila->f9_res_norm_x;
					Rowaux[9]=pfila->f10_res_norm_y;
					Rowaux[10]=pfila->f11_res_norm_z;
					Rowaux[11]=pfila->f12_res_norm_w;
					Rowaux[12]=pfila->f13_res_norm_fi;
					Rowaux[13]=pfila->f14_res_norm_k;
					DT_res_GPS.Rows.Add(Rowaux);
				}
				DT_res_GPS.EndLoadData();
				DT_res_GPS.AcceptChanges();
				P_Tabla=(IntPtr)(void*)Tabla_res_gpsins.filas;
				if(P_Tabla!=IntPtr.Zero) FuncionesC.free_filas(P_Tabla);
			}
		}
	#endregion

	#region Splitter
		protected override void OnResize(EventArgs e){
			if(dg!=null){
				height_tablas=this.ClientSize.Height-16;
				this.SuspendLayout();

				int itop=16;
				for(int i=0;i<ngrupos;i++){
					dg[i].Top=itop;
					itop=(int)(height_tablas*altos[i])+16;
					dg[i].Width=this.ClientSize.Width;
					dg[i].Height=itop-dg[i].Top;
				}
				this.ResumeLayout(false);
			}
			base.OnResize(e);
		}

		private void Splitters_MouseDown(object sender,MouseEventArgs e){
			if(e.Button!=MouseButtons.Left) return;
			int i;

			for(i=0;i<ngrupos;i++){
				if(sender.Equals(dg[i].Splitter1)) break;
			}
			split_i=i;
			split_y=e.Y;
			ss=true;
			if(dg[i].Height<dg[i].MINH && dg[i+1].Height<dg[i+1].MINH) ss=false;
		}

		private void Splitters_MouseMove(object sender,MouseEventArgs e)
		{
			if(ss==false) return;
			int dy;
			int i=split_i;

			dy=e.Y-split_y;
			if((dy<0 && dg[i].Height<=dg[i].MINH) || (dy>0 && dg[i+1].Height<=dg[i].MINH)){return;}
			altos[i]+=(float)dy/height_tablas;
			dg[i].Height=(int)(altos[i]*height_tablas)+16-dg[i].Top;
			dg[i+1].Top+=dy;
			dg[i+1].Height=(int)(altos[i+1]*height_tablas)+16-dg[i+1].Top;
		}

		private void Splitters_MouseUp(object sender,MouseEventArgs e)
		{
			ss=false;
		}
	#endregion

	#region Archivo
		private void ACerrar_Click(object sender,System.EventArgs e){
			int i,j;
			i=dg[0].tabControl1.SelectedIndex;
			j=dg[1].tabControl1.SelectedIndex;
			ffotogramas=""; faproximadas="";
			fapoyo=""; fgps="";
			dg[0].borra_tablas();	dg[0].DataGrid1.DataSource=null;
			dg[1].borra_tablas();	dg[1].DataGrid1.DataSource=null;
			dg[0].SeleccionaIndice(i);
			dg[1].SeleccionaIndice(i);
			EnabledFalse();
		}
		public void EnabledTrue(){
			ACerrar.Enabled=true;
			AGtodocalcular.Enabled=true;
			CEscalaRes.Enabled=true;
		}
		public void EnabledFalse(){
			ACerrar.Enabled=false;
			AGtodocalcular.Enabled=false;
			CEscalaRes.Enabled=false;
		}
		private void AAbrir_Click(object sender,System.EventArgs e){
			int nret;
			ahora_no_se_puede_cerrar=1;
			this.mensaje_estado=Globales.Textos.get_texto(Globales.Textos.Cods.Abriendo_un_fichero,idioma);

			if(ControlesAt.Methods.AAbrir(Open1,ref ConfigPrograma.OpenPath,get_texto(FilterBin),1)==null){
				ahora_no_se_puede_cerrar=0;
				return;
			}
			if(Open1.FilterIndex==1) nret=abre_ficherobnf(Open1.FileName);
			else nret=lee_otrofichero(Open1.FileName);
			if(nret==0){
				EnabledTrue();
				if(Open1.FilterIndex!=1) muestra_ficheros();
			}
		}
		private int abre_ficherobnf(string s){
			int nret=0;
			IntPtr P_fichero=Marshal.StringToHGlobalUni(s);

			ffotogramas=""; faproximadas="";
			fapoyo=""; fgps="";
			dg[0].borra_tablas();	dg[0].DataGrid1.DataSource=null;
			dg[1].borra_tablas();	dg[1].DataGrid1.DataSource=null;
			FicheroBnf datos;
			unsafe{
				int returned=FuncionesC.lee_ficherobnf(P_fichero,&datos);
				if(returned!=0){
					FuncionesC.free_plist(datos.plist);
					nret=1; goto @return;
				}
				try{remuestra(&datos);
					FuncionesC.free_plist(datos.plist);
				}catch(Exception){
					FuncionesC.free_plist(datos.plist);
					nret=1; goto @return;
				}
			}
			dg[1].inicializa2();
			dg[1].SeleccionaIndice(1);

			dg[0].borra_tablas();
			dg[0].DataGrid1.DataSource=null;
			dg[0].uni=varios.uni;
			rellena_ficheros();
			dg[0].inicializa2(ffotogramas,faproximadas,fapoyo,fgps);
			dg[0].SeleccionaIndice(0);

		@return:
			Marshal.FreeHGlobal(P_fichero);
			return nret;
		}

		private void AGtodocalcular_Click(object sender,System.EventArgs e){
			ahora_no_se_puede_cerrar=1;
			mensaje_estado=Globales.Textos.get_texto(Globales.Textos.Cods.Guardando_ficheros,idioma);
			bool b=dg[0].guardatodo();
			if(b){
				set_message(mensaje_pordefecto);
				MessageBoxAT.Show(get_texto(No_todos_guardados),Globales.Textos.YesNo(idioma),2);
				if(MessageBoxAT.returnedButton!=1){
					ahora_no_se_puede_cerrar=0;
					return;
				}
			}
			ahora_no_se_puede_cerrar=0;

			if(HazAlgo!=null) HazAlgo(this);
		}

		private void ASalir_Click(object sender,System.EventArgs e){
			if(cierra_todo()!=1) Application.Exit();
		}
	#endregion

	#region Configuracion
		private void CEscalaRes_Click(object sender,System.EventArgs e){
			if(dg[1].activa<0) return;
			FormEscalares1.Escalares.set_to_limits(dg[1].Tabinfo[dg[1].activa].format_Lnorm.limits.limits);
			FormEscalares1.Show();
		}
		private void EscalaRes_ValueChanged(object sender,EventArgs e){
			int i;
			unsafe{
				Limites=new float[FormEscalares1.Escalares.get_limites().Length+1];
				for(i=0;i<FormEscalares1.Escalares.get_limites().Length;i++)
					Limites[i]=FormEscalares1.Escalares.get_limites()[i];
				Limites[i]=float.PositiveInfinity;
			}
			if(dg[1].Tabinfo[dg[1].activa].format_Lnorm.limits.set_limits(Limites)){
				dg[1].DataGrid1.Refresh();
			}
		}
	#endregion

	#region rellena_defichero
		private void rellena_ficheros(){
			/*int nret;
			string mensaje;
			System.IntPtr P_mensaje=Marshal.AllocHGlobal(512);

			if(ffotogramas!=""){
				nret=cppwin32.Rellfichero_ficheros.fotogramas(DT_fotogramas,ffotogramas,P_mensaje,idioma);
				if(nret>0){
					mensaje=Marshal.PtrToStringUni(P_mensaje);
					MessageBoxAT.Show(mensaje);
				}
			}
			if(faproximadas!=""){
				nret=cppwin32.Rellfichero_ficheros.aproximadas(DT_aproximadas_pp,DT_aproximadas_ccpp,faproximadas,dg[0].uni,P_mensaje,idioma);
				if(nret>0){
					mensaje=Marshal.PtrToStringUni(P_mensaje);
					MessageBoxAT.Show(mensaje);
				}
			}
			if(fapoyo!=""){
				nret=cppwin32.Rellfichero_ficheros.apoyo(DT_apoyo,fapoyo,P_mensaje,idioma);
				if(nret>0){
					mensaje=Marshal.PtrToStringUni(P_mensaje);
					MessageBoxAT.Show(mensaje);
				}
			}
			if(fgps!=""){
				nret=cppwin32.Rellfichero_ficheros.gps(DT_GPS,fgps,dg[0].uni,P_mensaje,idioma);
				if(nret>0){
					mensaje=Marshal.PtrToStringUni(P_mensaje);
					MessageBoxAT.Show(mensaje);
				}
			}

			Marshal.FreeHGlobal(P_mensaje);*/
		}
	#endregion

		unsafe static String lee_string(System.IO.StreamReader fi){
			System.IntPtr idiota=Marshal.StringToHGlobalAnsi(new String((char)0,320));
			sbyte* palabra=(sbyte*)(idiota.ToPointer());
			sbyte c;
			int j;

			for(;;){
				c=(sbyte)fi.Peek();
				if(!(c==' ' || c=='\t' || c=='\n' || c==(char)13)) break;
				fi.Read();
			}
			for(j=0;j<319;j++){
				c=(sbyte)fi.Peek();
				if(c==-1 || c==' ' || c=='\t' || c=='\n' || c==(char)13) break;
				palabra[j]=c;
				fi.Read();
			}
			palabra[j]=(sbyte)0;
			String s=new String(palabra);
			Marshal.FreeHGlobal(idiota);
			return s;
		}
		byte selecciona_fichero(string ss){
			System.IO.StreamReader ff;
			byte r;
			string s;
			try{
				ff=new StreamReader(ss,System.Text.Encoding.Default);
			}catch(System.IO.FileNotFoundException){
				MessageBoxAT.Show(Globales.Textos.get_texto(16,ss,idioma)); return 255;
			}catch(System.IO.IOException){
				MessageBoxAT.Show(Globales.Textos.get_texto(15,ss,idioma)); return 255;
			}
			s="";
			while(ff.Peek()!=-1){
				s=lee_string(ff);
				if(s.Length>0 && s[0]=='-') break;
			}
			switch(s){
				case "-ff": return 0;
				case "-ccpp": return 1;
				case "-pp": r=1; break;
				case "-gps": case "-ins": case "-gpsins": return 3;
				default: return 255;
			}

			if(r==1){
				s=lee_string(ff);	//nombre
				s=lee_string(ff);	//X
				s=lee_string(ff);	//Y
				s=lee_string(ff);	//X
				s=lee_string(ff);	//marca
				switch(s.Length){
					case 1: return 1;
					case 3: return 2;
					default: return 255;
				}
			}
			return 255;
		}
		int lee_otrofichero(string s){
			byte r;
			int nret;
			//string mensaje;
			System.IntPtr P_mensaje=Marshal.AllocHGlobal(512);

			dg[0].DataGrid1.DataSource=null;
			r=selecciona_fichero(s);
			switch(r){
				/*case 0:
					dg[0].borra_fotogramas();
					nret=cppwin32.Rellfichero_ficheros.fotogramas(DT_fotogramas,s,P_mensaje,idioma);
					if(nret>1){
						mensaje=Marshal.PtrToStringUni(P_mensaje);
						MessageBoxAT.Show(mensaje);
					}
					if(nret==0) dg[0].inicializa2_fotogramas(s);
					else dg[0].inicializa2_fotogramas("");
					break;
				case 1:
					dg[0].borra_aproximadas();
					nret=cppwin32.Rellfichero_ficheros.aproximadas(DT_aproximadas_pp,DT_aproximadas_ccpp,s,dg[0].uni,P_mensaje,idioma);
					if(nret>1){
						mensaje=Marshal.PtrToStringUni(P_mensaje);
						MessageBoxAT.Show(mensaje);
					}
					if(nret==0) dg[0].inicializa2_aproximadas(s);
					else dg[0].inicializa2_aproximadas("");
					break;
				case 2:
					dg[0].borra_apoyo();
					nret=cppwin32.Rellfichero_ficheros.apoyo(DT_apoyo,s,P_mensaje,idioma);
					if(nret>1){
						mensaje=Marshal.PtrToStringUni(P_mensaje);
						MessageBoxAT.Show(mensaje);
					}
					if(nret==0) dg[0].inicializa2_apoyo(s);
					else dg[0].inicializa2_apoyo("");
					break;
				case 3:
					dg[0].borra_gps();
					nret=cppwin32.Rellfichero_ficheros.gps(DT_GPS,s,dg[0].uni,P_mensaje,idioma);
					if(nret>1){
						mensaje=Marshal.PtrToStringUni(P_mensaje);
						MessageBoxAT.Show(mensaje);
					}
					if(nret==0) dg[0].inicializa2_gps(s);
					else dg[0].inicializa2_gps("");
					break;*/
				default:
					nret=1; break;
			}
			Marshal.FreeHGlobal(P_mensaje);
			return nret;
		}

		protected override void colores(){
			base.colores();
		}

		protected override void update_idioma(){
			base.update_idioma();
			ParentForm.Text=get_texto(Caption);
			MessageBoxAT.Caption=get_texto(MsgCaption);
			AAcercade.Text=get_texto(Acercade);
			ManualPath=get_texto(Manualpath);
			FormAcercade1.titulo=get_texto(Acercade);
			FormAcercade1.cabecera=get_texto(FullTitle);
			AAbrir.Text=get_texto(Abrir);
			ACerrar.Text=get_texto(Cerrar);
			AGtodocalcular.Text=get_texto(GTodo);
			CEscalaRes.Text=get_texto(Escala_para_marcas);

			switch(idioma){
				case Globales.Idioma.Esp: FormAcercade1.fecha="15 de abril de 2012"; break;
				case Globales.Idioma.Eng: FormAcercade1.fecha="15th April, 2012"; break;
				case Globales.Idioma.It: FormAcercade1.fecha="15 aprile 2012"; break;
				default: goto case Globales.Idioma.Esp;
			}
			if(FormEscalares1.Visible) FormEscalares1.set_idioma(idioma);
		}

		private string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
