using System;
using System.Windows.Forms;
using System.Drawing;

namespace ControlesAt{
	public class FuncionesColor{
		public static Color color_to_Color(uint color){
			return Color.FromArgb((int)(color&0xFF),(int)(color>>8&0xFF),(int)(color>>16&0xFF));
		}
	}
	public class PanelColor : ContainerControl{
		Label R,G,B;
		ControlesAt.ByteUpDown UpDownRed, UpDownGreen, UpDownBlue;
		System.Windows.Forms.Label LabelColor;

	#region Variables
		private uint color;
		public uint Color{
			get{return color;}
			set{
				//color=value;	//Al cambiar los valores de los UpDown ya se actualiza
				UpDownBlue.Value=(byte)(value>>16);
				UpDownGreen.Value=(byte)(value>>8);
				UpDownRed.Value=(byte)value;
			}
		}
		public byte Red{
			get{return UpDownRed.Value;}
			set{UpDownRed.Value=value;}
		}
		public byte Green{
			get{return UpDownGreen.Value;}
			set{UpDownGreen.Value=value;}
		}
		public byte Blue{
			get{return UpDownBlue.Value;}
			set{UpDownBlue.Value=value;}
		}
	#endregion

		public PanelColor(){
			InitializeComponent();
			this.UpDown_Changed(this, EventArgs.Empty);
		}

	#region InitializeComponent
		private void InitializeComponent(){
			LabelColor=new Label();
			UpDownRed=new ByteUpDown();
			UpDownGreen=new ByteUpDown();
			UpDownBlue=new ByteUpDown();
			R=new Label();
			G=new Label();
			B=new Label();
			//
			//LabelColor
			LabelColor.Location=new Point(0,20);
			LabelColor.Size=new Size(24,24);
			LabelColor.TabIndex=0;
			//
			//UpDownRed
			UpDownRed.Location=new Point(52,0);
			UpDownRed.Value=200;
			UpDownRed.TabIndex=1;
			UpDownRed.ValueChanged+=new EventHandler(UpDown_Changed);
			//
			//UpDownGreen
			UpDownGreen.Location=new Point(52,24);
			UpDownGreen.Value=200;
			UpDownGreen.TabIndex=2;
			UpDownGreen.ValueChanged+=new EventHandler(UpDown_Changed);
			//
			//UpDownBlue
			UpDownBlue.Location=new Point(52,48);
			UpDownBlue.Value=200;
			UpDownBlue.TabIndex=3;
			UpDownBlue.ValueChanged+=new EventHandler(UpDown_Changed);
			//
			//R, G, B
			R.Location=new Point(36,0);
			R.Size=new Size(16,20);
			R.Text="R:";
			R.TextAlign=ContentAlignment.MiddleRight;

			G.Location=new Point(36,24);
			G.Size=new Size(16,20);
			G.Text="G:";
			G.TextAlign=ContentAlignment.MiddleRight;

			B.Location=new Point(36,48);
			B.Size=new Size(16,20);
			B.Text="B:";
			B.TextAlign=ContentAlignment.MiddleRight;
			//
			//this
			this.Controls.Add(this.LabelColor);
			this.Controls.Add(this.UpDownRed);
			this.Controls.Add(this.UpDownGreen);
			this.Controls.Add(this.UpDownBlue);
			this.Controls.Add(this.R);
			this.Controls.Add(this.G);
			this.Controls.Add(this.B);
		}
		protected override Size DefaultSize{
			get	{return new Size(100,68);}
		}

	#endregion

		void UpDown_Changed(Object sender,System.EventArgs e)
		{
			color=((uint)UpDownBlue.Value<<16) | ((uint)UpDownGreen.Value<<8) | ((uint)UpDownRed.Value);
			//LabelColor.BackColor=System.Drawing.Color.FromArgb(0xFF000000 | (int)color);	//Va al revs
			LabelColor.BackColor=System.Drawing.Color.FromArgb(UpDownRed.Value,UpDownGreen.Value,UpDownBlue.Value);
		}
	}
}