using System;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.IO;
using ControlesAt;
using static Globales.FileTypes;

namespace Calibracion{
using static Calibracion.Textos.Cods;
	unsafe public struct Enlaces{
		public void*	EnlaceGrafico,
						EnlaceEdTexto;
	}
	internal struct ConfiguracionPrograma{
		public string OpenPath;
		public string OpenConfigPath;
	}
	public delegate string GetFromArray(int i);

	public class LblParametros : LabelLabel{
		public LblParametros(){
			this.T.Font= new Font("Verdana", 9F);
			this.T.Size= new Size(24, 16);
			this.Cursor= Cursors.Hand;
			this.ForeColor= Color.Blue;
			this.L.Click+= new EventHandler(this.internalClick);
		}
	}

	internal class ControlDextrogiro : Control{
		protected override Size DefaultSize{
			get{return new Size(27,27);}
		}
		protected override void OnPaint(PaintEventArgs e){
			base.OnPaint (e);
			System.Drawing.Pen p;
			p= new Pen(this.ForeColor,1);
			e.Graphics.DrawLine(p,0,0,2,2);		e.Graphics.DrawLine(p,0,4,4,0);
			e.Graphics.TranslateTransform(0,7);
			e.Graphics.DrawLine(p,0,2,2,0);		e.Graphics.DrawLine(p,2,0,4,2);
			e.Graphics.DrawLine(p,2,0,2,17);
			e.Graphics.DrawLine(p,2,17,19,17);
			e.Graphics.DrawLine(p,17,15,19,17);	e.Graphics.DrawLine(p,19,17,17,19);
			//
			e.Graphics.DrawLine(p,22,15,26,19);	e.Graphics.DrawLine(p,22,19,26,15);
			p.Dispose();
		}
	}
	internal class ControlLevogiro : Control{
		protected override Size DefaultSize{
			get{return new Size(27,27);}
		}
		protected override void OnPaint(PaintEventArgs e){
			base.OnPaint (e);
			System.Drawing.Pen p;
			p= new Pen(this.ForeColor,1);
			e.Graphics.DrawLine(p,2,2,19,2);
			e.Graphics.DrawLine(p,17,0,19,2);	e.Graphics.DrawLine(p,19,2,17,4);
			e.Graphics.DrawLine(p,2,2,2,20);
			e.Graphics.DrawLine(p,0,18,2,20);		e.Graphics.DrawLine(p,2,20,4,18);
			//
			e.Graphics.DrawLine(p,22,0,26,4);	e.Graphics.DrawLine(p,22,4,26,0);
			e.Graphics.DrawLine(p,0,22,2,24);	e.Graphics.DrawLine(p,0,26,4,22);
			p.Dispose();
		}
	}
	/// <summary>
	/// Descripcin breve de PanelCalibracion.
	/// </summary>
	public class PanelCalibracion : PanelesSub.PanelSubordinado, ControlesAt.IIdioma
	{
		internal class TextoParametros : System.Windows.Forms.ContainerControl{
			protected ControlesAt.LabelRight Label, Texto;
			public TextoParametros(){
				Label=new LabelRight();
				Texto=new LabelRight();
			}
			protected override Size DefaultSize{
				get{return new Size(100,18);}
			}
		}
		private System.Windows.Forms.MenuItem	CSalida,
															CSGrafico,	CSSimbolos;
		private ControlesAt.LabelTxtBotAbrir	TxtBotfot,	TxtBotapy;
		private ControlesAt.Labeltf		Tffot,	Tfapy;
		private System.Windows.Forms.ComboBox ComboBox1;

	private System.Windows.Forms.GroupBox GroupBox1;
		private ControlesAt.BaseLabel Label3;
		private ControlesAt.BaseLabel Label_1, Labelfpp, LabelExt;
		private ControlesAt.Botonppp Bot1, Botfpp, BotExt;
		private System.Windows.Forms.CheckBox	Chk_1;

		private System.Windows.Forms.GroupBox GBoxdistorsion;
		private ControlesAt.BaseLabel		Label_distorsion;
		private System.Windows.Forms.CheckBox	Chkdistorsion;
		private ControlesAt.LabelRight Label12;
		internal System.Windows.Forms.ComboBox CBoxpoli;
		private ControlesAt.NoControl Label5, Label6;
		private ControlesAt.LTFloatPosSingle Textsemidiag;
		private ControlesAt.ChkSalida Chkradial, Chktangencial;
		private ControlesAt.LabelCheck Chkasim;
		internal System.Windows.Forms.ComboBox CBoxasim;
		private System.Windows.Forms.ContainerControl PanelAsim;
		private LblParametros	lbl_radsim,	lbl_tansim,
									lbl_radasim,	lbl_tanasim,
									lbl_uvserie1,	lbl_uvserie2;

		internal ControlesAt.BotAceptar Calcular;
		private System.Windows.Forms.OpenFileDialog Open1;
		private System.Windows.Forms.SaveFileDialog SaveConfig;
		private System.Windows.Forms.OpenFileDialog OpenConfig;
		private System.Windows.Forms.MenuItem AAbrirConfig,	AGuardarConfig;
		internal Formr1 FormR1;
		internal Formpixel Formpixel1;
		internal FormCal1 FCal1;
		internal FormCalfpp FInterna1;
		internal FormCalExterna FExterna1;

	#region Variables
		private bool idioma_read;
		internal Enlaces enlaces;
		internal ConfiguracionPrograma ConfigPrograma;

		private FormSimetrica FRadial1, FTangencial1;
		private FormAsimetricaRadTan FAsimetricaRad1;
		private FormAsimetricaRadTan FAsimetricaTan1;
		private FormAsimetricauv FAsimetricauvserie1;
		private FormAsimetricauv FAsimetricauvserie2;
		private FormSalidaCalgra FormSalidagra1;
		private ControlesAt.FormUnidades_pft FUni1;

		string[] configuraciones_nombres; //8
		string[] configuraciones_paths;	//8
		int iconfig, nconfig;
		const int nconfig_internas=3;
		bool llamada_Combo1;

		char[] separadores={' ','\t'};
		string[] config_radsim;
		string[] config_otras;
		internal InterComCalibracion.CConfigGrafico CGrafico;
		internal InterComCalibracion.ConfigSalida Salida;
		internal ControlesAt.ThreeStrings suni;
	#endregion

	#region Inicializacin
		unsafe public PanelCalibracion(PanelesSub.Duenno _owner, Globales.Idioma idioma_inicial, IntPtr _enlaces) : base(_owner,idioma_inicial){
			enlaces.EnlaceGrafico=(void*)0;
			enlaces.EnlaceEdTexto=(void*)0;
			if(_enlaces!=IntPtr.Zero){
				void** enl=(void**)_enlaces.ToPointer();
				for(;*enl!=(void*)0;enl++){
					char* nom=PanelesSub.varias.get_enlace_nombre(*enl);
					string nombre=new String(nom);
					switch(nombre){
						case "Grafico": enlaces.EnlaceGrafico=*enl; break;
						case "EditordeTexto": enlaces.EnlaceEdTexto=*enl; break;
					}
				}
			}
			InitializeComponent();
		}
		unsafe public PanelCalibracion() : base(){
			enlaces.EnlaceGrafico=(void*)0;
			enlaces.EnlaceEdTexto=(void*)0;
			InitializeComponent();
		}
		protected override void inizializeb(string[] argv){
			AppData=Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData)+"\\Aerotri\\";
			if(!System.IO.Directory.Exists(AppData)) System.IO.Directory.CreateDirectory(AppData);
			icono= new System.Drawing.Icon(System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("Calibracion.IconCalibracion.ico"));
			ParentForm.AcceptButton=this.Calcular;

			//Los encapsulados
			suni=new ThreeStrings();
			CGrafico=new InterComCalibracion.CConfigGrafico();

			FCal1= new FormCal1(this);
			FInterna1= new FormCalfpp(this);
			FExterna1= new FormCalExterna(this);
			FormR1= new Formr1();
			Formpixel1= new Formpixel(this);
			FRadial1=new FormSimetrica(this,1,"a",false);
			FRadial1.Icon=icono;
			FTangencial1=new FormSimetrica(this,2,"b",false);
			FTangencial1.Icon=icono;
			FAsimetricaRad1=new FormAsimetricaRadTan(this,1,"c",false);
			FAsimetricaRad1.Icon=icono;
			FAsimetricaTan1=new FormAsimetricaRadTan(this,2,"d",false);
			FAsimetricaTan1.Icon=icono;
			FAsimetricauvserie1=new FormAsimetricauv(this,1,"c",false);
			FAsimetricauvserie1.Icon=icono;
			FAsimetricauvserie2=new FormAsimetricauv(this,2,"d",false);
			FAsimetricauvserie2.Icon=icono;
			FormSalidagra1=new FormSalidaCalgra(this,this.ParentForm,CGrafico);
			FUni1=new FormUnidades_pft(this, this.ParentForm,suni);
			FormAcercade1=new ControlesAt.FormAcercade(typeof(PanelCalibracion),idioma);
			FormAcercade1.Icon=icono;
			FormAcercade1.LabelIcono.Image=icono.ToBitmap();

			FCal1.Owner=ParentForm;
			FInterna1.Owner=ParentForm;
			FExterna1.Owner=ParentForm;
			FormR1.Owner=ParentForm;
			Formpixel1.Owner=ParentForm;
			FRadial1.Owner=ParentForm;
			FTangencial1.Owner=ParentForm;
			FAsimetricaRad1.Owner=ParentForm;
			FAsimetricaTan1.Owner=ParentForm;
			FAsimetricauvserie1.Owner=ParentForm;
			FAsimetricauvserie2.Owner=ParentForm;
			FormSalidagra1.Owner=ParentForm;
			FUni1.Owner=ParentForm;
			FormAcercade1.Owner=ParentForm;

			//Chk1
			FCal1.Chk1Tx.CheckedChanged+= new EventHandler(Chk1Tx_CheckedChanged);
			FCal1.Chk1Ty.CheckedChanged+= new EventHandler(Chk1Ty_CheckedChanged);
			FCal1.Chk1k.CheckedChanged+= new EventHandler(Chk1k_CheckedChanged);
			FCal1.Chk1esc.CheckedChanged+= new EventHandler(Chk1esc_CheckedChanged);
			FCal1.Chk1escy.CheckedChanged+= new EventHandler(Chk1escy_CheckedChanged);
			FCal1.Chk1delta.CheckedChanged+= new EventHandler(Chk1delta_CheckedChanged);
			//ChkInterna
			FInterna1.ChkInternaf.CheckedChanged+= new EventHandler(ChkInternaf_CheckedChanged);
			FInterna1.ChkInternax.CheckedChanged+= new EventHandler(ChkInternax_CheckedChanged);
			FInterna1.ChkInternay.CheckedChanged+= new EventHandler(ChkInternay_CheckedChanged);
			FInterna1.List1.SelectedIndexChanged+= new EventHandler(List1_SelectedIndexChanged);
			//ChkExterna
			FExterna1.ChkExternaW.CheckedChanged+= new EventHandler(ChkExternaW_CheckedChanged);
			FExterna1.ChkExternaFI.CheckedChanged+= new EventHandler(ChkExternaFI_CheckedChanged);
			FExterna1.ChkExternak.CheckedChanged+= new EventHandler(ChkExternak_CheckedChanged);

			config_radsim=new string[2];
			config_radsim[0]="Impar";
			config_radsim[1]="Completo";

			config_otras=new string[2];
			config_otras[0]="Radial / tangencial";
			config_otras[1]="Vector giratorio";

			colores();
			set_cfg_defecto();

			idioma_read=false;
			CGrafico.S.ny=CGrafico.S.nx=21;
			CGrafico.S.rednx=CGrafico.S.redny=6;
			CGrafico.S.npx=CGrafico.S.npy=21;
			lee_ficheroConfiguracion("Calibracion.config");
			if(!idioma_read && Myowner.modo==0){
				idioma_read=PanelesSub.varias.read_reg_language("Aerotri","InstallLanguage",ref base.idioma);
			}

			update_idioma();
			set_idioma(idioma);
		}

		void set_cfg_defecto(){
			iconfig=3;
			nconfig=8;
			configuraciones_nombres=new string[8];
			configuraciones_paths=new string[8];
			configuraciones_nombres[0]= "Fotocoordenadas";
			configuraciones_nombres[1]= "Pixeles_mm";
			configuraciones_nombres[2]= "Pixeles_micras";
			configuraciones_nombres[3]= "Pixeles_pixeles";
			configuraciones_paths[0]= Application.StartupPath + "\\Configuraciones\\Calibracion\\Fotocoordenadas.cfg";
			configuraciones_paths[1]= Application.StartupPath + "\\Configuraciones\\Calibracion\\Pixeles_mm.cfg";
			configuraciones_paths[2]= Application.StartupPath + "\\Configuraciones\\Calibracion\\Pixeles_micras.cfg";
			configuraciones_paths[3]= Application.StartupPath + "\\Configuraciones\\Calibracion\\Pixeles_pixeles.cfg";
			ComboBox1.Items.Add("Fotocoordenadas");
			ComboBox1.Items.Add("Pxeles / mm");
			ComboBox1.Items.Add("Pxeles / micras");
			ComboBox1.Items.Add("Pxeles / pxeles");

			Chk_1.Checked=false;
			Bot1.Enabled=false;
			FCal1.Optlevo.Checked=true;
			FCal1.Txtpixel_x.Text=FCal1.Txtpixel_y.Text="1";
			FCal1.Chk1Tx.Checked=true;
			FCal1.Chk1Ty.Checked=true;
			for(int i=0;i<6;i++)
				FExterna1.ChkExterna[i].Checked=true;
			FInterna1.ChkInterna[0].Checked=true;
			FInterna1.ChkInterna[1].Checked=true;
			FInterna1.ChkInterna[2].Checked=true;
			FInterna1.List1.SelectedIndex=0;

			llamada_Combo1=true;
				ComboBox1.SelectedIndex=0;
			llamada_Combo1=false;
			CBoxpoli.SelectedIndex=1;
			Chkradial.Checked=true;
			Chktangencial.Checked=true;
			Chkasim.Checked=true;

			this.FRadial1.checkboxes[4].Checked=true;
			lbl_radsim.T.Text="3";

			CBoxasim.SelectedIndex=0;
			FAsimetricaRad1.checkboxes[1].Enabled=false;
			FAsimetricaRad1.checkboxes[2].Enabled=false;
			FAsimetricaRad1.checkboxes[3].Checked=true;
			FAsimetricaRad1.checkboxes[4].Checked=true;
			FAsimetricaRad1.checkboxes[5].Checked=true;
			FAsimetricaRad1.checkboxes[6].Checked=true;
			FAsimetricaTan1.checkboxes[1].Checked=true;
			FAsimetricaTan1.checkboxes[2].Checked=true;
			FAsimetricaTan1.checkboxes[3].Checked=true;
			FAsimetricaTan1.checkboxes[4].Checked=true;
			FAsimetricaTan1.checkboxes[5].Checked=true;
			FAsimetricaTan1.checkboxes[6].Checked=true;
			lbl_radasim.T.Text="4";
			lbl_tanasim.T.Text="6";
			FAsimetricauvserie1.checkboxes[1].Enabled=false;
			FAsimetricauvserie1.checkboxes[2].Enabled=false;
			FAsimetricauvserie1.checkboxes[3].Checked=true;
			FAsimetricauvserie1.checkboxes[4].Checked=true;
			FAsimetricauvserie1.checkboxes[5].Checked=true;
			FAsimetricauvserie1.checkboxes[6].Checked=true;
			FAsimetricauvserie2.checkboxes[1].Checked=true;
			FAsimetricauvserie2.checkboxes[2].Checked=true;
			FAsimetricauvserie2.checkboxes[3].Checked=true;
			FAsimetricauvserie2.checkboxes[4].Checked=true;
			FAsimetricauvserie2.checkboxes[5].Checked=true;
			FAsimetricauvserie2.checkboxes[6].Checked=true;
			lbl_uvserie1.T.Text="4";
			lbl_uvserie2.T.Text="6";

			suni.p="mm";
			suni.f="mm";
			suni.t="m";
			Tffot.Indice=0;
			Tfapy.Indice=0;
		}

		protected override void lee_ficheroConfiguracion(string nombre){
			base.lee_ficheroConfiguracion(nombre);
			ConfigPrograma.OpenPath=__OpenPath;
			ConfigPrograma.OpenConfigPath=AppData + "Configuraciones\\Calibracion";
		}
		protected override void procesa_linea_config(string tipo, string[] palabras){
			if(!idioma_read) if(tipo=="Idioma") idioma_read=true;
			base.procesa_linea_config (tipo, palabras);
		}
	#endregion

	#region InitializeComponent
		private void InitializeComponent(){
			AAbrirConfig= new MenuItem();
			AGuardarConfig= new MenuItem();
			CSalida= new MenuItem();
			CSGrafico= new MenuItem();
			CSSimbolos= new MenuItem();
			ComboBox1= new ComboBox();
			TxtBotapy= new LabelTxtBotAbrir(132);
			TxtBotfot= new LabelTxtBotAbrir(132);
			Tffot= new Labeltf(Filtros[TipoFiltro.FotogramasLeer]);
			Tfapy=new Labeltf(Filtros[TipoFiltro.PuntosTodos]);
		GroupBox1= new GroupBox();
			Label3= new BaseLabel();
			Chk_1= new CheckBox();
			Label_1= new BaseLabel();	Bot1=new Botonppp();
			Labelfpp= new BaseLabel();	Botfpp=new Botonppp();
			LabelExt=new BaseLabel();	BotExt=new Botonppp();
			GBoxdistorsion= new GroupBox();
			   Label_distorsion= new BaseLabel();   Chkdistorsion= new CheckBox();
				Textsemidiag= new LTFloatPosSingle(36,(short)4);
				Label12= new LabelRight();			CBoxpoli= new ComboBox();
				Label5= new NoControl();
				Label6= new NoControl();
				Chkradial= new ChkSalida();			lbl_radsim= new LblParametros();
				Chktangencial= new ChkSalida();		lbl_tansim= new LblParametros();
				lbl_radsim.TextWidth=16;
				lbl_tansim.TextWidth=16;
				Chkasim= new LabelCheck();
				CBoxasim= new ComboBox();
				PanelAsim= new ContainerControl();
				lbl_radasim= new LblParametros();		lbl_tanasim= new LblParametros();
				lbl_uvserie1= new LblParametros();		lbl_uvserie2= new LblParametros();
			Calcular= new BotAceptar();
			Open1= new OpenFileDialog();
			SaveConfig= new SaveFileDialog();
			OpenConfig= new OpenFileDialog();
			//
			// MenuArchivo
			//
			MenuArchivo.MenuItems.AddRange(new MenuItem[] {AAbrirConfig,
																				AGuardarConfig});
			//
			// AAbrirConfig
			AAbrirConfig.Index= 0;
			AAbrirConfig.Click+= new EventHandler(AAbrirConfig_Click);
			//
			// AGuardarConfig
			AGuardarConfig.Index= 1;
			AGuardarConfig.Click+= new EventHandler(AGuardarConfig_Click);
			//
			// MenuConfiguracion
			//
			MenuConfiguracion.MenuItems.AddRange(new MenuItem[]{CSalida});
			//
			// CSalida
			CSalida.Index= 1;
			CSalida.MenuItems.AddRange(new MenuItem[]{	CSGrafico,
																		CSSimbolos});
			//
			// CSGrafico, CSSimbolos
			CSGrafico.Index=0;		CSGrafico.Click+=new EventHandler(CSGrafico_Click);
			CSSimbolos.Index=1;	CSSimbolos.Click+=new EventHandler(CSSimbolos_Click);
			//
			// ComboBox1
			//
			ComboBox1.DropDownStyle= ComboBoxStyle.DropDownList;
			ComboBox1.Location= new Point(4, 24);
			ComboBox1.Size= new Size(140, 21);
			ComboBox1.TabIndex= 0;
			ComboBox1.SelectedIndexChanged+= new EventHandler(ComboBox1_SelectedIndexChanged);
			//
			// TxtBotfot, apy
			//
			TxtBotfot.TextLocation= new Point(232, 28);		TxtBotfot.TabIndex= 1;		TxtBotfot.Click+= new EventHandler(Botabrirfot_Click);
			TxtBotapy.TextLocation= new Point(420, 28);		TxtBotapy.TabIndex= 2;		TxtBotapy.Click+= new EventHandler(Botabrirapy_Click);
			//
			// Tffot, apy
			//
			Tffot.Location= new Point(172, 56);		Tffot.Width= 92;		Tffot.TabIndex= 3;
			Tfapy.Location= new Point(368, 56);	Tfapy.Width= 92;		Tfapy.TabIndex= 4;
			//
			// GroupBox1
			//
			GroupBox1.FlatStyle= FlatStyle.System;
			GroupBox1.Location= new Point(4, 88);
			GroupBox1.Size= new Size(272, 208);
			GroupBox1.TabIndex=5;
			//
			Label3.RefLocation=new Point(12,20);
			Label3.MaxWidth= 252;
			int pos=68;
			//
			Chk_1.Location= new Point(12,pos-2);
			Chk_1.Size= new Size(16,16);
			Chk_1.CheckedChanged+= new EventHandler(Chk_1_CheckedChanged);
			//
			Label_1.RefLocation=new Point(32,pos);		Bot1.Location=new Point(220,pos-2);		pos+=36;
			Labelfpp.RefLocation=new Point(32,pos);		Botfpp.Location=new Point(220,pos-2);		pos+=36;
			LabelExt.RefLocation=new Point(32,pos);		BotExt.Location=new Point(220,pos-2);		pos+=36;
			//
			Bot1.Click+=new EventHandler(Bot1_Click);
			Botfpp.Click+=new EventHandler(Botfpp_Click);
			BotExt.Click+=new EventHandler(BotExt_Click);
			//
			GroupBox1.Controls.AddRange(new Control[]{
				Label3,
				Chk_1,	Label_1,	Bot1,
				Labelfpp,		Botfpp,
				LabelExt,		BotExt
			});
			//
			// Chkdistorsion
			//
			{Margenes prov=Label_distorsion.Margins;
			Label_distorsion.Margins=new Margenes(prov.Left,prov.Right+2,prov.Top,prov.Bottom);}
			Label_distorsion.RefLocation= new Point(298,89);
			Chkdistorsion.Checked= true;
			Chkdistorsion.Top= 88;
			Chkdistorsion.Size= new Size(16, 16);
			Chkdistorsion.TabIndex= 15;
			Chkdistorsion.CheckedChanged+= new EventHandler(Chkdistorsion_CheckedChanged);
			//
			// GBoxdistorsion
			//
			GBoxdistorsion.Controls.AddRange(new Control[]{
				Textsemidiag,
				Label12,		CBoxpoli,
				Label5,		Label6,
				Chkradial,		lbl_radsim,
				Chktangencial,	lbl_tansim,
				Chkasim,		CBoxasim,
				PanelAsim
			});
			GBoxdistorsion.FlatStyle= FlatStyle.System;
			GBoxdistorsion.Location= new Point(284, 88);
			GBoxdistorsion.Width= 264;
			GBoxdistorsion.TabIndex= 16;
			//
			// Textsemidiag
			Textsemidiag.TextLocation= new Point(188, 26);		Textsemidiag.TabIndex= 0;
			//
			// CBoxpoli
			//
			Label12.RefLocation= new Point(114,68);	Label12.TabIndex=1;
			//
			CBoxpoli.DropDownStyle= ComboBoxStyle.DropDownList;
			CBoxpoli.Items.AddRange(new object[]{"Impar",
															"Completo"});
			CBoxpoli.Location= new Point(120, 54);
			CBoxpoli.Size= new Size(124, 21);
			CBoxpoli.TabIndex= 2;
			//
			// Label5, 6
			//
			Label5.Location= new Point(11,92);		Label5.Size= new Size(GBoxdistorsion.Width-23,1);
			Label6.Location= new Point(11,93);		Label6.Size= Label5.Size;
			Label5.BackColor= SystemColors.ControlDark;
			Label6.BackColor= Color.White;
			//
			// lbl_radsim
			//
			lbl_radsim.TextLocation= new Point(112, 110);
			lbl_radsim.TabIndex= 4;
			lbl_radsim.T.Text= "3";
			lbl_radsim.Click+= new EventHandler(Lblradsim_Click);
			//
			//Chkradial
			Chkradial.Location= new Point(4, lbl_radsim.Location.Y+1);
			Chkradial.TabIndex= 3;
			Chkradial.BorderStyle= ChkSalida.ExtendedBorderStyle.Alternating3D;
			Chkradial.CheckedChanged+= new EventHandler(Chkradial_CheckedChanged);
			//
			//Chktangencial
			Chktangencial.Location= new Point(140, Chkradial.Top);
			Chktangencial.TabIndex= 8;
			Chktangencial.BorderStyle= ChkSalida.ExtendedBorderStyle.Alternating3D;
			Chktangencial.CheckedChanged+= new EventHandler(Chktangencial_CheckedChanged);
			//
			// lbl_tansim
			//
			lbl_tansim.TextLocation= new Point(244, lbl_radsim.Top);
			lbl_tansim.TabIndex= 9;
			lbl_tansim.T.Text= "3";
			lbl_tansim.Enabled=false;
			lbl_tansim.Click+= new EventHandler(Lbltansim_Click);
			//
			// Chkasim
			//
			Chkasim.TextLocation= new Point(92, 148);		Chkasim.TabIndex= 10;
			Chkasim.CheckedChanged+= new EventHandler(Chkasim_CheckedChanged);
			//
			// CBoxasim
			//
			CBoxasim.DropDownStyle= ComboBoxStyle.DropDownList;
			CBoxasim.Items.AddRange(new object[] {	"Radial / tangencial",
																"Vector giratorio"});
			CBoxasim.Location= new Point(132, Chkasim.Top);
			CBoxasim.Size= new Size(120, 21);
			CBoxasim.DropDownWidth= 120;
			CBoxasim.TabIndex= 11;
			CBoxasim.Enabled=false;
			CBoxasim.SelectedIndexChanged+= new EventHandler(CBoxasim_SelectedIndexChanged);
			//
			// PanelAsim
			//
			PanelAsim.Location=new Point(4,Chkasim.Top+20);
			PanelAsim.Size=new Size(GBoxdistorsion.Width-8,32);
			PanelAsim.Enabled=false;
			PanelAsim.Controls.AddRange(new Control[]{
				lbl_radasim,	lbl_tanasim,
				lbl_uvserie1,	lbl_uvserie2,
			});
			PanelAsim.TabIndex= 12;
			//
			// lbl_radasim
			//
			lbl_radasim.TextLocation= new Point(80, 8);
			lbl_radasim.TabIndex= 0;
			lbl_radasim.Click+= new EventHandler(Lblradasim_Click);
			//
			// lbl_tanasim
			//
			lbl_tanasim.TextLocation= new Point(216, 8);
			lbl_tanasim.TabIndex= 1;
			lbl_tanasim.Click+= new EventHandler(Lbltanasim_Click);
			//
			// lbl_uvserie1
			//
			lbl_uvserie1.TextLocation= new Point(80, 8);
			lbl_uvserie1.TabIndex= 0;
			lbl_uvserie1.Click+= new EventHandler(Lbluvserie1_Click);
			//
			// lbl_uvserie2
			//
			lbl_uvserie2.TextLocation= new Point(216, 8);
			lbl_uvserie2.TabIndex= 1;
			lbl_uvserie2.Click+= new EventHandler(Lbluvserie2_Click);
			//
			GBoxdistorsion.Height=PanelAsim.Bottom+8;
			//
			// Calcular
			//
			Calcular.Font= new Font("Microsoft Sans Serif", 8F);
			Calcular.Location= new Point(252, GBoxdistorsion.Bottom+14);
			Calcular.Size= new Size(58, 24);
			Calcular.TabIndex= 39;
			Calcular.Click+= new EventHandler(Calcular_Click);
			//
			// PanelCalibracion
			//
			this.Controls.AddRange(new Control[]{
				ComboBox1,		Tffot, TxtBotfot,		Tfapy, TxtBotapy
			});
			this.Controls.Add(Chkdistorsion);
			this.Controls.Add(Label_distorsion);
			this.Controls.Add(this.GBoxdistorsion);
			this.Controls.Add(this.GroupBox1);
			this.Controls.Add(Calcular);
		}
		protected override Size DefaultSize{
			get{return new Size(560, 350);}
		}

	#endregion

		protected override int cierra_todo(){
			guarda_ficheroConfiguracion("Calibracion.config");
			return 0;
		}
		protected override void escribe_fConfiguracion(StreamWriter fconfig){
			base.escribe_fConfiguracion_comienzo(fconfig);
			fconfig.WriteLine("OpenPath \"" + ConfigPrograma.OpenPath +"\"");
			fconfig.WriteLine("OpenConfigPath \"" + ConfigPrograma.OpenConfigPath +"\"");
		}

	#region Abrir
		void Botabrirfot_Click(object sender,System.EventArgs e){
			ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotfot.T,Tffot,Open1,ref ConfigPrograma.OpenPath, buildfiltro(TipoFiltro.FotogramasLeer,idioma));
			ahora_no_se_puede_cerrar=0;
		}
		void Botabrirapy_Click(object sender,System.EventArgs e){
			ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotapy.T,Tfapy,Open1,ref ConfigPrograma.OpenPath, buildfiltro(TipoFiltro.PuntosTodos,idioma));
			ahora_no_se_puede_cerrar=0;
		}
	#endregion

	#region Configuraciones

	#region leer
		void AAbrirConfig_Click(object sender,System.EventArgs e){
			string s="";
			System.IO.StreamReader File1;
			string linea;

			ahora_no_se_puede_cerrar=1;
			s=Methods.AAbrir(OpenConfig, ref ConfigPrograma.OpenConfigPath, get_texto(Filtrocfg),1);
			if(s==null) goto @return;
			try{
				File1= new StreamReader(s,System.Text.Encoding.Default);
			}catch(System.IO.IOException ex){
				MessageBoxAT.Show(get_texto(Error_al_abrir_archivo)+"\n\n" + ex.Message);
				goto @return;
			}

			set_message(Globales.Textos.get_texto(Globales.Textos.Cods.Abriendo_un_fichero,idioma));
			do{
				linea= File1.ReadLine();
				linea.Trim(separadores);
			}while((linea=="" || linea[0]=='%') && File1.Peek()>=0);
			if(File1.Peek()<0){
				MessageBoxAT.Show(get_texto(Fichero_vaco));
				File1.Close();
				goto @return;
			}

			iconfig= iconfig+1;
			if(iconfig==nconfig){
				Varias.redim(ref configuraciones_nombres,nconfig + 8);
				Varias.redim(ref configuraciones_paths,nconfig + 8);
				nconfig= nconfig+8;
			}
			ComboBox1.Items.Add(linea);
			configuraciones_nombres[iconfig]= linea;
			configuraciones_paths[iconfig]= OpenConfig.FileName;
			llamada_Combo1= true;
			ComboBox1.SelectedIndex= iconfig;
			lee_configuracion(File1);
			llamada_Combo1= false;
			Update_data();

		@return:
			ahora_no_se_puede_cerrar=0;
		}

		void lee_configuracion(StreamReader file1){
		string[] palabras=new string[0];	//Para que el tonto no proteste
			short i,n;

			Chk_1.Checked=false;
			Chkdistorsion.Checked= false;
			Chkradial.Checked= false;
			Chkasim.Checked= false;

			//Imposible hacerlo con foreach
			for(i=0;i<3;i++) FCal1.Text1apr[i].Text=FCal1.Text1con[i].Text="";
			for(i=0;i<6;i++) FExterna1.TextExternaapr[i].Text=FExterna1.TextExternacon[i].Text="";
			for(i=0;i<3;i++) FInterna1.TextInternaapr[i].Text=FInterna1.TextInternacon[i].Text="";
			this.Textsemidiag.Text="";
			FormR1.Textr1.Text="";

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek()<0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case @"\begin":
						if(n==1){
							MessageBoxAT.Show(get_texto(Lone_Begin));
							file1.Close();
							return;
						}
						switch(palabras[1]){
							case "Coordenadas":
								if(n>4 && palabras[2]=="medidas" && palabras[3]=="-->" && palabras[4]=="fotocoordenadas"){
										lee_1(file1);
								}
								break;
							case "Orientacion":
								if(n>2){
									if(palabras[2]=="externa"){
										lee_externa(file1);
									}else if(palabras[2]=="interna"){
										lee_interna(file1);
									}
								}
								break;
							case "Funcion":
								if(n>3 && palabras[2]=="de" && palabras[3]=="distorsion"){
									lee_distorsion(file1);
								}
								break;
							case "Informacion":
								if(n>3 && palabras[2]=="de"){switch(palabras[3]){
									case "salida": lee_Salida(file1); break;
								}}
								break;
						}//\begin
						break;
				}//linea
			}while(file1.Peek()>=0);

			file1.Close();
		}

	#region lee_externas
		void lee_1(StreamReader file1){
			string[] palabras=new string[0];	//Para que el tonto no proteste
			short n, i;

			FCal1.Optlevo.Checked=true;
			FCal1.Txtpixel_x.Text=FCal1.Txtpixel_y.Text="1";
			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek()<0) return;

				if(palabras[0]==@"\end") return;
				n= (short)palabras.Length;
				if(n<2) continue;
				switch(palabras[0]){
					case "Selected": i=-1;
						if(palabras[1]=="No") Chk_1.Checked=false;
						else Chk_1.Checked=true;
						break;
					case "ejes": i=-1;
						switch(palabras[1]){
							case "0": FCal1.Optdext.Checked=true; break;
							default: FCal1.Optlevo.Checked=true; break;
						}
						break;
					case "pixelratio": i=-1;
						try{Convert.ToByte(palabras[1]); FCal1.Txtpixel_x.Text=palabras[1];}catch{}
						if(n>2){
							try{Convert.ToByte(palabras[2]); FCal1.Txtpixel_y.Text=palabras[2];}catch{}
						}
						break;
					case "Tx" : i= 0; break;
					case "Ty" : i= 1; break;
					case "giro" : i= 2; break;
					case "esc" : i= 3; break;
					case "esc_x/y" : i= 4; break;
					case "delta" : i= 5; break;
					default : goto continua;
				}
				if(i>=0){
					if(palabras[1]=="0") FCal1.Chk1[i].Checked= false;
					else FCal1.Chk1[i].Checked= true;
					if(n>2){
						if(palabras[2][0]=='$')
							palabras[2]=procesa_string(palabras[2]);
						if(palabras[1]=="0") FCal1.Text1con[i].Text= palabras[2];
						else FCal1.Text1apr[i].Text= palabras[2];
					}
				}
	continua:;
			}while(file1.Peek()>=0);
		}

		void lee_externa(StreamReader file1){
			string[] palabras=new string[0];	//Para que el tonto no proteste
			short n, i;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek()<0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case "X" : i= 0; break;
					case "Y" : i= 1; break;
					case "Z" : i= 2; break;
					case "W" : i= 3; break;
					case "PHI": i=4; break;
					case "K" : i= 5; break;
					case @"\end" : return;
					default: goto continua;
				}
				if(n>1){
					if(palabras[1]=="0") FExterna1.ChkExterna[i].Checked= false;
					else FExterna1.ChkExterna[i].Checked= true;
					if(n>2){
						if(palabras[1]=="0") FExterna1.TextExternacon[i].Text= palabras[2];
						else FExterna1.TextExternaapr[i].Text= palabras[2];
					}
				}
	continua:;
			}while(file1.Peek() >= 0);
		}

		void lee_interna(StreamReader file1){
			string[] palabras;
			short n, i;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek()<0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case "f": i= 0; break;
					case "x": i= 1; break;
					case "y": i= 2; break;
					case @"\end" : return;
					default : goto continua;
				}
				if(n>1){
					if(palabras[1]=="0") FInterna1.ChkInterna[i].Checked= false;
					else FInterna1.ChkInterna[i].Checked= true;
					if(n>2){
						if(palabras[1]=="0") FInterna1.TextInternacon[i].Text= palabras[2];
						else FInterna1.TextInternaapr[i].Text= palabras[2];
					}
				}
	continua:;
			}while(file1.Peek()>=0);
		}
	#endregion
	#region lee_distorsiones
		void lee_distorsion(StreamReader file1){
			string[] palabras=new string[0];	//Para que el tonto no proteste
			short n;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek()<0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case "presente":
						if(n>1 && palabras[1]=="si") Chkdistorsion.Checked= true;
						else	Chkdistorsion.Checked= false;
						break;
					case "semidiag":
						if(n>1) Textsemidiag.Text= palabras[1];
						break;
					case "modelo":
					   if(n<2) break;
					   string[] modelo;
					   int i;
					   switch(palabras[1]){
						case "polinomico":
							if(n==2){CBoxpoli.SelectedIndex=1; break;}
							modelo=new string[n-2];
							for(i=2;i<n;i++)
								modelo[i-2]=palabras[i];
							CBoxpoli.SelectedIndex=Basicas._gcVarios.match_item(config_radsim,modelo);
							break;
						case "asimetrico":
							if(n==2){CBoxasim.SelectedIndex=0; break;}
							modelo=new string[n-2];
							for(i=2;i<n;i++)
								modelo[i-2]=palabras[i];
							CBoxasim.SelectedIndex=Basicas._gcVarios.match_item(config_otras,modelo);
							break;
					   }
					   break;
					case @"\begin":
						if(n==1){
							MessageBoxAT.Show(get_texto(Lone_Begin));
							file1.Close();
							return;
						}
						switch(palabras[1]){
							case "Radial":
								if(n>2 && palabras[2]=="simetrica"){
									lee_radialsim(file1);
								}
								break;
							case "Tangencial":
								if(n>2 && palabras[2]=="simetrica"){
									lee_tansim(file1);
								}
								break;
							case "Otras":
								if(n>2 && palabras[2]=="distorsiones")
									lee_otras(file1);
								break;
							case "Asimetricas":
								lee_otras(file1);
								break;
						}//\begin
						break;
					case @"\end": return;
				}//linea
			}while(file1.Peek()>=0);
		}

		void lee_radialsim(StreamReader file1){
			string[] palabras=new string[0];	//Para que el tonto no proteste
			short n, i;
			ushort b16,l;
			System.IntPtr P_b16;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek()<0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case "presente":
						if(n>1 && palabras[1]=="si") Chkradial.Checked= true;
						else	Chkradial.Checked= false;
						break;
					case "condicion":
						if(n>1 && FInterna1.List1.Items.Contains(palabras[1])){
							FInterna1.List1.SelectedItem= palabras[1];
						}else{
							FInterna1.List1.SelectedIndex= 0;
						}
						break;
					case "r1":
						if(n>1) FormR1.Textr1.Text= palabras[1];
						break;
					case "parametros":
						if(n>1){unsafe{
							P_b16=Marshal.StringToHGlobalAnsi(palabras[1]);
							b16= Basicas._nogcVarios.str_b16_rev((byte*)P_b16.ToPointer());
							for(i=1,l=1;i<=FormSimetrica.nparametros;i++,l<<=1){
								if(FRadial1.checkboxes[i].Enabled){
									FRadial1.checkboxes[i].Checked= (b16&l)!=0;
								}
							}
							lbl_radsim.T.Text= Convert.ToString(FRadial1.npar);
							Marshal.FreeHGlobal(P_b16);
						}}
						break;
					case @"\end": return;
				}
			}while(file1.Peek()>=0);
		}

		void lee_tansim(StreamReader file1){
			string[] palabras=new string[0];	//Para que el tonto no proteste
			short n, i;
			ushort b16,l;
			System.IntPtr P_b16;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek()<0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case "presente":
						if(n>1 && palabras[1]=="si") Chktangencial.Checked=true;
						else	Chktangencial.Checked=false;
						break;
					case "parametros":
						if(n>1){unsafe{
							P_b16=Marshal.StringToHGlobalAnsi(palabras[1]);
							b16= Basicas._nogcVarios.str_b16_rev((byte*)P_b16.ToPointer());
							for(i=1,l=1;i<=FormSimetrica.nparametros;i++,l<<=1){
								if(FTangencial1.checkboxes[i].Enabled){
									FTangencial1.checkboxes[i].Checked= (b16&l)!=0;
								}
							}
							lbl_tansim.T.Text= Convert.ToString(FTangencial1.npar);
							Marshal.FreeHGlobal(P_b16);
						}}
						break;
					case @"\end": return;
				}
			}while(file1.Peek()>=0);
		}

		void lee_otras(StreamReader file1){
			string[] palabras=new string[0];	//Para que el tonto no proteste
			short n, i;
			ushort b16,l;
			System.IntPtr P_b16;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek()<0) return;

				n= (short)palabras.Length;
				switch(palabras[0]){
					case "presente":
						if(n>1 && palabras[1]=="si") Chkasim.Checked= true;
						else	Chkasim.Checked= false;
						break;
					case "parametros_asim": goto case "serie1";
					case "serie1":
						if(n>1){unsafe{
							P_b16=Marshal.StringToHGlobalAnsi(palabras[1]);
							b16= Basicas._nogcVarios.str_b16_rev((byte*)P_b16.ToPointer());
							if(CBoxasim.SelectedIndex==0){
								for(i=1,l=1;i<=FormAsimetricaRadTan.nparametros;i++,l<<=1){
									if(FAsimetricaRad1.checkboxes[i].Enabled){
										FAsimetricaRad1.checkboxes[i].Checked= (b16&l)!=0;
									}
								}
								lbl_radasim.T.Text= Convert.ToString(FAsimetricaRad1.npar);
							}else if(CBoxasim.SelectedIndex==1){
								for(i=1,l=1;i<=FormAsimetricauv.nparametros;i++,l<<=1){
									if(FAsimetricauvserie1.checkboxes[i].Enabled){
										FAsimetricauvserie1.checkboxes[i].Checked= (b16&l)!=0;
									}
								}
								lbl_uvserie1.T.Text= Convert.ToString(FAsimetricauvserie1.npar);
							}
							Marshal.FreeHGlobal(P_b16);
						}}
						break;
					case "serie2":
						if(n>1){unsafe{
						    P_b16=Marshal.StringToHGlobalAnsi(palabras[1]);
							b16= Basicas._nogcVarios.str_b16_rev((byte*)P_b16.ToPointer());
							if(CBoxasim.SelectedIndex==0){
								for(i=1,l=1;i<=FormAsimetricaRadTan.nparametros;i++,l<<=1){
									if(FAsimetricaTan1.checkboxes[i].Enabled){
										FAsimetricaTan1.checkboxes[i].Checked= (b16&l)!=0;
									}
								}
								lbl_tanasim.T.Text= Convert.ToString(FAsimetricaTan1.npar);
							}else if(CBoxasim.SelectedIndex==1){
								for(i=1,l=1;i<=FormAsimetricauv.nparametros;i++,l<<=1){
									if(FAsimetricauvserie2.checkboxes[i].Enabled){
										FAsimetricauvserie2.checkboxes[i].Checked= (b16&l)!=0;
									}
								}
								lbl_uvserie2.T.Text= Convert.ToString(FAsimetricauvserie2.npar);
							}
							Marshal.FreeHGlobal(P_b16);
						}}
						break;
					case @"\end": return;
				}
			}while(file1.Peek() >= 0);
		}
	#endregion
	#region lee_Salida
		void lee_Salida(StreamReader file1){
			string[] palabras;
			short n;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek()<0) return;
				if(palabras[0]==@"\end") return;

				n= (short)palabras.Length;
				if(n<2) continue;
				switch(palabras[0]){
					case @"\begin":
						switch(palabras[1]){
							case "General": lee_Salida_general(file1); break;
						}
						break;
				}
			}while(file1.Peek()>=0);
		}
		void lee_Salida_general(StreamReader file1){
			string[] palabras;
			short n;

			do{
				palabras=Basicas._gcVarios.skip_lineas(file1);
				if(file1.Peek()<0) return;
				if(palabras[0]==@"\end") return;

				n= (short)palabras.Length;
				if(n<2) continue;
				switch(palabras[0]){
					case "Unidades":
						if(n>=3){switch(palabras[1]){
							case "medida": suni.p=palabras[2]; break;
							case "foto": suni.f=palabras[2]; break;
							case "terreno": suni.t=palabras[2]; break;
						}}
						break;
				}
			}while(file1.Peek()>=0);
		}
	#endregion

	void Update_data(){
		if(FUni1.Visible) FUni1.update_data();
		if(Chk_1.Checked && !FCal1.Chk1esc.Checked){
			string txt=FCal1.Text1esccon.Text;
			bool b=false;
			if(txt!=""){	try{
				Basicas._gcVarios.atodbl(txt.ToCharArray());
				b=true;
			    }catch(Exception){}
			}
			if(!b){
				Formpixel1.Location=this.PointToScreen(this.ComboBox1.Location+new Size(12,this.ComboBox1.Height));
				Formpixel1.ShowDialog(this.ParentForm);
				FCal1.Text1esccon.Text=Formpixel1.LTxtR.Text;
			}
		}
	}
	#endregion

	#region escribir
		unsafe void AGuardarConfig_Click(object sender,System.EventArgs e){
			string s;
			StreamWriter File1;
			short i;
			string[] stextos= new string[6];
			string titulo;
			byte* cifras=(byte*)Marshal.AllocHGlobal(20).ToPointer();
			ushort b16,l;

			ahora_no_se_puede_cerrar=1;
			s=Methods.AAbrir(SaveConfig, ref ConfigPrograma.OpenConfigPath, get_texto(Filtrocfg),1);
			if(s==null){ahora_no_se_puede_cerrar=0; return;}
			try{
				File1= new StreamWriter(s,false,System.Text.Encoding.Default);
			}catch(System.IO.IOException){
				MessageBoxAT.Show(Globales.Textos.get_texto(17,System.IO.Path.GetFileName(s),idioma));
				ahora_no_se_puede_cerrar=0;
				return;
			}
			set_message(get_texto(Escribiendo_configuracin));
			titulo= System.IO.Path.GetFileNameWithoutExtension(s);
			File1.WriteLine("%Calibracion");
			File1.WriteLine(titulo);
			File1.WriteLine();

			File1.WriteLine(@"\begin Coordenadas medidas --> fotocoordenadas");
			File1.WriteLine();
			if(this.Chk_1.Checked) File1.WriteLine("Selected\tSi");
			else File1.WriteLine("Selected\tNo");
			if(FCal1.Optdext.Checked) File1.WriteLine("ejes\t0");
			else File1.WriteLine("ejes\t1");
			stextos[0]= "Tx";
			stextos[1]= "Ty";
			stextos[2]= "giro";
			stextos[3]= "esc";
			stextos[4]= "esc_x/y";
			stextos[5]= "delta";
			for(i=0;i<6;i++){
				File1.Write(stextos[i] + '\t');
				if(FCal1.Chk1[i].Checked==false){
					File1.Write("0");
					if(FCal1.Text1con[i].Text!="") File1.Write('\t' + FCal1.Text1con[i].Text);
				}else{
					File1.Write("1");
					if(FCal1.Text1apr[i].Text!="") File1.Write('\t' + FCal1.Text1apr[i].Text);
				}
				File1.WriteLine();
			}
			File1.WriteLine(@"\end");

			File1.WriteLine();
			File1.WriteLine(@"\begin Orientacion externa");
			File1.WriteLine();
			stextos[0]= "X";
			stextos[1]= "Y";
			stextos[2]= "Z";
			stextos[3]= "W";
			stextos[4]= "PHI";
			stextos[5]= "K";
			for(i=0;i<6;i++){
				File1.Write(stextos[i] + '\t');
				if(FExterna1.ChkExterna[i].Checked==false){
					File1.Write("0");
					if(FExterna1.TextExternacon[i].Text!="") File1.Write('\t' + FExterna1.TextExternacon[i].Text);
				}else{
					File1.Write("1");
					if(FExterna1.TextExternaapr[i].Text!="") File1.Write('\t' + FExterna1.TextExternaapr[i].Text);
				}
				File1.WriteLine();
			}
			File1.WriteLine(@"\end");

			File1.WriteLine();
			File1.WriteLine(@"\begin Orientacion interna media");
			File1.WriteLine();
			stextos[0]= "f";
			stextos[1]= "x";
			stextos[2]= "y";
			for(i=0;i<3;i++){
				File1.Write(stextos[i] + '\t');
				if(FInterna1.ChkInterna[i].Checked==false){
					File1.Write("0");
					if(FInterna1.TextInternacon[i].Text!="") File1.Write('\t' + FInterna1.TextInternacon[i].Text);
				}else{
					File1.Write("1");
					if(FInterna1.TextInternaapr[i].Text!="") File1.Write('\t' + FInterna1.TextInternaapr[i].Text);
				}
				File1.WriteLine();
			}
			File1.WriteLine(@"\end");

			File1.WriteLine();
			File1.WriteLine(@"\begin Funcion de distorsion");
			File1.WriteLine();
			if(Chkdistorsion.Checked==false){
				File1.WriteLine("presente\tno");
			}else{
				File1.WriteLine("presente\tsi");
				File1.WriteLine("semidiag\t" + Textsemidiag.Text);
				File1.WriteLine("modelo polinomico\t" + config_radsim[CBoxpoli.SelectedIndex]);
				File1.WriteLine("modelo asimetrico\t" + config_otras[CBoxasim.SelectedIndex]);

				File1.WriteLine();
				File1.WriteLine(@"\begin Radial simetrica");
				File1.WriteLine();
				if(Chkradial.Checked) File1.WriteLine("presente\tsi");
				else File1.WriteLine("presente\tno");
				File1.WriteLine("condicion\t" + FInterna1.List1.SelectedItem);
				File1.WriteLine("r1\t\t" + FormR1.Textr1.Text);

				b16= 0;
				for(i=1,l=1;i<=FormSimetrica.nparametros;i++,l<<=1){
					if(FRadial1.checkboxes[i].Checked==true){
						b16|=l;
					}
				}
				Basicas._nogcVarios.b16_str_rev(b16, cifras);
				File1.WriteLine("parametros\t" + new string((sbyte*)cifras));
				File1.WriteLine(@"\end");

				File1.WriteLine();
				File1.WriteLine(@"\begin Tangencial simetrica");
				File1.WriteLine();
				if(Chktangencial.Checked) File1.WriteLine("presente\tsi");
				else File1.WriteLine("presente\tno");

				b16= 0;
				for(i=1,l=1;i<=FormSimetrica.nparametros;i++,l<<=1){
					if(FTangencial1.checkboxes[i].Checked==true){
						b16|=l;
					}
				}
				Basicas._nogcVarios.b16_str_rev(b16, cifras);
				File1.WriteLine("parametros\t" + new string((sbyte*)cifras));
				File1.WriteLine(@"\end");

				File1.WriteLine();
				File1.WriteLine(@"\begin Asimetricas");
				File1.WriteLine();
				if(Chkasim.Checked) File1.WriteLine("presente\tsi");
				else File1.WriteLine("presente\tno");

				b16= 0;
				if(CBoxasim.SelectedIndex==0){
					for(i=1,l=1;i<=FormAsimetricaRadTan.nparametros;i++,l<<=1){
						if(FAsimetricaRad1.checkboxes[i].Checked== true){
							b16|=l;
					}	}
				}else if(CBoxasim.SelectedIndex==1){
					for(i=1,l=1;i<=FormAsimetricauv.nparametros;i++,l<<=1){
						if(FAsimetricauvserie1.checkboxes[i].Checked== true){
							b16|=l;
					}	}
				}
				Basicas._nogcVarios.b16_str_rev(b16, cifras);
				File1.WriteLine("serie1\t" + new string((sbyte*)cifras));

				b16= 0;
				if(CBoxasim.SelectedIndex==0){
					for(i=1,l=1;i<=FormAsimetricaRadTan.nparametros;i++,l<<=1){
						if(FAsimetricaTan1.checkboxes[i].Checked==true){
							b16|=l;
					}	}
				}else if(CBoxasim.SelectedIndex==1){
					for(i=1,l=1;i<=FormAsimetricauv.nparametros;i++,l<<=1){
						if(FAsimetricauvserie2.checkboxes[i].Checked==true){
							b16|=l;
					}	}
				}
				Basicas._nogcVarios.b16_str_rev(b16, cifras);
				File1.WriteLine("serie2\t" + new string((sbyte*)cifras));
				File1.WriteLine(@"\end");
			}
			File1.WriteLine();

			File1.WriteLine(@"\end" + "\tFuncion de distorsion");
			File1.Flush();

			File1.WriteLine();
			File1.WriteLine(@"\begin Informacion de salida");
			File1.WriteLine(@"\begin General");
			File1.WriteLine("Unidades medida "+suni.p);
			File1.WriteLine("Unidades foto "+suni.f);
			File1.WriteLine("Unidades terreno "+suni.t);
			File1.WriteLine(@"\end");
			File1.WriteLine(@"\end");

			File1.Flush();
			File1.Close();

			llamada_Combo1= true;
			iconfig= iconfig + 1;
			if(iconfig==nconfig){
				Varias.redim(ref configuraciones_nombres,nconfig + 8);
				Varias.redim(ref configuraciones_paths,nconfig + 8);
				nconfig= nconfig + 8;
			}
			ComboBox1.Items.Add(titulo);
			configuraciones_nombres[iconfig]= titulo;
			configuraciones_paths[iconfig]= SaveConfig.FileName;
			ComboBox1.SelectedIndex= iconfig;
			llamada_Combo1= false;

			Marshal.FreeHGlobal(new System.IntPtr((void*)cifras));
			ahora_no_se_puede_cerrar=0;
		}
	#endregion

		void ComboBox1_SelectedIndexChanged(object sender,System.EventArgs e){
			int i;
			StreamReader file1;
			string linea;
			i= ComboBox1.SelectedIndex;

			if(llamada_Combo1==true) return;

			try{
				file1= new StreamReader(configuraciones_paths[i],System.Text.Encoding.Default);
			}catch(System.IO.IOException ex){
				MessageBoxAT.Show(get_texto(Error_apertura_fichero)+"\n\n" + ex.Message); return;
			}

			ahora_no_se_puede_cerrar=1;
			set_message(get_texto(Leyendo_configuracin));
			do{
				linea= file1.ReadLine();
				linea.Trim(separadores);
			}while((linea=="" || linea[0]=='%') && file1.Peek()>=0);
			if(file1.Peek()<0){
				MessageBoxAT.Show(get_texto(Fichero_vaco));
				file1.Close();
				ahora_no_se_puede_cerrar=0;
				return;
			}
			if(linea!=configuraciones_nombres[i]){
				configuraciones_nombres[i]= linea;
				ComboBox1.Items[i]= linea;
			}
			lee_configuracion(file1);
			Update_data();
			ahora_no_se_puede_cerrar=0;
		}
	#endregion

	#region BotOtros
		void Bot1_Click(object sender,System.EventArgs e){
			if(!FCal1.Created) FCal1.Location= this.ParentForm.Location +new Size(252,140);
			FCal1.Show();
		}
		void Botfpp_Click(object sender,System.EventArgs e){
			if(!FInterna1.Created) FInterna1.Location= this.ParentForm.Location +new Size(252,140);
			FInterna1.Show();
		}
		void BotExt_Click(object sender,System.EventArgs e){
			if(!FExterna1.Created) FExterna1.Location= this.ParentForm.Location +new Size(252,140);
			FExterna1.Show();
		}
	#endregion
	#region 1
		void Chk_1_CheckedChanged(object sender,System.EventArgs e){
			Bot1.Enabled=Chk_1.Checked;
			if(FCal1.Chk1Tx.Checked==true){
				if(Bot1.Enabled==false) FInterna1.ChkInternax.Checked=true;
				else Chk1Tx_CheckedChanged(this,EventArgs.Empty);
			}
			if(FCal1.Chk1Ty.Checked==true){
				if(Bot1.Enabled==false) FInterna1.ChkInternay.Checked=true;
				else Chk1Ty_CheckedChanged(this,EventArgs.Empty);
			}
			Chk1k_CheckedChanged(this,EventArgs.Empty);
			Chk1esc_CheckedChanged(this,EventArgs.Empty);
			Chk1escy_CheckedChanged(this,EventArgs.Empty);
			Chk1delta_CheckedChanged(this,EventArgs.Empty);
		}
		void Chk1Tx_CheckedChanged(object sender,System.EventArgs e){
			if(Bot1.Enabled && FCal1.Chk1Tx.Checked) FInterna1.ChkInternax.Checked=false;
			if(((Bot1.Enabled && FCal1.Chk1Tx.Checked) || FInterna1.ChkInternax.Checked) && FExterna1.ChkExternaFI.Checked){
				FAsimetricaRad1.checkboxes[1].Checked=false;
				FAsimetricaRad1.checkboxes[1].Enabled=false;
				FAsimetricauvserie1.checkboxes[1].Checked=false;
				FAsimetricauvserie1.checkboxes[1].Enabled=false;
			}else{
				FAsimetricaRad1.checkboxes[1].Enabled=true;
				FAsimetricaRad1.checkboxes[1].Checked=true;
				FAsimetricauvserie1.checkboxes[1].Enabled=true;
				FAsimetricauvserie1.checkboxes[1].Checked=true;
			}
			lbl_radasim.T.Text= Convert.ToString(FAsimetricaRad1.npar);
			lbl_uvserie1.T.Text= Convert.ToString(FAsimetricauvserie1.npar);
		}
		void Chk1Ty_CheckedChanged(object sender,System.EventArgs e){
			if(Bot1.Enabled && FCal1.Chk1Ty.Checked) FInterna1.ChkInternay.Checked=false;
			if(((Bot1.Enabled && FCal1.Chk1Ty.Checked) || FInterna1.ChkInternay.Checked) && FExterna1.ChkExternaW.Checked){
				FAsimetricaRad1.checkboxes[2].Checked=false;
				FAsimetricaRad1.checkboxes[2].Enabled=false;
				FAsimetricauvserie1.checkboxes[2].Checked=false;
				FAsimetricauvserie1.checkboxes[2].Enabled=false;
			}else{
				FAsimetricaRad1.checkboxes[2].Enabled=true;
				FAsimetricaRad1.checkboxes[2].Checked=true;
				FAsimetricauvserie1.checkboxes[2].Enabled=true;
				FAsimetricauvserie1.checkboxes[2].Checked=true;
			}
			lbl_radasim.T.Text= Convert.ToString(FAsimetricaRad1.npar);
			lbl_uvserie1.T.Text= Convert.ToString(FAsimetricauvserie1.npar);
		}
		void Chk1k_CheckedChanged(object sender,System.EventArgs e){
			if(Bot1.Enabled && FCal1.Chk1k.Checked){
				FExterna1.ChkExternak.Checked=false;
				FTangencial1.checkboxes[1].Checked=false;
				FTangencial1.checkboxes[1].Enabled=false;
			}else if(FExterna1.ChkExternak.Checked==false){
				FTangencial1.checkboxes[1].Enabled=true;
				FTangencial1.checkboxes[1].Checked=true;
			}
			lbl_tansim.T.Text= Convert.ToString(FTangencial1.npar);
		}
		void Chk1esc_CheckedChanged(object sender,System.EventArgs e){
			if(Bot1.Enabled && FCal1.Chk1esc.Checked){
				FInterna1.ChkInternaf.Checked=false;
				FRadial1.checkboxes[1].Enabled=false;
				if(FInterna1.List1.SelectedIndex==0){
					FRadial1.checkboxes[1].Checked=false;
				}else{
					FRadial1.checkboxes[1].Checked=true;
				}
			}else if(FInterna1.ChkInternaf.Checked==false){
				FRadial1.checkboxes[1].Enabled=true;
				FRadial1.checkboxes[1].Checked=true;
			}
			lbl_radsim.T.Text= Convert.ToString(FRadial1.npar);
		}
		void Chk1escy_CheckedChanged(object sender,System.EventArgs e){
			if(Bot1.Enabled && FCal1.Chk1escy.Checked){
				FAsimetricaRad1.checkboxes[5].Checked=false;
				FAsimetricaRad1.checkboxes[5].Enabled=false;
				FAsimetricaTan1.checkboxes[6].Checked=false;
				FAsimetricaTan1.checkboxes[6].Enabled=false;
				FAsimetricauvserie1.checkboxes[5].Checked=false;
				FAsimetricauvserie1.checkboxes[5].Enabled=false;
			}else{
				FAsimetricaRad1.checkboxes[5].Enabled=true;
				FAsimetricaTan1.checkboxes[6].Enabled=true;
				FAsimetricauvserie1.checkboxes[5].Enabled=true;
				FAsimetricaRad1.checkboxes[5].Checked=true;
				FAsimetricaTan1.checkboxes[6].Checked=true;
				FAsimetricauvserie1.checkboxes[5].Checked=true;
			}
			lbl_radasim.T.Text= Convert.ToString(FAsimetricaRad1.npar);
			lbl_tanasim.T.Text= Convert.ToString(FAsimetricaTan1.npar);
			lbl_uvserie1.T.Text= Convert.ToString(FAsimetricauvserie1.npar);
		}
		void Chk1delta_CheckedChanged(object sender,System.EventArgs e){
			if(Bot1.Enabled && FCal1.Chk1delta.Checked){
				FAsimetricaRad1.checkboxes[6].Checked=false;
				FAsimetricaRad1.checkboxes[6].Enabled=false;
				FAsimetricaTan1.checkboxes[5].Checked=false;
				FAsimetricaTan1.checkboxes[5].Enabled=false;
				FAsimetricauvserie1.checkboxes[6].Checked=false;
			}else{
				FAsimetricaRad1.checkboxes[6].Enabled=true;
				FAsimetricaTan1.checkboxes[5].Enabled=true;
				FAsimetricauvserie1.checkboxes[6].Checked=true;
			}
			lbl_radasim.T.Text= Convert.ToString(FAsimetricaRad1.npar);
			lbl_tanasim.T.Text= Convert.ToString(FAsimetricaTan1.npar);
			lbl_uvserie1.T.Text= Convert.ToString(FAsimetricauvserie1.npar);
		}
	#endregion

	#region Externa
		void ChkExternaW_CheckedChanged(object sender,System.EventArgs e){
			FExterna1.ChkExternaFI.Checked= FExterna1.ChkExternaW.Checked;
			if((FCal1.Chk1Ty.Checked || FInterna1.ChkInternay.Checked) && FExterna1.ChkExternaW.Checked){
				FAsimetricaRad1.checkboxes[2].Checked=false;
				FAsimetricaRad1.checkboxes[2].Enabled=false;
				FAsimetricauvserie1.checkboxes[2].Checked=false;
				FAsimetricauvserie1.checkboxes[2].Enabled=false;
			}else{
				FAsimetricaRad1.checkboxes[2].Enabled=true;
				FAsimetricaRad1.checkboxes[2].Checked=true;
				FAsimetricauvserie1.checkboxes[2].Enabled=true;
				FAsimetricauvserie1.checkboxes[2].Checked=true;
			}
			lbl_radasim.T.Text= Convert.ToString(FAsimetricaRad1.npar);
			lbl_uvserie1.T.Text= Convert.ToString(FAsimetricauvserie1.npar);
		}
		void ChkExternaFI_CheckedChanged(object sender,System.EventArgs e){
			FExterna1.ChkExternaW.Checked= FExterna1.ChkExternaFI.Checked;
			if((FCal1.Chk1Tx.Checked || FInterna1.ChkInternax.Checked) && FExterna1.ChkExternaFI.Checked){
				FAsimetricaRad1.checkboxes[1].Checked=false;
				FAsimetricaRad1.checkboxes[1].Enabled=false;
				FAsimetricauvserie1.checkboxes[1].Checked=false;
				FAsimetricauvserie1.checkboxes[1].Enabled=false;
			}else{
				FAsimetricaRad1.checkboxes[1].Enabled=true;
				FAsimetricaRad1.checkboxes[1].Checked=true;
				FAsimetricauvserie1.checkboxes[1].Enabled=true;
				FAsimetricauvserie1.checkboxes[1].Checked=true;
			}
			lbl_radasim.T.Text= Convert.ToString(FAsimetricaRad1.npar);
			lbl_uvserie1.T.Text= Convert.ToString(FAsimetricauvserie1.npar);
		}
		void ChkExternak_CheckedChanged(object sender,System.EventArgs e){
			if(FExterna1.ChkExternak.Checked){
				if(Bot1.Enabled) FCal1.Chk1k.Checked=false;
				FTangencial1.checkboxes[1].Checked=false;
				FTangencial1.checkboxes[1].Enabled=false;
			}else if(Bot1.Enabled==false || FCal1.Chk1k.Checked==false){
				FTangencial1.checkboxes[1].Enabled=true;
				FTangencial1.checkboxes[1].Checked=true;
			}
			lbl_tansim.T.Text= Convert.ToString(FTangencial1.npar);
		}
	#endregion

	#region Interna
		void ChkInternax_CheckedChanged(object sender,System.EventArgs e){
			if(Bot1.Enabled && FInterna1.ChkInternax.Checked) FCal1.Chk1Tx.Checked=false;
			if(((Bot1.Enabled && FCal1.Chk1Tx.Checked) || FInterna1.ChkInternax.Checked) && FExterna1.ChkExternaFI.Checked){
				FAsimetricaRad1.checkboxes[1].Checked=false;
				FAsimetricaRad1.checkboxes[1].Enabled=false;
				FAsimetricauvserie1.checkboxes[1].Checked=false;
				FAsimetricauvserie1.checkboxes[1].Enabled=false;
			}else{
				FAsimetricaRad1.checkboxes[1].Enabled=true;
				FAsimetricaRad1.checkboxes[1].Checked=true;
				FAsimetricauvserie1.checkboxes[1].Enabled=true;
				FAsimetricauvserie1.checkboxes[1].Checked=true;
			}
			lbl_radasim.T.Text= Convert.ToString(FAsimetricaRad1.npar);
			lbl_uvserie1.T.Text= Convert.ToString(FAsimetricauvserie1.npar);
		}
		void ChkInternay_CheckedChanged(object sender,System.EventArgs e){
			if(Bot1.Enabled && FInterna1.ChkInternay.Checked) FCal1.Chk1Ty.Checked=false;
			if(((Bot1.Enabled && FCal1.Chk1Ty.Checked) || FInterna1.ChkInternay.Checked) && FExterna1.ChkExternaW.Checked){
				FAsimetricaRad1.checkboxes[2].Checked=false;
				FAsimetricaRad1.checkboxes[2].Enabled=false;
				FAsimetricauvserie1.checkboxes[2].Checked=false;
				FAsimetricauvserie1.checkboxes[2].Enabled=false;
			}else{
				FAsimetricaRad1.checkboxes[2].Enabled=true;
				FAsimetricaRad1.checkboxes[2].Checked=true;
				FAsimetricauvserie1.checkboxes[2].Enabled=true;
				FAsimetricauvserie1.checkboxes[2].Checked=true;
			}
			lbl_radasim.T.Text= Convert.ToString(FAsimetricaRad1.npar);
			lbl_uvserie1.T.Text= Convert.ToString(FAsimetricauvserie1.npar);
		}
		void ChkInternaf_CheckedChanged(object sender,System.EventArgs e){
			if(FInterna1.ChkInternaf.Checked){
				if(Bot1.Enabled) FCal1.Chk1esc.Checked=false;
				FRadial1.checkboxes[1].Enabled=false;
				if(FInterna1.List1.SelectedIndex==0){
					FRadial1.checkboxes[1].Checked=false;
				}else{
					FRadial1.checkboxes[1].Checked=true;
				}
			}else if(FInterna1.ChkInternaf.Checked==false){
				FRadial1.checkboxes[1].Enabled=true;
				FRadial1.checkboxes[1].Checked=true;
			}
			lbl_radsim.T.Text= Convert.ToString(FRadial1.npar);
		}
	#endregion

	#region distorsin
		void Chkdistorsion_CheckedChanged(object sender,System.EventArgs e){
			GBoxdistorsion.Enabled= Chkdistorsion.Checked;
		}

	#region radial y tangencial
		void Chkradial_CheckedChanged(object sender,System.EventArgs e){
			lbl_radsim.Enabled=Chkradial.Checked;
		}
		void Chktangencial_CheckedChanged(object sender,System.EventArgs e){
			lbl_tansim.Enabled=Chktangencial.Checked;
		}

		void List1_SelectedIndexChanged(object sender,System.EventArgs e){
			if(FInterna1.List1.SelectedIndex==1){
				Rectangle ab=FInterna1.List1.RectangleToScreen(new Rectangle(0,0,0,0));
				FormR1.Location=ab.Location- new Size(12,24);
				FormR1.ShowDialog();
			}
			if(FInterna1.List1.SelectedIndex==0) FRadial1.checkboxes[1].Checked=false;
			else FRadial1.checkboxes[1].Checked=true;

			lbl_radsim.T.Text= Convert.ToString(FRadial1.npar);
		}
	#endregion
	#region otras
		void Chkasim_CheckedChanged(object sender,System.EventArgs e){
			bool enabled= Chkasim.Checked;
			CBoxasim.Enabled=enabled;
			PanelAsim.Enabled=enabled;
		}
		void CBoxasim_SelectedIndexChanged(object sender,System.EventArgs e){
			if(config_otras[CBoxasim.SelectedIndex]=="Radial / tangencial"){
				lbl_radasim.Visible=true;
				lbl_tanasim.Visible=true;
				lbl_uvserie1.Visible=false;
				lbl_uvserie2.Visible=false;
			}else{
				lbl_radasim.Visible=false;
				lbl_tanasim.Visible=false;
				lbl_uvserie1.Visible=true;
				lbl_uvserie2.Visible=true;
			}
		}
	#endregion
	#region detalles
		void Lblradsim_Click(object sender,System.EventArgs e){
			FRadial1.modelo=(byte)(CBoxpoli.SelectedIndex+1);
			FRadial1.ShowDialog();
			lbl_radsim.T.Text= Convert.ToString(FRadial1.npar);
		}
		void Lbltansim_Click(object sender,System.EventArgs e){
			FTangencial1.modelo=(byte)(CBoxpoli.SelectedIndex+1);
			FTangencial1.ShowDialog();
			lbl_tansim.T.Text= Convert.ToString(FTangencial1.npar);
		}
		void Lblradasim_Click(object sender,System.EventArgs e){
			FAsimetricaRad1.modelo=(byte)(CBoxpoli.SelectedIndex+1);
			FAsimetricaRad1.ShowDialog();
			lbl_radasim.T.Text= Convert.ToString(FAsimetricaRad1.npar);
		}
		void Lbltanasim_Click(object sender,System.EventArgs e){
			FAsimetricaTan1.modelo=(byte)(CBoxpoli.SelectedIndex+1);
			FAsimetricaTan1.ShowDialog();
			lbl_tanasim.T.Text= Convert.ToString(FAsimetricaTan1.npar);
		}
		void Lbluvserie1_Click(object sender,System.EventArgs e){
			FAsimetricauvserie1.modelo=(byte)(CBoxpoli.SelectedIndex+1);
			FAsimetricauvserie1.ShowDialog();
			lbl_uvserie1.T.Text= Convert.ToString(FAsimetricauvserie1.npar);
		}
		void Lbluvserie2_Click(object sender,System.EventArgs e){
			FAsimetricauvserie2.modelo=(byte)(CBoxpoli.SelectedIndex+1);
			FAsimetricauvserie2.ShowDialog();
			lbl_uvserie2.T.Text= Convert.ToString(FAsimetricauvserie2.npar);
		}
	#endregion
	#endregion

	#region Configuracin
		void CSGrafico_Click(object sender,System.EventArgs e){
			FormSalidagra1.ShowDialog();
		}
		void CSSimbolos_Click(object sender,System.EventArgs e){
			FUni1.Show();
		}
	#endregion

	#region Calcular
		unsafe void Calcular_Click(object sender,System.EventArgs e){
			int returned;
			byte mar,pym;
			string texto;
			InterComCalibracion.ConfigDistorsion config_dist;
			string mensaje;
			System.IntPtr P_mensaje= IntPtr.Zero;
			System.IntPtr P_foto= IntPtr.Zero;
			System.IntPtr P_nombrebaseCEx= IntPtr.Zero;
			System.IntPtr P_apoyo= IntPtr.Zero;
			ushort *extpos;
			InterComCalibracion.Buffer_to log_file;
			uint log_level;
			float ratio;
			byte calcula1, calculaE, calculaI;
			double[] dval1=new double[6];
			double[] dvalExterna=new double[6];
			double[] dvalInterna=new double[3];

			log_file.id=(IntPtr)(-1);

			if(TxtBotfot.Text==""){
				MessageBoxAT.Show(get_texto(Debe_indicar_fich_foto));
				return;
			}else if(TxtBotfot.Text.IndexOfAny(Path.GetInvalidPathChars())!=-1){	//GetFullPath might raise SecurityException
				MessageBoxAT.Show(get_texto(Fotogramas_carcteres_no_vlidos));
				return;
			}

			if(!Methods.CheckExtension(MessageBoxAT,TxtBotfot.Text,Tffot.Indice,TipoFiltro.FotogramasLeer,idioma)) return;
			P_foto=				Marshal.StringToHGlobalUni(TxtBotfot.Text + new string((char)0, 4));
			P_nombrebaseCEx=Marshal.StringToHGlobalUni(TxtBotfot.Text+ new string((char)0, 5));	//for a future .html
			extpos=pointat((ushort*)P_nombrebaseCEx.ToPointer());
			extension3(extpos,'l','o','g');
			/*returned=InterComCalibracion.toopen(P_nombrebaseCEx,&log_file);
			if(returned!=0){
				log_file.id=(IntPtr)(-1);
				returned=0;
			}*/
			log_level=1;

			if(TxtBotapy.Text==""){
				MessageBoxAT.Show(get_texto(Debe_indicar_fich_apoyo));
				goto @return;
			}else if(TxtBotapy.Text.IndexOfAny(Path.GetInvalidPathChars())!=-1){	//GetFullPath might raise SecurityException
				MessageBoxAT.Show(get_texto(Apoyo_caracteres_no_vlidos));
				goto @return;
			}

			P_apoyo=Marshal.StringToHGlobalUni(TxtBotapy.Text+new string((char)0,4));

			Salida.General.P_unip=Marshal.StringToHGlobalUni(suni.p);
			Salida.General.P_unif=Marshal.StringToHGlobalUni(suni.f);
			Salida.General.P_unit=Marshal.StringToHGlobalUni(suni.t);

			//Principio cajas de texto
			TextBox cajablanca;
			calcula1=0;
			if(Chk_1.Checked){
				ratio=(float)Convert.ToByte(FCal1.Txtpixel_x.Text)/(float)Convert.ToByte(FCal1.Txtpixel_y.Text);
				if(FCal1.Optlevo.Checked) ratio=-ratio;
				byte i,l;
				for(i=0,l=1;i<6;i++,l<<=1){
					if(FCal1.Chk1[i].Checked){
						calcula1+=l;
						texto= FCal1.Text1apr[i].Text;
						if(texto==""){
							if(FCal1.Text1apr[i].BackColor==System.Drawing.SystemColors.Window){
								cajablanca=FCal1.Text1apr[i];
								goto cajaenblanco_1;
							}else dval1[i]= System.Double.NegativeInfinity;
						}else{
							try{dval1[i]= Basicas._gcVarios.atodbl(texto.ToCharArray());}
							catch(System.SystemException){
								MessageBoxAT.Show(get_texto(En_medidas_a_foto)+"\n"+get_texto(Tx_errneo + i));
								goto @return;
							}
						}
					}else{
						texto= FCal1.Text1con[i].Text;
						if(texto==""){
							cajablanca=FCal1.Text1con[i];
							goto cajaenblanco_1;
						}else{
							try{dval1[i]= Basicas._gcVarios.atodbl(texto.Trim().ToCharArray());}
							catch(System.SystemException){
								MessageBoxAT.Show(get_texto(En_medidas_a_foto)+"\n"+get_texto(Tx_errneo + i));
								goto @return;
							}
						}
					}
				}//Fin for
				goto Fin1;
				//if(false){
				cajaenblanco_1:
					Bot1_Click(Calcular,EventArgs.Empty);
					cajablanca.Focus();
					MessageBoxAT.Show(get_texto(Cajas_fondo_blanco_obligatorias));
					goto @return;
				//}
			}else{//Chk_1 Checked
				ratio=1;
				dval1[0]=dval1[1]=dval1[2]=0;
				dval1[3]=dval1[4]=1;
				dval1[5]=0;
			}
		Fin1:

			calculaE= 0;
			for(byte i=0,l=1;i<6;i++,l<<=1){
				if(FExterna1.ChkExterna[i].Checked){
					calculaE+=l;
					texto= FExterna1.TextExternaapr[i].Text;
					if(texto==""){
						if(FExterna1.TextExternaapr[i].BackColor==System.Drawing.SystemColors.Window){
							cajablanca=FExterna1.TextExternaapr[i];
							goto cajaenblanco_E;
						}else dvalExterna[i]= System.Double.NegativeInfinity;
					}else{
						try{dvalExterna[i]= Basicas._gcVarios.atodbl(texto.ToCharArray());}
						catch(System.SystemException){
							MessageBoxAT.Show(get_texto(En_externa)+" "+get_texto(X_errneo + i));
							goto @return;
						}
					}
				}else{
					texto= FExterna1.TextExternacon[i].Text;
					if(texto==""){
						cajablanca=FExterna1.TextExternacon[i];
						goto cajaenblanco_E;
					}else{
						try{dvalExterna[i]= Basicas._gcVarios.atodbl(texto.ToCharArray());}
						catch(System.SystemException){
							MessageBoxAT.Show(get_texto(En_externa)+" "+get_texto(X_errneo + i));
							goto @return;
						}
					}
				}
			}
		goto finE;
		cajaenblanco_E:
			BotExt_Click(Calcular,EventArgs.Empty);
			cajablanca.Focus();
			MessageBoxAT.Show(get_texto(Cajas_fondo_blanco_obligatorias));
			goto @return;
		finE:

			calculaI= 0;
			for(byte i=0,l=1;i<3;i++,l<<=1){
				if(FInterna1.ChkInterna[i].Checked){
					calculaI+=l;
					texto= FInterna1.TextInternaapr[i].Text;
					if(texto==""){
						if(FInterna1.TextInternaapr[i].BackColor==System.Drawing.SystemColors.Window){
							cajablanca=FInterna1.TextInternaapr[i];
							goto cajaenblanco_I;
						}else dvalInterna[i]= System.Double.NegativeInfinity;
					}else{
						try{dvalInterna[i]= Basicas._gcVarios.atodbl(texto.ToCharArray());}
						catch(System.SystemException){
							MessageBoxAT.Show(get_texto(focal_errnea+i));
							goto @return;
						}
					}
				}else{
					texto= FInterna1.TextInternacon[i].Text;
					if(texto==""){
						cajablanca=FInterna1.TextInternacon[i];
						goto cajaenblanco_I;
					}else{
						try{dvalInterna[i]= Basicas._gcVarios.atodbl(texto.ToCharArray());}
						catch(System.SystemException){
							MessageBoxAT.Show(get_texto(focal_errnea+i));
							goto @return;
						}
					}
				}
			}
		goto finI;
		cajaenblanco_I:
			Botfpp_Click(Calcular,EventArgs.Empty);
			cajablanca.Focus();
			MessageBoxAT.Show(get_texto(Cajas_fondo_blanco_obligatorias));
			goto @return;
		finI:

			//Fin cajas de texto
			if((Bot1.Enabled && FCal1.Chk1k.Checked) || dval1[2]!=0){
				if(FInterna1.ChkInternax.Checked!=FInterna1.ChkInternay.Checked){
					MessageBoxAT.Show(get_texto(giro_y_pp));
					goto @return;
				}
			}

			config_dist.modelo_poli=0;
			if(Chkdistorsion.Checked==false) goto Fin;

			//semdiag
			texto= Textsemidiag.Text;
			if(Textsemidiag.Text==""){
				config_dist.semidiag=float.NegativeInfinity;
			}else{
				try{config_dist.semidiag= Basicas._gcVarios.atofl(texto.ToCharArray());}
				catch(System.SystemException){
					MessageBoxAT.Show(get_texto(En_distorsin)+" "+get_texto(semidiag_errnea));
					goto @return;
				}
				if(config_dist.semidiag <= 0){
					MessageBoxAT.Show(get_texto(En_distorsin)+" "+get_texto(semidiag_errnea));
					goto @return;
				}
			}

			config_dist.modelo_poli= (byte)(CBoxpoli.SelectedIndex+1);
			config_dist.condicion= (byte)0;
			//radsim
			config_dist.param_radsim= 0;
			if(Chkradial.Checked){
				if((config_dist.condicion= (byte)(FInterna1.List1.SelectedIndex))==1){
					texto= FormR1.Textr1.Text;
					if(texto==""){
						MessageBoxAT.Show(get_texto(Debe_indicar_r1));
						goto @return;
					}
					try{config_dist.r1= Basicas._gcVarios.atofl(texto.ToCharArray());}
					catch(System.SystemException){
						MessageBoxAT.Show(get_texto(En_distorsin)+" "+get_texto(r1_errneo));
						goto @return;
					}
					if(config_dist.r1 <= 0){
						MessageBoxAT.Show(get_texto(En_distorsin)+" "+get_texto(r1_errneo));
						goto @return;
					}
				}

				byte i;
				uint l;
				for(i=1,l=1;i<=FormSimetrica.nparametros;i++,l<<=1){
					if(FRadial1.checkboxes[i].Checked)
						config_dist.param_radsim|=l;
				}
			}

			config_dist.param_tansim= 0;
			if(Chktangencial.Checked){
				byte i;
				uint l;
				for(i=1,l=1;i<=FormSimetrica.nparametros;i++,l<<=1){
					if(FTangencial1.checkboxes[i].Checked)
						config_dist.param_tansim|=l;
			}	}

			config_dist.modelo_asim= (byte)0;
			config_dist.param_asim1=0;
			config_dist.param_asim2=0;
			if(Chkasim.Checked){
				byte i;
				uint l;
				config_dist.modelo_asim= (byte)(CBoxasim.SelectedIndex+1);
				if(config_dist.modelo_asim==1){
					for(i=1,l=1;i<=FormAsimetricaRadTan.nparametros;i++,l<<=1){
						if(FAsimetricaRad1.checkboxes[i].Checked){
							config_dist.param_asim1|=l;
					}	}
					for(i=1,l=1;i<=FormAsimetricaRadTan.nparametros;i++,l<<=1){
						if(FAsimetricaTan1.checkboxes[i].Checked){
							config_dist.param_asim2|=l;
					}	}
				}else if(config_dist.modelo_asim==2){
					for(i=1,l=1;i<=FormAsimetricauv.nparametros;i++,l<<=1){
						if(FAsimetricauvserie1.checkboxes[i].Checked){
							config_dist.param_asim1|=l;
					}	}
					for(i=1,l=1;i<=FormAsimetricauv.nparametros;i++,l<<=1){
						if(FAsimetricauvserie2.checkboxes[i].Checked){
							config_dist.param_asim2|=l;
					}	}
				}
			}else{
				config_dist.modelo_asim=(byte)0;
			}

	Fin:
			ahora_no_se_puede_cerrar=1;
			P_mensaje=Marshal.AllocHGlobal(512);
			set_message(get_texto(Esperando_clculo));
			mar=FileTypeInfos[Tffot.Indice].aerotri;
			pym=FileTypeInfos[Tfapy.Indice].aerotri;
			try{
				fixed(double* p_val1=dval1,p_valE=dvalExterna,p_valI=dvalInterna){
					InterComCalibracion.Buffer_to *plog;
					if(log_file.id==(IntPtr)(-1)) plog=(InterComCalibracion.Buffer_to*)0;
					else plog=&log_file;
					returned= InterComCalibracion.mainCalibracion(this.Handle,plog,log_level, P_foto,mar, P_apoyo,pym, ratio, calcula1, calculaE, calculaI, p_val1, p_valE, p_valI, &config_dist, Salida, CGrafico.S, 2, P_mensaje, (byte)idioma);
					mensaje=Marshal.PtrToStringUni(P_mensaje);
				}
			}catch(System.DllNotFoundException){
				returned=-4;
				mensaje=get_texto(No_se_ha_podido_abrir_ajcalibracion);
			}
			if(returned==-3) mensaje=mensaje + "\n\n"+get_texto(No_ms_de_25puntos);
			set_message(mensaje_pordefecto);
			if(returned!=-1) MessageBoxAT.Show(mensaje);

			if(returned==0 || returned>2){
				/*if(Tffot.tipof!=0){	//Do not replace
					ushort *ext=pointat((ushort*)P_fotos.ToPointer());
					extension3(ext,'f','t','m');
					Tffot.tipof=0;
					Tffot.actualiza();
					TxtBotfot.Text= Marshal.PtrToStringUni(P_foto);
				}*/
			if(returned==0 || returned>3){
				if(Tfapy.Indice!=TipoFichero.Aerotriccpp){
					ushort *ext=pointat((ushort*)P_apoyo.ToPointer());
					extension3(ext,'p','r','m');
					Tfapy.Indice=TipoFichero.Aerotriccpp;
					Tfapy.actualiza();
					TxtBotapy.Text= Marshal.PtrToStringUni(P_apoyo);
				}
			}}
			if(returned!=0) goto @return;

			if(enlaces.EnlaceGrafico!=(void*)0){
			   void* hwnd=PanelesSub.varias.get_enlace_hwnd(enlaces.EnlaceGrafico);
			   if(hwnd!=null){
				//extension3(extpos,'g','r','a');
				//string graf=Marshal.PtrToStringUni(P_nombrebaseCEx);
				//malditopuntoNET.enlaceGra(enlaces.PanelGrafico1.get_Panel(),graf);
			}}
			if(enlaces.EnlaceEdTexto!=(void*)0){
				string[] argv=new string[3];
				argv[0]="-g";
				argv[1]="Calibracin";
				extension3(extpos,'i','n','f');
				argv[2]=Marshal.PtrToStringUni(P_nombrebaseCEx);
				malditopuntoNET.enlaceEdT(enlaces.EnlaceEdTexto,argv);	//Si el clr no fuese tan listo, y no hiciese por su cuenta lo que nadie le manda
				//enlaces.PanelEdTexto1.Invoke(enlaces.PanelEdTexto1.rannade_ficheros,new object[]{argv});	//no me hara falta llamar al EditordeDatos a travs de otra clase
			}

			string s;
			StreamWriter fbat;
			extension3(extpos,'b','a','t');
			try{
				s=Marshal.PtrToStringUni(P_nombrebaseCEx);
				fbat=new StreamWriter(s,false,System.Text.Encoding.Default);
				#if DEBUG
					AppPath=@"C:\Program Files (x86)\Aerotri\2012\";
				#endif
				fbat.WriteLine("SET  TEXMFCNF="+AppPath+@"tex\web2c\");
				fbat.WriteLine("\""+AppPath+@"tex\web2c\Aerotripdftex.exe"" """+Path.GetFileName(Path.ChangeExtension(s,"tex"))+"\"");
				fbat.WriteLine("del \""+Path.GetFileName(Path.ChangeExtension(s,"log"))+"\"");
				fbat.Close();
				Environment.CurrentDirectory=Path.GetDirectoryName(s);
				System.Diagnostics.Process.Start(s);
			}catch(System.IO.IOException){}
			#if DEBUG
				AppPath=Application.StartupPath+"\\";
			#endif
		@return:
			if(P_mensaje!=IntPtr.Zero) Marshal.FreeHGlobal(P_mensaje);
			if(Salida.General.P_unif!=IntPtr.Zero){
				Marshal.FreeHGlobal(Salida.General.P_unip);
				Marshal.FreeHGlobal(Salida.General.P_unif);
				Marshal.FreeHGlobal(Salida.General.P_unit);
			}
			if(P_nombrebaseCEx!=IntPtr.Zero) Marshal.FreeHGlobal(P_nombrebaseCEx);
			if(P_foto!=IntPtr.Zero) Marshal.FreeHGlobal(P_foto);
			if(P_apoyo!=IntPtr.Zero) Marshal.FreeHGlobal(P_apoyo);
			if(log_file.id!=(IntPtr)(-1)) InterComCalibracion.toclose(&log_file);
			ahora_no_se_puede_cerrar=0;
			return;
		}

		unsafe static ushort* pointat(ushort* fichero){
			ushort *ext, fin;
			ext=fichero; while(*ext!='\0') ext++;
			fin=ext;
			while(*ext!='.' && ext!=fichero) ext--;
			if(*ext!='.' || fin-ext>4) ext=fin;
			return ext;
		}
		unsafe static void extension3(ushort *ext, ushort x1, ushort x2, ushort x3){
			*ext++='.'; *ext++=x1; *ext++=x2; *ext++=x3; *ext='\0';
		}
		unsafe static void extension4(ushort *ext, ushort x1, ushort x2, ushort x3, ushort x4){
			*ext++='.'; *ext++=x1; *ext++=x2; *ext++=x3; *ext++=x4; *ext='\0';
		}
	#endregion

		protected override void colores(){
			base.colores();
			Calcular.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			Textsemidiag.T.BackColor=Globales.Colores.NETColor(Globales.Colores.cOpcional);
		}

	#region etiquetas_idiomas
		protected override void update_idioma(){
			base.update_idioma();

			ParentForm.Text=get_texto(Caption);
			MessageBoxAT.Caption=get_texto(MsgCaption);
			AAcercade.Text=get_texto(Acercade);
			ManualPath=get_texto(Manualpath);
			FormAcercade1.titulo=get_texto(Acercade);
			FormAcercade1.cabecera=get_texto(FullTitle);

			AAbrirConfig.Text=get_texto(Abrir);
			AGuardarConfig.Text=get_texto(Guardar);
			CSalida.Text=get_texto(Informacin_salida);
			CSGrafico.Text=get_texto(Grfico);
			CSSimbolos.Text=get_texto(Smbolos_unidades);
			switch(idioma){
				case Globales.Idioma.Esp: FormAcercade1.fecha="14 de abril de 2012"; break;
				case Globales.Idioma.Eng: FormAcercade1.fecha="14th April 2012"; break;
				case Globales.Idioma.It: FormAcercade1.fecha="14 aprile 2012"; break;
				default: goto case Globales.Idioma.Esp;
			}

			if(configuraciones_nombres!=null){
				bool b;
				b=llamada_Combo1;
				llamada_Combo1=true;
				int n=configuraciones_nombres.Length;
				if(n>0){
					if(configuraciones_nombres[0]=="Fotocoordenadas")
						ComboBox1.Items[0]=get_texto(Fotocoordenadas);
					if(n>1){
						if(configuraciones_nombres[1]=="Pixeles_mm")
							ComboBox1.Items[1]=get_texto(Pxeles_mm);
					if(n>2){
						if(configuraciones_nombres[2]=="Pixeles_micras")
							ComboBox1.Items[2]=get_texto(Pxeles_micras);
					if(n>3){
						if(configuraciones_nombres[3]=="Pixeles_pixeles")
							ComboBox1.Items[3]=get_texto(Pxeles_pxeles);
				}}}}
				llamada_Combo1=b;
			}
			Label12.Text=get_texto(Modelo_polinmico);
			CBoxpoli.Items[0]=get_texto(Impar);
			CBoxpoli.Items[1]=get_texto(Completo);
			CBoxasim.Items[0]=get_texto(Radial_tangencial);
			CBoxasim.Items[1]=get_texto(Vector_giratorio);

			TxtBotfot.L.Text=get_texto(Fotograma);
			TxtBotapy.L.Text=get_texto(Apoyo);

			GroupBox1.Text=get_texto(Otros_parmetros);
			Label3.Text=get_texto(no_se_suele_modificar);
			Label_1.Text=get_texto(Coord_medidas_fotocoord);
			Labelfpp.Text=get_texto(focal_y_pp);
			LabelExt.Text=get_texto(Orientacin_externa);

			Label_distorsion.Text=get_texto(Funcin_de_distorsin);
			Textsemidiag.L.Text=get_texto(Semidiagonal);
			lbl_radsim.L.Text=get_texto(Radial_simtrica);
			lbl_tansim.L.Text=get_texto(Tangencial_sim);
			Chkasim.L.Text=get_texto(Asimtricas);
			lbl_radasim.L.Text=get_texto(Radial_);
			lbl_tanasim.L.Text=get_texto(Tangencial_);
			lbl_uvserie1.L.Text=get_texto(Serie1_);
			lbl_uvserie2.L.Text=get_texto(Serie2_);

			Calcular.Text=get_texto(Textos.Cods.Calcular);

			Tffot.set_textos(GetShortNames(TipoFiltro.FotogramasLeer,idioma));
			Tfapy.set_textos(GetShortNames(TipoFiltro.PuntosTodos,idioma));
			Tffot.actualiza();
			Tfapy.actualiza();

			Chkdistorsion.Left= Label_distorsion.Location.X+Label_distorsion.Width+4;
			if(FCal1.Visible) FCal1.set_idioma(idioma);
			if(FInterna1.Visible) FInterna1.set_idioma(idioma);
			if(FExterna1.Visible) FExterna1.set_idioma(idioma);
			if(FUni1.Visible) FUni1.set_idioma(idioma);
		}

		private string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	#endregion

		string procesa_string(string ss){
			if(ss==null || ss.Length<1) return ss;
			if(ss[0]!='$') return ss;
			ss=ss.Substring(1,ss.Length-1);
			switch(ss){
				case "TamannoPixel":
					ss=get_texto(Tamao_de_pxel);
					if(ss.Length<11) ss+="  ";
					else ss+=" ";
					return ss;
			}
			return ss;
		}
	}

	internal class Varias{
		public static void redim(ref string[] cadenas,int n){
			int m=cadenas.Length;
			string[] antiguas=new string[m];

			int i;
			for(i=0;i<m;i++) antiguas[i]=cadenas[i];

			cadenas=new string[n];
			if(n<m) m=n;
			for(i=0;i<m;i++) cadenas[i]=antiguas[i];
		}
	}

	internal class malditopuntoNET{
		unsafe internal static void enlaceEdT(void* enlace,string[] args){
			EditorT.PanelEditorT Panel=(EditorT.PanelEditorT)PanelesSub.varias.get_Panel(enlace);
			if(Panel==null) return;
			if(!Panel.IsHandleCreated) Panel.rannade_ficheros(args);
			else{
				Panel.BeginInvoke(Panel.rannade_ficheros,new object[]{args});
			}
		}
		//internal static void enlaceGra(PanelesSub.PanelSubordinado panel,string name){
		//      ((Grafico.PanelGrafico)panel).Abrir_un_Fichero(name);
		//}
	}
}
