﻿using System;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.IO;
using ControlesAt;
using static Aerotri.InterComAerotri;
using static Globales.FileTypes;

namespace Aerotri{
using static Textos.Cods;

	unsafe public struct Enlaces{
		public void*	EnlaceGrafico,
						EnlaceEdTexto,
						EnlaceEdDatos;
	}
	internal struct ConfiguracionPrograma{
		public string OpenPath;
		public string OpenPathCam;
	}
	/// <summary>
	/// El contenido de un formulario Aerotri
	/// </summary>
	public class PanelAerotri : PanelesSub.PanelSubordinado
	{
		protected const byte Esp=(byte)Globales.Idioma.Esp;
		protected const byte Eng=(byte)Globales.Idioma.Eng;
		protected const byte It=(byte)Globales.Idioma.It;
		protected const byte Bra=(byte)Globales.Idioma.NIDIOMAS;

		private MenuItem	AAbrirTrabajo,	AGuardarTrabajo,
								AGuardarConfiguracion;
		private ContextMenu MenuHerramientas;
		private MenuItem	HTrFicheros,
								HTFotogramas,
								HTGpsIns,	HTInterna,
								HVCmd,		HModelos;
		private OpenFileDialog Open1, OpenCam;
		internal SaveFileDialog Save1;
		private MenuItem	CSensor,
									CSconico, CSmodelo;
		internal ControlesAt.BotAceptar Calcular;
		private GroupBox GroupBox11;
			internal RadioButton Ajcompleto;
			internal RadioButton SoloRel;
		internal Label lblinfo;
		internal TabControl TabControl1;
  /* */	internal TabPage TabPrincipal;
		private GroupBox GroupBox1;
		private Control GBox1_sep1, GBox1_sep2, GBox1_sep3, GBox1_sep4;
		private ControlesAt.LabelTxtBotAbrir	TxtBotfot,	TxtBotapr,
														TxtBotapy,	TxtBotgps;
		private ControlesAt.Labeltf	Tffot,		Tfapr,
											Tfapy,		Tfgps,
											Tfint;
		internal ContainerControl FotisFolder;
			internal ControlesAt.LabelRadio Fotfolder0, Fotfolder1;
		private ControlesAt.LabelCheck Chkaprajs;
		private ControlesAt.LabelTxtBotAbrir TxtBotint;
		private ControlesAt.MasMenos mmPrecisiones;
		private GroupBox GBoxPrecisiones;
			private ControlesAt.LTFloatPos	txtsigmaf,
														txtsigmaXY,		txtsigmaZ,
														txtsigmaGPSXY,	txtsigmaGPSZ,
														txtsigmaINSWF,	txtsigmaINSK;
			private GroupBox GroupBox5;
			private GroupBox GroupBox10;
			private GroupBox GroupBox6;
		internal GroupBox GroupBox4;
		internal RadioButton Variables, Fijos;
   /* */	internal TabPage TabAvanzado;
		internal GroupBox GroupBoxSistema;
		internal ControlesAt.SistemadeCoordenadas.ControlSistema ControlSistema;
		private ControlesAt.LabelBotppp BotAproximados;
		internal GroupBox GroupBoxEstimador;
		   internal RadioButton Rob0, Rob1;
		   internal ContainerControl PanelRobusto; 
			private Label LabelConjuntas;
			internal ControlesAt.LabelSelectorUD	ListConjuntasxy,
																ListConjuntasXY, ListConjuntasplaniZ;
		private GroupBox GroupBoxGPS;
			private ControlesAt.LabelRight Labeltdgps;
			internal Label lbltdgps, lbltdgps1;
			internal String[] nombres_tdgps;
			private CheckBox Chkfillgps, Chkinterp_resgps;
			private ControlesAt.BaseLabel LabelDifIns;
			private RadioButton Chkcamaragirada, Chkfotosgiradas;
		internal ComboBox Comestimador;
		private ControlesAt.BaseLabel Label25;
		internal ControlesAt.IntegerTextSingle Txt_limiteajuste, Txt_limiteajuste2;
		internal CheckBox ChkAutoCalib;
		private ControlesAt.BaseLabel LabelCalib;
   /* */	internal TabPage TabSalida;
		private GroupBox GSgeneral;
		private ControlesAt.LabelBotppp		LBotpdf,	LBotmm,	LBotdec, LBotpares;
		private GroupBox GSinformacion;
			private CheckBox	Chkinf,	Chkhtm,
									Chkbnf,	Chkpdf;
			private ControlesAt.Botonppp Botinf, Botbnf;
		private GroupBox GSajs;
			private CheckBox	Chkajs,
									Chkori,	Chkorixml,
									Chkoe,	ChkDigi,
									ChkImaster;
			private ControlesAt.Botonppp BotDigi,	BotImaster;
		private GroupBox GSautocalib;
			private CheckBox	Chkintint,	Chkintpdf,
									Chkintgra,	Chkintini,
									Chkintcmr,	ChkintDigi;
		private GroupBox GSotros;
			private CheckBox	Chkres,	Chkinc,
									Chkrespdf,	Chkstd,
									Chklog,	Chkgrares;
			private ControlesAt.Botonppp Botstd,	Botlog;
		CheckBox[] ChkF0;
		CheckBox[] ChkF1;
		private GroupBox GBoxEscalaRes;
		private ControlesAt.EscalaResiduos Escalares;

	#region Variables
		private bool idioma_read;
		internal bool calculando;
		internal Enlaces enlaces;
		internal EventHandler dCalcular;
		internal ConfiguracionPrograma ConfigPrograma;
		private FormtdGPS FormtdGPS1;
		private FormValoresAproximados FormAproximados1;
		private FormAutoCalib FormAutoCalib1;
		private FormTrFotogramas FormTrFotogramas1;
		//private FormTrAprApoyo FormTrAprApoyo1;
		private FormTrGpsIns FormTrGpsIns1;
		private FormTrCamara FormTrInterna1;
		private FormSalidapdf FPdf1;
		private ControlesAt.FormUnidades_pft FUni1;
		private FormSalidadec FDec1;
		private FormSalidaPares FPares1;
		private FormSalidainf FInf1;
		private FormSalidabnf FBnf1;
		private FormSalidaDigi FDigi1;
		private FormSalidaImaster FImaster1;
		private FormSalidastd FStd1;
		private FormSalidalog FLog1;
		private const short nestim=1;

		internal string nombretrabajo, ficheroftrabajo;
		internal byte flags_generar;
		internal CConfigSalida CSalida;
		internal DatosGPS datosgps;
		internal ValoresAproximados aproximados;
		internal CConfigInterna CInterna;
		internal CConfigSalida CSalidaDefecto;
		internal static readonly string[] Comestimador_nombres=new String[nestim]{
			"Aerotri 2006",
		};
		static char[] separadores= {' ','\t'};
		internal TwoStrings rutasDigi, rutasImaster;
		internal Cbool muestra_html;
		internal ControlesAt.ThreeStrings suni;
		internal bool leyendo_configuracion;
	#endregion

	#region Inicialización
		unsafe public PanelAerotri(PanelesSub.Duenno _owner, Globales.Idioma idioma_inicial, IntPtr _enlaces) : base(_owner,idioma_inicial){
			enlaces.EnlaceGrafico=(void*)0;
			enlaces.EnlaceEdTexto=(void*)0;
			enlaces.EnlaceEdDatos=(void*)0;
			if(_enlaces!=IntPtr.Zero){
				void** enl=(void**)_enlaces.ToPointer();
				for(;*enl!=(void*)0;enl++){
					char* nom=PanelesSub.varias.get_enlace_nombre(*enl);
					string nombre=new String(nom);
					switch(nombre){
						case "Grafico": enlaces.EnlaceGrafico=*enl; break;
						case "EditordeTexto": enlaces.EnlaceEdTexto=*enl; break;
						case "EditordeDatos": enlaces.EnlaceEdDatos=*enl; break;
					}
				}
			}
			InitializeComponent();
		}
		unsafe public PanelAerotri() : base(){
			enlaces.EnlaceGrafico=(void*)0;
			enlaces.EnlaceEdTexto=(void*)0;
			enlaces.EnlaceEdDatos=(void*)0;
			InitializeComponent();
		}
		protected override void inizializeb(string[] argv){
			short n;
			string _titulo;
			string ext;

			nombretrabajo=null;
			calculando=false;
			AppData=Environment.GetFolderPath(Environment.SpecialFolder.ApplicationData)+"\\Aerotri\\";
			if(!System.IO.Directory.Exists(AppData)) System.IO.Directory.CreateDirectory(AppData);
			icono= new System.Drawing.Icon(System.Reflection.Assembly.GetExecutingAssembly().GetManifestResourceStream("Aerotri.IconAerotri.ico"));
			MessageBoxAT.Caption="Aerotri";
			ParentForm.AcceptButton=this.Calcular;

			//Los encapsulados
			CSalida=new CConfigSalida();
			CSalidaDefecto=new CConfigSalida();
			CInterna=new CConfigInterna();
			rutasDigi=new TwoStrings();
			rutasImaster=new TwoStrings();
			muestra_html=new Cbool();
			suni=new ControlesAt.ThreeStrings();

			FormtdGPS1=new FormtdGPS(this);
			FormAproximados1=new FormValoresAproximados(this);
			FormAutoCalib1=new FormAutoCalib(this, this.ParentForm, CInterna);
				FormAutoCalib1.FRadial1.Icon=icono;
				FormAutoCalib1.FTangencial1.Icon=icono;
				FormAutoCalib1.FAsimetricaRad1.Icon=icono;
				FormAutoCalib1.FAsimetricaTan1.Icon=icono;
				FormAutoCalib1.FAsimetricauvserie1.Icon=icono;
				FormAutoCalib1.FAsimetricauvserie2.Icon=icono;
			FormTrFotogramas1=new FormTrFotogramas(this);	FormTrFotogramas1.Icon=icono;
			//FormTrAprApoyo1=new FormTrAprApoyo(this);		FormTrAprApoyo1.Icon=icono;
			FormTrGpsIns1=new FormTrGpsIns(this);					FormTrGpsIns1.Icon=icono;
			FormTrInterna1=new FormTrCamara(this);				FormTrInterna1.Icon=icono;
			FPdf1= new FormSalidapdf(this, this.ParentForm, CSalida);
			FUni1=new FormUnidades_pft(this, this.ParentForm, suni);
			FDec1= new FormSalidadec(this, this.ParentForm, CSalida);
			FPares1= new FormSalidaPares(this, this.ParentForm, CSalida);
			FInf1= new FormSalidainf(this, this.ParentForm, CSalida, muestra_html);
			FBnf1= new FormSalidabnf(this, this.ParentForm, CSalida);
			FDigi1= new FormSalidaDigi(this, this.ParentForm, CSalida, rutasDigi);
			FImaster1= new FormSalidaImaster(this, this.ParentForm, CSalida, rutasImaster);
			FStd1= new FormSalidastd(this, this.ParentForm, CSalida);
			FLog1= new FormSalidalog(this, this.ParentForm);
			FormAcercade1=new FormAcercade(typeof(PanelAerotri),idioma);
			FormAcercade1.Icon= icono;
			FormAcercade1.LabelIcono.Image= icono.ToBitmap();

			ControlSistema.SetOwner(ParentForm);
			FormtdGPS1.Owner=ParentForm;
			FormAproximados1.Owner=ParentForm;
			FormAutoCalib1.Owner=ParentForm;
			FormTrFotogramas1.Owner=ParentForm;
			//FormTrAprApoyo1.Owner=ParentForm;
			FormTrGpsIns1.Owner=ParentForm;
			FormTrInterna1.Owner=ParentForm;
			FPdf1.Owner=ParentForm;
			FDec1.Owner=ParentForm;
			FPares1.Owner=ParentForm;
			FUni1.Owner=ParentForm;
			FInf1.Owner=ParentForm;
			FBnf1.Owner=ParentForm;
			FDigi1.Owner=ParentForm;
			FImaster1.Owner=ParentForm;
			FStd1.Owner=ParentForm;
			FLog1.Owner=ParentForm;
			FormAcercade1.Owner=ParentForm;

			dCalcular= new EventHandler(this.Calcular_Click);

			//MessageBoxAT.Show("");
			try{lee_configuracion(GetUserOrDefault_File("Configuraciones\\Aerotri\\porDefecto.cfg"),false);}
			catch(Exception){}

			idioma_read=false;
			lee_ficheroConfiguracion("Aerotri.config");
			if(!idioma_read && Myowner.modo==0){
				idioma_read=PanelesSub.varias.read_reg_language("Aerotri","InstallLanguage",ref base.idioma);
			}

			n=(short)argv.Length;
			if(n==0) goto Finext;
			_titulo=argv[n-1];
			try{
				System.Text.StringBuilder fichero=new System.Text.StringBuilder(260);
				InterComAerotri.GetLongPathName(_titulo,fichero,256);
				_titulo=fichero.ToString();
				ext=System.IO.Path.GetExtension(_titulo);
				ConfigPrograma.OpenPath=System.IO.Path.GetDirectoryName(_titulo);
			}catch(ArgumentException){goto Finext;}
			switch(ext.ToLower()){
			 case ".art":
				Abre_trabajo(_titulo);
				break;
			}

		Finext:
			EventHandler quitar_aj=new EventHandler(Quita_ajustados);
			TxtBotapr.TextChanged+= quitar_aj;
			TxtBotapy.TextChanged+= quitar_aj;
			TxtBotgps.TextChanged+= quitar_aj;
			txtsigmaf.T.TextChanged+= quitar_aj;
			txtsigmaXY.T.TextChanged+= quitar_aj;			txtsigmaZ.T.TextChanged+= quitar_aj;
			txtsigmaGPSXY.T.TextChanged+= quitar_aj;	txtsigmaGPSZ.T.TextChanged+= quitar_aj;
			txtsigmaINSWF.T.TextChanged+= quitar_aj;	txtsigmaINSK.T.TextChanged+= quitar_aj;
			ListConjuntasxy.T.SelectedItemChanged+= quitar_aj;
			ListConjuntasXY.T.SelectedItemChanged+= quitar_aj;
			ListConjuntasplaniZ.T.SelectedItemChanged+= quitar_aj;
			lbltdgps.TextChanged+= quitar_aj;
			Rob1.CheckedChanged+=quitar_aj;
			ControlSistema.SistemaChanged+=quitar_aj;
			ControlSistema.OndulacionChanged+=quitar_aj;
			leyendo_configuracion=false;

			ParentForm.Text="Aerotri";
			colores();
			update_idioma();
		#if UPM
			ParentForm.Text="Aerotri - E.T.S.I. Topografía";
		#endif

			lbltdgps.Text=nombres_tdgps[(byte)(datosgps.tdgps+1)]+"/"+nombres_tdgps[(byte)(datosgps.tdins+1)];
		}
		protected override void lee_ficheroConfiguracion(string nombre){
			base.lee_ficheroConfiguracion(nombre);
			ConfigPrograma.OpenPath=__OpenPath;
		}
		protected override void procesa_linea_config(string tipo, string[] palabras){
			if(tipo=="OpenPathCam"){
				if(palabras.Length<2) return;
				ConfigPrograma.OpenPathCam=System.IO.Path.GetFullPath(palabras[1]);
				return;
			}
			if(!idioma_read) if(tipo=="Idioma") idioma_read=true;
			base.procesa_linea_config (tipo, palabras);
		}
#endregion

#region InitializeComponent
		private void InitializeComponent(){
			AAbrirTrabajo= new MenuItem();
			AGuardarTrabajo= new MenuItem();
			AGuardarConfiguracion= new MenuItem();
			MenuHerramientas= new ContextMenu();
			HTrFicheros= new MenuItem();
				HTFotogramas= new MenuItem();
				//HTAprApoyo= new MenuItem();
				HTGpsIns= new MenuItem();
				HTInterna= new MenuItem();
			HVCmd= new MenuItem();
			HModelos= new MenuItem();
			Open1= new OpenFileDialog();
			OpenCam= new OpenFileDialog();
			Save1= new SaveFileDialog();
			GroupBox11= new GroupBox();
			Ajcompleto= new RadioButton();
			SoloRel= new RadioButton();
			CSensor= new MenuItem();
				CSconico= new MenuItem();
				CSmodelo= new MenuItem();
			Calcular= new BotAceptar();
			lblinfo= new Label();

			int old;
			TabControl1= new TabControl();
			TabPrincipal= new TabPage();
			GroupBox1= new GroupBox();
			GBox1_sep1= new Control();
			GBox1_sep2= new Control();
			GBox1_sep3= new Control();
			GBox1_sep4= new Control();
			TxtBotfot= new LabelTxtBotAbrir();
			TxtBotapr= new LabelTxtBotAbrir();
			TxtBotapy= new LabelTxtBotAbrir();
			TxtBotgps= new LabelTxtBotAbrir((short)3);
			Tffot= new Labeltf(Filtros[TipoFiltro.FotogramasLeer]);
			Tfint= new Labeltf(Filtros[TipoFiltro.InternaLeer]);
			Tfapr= new Labeltf(Filtros[TipoFiltro.Aproximadas]);
			Tfapy= new Labeltf(Filtros[TipoFiltro.Apoyo]);
			Tfgps= new Labeltf(Filtros[TipoFiltro.GPSLeer]);
			FotisFolder= new ContainerControl();
			Fotfolder0= new LabelRadio();
			Fotfolder1= new LabelRadio();
			Chkaprajs= new LabelCheck();
			LabelConjuntas= new Label();
			mmPrecisiones= new MasMenos();
			GBoxPrecisiones= new GroupBox();
			GroupBox4= new GroupBox();
			GroupBox5= new GroupBox();
			GroupBox6= new GroupBox();
			old=LTFloatPos.DefaultSep(4);
			txtsigmaf= new LTFloatPos();
			txtsigmaXY= new LTFloatPos();
			txtsigmaZ= new LTFloatPos();
			txtsigmaGPSXY= new LTFloatPos();
			txtsigmaGPSZ= new LTFloatPos();
			txtsigmaINSWF= new LTFloatPos();
			txtsigmaINSK= new LTFloatPos();
			LTFloatPos.DefaultSep(old);

			TabAvanzado= new TabPage();
			BotAproximados= new LabelBotppp();
			TxtBotint= new LabelTxtBotAbrir();
			GroupBox10= new GroupBox();
				Variables= new RadioButton();
				Fijos= new RadioButton();
			GroupBoxEstimador= new GroupBox();
			   Rob0= new RadioButton();
			   Rob1= new RadioButton();
			   PanelRobusto= new ContainerControl();
				LabelConjuntas= new Label();
				ListConjuntasxy= new LabelSelectorUD(108,(short)4);
				ListConjuntasXY= new LabelSelectorUD(108,(short)4);
				ListConjuntasplaniZ= new LabelSelectorUD(108,(short)4);
			Comestimador= new ComboBox();		Label25= new BaseLabel();
			Txt_limiteajuste= new IntegerTextSingle();
			Txt_limiteajuste2= new IntegerTextSingle();
			ChkAutoCalib= new CheckBox();		LabelCalib= new BaseLabel();
			GroupBoxSistema= new GroupBox();
			ControlSistema= new ControlesAt.SistemadeCoordenadas.ControlSistema();
			GroupBoxGPS= new GroupBox();
				Labeltdgps= new LabelRight();
				lbltdgps= new Label();
					lbltdgps1= new Label();
				nombres_tdgps=new String[]{"","","",""};
				Chkfillgps= new CheckBox();
				Chkinterp_resgps= new CheckBox();
				LabelDifIns= new BaseLabel();
				Chkcamaragirada= new RadioButton();
				Chkfotosgiradas= new RadioButton();

			TabSalida= new TabPage();
			GSgeneral= new GroupBox();
			LBotpdf= new LabelBotppp();
			LBotmm= new LabelBotppp();
			LBotdec= new LabelBotppp();
			LBotpares=new LabelBotppp();
			GSinformacion= new GroupBox();
			Chkinf= new CheckBox();
			Chkhtm= new CheckBox();	Botinf= new Botonppp();
			Chkbnf= new CheckBox();		Botbnf= new Botonppp();
			Chkpdf= new CheckBox();
			GSajs= new GroupBox();
			Chkajs= new CheckBox();
			Chkori= new CheckBox();
			Chkorixml= new CheckBox();
			Chkoe= new CheckBox();
			ChkDigi= new CheckBox();		BotDigi= new Botonppp();
			ChkImaster= new CheckBox();	BotImaster= new Botonppp();
			GSautocalib= new GroupBox();
			Chkintint= new CheckBox();
			Chkintpdf= new CheckBox();
			Chkintgra= new CheckBox();
			Chkintini= new CheckBox();
			Chkintcmr= new CheckBox();
			ChkintDigi= new CheckBox();
			GSotros= new GroupBox();
			Chkres= new CheckBox();
			Chkinc= new CheckBox();
			Chkrespdf= new CheckBox();
			Chkstd= new CheckBox();		Botstd= new Botonppp();
			Chklog= new CheckBox();		Botlog= new Botonppp();
			Chkgrares= new CheckBox();
			ChkF0= new CheckBox[16];
			ChkF1= new CheckBox[16];
			ChkF0[0]=Chkres;
			ChkF0[1]=Chkinc;
			ChkF0[2]=Chkrespdf;
			ChkF0[3]=Chkstd;
			ChkF0[4]=Chklog;
			ChkF0[5]=Chkgrares;
			ChkF0[6]=ChkF0[7]=null;
			ChkF0[8]=Chkajs;
			ChkF0[9]=Chkori;
			ChkF0[10]=Chkorixml;
			ChkF0[11]=ChkDigi;
			ChkF0[12]=Chkoe;
			ChkF0[13]=ChkImaster;
			ChkF0[14]=ChkF0[15]=null;
			ChkF1[0]=Chkinf;
			ChkF1[1]=Chkhtm;
			ChkF1[2]=Chkbnf;
			ChkF1[3]=Chkpdf;
			ChkF1[4]=ChkF1[5]=ChkF1[6]=ChkF1[7]=null;
			ChkF1[8]=Chkintint;
			ChkF1[9]=Chkintpdf;
			ChkF1[10]=Chkintgra;
			ChkF1[11]=Chkintini;
			ChkF1[12]=Chkintcmr;
			ChkF1[13]=ChkintDigi;
			ChkF1[14]=ChkF1[15]=null;
			for(int i=0;i<16;i++){if(ChkF0[i]!=null) ChkF0[i].Height=16;}
			for(int i=0;i<16;i++){if(ChkF1[i]!=null) ChkF1[i].Height=16;}
			GBoxEscalaRes= new GroupBox();
			Escalares= new EscalaResiduos();

			PanelMenu1.Controls.Remove(PanelMenu1.gLabels("Archivo"));
			PanelMenu1.AddLabel("Herramientas",MenuHerramientas);
			PanelMenu1.Controls.Add(PanelMenu1.gLabels("Archivo"));
			// AAbrirTrabajo, etc.
			//
			AAbrirTrabajo.Index= 0;
			AAbrirTrabajo.Click+= new EventHandler(AAbrirTrabajo_Click);
			//
			AGuardarTrabajo.Index= 1;
			AGuardarTrabajo.Click+= new EventHandler(AGuardarTrabajo_Click);
			//
			AGuardarConfiguracion.Index= 2;
			AGuardarConfiguracion.Click+= new EventHandler(AGuardarConfiguracion_Click);
			//
			MenuArchivo.MenuItems.Remove(ASalir);
			ASalir.Index=3;
			//
			// MenuArcihvo
			//
			MenuArchivo.MenuItems.AddRange(new MenuItem[] {AAbrirTrabajo,
																				AGuardarTrabajo,
																				AGuardarConfiguracion,
																				ASalir});
			//
			// MenuHerramientas
			//
			MenuHerramientas.MenuItems.AddRange(new MenuItem[]{HTrFicheros, HVCmd, HModelos});
			HTrFicheros.Index=0;
			HVCmd.Index=1;
			HModelos.Index=2;
			//
			// HTrFicheros
			//
			HTrFicheros.MenuItems.AddRange(new MenuItem[]{	HTFotogramas,
																				//HTAprApoyo,
																				HTGpsIns,
																				HTInterna});
			HTFotogramas.Index=0;	HTFotogramas.Click+= (s,e)=>FormTrFotogramas1.Show();
			//HTAprApoyo.Index=1;	HTAprApoyo.Click+= (s,e)=>FormTrAprApoyo1.Show();
			HTGpsIns.Index=1;		HTGpsIns.Click+= (s,e)=>FormTrGpsIns1.Show();
			HTInterna.Index=2;		HTInterna.Click+= (s,e)=>FormTrInterna1.Show();
			//
			// HVCmd
			HVCmd.Click+=new EventHandler(HVCmd_Click);
			HModelos.Click+=new EventHandler(HModelos_Click);
			//
			// CSensor
			//
			CSensor.Index= 1;
			CSensor.MenuItems.AddRange(new MenuItem[]{CSconico, CSmodelo});
			CSensor.Visible=false;
			//
			CSconico.Checked=true;
			CSconico.Index= 0;		CSconico.Click+= new EventHandler(CSconico_Click);
			CSmodelo.Index= 1;	CSmodelo.Click+= new EventHandler(CSmodelo_Click);
			//
			// MenuConfiguracion
			//
			MenuConfiguracion.MenuItems.AddRange(new MenuItem[]{CSensor});
			//
			// TabControl1
			//
			TabControl1.Controls.Add(this.TabPrincipal);
			TabControl1.Controls.Add(this.TabAvanzado);
			TabControl1.Controls.Add(this.TabSalida);
			TabControl1.Location= new Point(4, 20);
			TabControl1.SelectedIndex= 0;
			TabControl1.Size= new Size(616, 328);
			TabControl1.TabIndex= 0;
			foreach(TabPage p in TabControl1.TabPages){
				p.Size=new Size(TabControl1.Width-8,TabControl1.Height-28);
			}
			//
			// TabPrincipal
			//
			TabPrincipal.Controls.Add(this.GroupBoxSistema);
			TabPrincipal.Controls.AddRange(new Control[]{TxtBotapr, Tfapr, Chkaprajs});
			TabPrincipal.Controls.Add(mmPrecisiones);
			TabPrincipal.Controls.Add(this.GBoxPrecisiones);
			TabPrincipal.Controls.Add(this.GroupBox1);
			TabPrincipal.TabIndex= 0;
			//
			// GroupBox1
			//
			GroupBox1.Controls.AddRange(new Control[]{
				GBox1_sep2,	GBox1_sep4,	GBox1_sep1,	GBox1_sep3,
				TxtBotfot,	Tffot,		FotisFolder,
				TxtBotint,	Tfint,
				TxtBotapy,	Tfapy,
				TxtBotgps,	Tfgps,
			});
			GroupBox1.Location= new Point(0, 0);
			GroupBox1.Size= new Size(608, 140);
			GroupBox1.TabIndex= 0;
			//
			// Separadores
			GBox1_sep1.BackColor=Globales.Colores.NETColor(Globales.Colores.cAceptarFormLabel);
			GBox1_sep2.BackColor=Color.White;
			GBox1_sep3.BackColor=GBox1_sep1.BackColor;
			GBox1_sep4.BackColor=GBox1_sep2.BackColor;
			GBox1_sep1.Location= new Point(7,69);		GBox1_sep1.Size= new Size(593,1);
			GBox1_sep2.Location= new Point(7,70);		GBox1_sep2.Size= new Size(593,2);
			GBox1_sep3.Location= new Point(307,10);		GBox1_sep3.Size= new Size(1,123);
			GBox1_sep4.Location= new Point(308,10);	GBox1_sep4.Size= new Size(1,123);
			//
			// TxtBotfot, etc.
			TxtBotfot.TextLocation= new Point(116, 16);		TxtBotfot.TabIndex= 0;	TxtBotfot.Click+= new EventHandler(Botabrirfot_Click);
			TxtBotint.TextLocation= new Point(416, 16);		TxtBotint.TabIndex= 1;	TxtBotint.Click+= new EventHandler(Botabrirint_Click);
			TxtBotapy.TextLocation= new Point(116, 84);		TxtBotapy.TabIndex= 2;	TxtBotapy.Click+= new EventHandler(Botabrirapy_Click);
			TxtBotgps.TextLocation= new Point(416, 84);		TxtBotgps.TabIndex= 3;	TxtBotgps.Click+= new EventHandler(Botabrirgps_Click);
			//TxtBotgps.L.Top+=1;
			//
			// Tffot, apr, apy, gps
			//
			Tffot.Location= new Point(24-6, 44);	Tffot.TabIndex= 4;		Tffot.Width+=8;
			Tfint.Location= new Point(328, 48);		Tfint.TabIndex= 6;
			Tfapy.Location= new Point(24, 116);		Tfapy.TabIndex= 8;
			Tfgps.Location= new Point(328-12, 116);	Tfgps.TabIndex= 9;		Tfgps.Width+=16;
			//
			// FotisFolder
			//
			FotisFolder.Location= new Point(120,40);		FotisFolder.TabIndex=5;		FotisFolder.Size=new Size(180,22);
			Fotfolder0.TextLocation= new Point(76,0);		Fotfolder0.TabIndex=0;
			Fotfolder1.TextLocation= new Point(164,0);		Fotfolder1.TabIndex=1;
			FotisFolder.Visible=false;
			FotisFolder.Controls.Add(Fotfolder0);
			FotisFolder.Controls.Add(Fotfolder1);
			Fotfolder0.CheckedChanged+=new EventHandler(FotFolder_CheckedChanged);
			Fotfolder1.CheckedChanged+=new EventHandler(FotFolder_CheckedChanged);
			//
			// TxtBotapr
			//
			TxtBotapr.TextLocation=new Point(424, 150);		TxtBotapr.TextWidth-=4;	TxtBotapr.TabIndex= 1;
			TxtBotapr.Click+= new EventHandler(Botabrirapr_Click);
			Tfapr.Location= new Point(336-12, 182);				Tfapr.TabIndex= 2;		Tfapr.Width+=16;
			//
			Chkaprajs.TextLocation=new Point(590,182);	Chkaprajs.TabIndex= 3;
			Chkaprajs.T.Width=13;	//Parece otro bug del .NET. Wdith ya es 13, pero si no pongo esto hace algo raro.
			//
			// GBoxPrecisiones
			//
			GBoxPrecisiones.Controls.Add(txtsigmaf);
			GBoxPrecisiones.Controls.Add(this.GroupBox4);
			GBoxPrecisiones.Controls.Add(this.GroupBox5);
			GBoxPrecisiones.Controls.Add(this.GroupBox6);
			GBoxPrecisiones.Location= new Point(0, 140);
			GBoxPrecisiones.Size= new Size(318, 160);
			GBoxPrecisiones.TabIndex= 3;
			//
			// mmPrecisiones
			mmPrecisiones.Location= GBoxPrecisiones.Location + new Size(5,3);
			mmPrecisiones.State=false;
			mmPrecisiones.Click+=new EventHandler(mmPrecisiones_Click);
			//
			// txtsigmaf
			txtsigmaf.TextLocation= new Point(148, 16);
			txtsigmaf.TabIndex= 0;
			//
			// GroupBox4, 5, 6
			//
			GroupBox4.Controls.Add(txtsigmaZ);		GroupBox4.Controls.Add(txtsigmaXY);
			GroupBox5.Controls.Add(txtsigmaGPSZ);	GroupBox5.Controls.Add(txtsigmaGPSXY);
			GroupBox6.Controls.Add(txtsigmaINSK);	GroupBox6.Controls.Add(txtsigmaINSWF);
			//
			GroupBox4.Location= new Point(4, 40);	GroupBox4.Size= new Size(308, 37);		GroupBox4.TabIndex= 2;
			GroupBox5.Location= new Point(4, 80);	GroupBox5.Size= new Size(308, 37);		GroupBox5.TabIndex= 3;
			GroupBox6.Location= new Point(4, 120);	GroupBox6.Size= new Size(308, 37);		GroupBox6.TabIndex= 4;
			//
			// txtsigmaXY, Z, GPS
			//
			txtsigmaXY.TextLocation= new Point(88, 12);			txtsigmaXY.TabIndex= 0;
			txtsigmaZ.TextLocation= new Point(224, 12);			txtsigmaZ.TabIndex= 1;
			txtsigmaGPSXY.TextLocation= new Point(88, 12);		txtsigmaGPSXY.TabIndex= 0;
			txtsigmaGPSZ.TextLocation= new Point(224, 12);		txtsigmaGPSZ.TabIndex= 1;
			txtsigmaINSWF.TextLocation= new Point(88, 12);		txtsigmaINSWF.TabIndex= 0;
			txtsigmaINSK.TextLocation= new Point(224, 12);		txtsigmaINSK.TabIndex= 1;
			//
			// Label13, 14
			//
			txtsigmaINSWF.L.Font= new Font("Symbol", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(2)));
			txtsigmaINSWF.L.Text= "W,F";
			//
			txtsigmaINSK.L.Font= txtsigmaINSWF.L.Font;
			txtsigmaINSK.L.Text= "K";
			//
			// GroupBoxSistema
			//
			GroupBoxSistema.Controls.Add(ControlSistema);
			GroupBoxSistema.Location= new Point(368, 212);
			GroupBoxSistema.Size= ControlSistema.Size + new Size(8,23);
			GroupBoxSistema.TabIndex= 4;
			//
			ControlSistema.Location= new Point(4,20);
			//
			// TabAvanzado
			//
			TabAvanzado.Controls.Add(ChkAutoCalib);
			TabAvanzado.Controls.Add(this.GroupBox10);
			TabAvanzado.Controls.Add(this.GroupBoxEstimador);
			TabAvanzado.Controls.Add(this.GroupBoxGPS);
			TabAvanzado.Controls.Add(BotAproximados);
			//TabAvanzado.Controls.Add(Comestimador);
			//TabAvanzado.Controls.Add(Label25);
			//TabAvanzado.Controls.Add(Txt_limiteajuste);
			//TabAvanzado.Controls.Add(Txt_limiteajuste2);
			TabAvanzado.Controls.Add(LabelCalib);
			TabAvanzado.TabIndex= 1;
			TabAvanzado.Visible= false;
			TabAvanzado.MouseUp+=new MouseEventHandler(TabAvanzado_MouseUp);
			//
			BotAproximados.TextLocation= new Point(272, 25);														BotAproximados.TabIndex= 0;
			GroupBoxGPS.Location=new Point(16,76);				GroupBoxGPS.Size= new Size(312,204);	GroupBoxGPS.TabIndex= 1;
			LabelCalib.RefLocation= new Point(433,28);																	LabelCalib.TabIndex= 2;
			ChkAutoCalib.Location= LabelCalib.RefLocation-new Size(20,2);	ChkAutoCalib.Size=new Size(17,17);		ChkAutoCalib.TabIndex= 3;
			GroupBox10.Location= new Point(340, 76);				GroupBox10.Size= new Size(264, 44);		GroupBox10.TabIndex= 4;
			GroupBoxEstimador.Location= new Point(340, 132);	GroupBoxEstimador.Size= new Size(264, 148);	GroupBoxEstimador.TabIndex= 5;
			//
			// BotAproximados
			//
			BotAproximados.Click+= (s,e)=>FormAproximados1.ShowDialog();
			//
			// GroupBox10
			//
			GroupBox10.Controls.Add(Variables);
			GroupBox10.Controls.Add(Fijos);
			//
			Fijos.Location= new Point(16, 20);			Fijos.Size= new Size(80, 16);		Fijos.TabIndex= 0;
			Variables.Location= new Point(136, 20);	Variables.Size= new Size(80, 16);	Variables.TabIndex= 1;
			Variables.Checked= true;
			Variables.CheckedChanged+= new EventHandler(Quita_ajustados);
			//
			// GroupBoxEstimador
			//
			GroupBoxEstimador.Controls.AddRange(new Control[]{
				Rob0, Rob1,
				PanelRobusto
			});
			PanelRobusto.Controls.AddRange(new Control[]{
				//Comestimador,	Label25,
				//Txt_limiteajuste, Txt_limiteajuste2,
				LabelConjuntas,
				ListConjuntasxy, ListConjuntasXY, ListConjuntasplaniZ
			});
			//
			Rob0.Location= new Point(16, 20);		Rob0.Size= new Size(120, 16);	Rob0.TabIndex= 0;
			Rob1.Location= new Point(136, 20);		Rob1.Size= new Size(80, 16);		Rob1.TabIndex= 1;
			PanelRobusto.Location= new Point(4,40);
			PanelRobusto.Size= GroupBoxEstimador.ClientSize-new Size(8,44);
			PanelRobusto.TabIndex= 2;
			Comestimador.Location= new Point(12, 16);		Comestimador.Size= new Size(116, 21);	Comestimador.TabIndex= 0;
			Label25.RefLocation= new Point(132, 221);														Label25.TabIndex= 1;
			Txt_limiteajuste.Location=new Point(76,248);
			Txt_limiteajuste2.Location=new Point(128,248);
			LabelConjuntas.Location= new Point(12, 16);		LabelConjuntas.Width=200;		LabelConjuntas.TabIndex= 4;
			ListConjuntasxy.TextLocation= new Point(144, 40);										ListConjuntasxy.TabIndex= 5;
			ListConjuntasXY.TextLocation= new Point(144, 60);									ListConjuntasXY.TabIndex= 6;
			ListConjuntasplaniZ.TextLocation= new Point(144, 80);								ListConjuntasplaniZ.TabIndex= 7;
			//
			Rob1.CheckedChanged += (s,e)=>PanelRobusto.Enabled=Rob1.Checked;
			//
			Comestimador.DropDownStyle= ComboBoxStyle.DropDownList;
			Comestimador.Items.AddRange(new object[nestim]{"Aerotri"});
			Txt_limiteajuste.Text="12";
			Txt_limiteajuste2.Text="15";
			//
			ListConjuntasxy.T.Items.Add("Individual");
			ListConjuntasxy.T.Items.Add("Conjunto");
			//
			ListConjuntasXY.T.Items.Add("Individual");
			ListConjuntasXY.T.Items.Add("Conjunto");
			//
			ListConjuntasplaniZ.T.Items.Add("Individual");
			ListConjuntasplaniZ.T.Items.Add("Conjunto");
			//
			// GroupBoxGPS
			//
			GroupBoxGPS.Controls.AddRange(new Control[]{
				Labeltdgps,	lbltdgps, lbltdgps1,
				Chkfillgps,	Chkinterp_resgps,
				LabelDifIns,
				Chkcamaragirada, Chkfotosgiradas
			});
			//
			Labeltdgps.RefLocation= new Point(148, 37);																Labeltdgps.TabIndex= 0;
			lbltdgps.Location= new Point(150, 27);				lbltdgps.Size= new Size(140, 15);			lbltdgps.TabIndex= 1;
			Chkfillgps.Location= new Point(12, 56);				Chkfillgps.Width=288;					Chkfillgps.TabIndex= 2;
			Chkinterp_resgps.Location= new Point(28, 80);		Chkinterp_resgps.Width=128;			Chkinterp_resgps.TabIndex= 3;
			LabelDifIns.RefLocation= new Point(12, 118);			LabelDifIns.MaxWidth=292;				LabelDifIns.TabIndex= 4;
			Chkcamaragirada.Location= new Point(28, 146);	Chkcamaragirada.Width=240;			Chkcamaragirada.TabIndex= 5;
			Chkfotosgiradas.Location= new Point(28,166);		Chkfotosgiradas.Width=240;				Chkfotosgiradas.TabIndex= 6;
			//
			// lbltdgps
			//
			lbltdgps.FlatStyle= FlatStyle.System;
			lbltdgps.BackColor= System.Drawing.SystemColors.Window;
			lbltdgps.TextAlign= ContentAlignment.TopCenter;
			lbltdgps.Font= new Font("Verdana", 8.25F);
			lbltdgps.Click+= new EventHandler(lbltdgps_Click);
			lbltdgps.Cursor= Cursors.Hand;
			lbltdgps1.Location= new Point(lbltdgps.Left, lbltdgps.Top-1);
			lbltdgps1.Size= new Size(lbltdgps.Width,1);
			lbltdgps1.BackColor= lbltdgps.BackColor;
			//
			// Chkfillgps, interp_resgps
			//
			Chkfillgps.FlatStyle= FlatStyle.System;
			Chkfillgps.CheckedChanged+= (s,e)=>Chkinterp_resgps.Enabled= Chkfillgps.Checked;
			//
			// ChkAutoCalib
			//
			ChkAutoCalib.Click+= new EventHandler(ChkAutoCalib_Click);
			LabelCalib.ForeColor= Color.Blue;
			LabelCalib.Click+= (s,e)=>FormAutoCalib1.ShowAt(ParentForm.Left + ParentForm.Width-FormAutoCalib1.Width+20, ParentForm.Top);
			LabelCalib.Cursor= Cursors.Hand;
			//
			// TabSalida
			//
			TabSalida.Controls.Add(this.GBoxEscalaRes);
			TabSalida.Controls.AddRange(new Control[]{
				this.GSgeneral,
				this.GSinformacion,	this.GSajs,
				this.GSautocalib,	this.GSotros
			});
			TabSalida.TabIndex= 2;
			//
			// GSgeneral
			//
			GSgeneral.Controls.AddRange(new Control[]{LBotpdf, LBotmm, LBotdec, LBotpares});
			GSgeneral.Location= new Point(0,0);
			GSgeneral.Size=new Size(608, 60);
			GSgeneral.TabIndex= 0;
			//
			// LBots
			//
			LBotpdf.TextLocation= new Point(84,24);		LBotpdf.TabIndex= 0;
			LBotmm.TextLocation= new Point(260,24);	LBotmm.TabIndex= 1;
			LBotdec.TextLocation= new Point(416,24);		LBotdec.TabIndex= 2;
			LBotpares.TextLocation= new Point(540,24);	LBotpares.TabIndex= 3;
			//
			LBotpdf.Click+= (s,e)=>FPdf1.Show();
			LBotmm.Click+= (s,e)=>FUni1.Show();
			LBotdec.Click+= (s,e)=>FDec1.Show();
			LBotpares.Click+= (s,e)=>FPares1.Show();
			//
			int pos;
			for(pos=0;pos<16;pos++){
				if(ChkF0[pos]!=null) ChkF0[pos].FlatStyle= FlatStyle.System;
			}
			for(pos=0;pos<16;pos++){
				if(ChkF1[pos]!=null) ChkF1[pos].FlatStyle= FlatStyle.System;
			}
			//
			// GBoxEscalaRes, Escalares
			//
			GBoxEscalaRes.FlatStyle= FlatStyle.System;
			GBoxEscalaRes.Controls.Add(this.Escalares);
			GBoxEscalaRes.Size= new Size(204, 124);
			GBoxEscalaRes.Location= new Point(0, GBoxEscalaRes.Parent.ClientRectangle.Height-GBoxEscalaRes.Height);
			GBoxEscalaRes.TabIndex= 5;
			//
			Escalares.Location= new Point(8, 20);
			//
			// GSinformacion
			//
			GSinformacion.Controls.AddRange(new Control[]{
				Chkinf,		Chkhtm,		Botinf,
				Chkbnf,		Botbnf,
				Chkpdf
			});
			GSinformacion.Location= new Point(0,64);
			GSinformacion.Width=204;
			GSinformacion.Height=GBoxEscalaRes.Top-6-GSinformacion.Top;
			GSinformacion.TabIndex= 1;
			//
			// Chks, Bots
			//
			pos=20;
			Chkinf.Location= new Point(6,pos);		pos+=20;
			Chkhtm.Location= new Point(6,pos);	Botinf.Location= new Point(168,pos-10);	pos+=20;
			Chkbnf.Location= new Point(6,pos);		Botbnf.Location= new Point(168,pos);		pos+=20;
			Chkpdf.Location= new Point(6,pos);
			//
			Chkinf.Size= new Size(80, 16);		Chkinf.TabIndex= 0;
			Chkhtm.Size= new Size(80, 16);		Chkhtm.TabIndex= 1;		Botinf.TabIndex= 2;
			Chkbnf.Size= new Size(100, 16);		Chkbnf.TabIndex= 3;		Botbnf.TabIndex= 4;
			Chkpdf.Size= new Size(156, 16);		Chkpdf.TabIndex= 5;
			//
			Chkhtm.Text= "Html (.html)";
			Botinf.Click+= (s,e)=>FInf1.Show();
			Botbnf.Click+= (s,e)=>FBnf1.Show();
			//
			// GSajs
			//
			GSajs.Controls.AddRange(new Control[]{
					Chkajs,
					Chkori,		Chkorixml,
					Chkoe,
					ChkDigi,		BotDigi,
					ChkImaster,	BotImaster
			});
			GSajs.Location= new Point(208,64);
			GSajs.Width=GSinformacion.Width-12;
			GSajs.Height=GSajs.Parent.ClientSize.Height-GSajs.Top;
			GSajs.TabIndex= 2;
			//
			// Chks, Bots
			//
			pos=20;
			Chkajs.Location= new Point(6,pos);			pos+=20;
			Chkori.Location= new Point(6,pos);			pos+=20;
			Chkorixml.Location= new Point(6,pos);		pos+=20;
			Chkoe.Location= new Point(6,pos);			pos+=20;
			ChkDigi.Location= new Point(6,pos);		BotDigi.Location= new Point(156,pos);		pos+=20;
			ChkImaster.Location= new Point(6,pos);	BotImaster.Location= new Point(156,pos);	pos+=20;
			//
			Chkajs.Width=100;			Chkajs.TabIndex= 0;
			Chkori.Width=80;			Chkori.TabIndex= 1;
			Chkorixml.Width=100;		Chkorixml.TabIndex= 2;
			Chkoe.Width=124;			Chkoe.TabIndex= 3;
			ChkDigi.Width=40;			ChkDigi.TabIndex= 4;		BotDigi.TabIndex= 5;
			ChkImaster.Width=100;		ChkImaster.TabIndex= 6;	BotImaster.TabIndex= 7;
			//
			Chkori.Text="PATB (.ori)";
			Chkorixml.Text="Xml (.ori.xml)";
			ChkDigi.Text="Digi";
			ChkImaster.Text="Image Master";
			BotDigi.Click+= (s,e)=>FDigi1.Show();
			BotImaster.Click+= (s,e)=>FImaster1.Show();
			//
			// GSautocalibracion
			//
			GSautocalib.Controls.AddRange(new Control[]{
				Chkintint,	Chkintpdf,
				Chkintgra,	Chkintini,
				Chkintcmr,	ChkintDigi,
			});
			GSautocalib.Location= new Point(404,64);
			GSautocalib.Size=new Size(GSajs.Width+12,128);
			GSautocalib.TabIndex= 3;
			//
			// Chks
			//
			pos=20;
			Chkintint.Location= new Point(6,pos);	pos+=20;		Chkintint.TabIndex=0;
			Chkintpdf.Location= new Point(6,pos);	pos+=20;		Chkintpdf.TabIndex=1;	Chkintpdf.Width+=4;
			Chkintgra.Visible=false;
			//Chkintgra.Location= new Point(6,pos);	pos+=20;		Chkintgra.TabIndex=2;
			Chkintini.Location= new Point(6,pos);	pos+=20;		Chkintini.TabIndex=3;	Chkintini.Width+=8;
			Chkintcmr.Location= new Point(6,pos);	pos+=20;	Chkintcmr.TabIndex=4;	Chkintcmr.Width+=28;
			ChkintDigi.Location= new Point(6,pos);	pos+=20;	ChkintDigi.TabIndex=4;
			//
			// GSotros
			//
			GSotros.Controls.AddRange(new Control[]{
					Chkres,		Chkinc,
					Chkrespdf,
					Chkstd,		Botstd,
					Chklog,		Botlog,
					Chkgrares
			});
			GSotros.Location= new Point(404,196);
			GSotros.Size=new Size(GSautocalib.Width,GSotros.Parent.ClientSize.Height-GSotros.Top);
			GSotros.TabIndex= 4;
			//
			// Chks, Bots
			//
			pos=20;
			Chkres.Visible=false; //Chkres.Location= new Point(6,pos);		pos+=20;
			Chkinc.Visible=false; //Chkinc.Location= new Point(6,pos);		pos+=32;
			Chkrespdf.Location= new Point(6,pos);	pos+=20;
			Chkstd.Location= new Point(6,pos);		Botstd.Location= new Point(172,pos);	pos+=20;
			Chklog.Location= new Point(6,pos);		Botlog.Location= new Point(172,pos);	pos+=20;
			Chkgrares.Location= new Point(6,pos);
			//
			Chkres.Size= new Size(100, 16);		Chkres.TabIndex= 0;
			Chkinc.Size= new Size(156, 28);		Chkinc.TabIndex= 1;
			Chkrespdf.Size= new Size(156, 16);	Chkrespdf.TabIndex= 2;
			Chkstd.Size= new Size(120, 16);		Chkstd.TabIndex= 3;		Botstd.TabIndex= 4;
			Chklog.Size= new Size(120, 16);		Chklog.TabIndex= 5;		Botlog.TabIndex= 6;
			Chkgrares.Size= new Size(156, 16);	Chkgrares.TabIndex= 7;
			//
			Botstd.Click+= (s,e)=>FStd1.Show();
			Botlog.Click+= (s,e)=>FLog1.Show();
			//
			// GroupBox11
			//
			GroupBox11.Controls.Add(this.Ajcompleto);
			GroupBox11.Controls.Add(this.SoloRel);
			GroupBox11.Location= new Point(76, 356);
			GroupBox11.Size= new Size(164, 60);
			GroupBox11.TabIndex= 1;
			//
			// SoloRel, Ajcompleto
			//
			SoloRel.Location= new Point(10, 12);			SoloRel.Size= new Size(148, 20);		SoloRel.TabIndex= 0;
			Ajcompleto.Location= new Point(10, 36);	Ajcompleto.Size= new Size(150, 20);	Ajcompleto.TabIndex= 1;
			Ajcompleto.Checked= true;	
			//
			// Calcular
			//
			Calcular.Location= new Point(288, 376);
			Calcular.TabIndex= 3;
			Calcular.Click+= new EventHandler(Calcular_Click);
			//
			// lblinfo
			//
			lblinfo.Font= new Font("Microsoft Sans Serif", 8F);
			lblinfo.Location= new Point(384, 372);
			lblinfo.Size= new Size(164, 36);
			lblinfo.TabIndex= 2;
			//
			// PanelAerotri
			//
			this.Controls.Add(this.GroupBox11);
			this.Controls.Add(this.Calcular);
			this.Controls.Add(this.lblinfo);
			this.Controls.Add(this.TabControl1);
			this.Size= new Size(622, 428);
			//
			Calcular.Left=(this.Width-Calcular.Width)/2;
		}
#endregion

		protected override int cierra_todo(){
			guarda_ficheroConfiguracion("Aerotri.config");
			return 0;
		}
		protected override void escribe_fConfiguracion(System.IO.StreamWriter fconfig){
			base.escribe_fConfiguracion_comienzo(fconfig);
			fconfig.WriteLine("OpenPath \"" + ConfigPrograma.OpenPath +"\"");
			fconfig.WriteLine("OpenPathCam \"" + ConfigPrograma.OpenPathCam +"\"");
		}

		unsafe protected override void WndProc(ref Message m){
			switch(m.Msg-0x480){
				case 0:	//Calcular
					this.Calcular_Click(this,EventArgs.Empty); break;
				case 0x10://Actualiza el log
					this.lblinfo.Text=new string((char *)m.LParam);
					lblinfo.ForeColor= Color.DarkGreen;
					lblinfo.Refresh(); break;
				default:
					base.WndProc (ref m); break;
			}
		}

#region Abrir
		private void Botabrirfot_Click(object sender,EventArgs e){
			ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotfot.T,Tffot, Open1, ref ConfigPrograma.OpenPath, buildfiltro(TipoFiltro.FotogramasLeer,idioma));
			ahora_no_se_puede_cerrar=0;
		}
		private void Botabrirapr_Click(object sender,EventArgs e){
			ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotapr.T,Tfapr, Open1, ref ConfigPrograma.OpenPath, buildfiltro(TipoFiltro.Aproximadas,idioma));
			ahora_no_se_puede_cerrar=0;
		}
		private void Botabrirapy_Click(object sender,EventArgs e){
			ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotapy.T,Tfapy, Open1, ref ConfigPrograma.OpenPath, buildfiltro(TipoFiltro.Apoyo,idioma));
			ahora_no_se_puede_cerrar=0;
		}
		private void Botabrirgps_Click(object sender,EventArgs e){
			ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotgps.T,Tfgps, Open1, ref ConfigPrograma.OpenPath, buildfiltro(TipoFiltro.GPSLeer,idioma));
			ahora_no_se_puede_cerrar=0;
		}
		private void Botabrirint_Click(object sender,EventArgs e){
			ahora_no_se_puede_cerrar=1;
			Methods.BotAbrir_Click(TxtBotint.T,Tfint, OpenCam, ref ConfigPrograma.OpenPathCam, buildfiltro(TipoFiltro.InternaLeer,idioma));
			ahora_no_se_puede_cerrar=0;
		}
#endregion

		private void Quita_ajustados(object sender,EventArgs e){
			if(leyendo_configuracion) return;
			Chkaprajs.Checked=false;
		}
		private void FotFolder_CheckedChanged(object sender,EventArgs e){
			LabelRadio Chk=(LabelRadio)sender;
			if(!Chk.Checked) return;
			if(Chk==Fotfolder0) Fotfolder1.Checked=false;
			else Fotfolder0.Checked=false;
		}
		private void mmPrecisiones_Click(object sender,EventArgs e){
			if(mmPrecisiones.State) GBoxPrecisiones.Height=160;
			else GBoxPrecisiones.Height=16;
		}

#region Archivo
		private void AAbrirTrabajo_Click(object sender,System.EventArgs e){
			string s="";
			ahora_no_se_puede_cerrar=1;
			s=Methods.AAbrir(Open1, ref ConfigPrograma.OpenPath, buildfiltro(TipoFiltro.TrabajoAerotri,idioma),1);
			if(s!=null) Abre_trabajo(s);
			ahora_no_se_puede_cerrar=0;
		}
		private void AGuardarTrabajo_Click(object sender,System.EventArgs e){
			ahora_no_se_puede_cerrar=1;
			string ss=Methods.AAbrir(Save1, ref ConfigPrograma.OpenPath, buildfiltro(TipoFiltro.TrabajoAerotri,idioma),1);
			if(ss==null) goto @return;
			GuardaTrabajo(ss,true);
		@return:
			ahora_no_se_puede_cerrar=0;
		}

		void Abre_trabajo(string s){
			nombretrabajo=null;
			ahora_no_se_puede_cerrar++;
			set_message(get_texto(Leyendo_el_fichero_de_trabajo));
			try{
				string sdir=Path.GetDirectoryName(s);
				if(sdir!=String.Empty) Environment.CurrentDirectory=Path.GetDirectoryName(s);
				lee_configuracion(s,true);
			}catch(System.IO.IOException){
				MessageBoxAT.Show(get_texto(15,s));
			}
			nombretrabajo=s;
			ficheroftrabajo=TxtBotfot.Text;
			try{s=Path.GetFileNameWithoutExtension(s);} catch(Exception){}
			NotificaTitulo(s);
			set_message(mensaje_pordefecto);
			ahora_no_se_puede_cerrar--;
		}

		private void AGuardarConfiguracion_Click(object sender,System.EventArgs e){
			string s;
			StreamWriter file1;

			if(ShowMessageWait(get_texto(De_esta_manera_la_configuración),Globales.Textos.OKCancel(idioma),1)!=1) return;
			s=AppData+"Configuraciones\\Aerotri";
			try{
				if(!System.IO.Directory.Exists(s)) System.IO.Directory.CreateDirectory(s);
				s=s+"\\porDefecto.cfg";
				file1=new StreamWriter(s,false,System.Text.Encoding.Default);
			}catch(System.IO.IOException){
				MessageBoxAT.Show(get_texto(14,s));
				return;
			}catch(UnauthorizedAccessException){
				MessageBoxAT.Show(get_global_texto(Globales.Textos.Cods.No_permiso_para_escribir));
				return;
			}catch(Exception){
				MessageBoxAT.Show(get_global_texto(Globales.Textos.Cods.Error_desconocido));
				return;
			}
			file1.Close();
			GuardaTrabajo(s,false);
		}
#endregion

#region fichero de configuracion
#region leer
		unsafe private void lee_configuracion(string str,bool modo){
			int nret;
			Trabajo trabajo;
			IntPtr P_fichero;

			P_fichero=Marshal.StringToHGlobalUni(str);
			nret=lee_trabajoAT(P_fichero,&trabajo);
			Marshal.FreeHGlobal(P_fichero);
			if(nret!=0 && modo==true) return;	//Si modo==false, si el fichero no existe se carga la configuración por defecto.
			bring_within_limits(ref trabajo);
			procesa_config(ref trabajo,modo);
			libera_trabajoAT(&trabajo);

			bool b=true;
			if(txtsigmaf.T.Text!="") b=false;
			foreach(Control G in GBoxPrecisiones.Controls){if(G is GroupBox){
				foreach(Control T in G.Controls){if(T is LTFloatPos && ((LTFloatPos)T).T.Text!="") b=false;}
			}}
			mmPrecisiones.State=!b;
			mmPrecisiones_Click(this,EventArgs.Empty);
		}

		unsafe private void bring_within_limits(ref Trabajo trabajo){
			/*if(trabajo.tipoficheros.tffot>=Tffot.n) trabajo.tipoficheros.tffot=0;
			if(trabajo.tipoficheros.tfapr>=Tfapr.n) trabajo.tipoficheros.tfapr=0;
			if(trabajo.tipoficheros.tfapy>=Tfapy.n) trabajo.tipoficheros.tfapy=0;
			if(trabajo.tipoficheros.tfgps>=Tfgps.n) trabajo.tipoficheros.tfgps=0;
			if(trabajo.tipoficheros.tfint>=Tfint.n) trabajo.tipoficheros.tfint=0;*/

			if(trabajo.datosgps.signoins!=0) trabajo.datosgps.signoins=1;
			if((byte)(trabajo.datosgps.tdgps+1)>=4) trabajo.datosgps.tdgps=1;
			if((byte)(trabajo.datosgps.tdins+1)>=4) trabajo.datosgps.tdins=1;

			if(trabajo.opciones.unigiros>2) trabajo.opciones.unigiros=2;
			if(trabajo.opciones.estimador>1) trabajo.opciones.estimador=1;
			if(trabajo.opciones.escalaresiduos!=unchecked((byte)-1) && trabajo.opciones.escalaresiduos>3)
				trabajo.opciones.escalaresiduos=2;
			if(trabajo.conjuntas.xy!=0) trabajo.conjuntas.xy=1;
			if(trabajo.conjuntas.XY!=0) trabajo.conjuntas.XY=1;
			if(trabajo.conjuntas.planiZ!=0) trabajo.conjuntas.planiZ=1;
		}

		unsafe private void procesa_config(ref Trabajo trabajo, bool modo){
			leyendo_configuracion=true;

			/*Opciones generales*/
			if(trabajo.sensor==0) CSconico.PerformClick();
			else CSmodelo.PerformClick();
			if(trabajo.modos.modo_ajuste==1) SoloRel.Select();
			else Ajcompleto.Select();
			//trabajo.modo
			//trabajo.modo2

			/*ficheros*/
			if(modo){
				setBotFotText(TxtBotfot,trabajo.ficheros.fotos);
				setBotFotText(TxtBotapr,trabajo.ficheros.aproximadas);
				setBotFotText(TxtBotapy,trabajo.ficheros.apoyo);
				setBotFotText(TxtBotgps,trabajo.ficheros.gpsins);
				setBotFotText(TxtBotint,trabajo.ficheros.camara);
			}
			flags_generar=trabajo.ficheros.generar;

			/*tipoficheros*/
			{byte b=trabajo.tipoficheros.tffot;
			if((b&0x80)==0) Fotfolder1.Checked=false;
			else{Fotfolder1.Checked=true; b=(byte)~b;}
			Tffot.Indice=tipofichero___aerotri(TipoFiltro.FotogramasLeer,	b,TipoFichero.AerotriFotos); Tffot.actualiza();
			}

			Tfapr.Indice=tipofichero___aerotri(TipoFiltro.Aproximadas,	trabajo.tipoficheros.tfapr,TipoFichero.Aerotriccpp);		Tfapr.actualiza();
			Tfapy.Indice=tipofichero___aerotri(TipoFiltro.Apoyo,			trabajo.tipoficheros.tfapy,TipoFichero.AerotriApoyo);		Tfapy.actualiza();
			Tfgps.Indice=tipofichero___aerotri(TipoFiltro.GPSLeer,		trabajo.tipoficheros.tfgps,TipoFichero.AerotriGps);		Tfgps.actualiza();
			Tfint.Indice=tipofichero___aerotri(TipoFiltro.InternaLeer,	trabajo.tipoficheros.tfint,TipoFichero.AerotriCamara);	Tfint.actualiza();
			Chkaprajs.Checked=trabajo.tipoficheros.tdapr!=0;

			/*datosgps*/
			datosgps=trabajo.datosgps;
			lbltdgps.Text=nombres_tdgps[(byte)(datosgps.tdgps+1)]+"/"+nombres_tdgps[(byte)(datosgps.tdins+1)];

			/*precisiones*/
			settexto_sigma(txtsigmaf,trabajo.apriori.f);
			settexto_sigma(txtsigmaXY,trabajo.apriori.pXY);
			settexto_sigma(txtsigmaZ,trabajo.apriori.pZ);
			settexto_sigma(txtsigmaGPSXY,trabajo.apriori.gpsXY);
			settexto_sigma(txtsigmaGPSZ,trabajo.apriori.gpsZ);
			settexto_sigma(txtsigmaINSWF,trabajo.apriori.insWF);
			settexto_sigma(txtsigmaINSK,trabajo.apriori.insK);

			//trabajo.opciones.reescribe_cpp
			if(trabajo.opciones.estimador==0) Rob0.Checked=true;
			else{
				Rob1.Checked=true;
				Comestimador.SelectedIndex=trabajo.opciones.estimador-1;
			}
			if(trabajo.opciones.bgirok==0) Chkcamaragirada.Checked=true;
			else Chkfotosgiradas.Checked=true;
			if(trabajo.opciones.fijas==0) Fijos.Checked=true;
			else Variables.Checked=true;
			//trabajo.opciones.completo
			Chkfillgps.Checked=trabajo.opciones.interp_gps!=0;
			Chkinterp_resgps.Checked=trabajo.opciones.interp_resgps!=0;
			if(trabajo.opciones.escalaresiduos==unchecked((byte)-1)){
				float[] limites;
				uint n=0;
				fixed(float *ptr=trabajo.opciones.residuos_escala){
					while(!float.IsInfinity(ptr[n]) && !float.IsNaN(ptr[n])) n++;
					limites=new float[n];
					for(uint i=0;i<n;i++) limites[i]=ptr[i];
				}
				Escalares.set_limites(limites);
			}else{
				Escalares.Value=trabajo.opciones.escalaresiduos;
			}

			/*Conjuntas*/
			ListConjuntasxy.T.SelectedIndex=trabajo.conjuntas.xy;
			ListConjuntasXY.T.SelectedIndex=trabajo.conjuntas.XY;
			ListConjuntasplaniZ.T.SelectedIndex=trabajo.conjuntas.planiZ;

			/*autocalib*/
			ChkAutoCalib.Checked=trabajo.autocalib.existe!=0;
			LabelCalib.Enabled=ChkAutoCalib.Checked;
			CInterna.DChk=trabajo.autocalib.selected;
			CInterna.S =trabajo.autocalib.config_dist;

			/*Valores aproximados*/
			aproximados=trabajo.valoresaproximados;

			/*Sistema*/
			try{ControlSistema.SetSistema((ControlesAt.SistemadeCoordenadas.Proyeccion)trabajo.sistema.nsistema);}
			catch(Exception){
				ControlSistema.SetSistema(ControlesAt.SistemadeCoordenadas.Proyeccion.Conforme);
				trabajo.sistema.nsistema=1;
			}
			ControlSistema.Celipsoideotro.V=trabajo.sistema.elip;
			ControlSistema.Ctierra.V=trabajo.sistema.tierra;
			ControlSistema.Csistemas.V=trabajo.sistema.valoressistemas;
			ControlSistema.SetOndulacion(trabajo.sistema.ondulacion);
			ControlSistema.SetElipsoide(trabajo.sistema.elipsoide);

			/*Salida*/
			CSalida.S=trabajo.configsalida;
			{ushort i, t=CSalida.S.SalidaF0;
			for(i=0;i<16;i++,t>>=1){
				if(ChkF0[i]!=null) ChkF0[i].Checked= (t&1)!=0;
			}
			t=CSalida.S.SalidaF1;
			for(i=0;i<16;i++,t>>=1){
				if(ChkF1[i]!=null) ChkF1[i].Checked= (t&1)!=0;
			}}
			//
			fixed(uint *ptr=&trabajo.configsalida.General.uniim_l){suni.p=new string((char*)ptr);}
			fixed(uint *ptr=&trabajo.configsalida.General.unif_l){suni.f=new string((char*)ptr);}
			fixed(uint *ptr=&trabajo.configsalida.General.unit_l){suni.t=new string((char*)ptr);}
			//
			if(CSalida.S.General.decrot==0) CSalida.S.General.decrot=~(sbyte)6;	//Forward compatibility
			else if((~CSalida.S.General.decrot)>7) CSalida.S.General.decrot=~(sbyte)7;
			else if(~CSalida.S.General.decrot<3) CSalida.S.General.decrot=3;
			//
			if(trabajo.configsalida.SalidaDigi.P_ruta1==IntPtr.Zero) rutasDigi.s1=null;
			else rutasDigi.s1=Marshal.PtrToStringUni(trabajo.configsalida.SalidaDigi.P_ruta1);
			if(trabajo.configsalida.SalidaDigi.P_ruta2==IntPtr.Zero) rutasDigi.s2=null;
			else rutasDigi.s2=Marshal.PtrToStringUni(trabajo.configsalida.SalidaDigi.P_ruta2);
			//
			if(trabajo.configsalida.SalidaImaster.P_ruta1==IntPtr.Zero) rutasImaster.s1=null;
			else rutasImaster.s1=Marshal.PtrToStringUni(trabajo.configsalida.SalidaImaster.P_ruta1);
			if(trabajo.configsalida.SalidaImaster.P_ruta2==IntPtr.Zero) rutasImaster.s2=null;
			else rutasImaster.s2=Marshal.PtrToStringUni(trabajo.configsalida.SalidaImaster.P_ruta2);

			/*salidatrabajo*/
			muestra_html.b=trabajo.salidatrabajo.muestra_html!=0;
			FLog1.Chkajuste.Checked=trabajo.salidatrabajo.log_ajuste!=0;
			FLog1.process_log_level((ushort)trabajo.salidatrabajo.log_level);
			FLog1.Chkpdfs.Checked=trabajo.salidatrabajo.log_pdfs!=0;

			Update_data();
			leyendo_configuracion=false;
		}

		void setBotFotText(LabelTxtBotAbrir txtbot, IntPtr nombre){
			if(nombre==IntPtr.Zero) txtbot.Text="";
			else{
				string s=Marshal.PtrToStringUni(nombre);
				try{s=Path.GetFullPath(s);}catch(Exception){}
				txtbot.Text=s;
			}
		}
		void settexto_sigma(LTFloatPos txtfloat, float sigma){
			if(float.IsInfinity(sigma) || float.IsNaN(sigma)) txtfloat.Text="";
			else txtfloat.Text=sigma.ToString();
		}

		void Update_data(){
			if(FormAutoCalib1.Visible) FormAutoCalib1.update_data();
			if(FPdf1.Visible) FPdf1.update_data();
			if(FUni1.Visible) FUni1.update_data();
			if(FDec1.Visible) FDec1.update_data();
			if(FPares1.Visible) FPares1.update_data();
			if(FInf1.Visible) FInf1.update_data();
			if(FBnf1.Visible) FBnf1.update_data();
			if(FDigi1.Visible) FDigi1.update_data();
			if(FImaster1.Visible) FImaster1.update_data();
			if(FStd1.Visible) FStd1.update_data();
			if(FLog1.Visible) FLog1.update_data();
		}
#endregion
#region escribir
		private string nombre_trabajo_expontaneo(){
				string s;
				if(nombretrabajo==null || ficheroftrabajo!=TxtBotfot.Text){
					System.IntPtr P_nombrebaseCEx=Marshal.StringToHGlobalUni(TxtBotfot.Text+ new string((char)0, 4));
					unsafe{ushort *extpos=pointat((ushort*)P_nombrebaseCEx.ToPointer());
					extension3(extpos,'a','r','t');}
					s=Marshal.PtrToStringUni(P_nombrebaseCEx);
					Marshal.FreeHGlobal(P_nombrebaseCEx);
				}else{
					s=nombretrabajo;
				}
				return s;
		}
		private void guarda_trabajo_expontaneo(){
			GuardaTrabajo(nombre_trabajo_expontaneo(),true);
		}

		void guarda_ruta_relativa(out IntPtr P_ruta,string text,IntPtr P_referencia){
			P_ruta=Marshal.AllocHGlobal(260*2);
			IntPtr P_fichero=Marshal.StringToHGlobalUni(text);
			InterComAerotri.relative_path16(P_ruta,260,P_referencia,P_fichero);
			Marshal.FreeHGlobal(P_fichero);
		}
		float text_to_float(string text){
			float f;
			if(text=="") f=float.NaN;
			else{try{f=Basicas._gcVarios.atofl(text.ToCharArray());}
				catch(System.SystemException){f=1.0E37F;}}	//Bad value
			return f;
		}
		void chars_to_uint64(out UInt32 cccc, out UInt32 mmmm, out UInt32 dddd, string s){
			int n;
			char[] chars;
			if(s==null) s="";
			if((n=s.Length)<6) chars=s.ToCharArray();
			else{n=5; chars=s.ToCharArray(0,5);}

			dddd=mmmm=cccc=0;
			if(n>4) dddd|=chars[5];
			if(n>2){while(n!=2){n--; mmmm<<=16; mmmm|=chars[n];}}
			while(n!=0){n--; cccc<<=16; cccc|=chars[n];}
		}
		unsafe private void genera_trabajo(string filerefname, out Trabajo trabajo){
			trabajo.ficheros.fotos=IntPtr.Zero;
			trabajo.ficheros.aproximadas=IntPtr.Zero;
			trabajo.ficheros.apoyo=IntPtr.Zero;
			trabajo.ficheros.gpsins=IntPtr.Zero;
			trabajo.ficheros.camara=IntPtr.Zero;
			trabajo.configsalida.SalidaDigi.P_ruta1=IntPtr.Zero;
			trabajo.configsalida.SalidaDigi.P_ruta2=IntPtr.Zero;
			trabajo.configsalida.SalidaImaster.P_ruta1=IntPtr.Zero;
			trabajo.configsalida.SalidaImaster.P_ruta2=IntPtr.Zero;
			trabajo.configsalida.fich_dibujo.cfilenames_main=(IntPtr*)IntPtr.Zero.ToPointer();
			trabajo.configsalida.fich_dibujo.cfilenames_residuos=(IntPtr*)IntPtr.Zero.ToPointer();

			if(CSmodelo.Checked) trabajo.sensor=1;	else trabajo.sensor=0;
			if(SoloRel.Checked) trabajo.modos.modo_ajuste=1;
			else trabajo.modos.modo_ajuste=0;
			trabajo.modos.modo_toma=0;
			trabajo.modos.modo_medida=0;

			{System.IntPtr P_nombretrabajo;
			P_nombretrabajo=Marshal.StringToHGlobalUni(filerefname);
			if(TxtBotfot.Text!="") guarda_ruta_relativa(out trabajo.ficheros.fotos,TxtBotfot.Text,P_nombretrabajo);
			if(TxtBotapr.Text!="") guarda_ruta_relativa(out trabajo.ficheros.aproximadas,TxtBotapr.Text,P_nombretrabajo);
			if(TxtBotapy.Text!="") guarda_ruta_relativa(out trabajo.ficheros.apoyo,TxtBotapy.Text,P_nombretrabajo);
			if(TxtBotgps.Text!="") guarda_ruta_relativa(out trabajo.ficheros.gpsins,TxtBotgps.Text,P_nombretrabajo);
			if(TxtBotint.Text!="") guarda_ruta_relativa(out trabajo.ficheros.camara,TxtBotint.Text,P_nombretrabajo);
			Marshal.FreeHGlobal(P_nombretrabajo);}
			trabajo.ficheros.generar=flags_generar;

			trabajo.tipoficheros.tffot=FileTypeInfos[Tffot.Indice].aerotri;	if(Fotfolder1.Checked) trabajo.tipoficheros.tffot=(byte)(~trabajo.tipoficheros.tffot);
			trabajo.tipoficheros.tfapr=FileTypeInfos[Tfapr.Indice].aerotri;
			trabajo.tipoficheros.tfapy=FileTypeInfos[Tfapy.Indice].aerotri;
			trabajo.tipoficheros.tfgps=FileTypeInfos[Tfgps.Indice].aerotri;
			trabajo.tipoficheros.tfint=FileTypeInfos[Tfint.Indice].aerotri;
			if(!Chkaprajs.Checked) trabajo.tipoficheros.tdapr=0;
			else trabajo.tipoficheros.tdapr=1;

			trabajo.datosgps=datosgps;
			trabajo.datosgps.signoins=Convert.ToByte(trabajo.tipoficheros.tfgps<=1);
			trabajo.conjuntas.xy=(byte)ListConjuntasxy.T.SelectedIndex;
			trabajo.conjuntas.XY=(byte)ListConjuntasXY.T.SelectedIndex;
			trabajo.conjuntas.planiZ=(byte)ListConjuntasplaniZ.T.SelectedIndex;

			trabajo.autocalib.existe=Convert.ToByte(ChkAutoCalib.Checked);
			trabajo.autocalib.selected=CInterna.DChk;
			trabajo.autocalib.config_dist=CInterna.S;

			trabajo.apriori.f=text_to_float(txtsigmaf.Text);
			trabajo.apriori.pXY=text_to_float(txtsigmaXY.Text);
			trabajo.apriori.pZ=text_to_float(txtsigmaZ.Text);
			trabajo.apriori.gpsXY=text_to_float(txtsigmaGPSXY.Text);
			trabajo.apriori.gpsZ=text_to_float(txtsigmaGPSZ.Text);
			trabajo.apriori.insWF=text_to_float(txtsigmaINSWF.Text);
			trabajo.apriori.insK=text_to_float(txtsigmaINSK.Text);

			if(Rob0.Checked) trabajo.opciones.estimador=0;
			else trabajo.opciones.estimador= (byte)(Comestimador.SelectedIndex+1);
			trabajo.valoresaproximados=aproximados;

			trabajo.sistema.nsistema=ControlSistema.GetSistema();
			trabajo.sistema.elipsoide=ControlSistema.GetElipsoide();
			try{trabajo.sistema.ondulacion=Basicas._gcVarios.atofl(ControlSistema.GetOndulacionText().ToCharArray());}
			catch(System.SystemException){trabajo.sistema.ondulacion=0;}
			trabajo.sistema.elip=ControlSistema.Celipsoideotro.V;
			trabajo.sistema.tierra=ControlSistema.Ctierra.V;
			trabajo.sistema.valoressistemas=ControlSistema.Csistemas.V;

			trabajo.salidatrabajo.log_ajuste=Convert.ToByte(FLog1.Chkajuste.Checked);
			trabajo.salidatrabajo.log_level=FLog1.get_log_level();
			trabajo.salidatrabajo.log_pdfs=Convert.ToByte(FLog1.Chkpdfs.Checked);
			trabajo.salidatrabajo.muestra_html=Convert.ToByte(muestra_html.b);

			trabajo.configsalida=CSalida.S;
			trabajo.configsalida.SalidaF0=0;
			trabajo.configsalida.SalidaF1=0;
			for(ushort i=0,t=1;i<16;i++,t<<=1){
				if(ChkF0[i]!=null && ChkF0[i].Checked) trabajo.configsalida.SalidaF0|=t;
			}
			for(ushort i=0,t=1;i<16;i++,t<<=1){
				if(ChkF1[i]!=null && ChkF1[i].Checked) trabajo.configsalida.SalidaF1|=t;
			}
			chars_to_uint64(out trabajo.configsalida.General.uniim_l,out trabajo.configsalida.General.uniim_m,out trabajo.configsalida.General.uniim_h, suni.p);
			chars_to_uint64(out trabajo.configsalida.General.unif_l,out trabajo.configsalida.General.uniim_m,out trabajo.configsalida.General.unif_h, suni.f);
			chars_to_uint64(out trabajo.configsalida.General.unit_l,out trabajo.configsalida.General.uniim_m,out trabajo.configsalida.General.unit_h, suni.t);
			//Rutas
			if(rutasDigi.s1!=null) trabajo.configsalida.SalidaDigi.P_ruta1=Marshal.StringToHGlobalUni(rutasDigi.s1);
			if(rutasDigi.s2!=null) trabajo.configsalida.SalidaDigi.P_ruta2=Marshal.StringToHGlobalUni(rutasDigi.s2);
			if(rutasImaster.s1!=null) trabajo.configsalida.SalidaImaster.P_ruta1=Marshal.StringToHGlobalUni(rutasImaster.s1);
			if(rutasImaster.s2!=null) trabajo.configsalida.SalidaImaster.P_ruta2=Marshal.StringToHGlobalUni(rutasImaster.s2);
			//dibujo
			if(enlaces.EnlaceGrafico==null){
				trabajo.configsalida.fich_dibujo.hwnd=null;
			}else{
				trabajo.configsalida.fich_dibujo.hwnd=PanelesSub.varias.get_enlace_hwnd(enlaces.EnlaceGrafico);
			}
			trabajo.configsalida.fich_dibujo.ConfigDibujo=3;
			trabajo.configsalida.fich_dibujo.cfilenames_main=(IntPtr*)Marshal.AllocHGlobal(sizeof(IntPtr)*3).ToPointer();
			trabajo.configsalida.fich_dibujo.cfilenames_main[0]=Marshal.StringToHGlobalUni(GetUserOrDefault_File("Configuraciones\\Grafico\\f-claro.cfg"));
			trabajo.configsalida.fich_dibujo.cfilenames_main[1]=Marshal.StringToHGlobalUni(GetUserOrDefault_File("Configuraciones\\Grafico\\f-negro.cfg"));
			trabajo.configsalida.fich_dibujo.cfilenames_main[2]=IntPtr.Zero;
			//
			trabajo.configsalida.fich_dibujo.cfilenames_residuos=(IntPtr*)Marshal.AllocHGlobal(sizeof(IntPtr)*3).ToPointer();
			trabajo.configsalida.fich_dibujo.cfilenames_residuos[0]=Marshal.StringToHGlobalUni(GetUserOrDefault_File("Configuraciones\\Grafico\\Calib_claro.cfg"));
			trabajo.configsalida.fich_dibujo.cfilenames_residuos[1]=Marshal.StringToHGlobalUni(GetUserOrDefault_File("Configuraciones\\Grafico\\Calib_negro.cfg"));
			trabajo.configsalida.fich_dibujo.cfilenames_residuos[2]=IntPtr.Zero;
			

			trabajo.opciones.unigiros=2;
			fixed(float *pescres=trabajo.opciones.residuos_escala){
				float[] flims=Escalares.get_limites();
				int n=flims.Length;
				if(n>19) n=19;
				for(int i=0;i<n;i++)
					pescres[i]=flims[i];
				pescres[n]=float.PositiveInfinity;
			}
			if(Escalares.Value>=0) trabajo.opciones.escalaresiduos=(byte)Escalares.Value;
			else trabajo.opciones.escalaresiduos=(byte)255;	//-1

			if(!Chkfillgps.Checked) trabajo.opciones.interp_gps=0;
			else trabajo.opciones.interp_gps=2;
			trabajo.opciones.interp_resgps=Convert.ToByte(Chkinterp_resgps.Checked);
			trabajo.opciones.bgirok=Convert.ToByte(Chkfotosgiradas.Checked);
			trabajo.opciones.fijas=Convert.ToByte(Variables.Checked);
			trabajo.opciones.completo=1;
			trabajo.opciones.reescribe_cpp=0;
		}
		//Libera un trabajo creado aquí mismo. Es decir, no mediante la librería aerotri_trabajos
		unsafe static void libera_trabajo(Trabajo trabajo){
			if(trabajo.ficheros.fotos!=IntPtr.Zero) Marshal.FreeHGlobal(trabajo.ficheros.fotos);
			if(trabajo.ficheros.aproximadas!=IntPtr.Zero) Marshal.FreeHGlobal(trabajo.ficheros.aproximadas);
			if(trabajo.ficheros.apoyo!=IntPtr.Zero) Marshal.FreeHGlobal(trabajo.ficheros.apoyo);
			if(trabajo.ficheros.gpsins!=IntPtr.Zero) Marshal.FreeHGlobal(trabajo.ficheros.gpsins);
			if(trabajo.ficheros.camara!=IntPtr.Zero) Marshal.FreeHGlobal(trabajo.ficheros.camara);
			if(trabajo.configsalida.SalidaDigi.P_ruta1!=IntPtr.Zero) Marshal.FreeHGlobal(trabajo.configsalida.SalidaDigi.P_ruta1);
			if(trabajo.configsalida.SalidaDigi.P_ruta2!=IntPtr.Zero) Marshal.FreeHGlobal(trabajo.configsalida.SalidaDigi.P_ruta2);
			if(trabajo.configsalida.SalidaImaster.P_ruta1!=IntPtr.Zero) Marshal.FreeHGlobal(trabajo.configsalida.SalidaImaster.P_ruta1);
			if(trabajo.configsalida.SalidaImaster.P_ruta2!=IntPtr.Zero) Marshal.FreeHGlobal(trabajo.configsalida.SalidaImaster.P_ruta2);
			if((void*)trabajo.configsalida.fich_dibujo.cfilenames_main!=IntPtr.Zero.ToPointer()){
				for(IntPtr *ptr=trabajo.configsalida.fich_dibujo.cfilenames_main;*ptr!=IntPtr.Zero;ptr++) Marshal.FreeHGlobal(*ptr);
				Marshal.FreeHGlobal(new IntPtr((void*)trabajo.configsalida.fich_dibujo.cfilenames_main));
			}
			if((void*)trabajo.configsalida.fich_dibujo.cfilenames_residuos!=IntPtr.Zero.ToPointer()){
				for(IntPtr *ptr=trabajo.configsalida.fich_dibujo.cfilenames_residuos;*ptr!=IntPtr.Zero;ptr++) Marshal.FreeHGlobal(*ptr);
				Marshal.FreeHGlobal(new IntPtr((void*)trabajo.configsalida.fich_dibujo.cfilenames_residuos));
			}
		}
		unsafe void GuardaTrabajo(string fullpathname, bool modo){
			Trabajo trabajo;
			System.IntPtr P_ficherot;
			int nret;

			genera_trabajo(fullpathname,out trabajo);
			P_ficherot=Marshal.StringToHGlobalUni(fullpathname);
			nret=escribe_trabajoAT(P_ficherot, &trabajo,Convert.ToByte(modo));
			Marshal.FreeHGlobal(P_ficherot);
			libera_trabajo(trabajo);
			if(nret==0){
				string s;
				if(modo){
					try{s=Path.GetFileNameWithoutExtension(fullpathname);}catch(Exception){s=fullpathname;}
					NotificaTitulo(s);
					nombretrabajo=fullpathname;
					try{
						s=Path.GetDirectoryName(fullpathname);
						if(s!=String.Empty) Environment.CurrentDirectory=s;
					}catch(System.Exception){}
				}
			}else{
				if(nret<5) MessageBoxAT.Show(get_texto(Error_en_la_escritura_del_fichero_de_trabajo)+" "+get_texto(No_se_pudo_abrir_para_escribirlo));
				else MessageBoxAT.Show(get_texto(Error_en_la_escritura_del_fichero_de_trabajo)+" "+get_texto(El_fichero_no_se_escribió_correctamente));
			}
		}
#endregion
#endregion

#region Herramientas
		void HVCmd_Click(object sender,System.EventArgs e){
			System.Diagnostics.Process.Start("cmd","/K SET PATH=%PATH%;"+AppPath+"\n cd "+Environment.CurrentDirectory);
		}
		void HModelos_Click(object sender,System.EventArgs e){
			System.Diagnostics.Process.Start(AppPath+"Modelos.exe");
		}
#endregion

#region Configuracion
#region Sensor
		void CSconico_Click(object sender,System.EventArgs e){
			CSmodelo.Checked=false;
			CSconico.Checked=true;
			if(!TabControl1.TabPages.Contains(TabAvanzado)) TabControl1.TabPages.Add(TabAvanzado);
			if(!TabControl1.TabPages.Contains(TabSalida)) TabControl1.TabPages.Add(TabSalida);
			TxtBotfot.Visible=true;		Tffot.Visible=true;
			Chkaprajs.Visible=true;
			TxtBotgps.Visible=true;		Tfgps.Visible=true;
			TxtBotint.Visible=true;		Tfint.Visible=true;
			GBoxPrecisiones.Visible=true;
			GroupBox11.Visible=true;

			TxtBotapr.TextLocation=new Point(424, 150);
			Tfapr.Location=new Point(336-12, 182);
			TxtBotapr.L.Text=get_texto(Fichero_de_valores_aproximados);
		}
		void CSmodelo_Click(object sender,System.EventArgs e){
			CSconico.Checked=false;
			CSmodelo.Checked=true;
			TabPrincipal.Select();
			if(TabControl1.TabPages.Contains(TabAvanzado)) TabControl1.TabPages.Remove(TabAvanzado);
			if(TabControl1.TabPages.Contains(TabSalida)) TabControl1.TabPages.Remove(TabSalida);
			TxtBotfot.Visible=false;		Tffot.Visible=false;
			Chkaprajs.Visible=false;
			TxtBotgps.Visible=false;		Tfgps.Visible=false;
			TxtBotint.Visible=false;		Tfint.Visible=false;
			GBoxPrecisiones.Visible=false;
			GroupBox11.Visible=false;

			TxtBotapr.TextLocation= TxtBotfot.TextLocation;
			Tfapr.Location=Tffot.Location;
			TxtBotapr.L.Text=get_texto(Fichero_de_modelo_local);
		}
#endregion
#endregion

		private void TxtBot_Validated(object sender,EventArgs e){
			((TextBox)sender).Text= ((TextBox)sender).Text.TrimStart(null);
		}
		void ChkAutoCalib_Click(object sender,EventArgs e){
			LabelCalib.Enabled=ChkAutoCalib.Checked;
			Chkaprajs.Checked=false;
		}
		void TabAvanzado_MouseUp(object sender,MouseEventArgs e){
			if(e.X>=LabelCalib.Left && e.X<LabelCalib.Left+LabelCalib.Width
				&& e.Y>=LabelCalib.Top && e.Y<LabelCalib.Top+LabelCalib.Height)
			ChkAutoCalib.Checked=true;
			ChkAutoCalib_Click(this,EventArgs.Empty);
		}
		void lbltdgps_Click(object sender,System.EventArgs e){
			FormtdGPS1.ShowDialog();
			lbltdgps.Text=nombres_tdgps[(byte)(datosgps.tdgps+1)]+"/"+nombres_tdgps[(byte)(datosgps.tdins+1)];
		}

#region Calcular
		unsafe void Calcular_modelolocal(){
			int returned;
			string mensaje;
			System.IntPtr P_mensaje= IntPtr.Zero;
			System.IntPtr P_aproximadas= IntPtr.Zero;
			System.IntPtr P_apoyo= IntPtr.Zero;

			if(calculando) return;
			calculando=true;

			if(TxtBotapr.Text==""){
				MessageBoxAT.Show(get_texto(Debe_indicar_modelo_local));
				goto @return;
			}else{
				if(TxtBotapr.Text.IndexOfAny(Path.GetInvalidPathChars())!=-1){
					MessageBoxAT.Show(get_texto(ajbloque_Nombre_valores_aproximados_no_válido));
					goto @return;
				}
				if(!CheckExtension(TxtBotapr.Text,Tfapr.Indice,TipoFiltro.Aproximadas)) goto @return;

				P_aproximadas=Marshal.StringToHGlobalUni(TxtBotapr.Text + new string((char)0, 4));
			}

			if(TxtBotapy.Text==""){
				MessageBoxAT.Show(get_texto(Debe_indicar_apoyo));
				goto @return;
			}else{
				if(TxtBotapy.Text.IndexOfAny(Path.GetInvalidPathChars())!=-1){
					MessageBoxAT.Show(get_texto(ajbloque_Nombre_apoyo_no_válido));
					goto @return;
				}
				if(!CheckExtension(TxtBotapy.Text,Tfapy.Indice,TipoFiltro.Apoyo)) goto @return;

				P_apoyo=Marshal.StringToHGlobalUni(TxtBotapy.Text + new string((char)0, 4));
			}

			ahora_no_se_puede_cerrar=1;
			guarda_trabajo_expontaneo();

			ControlesAt.SistemadeCoordenadas.Sistema sis=ControlSistema.Sistema;
			chars_to_uint64(out CSalida.S.General.unit_l,out CSalida.S.General.unit_m,out CSalida.S.General.unit_h, suni.t);
			P_mensaje=Marshal.AllocHGlobal(1024);
			try{
				unsafe{
					returned=transforma_terreno_a_local(P_apoyo,FileTypeInfos[Tfapy.Indice].aerotri,&sis,P_aproximadas,FileTypeInfos[Tfapr.Indice].aerotri,(byte)1,P_mensaje,(byte)idioma);
					mensaje=Marshal.PtrToStringUni(P_mensaje);
				}
			}catch(System.DllNotFoundException){
				returned=-4;
				mensaje=get_texto(No_se_ha_podido_abrir_ajbloque);
			}catch(SEHException SE){
				mensaje="Excepción no controlada en el ajuste del modelo";
				returned=-3;
			}

			lblinfo.Text="";
			lblinfo.Refresh();
			lblinfo.ForeColor=Label.DefaultForeColor;
			if(returned!=-1){
				if(returned>=100){
					mensaje=get_texto(Cálculo_terminado)+"\n\n"+mensaje;
				}
				MessageBoxAT.Show(mensaje);
			}

			@return:
			if(P_mensaje!=IntPtr.Zero) Marshal.FreeHGlobal(P_mensaje);
			if(P_aproximadas!=IntPtr.Zero) Marshal.FreeHGlobal(P_aproximadas);
			if(P_apoyo!=IntPtr.Zero) Marshal.FreeHGlobal(P_apoyo);
			calculando=false;
			ahora_no_se_puede_cerrar=0;
			return;
		}
		unsafe void Calcular_Click(object sender,System.EventArgs e){
			if(CSmodelo.Checked){Calcular_modelolocal(); return;}
			//System.DateTime a=DateTime.Now;	//IMBÉCIL
			int returned;
			string mensaje;
			System.IntPtr P_mensaje= IntPtr.Zero;
			System.IntPtr P_nombrebaseCEx= IntPtr.Zero;
			ushort* extpos;
			InterComAerotri.Buffer_to log_file;
			EditorD.InterComEditorD.FicheroBnf infoajbloque;
			InterComAerotri.Trabajo trabajo;
			System.IntPtr rparams, aparams;
			aparams=rparams=IntPtr.Zero;

			if(calculando) return;
			if(TxtBotfot.Text==""){
				MessageBoxAT.Show(get_texto(relativa_Debe_indicar_fotogramas));
				return;
			}
			calculando=true;
			calculando_disable();
			//Asignaciones para que el compilador se esté contento
				infoajbloque.plist=0;
				infoajbloque.punteros=(EditorD.InterComEditorD.NamedPointer*)0;
				infoajbloque.enes=(EditorD.InterComEditorD.Namedn*)0;
				infoajbloque.varios=(EditorD.InterComEditorD.BnfVarios*)0;

			log_file.id=(IntPtr)(-1);

			{string s=nombre_trabajo_expontaneo();
			genera_trabajo(s,out trabajo);
			if(SoloRel.Checked || trabajo.ficheros.aproximadas==IntPtr.Zero){
				rparams=get_relativa_params();
				returned=prepara_trabajo_relativa(&trabajo,rparams);
				if(returned!=0){
					MessageBoxAT.Show(get_texto((Textos.Cods)((int)PREPARA_RELATIVA_BASE+returned)));
					goto @return;
				}
			}
			GuardaTrabajo(s,true);}

			P_nombrebaseCEx=Marshal.StringToHGlobalUni(TxtBotfot.Text+ new string((char)0, 5));	//.html
			extpos=pointat((ushort*)P_nombrebaseCEx.ToPointer());

			if((trabajo.configsalida.SalidaF0&(1<<4))!=0 && trabajo.salidatrabajo.log_ajuste!=0){
				extension3(extpos,'\0','\0','\0');
				string graf=Marshal.PtrToStringUni(P_nombrebaseCEx);
				graf=graf.Substring(0,graf.Length-1);
				System.IntPtr P_largo=Marshal.StringToHGlobalUni(graf+"_ajuste.log");
				returned=InterComAerotri.toopen(P_largo,&log_file);
				Marshal.FreeHGlobal(P_largo);
				if(returned!=0){
					log_file.id=(IntPtr)(-1);
					returned=0;
				}else{
					graf="Cálculo comenzado en "+DateTime.Now.ToString()+"\n";
					P_largo=Marshal.StringToHGlobalAnsi(graf);
					InterComAerotri.towrite_string(&log_file,(sbyte*)P_largo.ToPointer());
					Marshal.FreeHGlobal(P_largo);
				}
			}

			ahora_no_se_puede_cerrar=1;
			P_mensaje=Marshal.AllocHGlobal(1024);

			//Valores aproximados
			if(SoloRel.Checked || trabajo.ficheros.aproximadas==IntPtr.Zero){
				set_message(get_texto(Esperando_a_que_termine_el_cálculo));
				lblinfo.Text=get_texto(Calculando_valores_aproximados);
				lblinfo.Refresh();
				returned=calcula_relativa(this.Handle,0x490,rparams,(void*)0,P_mensaje,(byte)idioma);
				lblinfo.Text="";
				lblinfo.Refresh();
				if(returned>=(int)ATCalculaRelativaCodes.partialerror && returned<=(int)ATCalculaRelativaCodes.manyblocks){
					if(enlaces.EnlaceEdTexto!=(void*)0){
						string[] argv=new string[3];
						argv[0]="-g";		argv[1]="Aerotri";
						extension3(extpos,'p','r','o');
						argv[2]=Marshal.PtrToStringUni(P_nombrebaseCEx);
						malditopuntoNETEditorT.annade_ficheros(enlaces.EnlaceEdTexto, argv);
					}
				}
				set_message(mensaje_pordefecto);
				mensaje=null;	//estúpido
				if(returned!=-1) mensaje=Marshal.PtrToStringUni(P_mensaje);
				if(SoloRel.Checked){
					if(returned>=(int)ATCalculaRelativaCodes.partialerror) mensaje+="\n\n      " + get_texto(Mirar_el_fichero_de_proceso);
					if(returned!=-1){
						MessageBoxAT.Show(mensaje);
					}
					goto @return;
				}
				//!SoloRel
				if(returned==(int)ATCalculaRelativaCodes.error_ajuste){
					extension3(extpos,'p','r','o');
					mensaje=get_texto(Error_en_valores_aproximados)+mensaje+"\n\n" + get_texto(Mirar_el_fichero_de_proceso)+", "+ Marshal.PtrToStringUni(P_nombrebaseCEx)+get_texto(para_posibles_puntos_erróneos);
				}
				if(returned!=0 && returned!=(int)ATCalculaRelativaCodes.manyblocks && returned!=(int)ATCalculaRelativaCodes.partialerror){
					if(returned!=-1) MessageBoxAT.Show(mensaje);
					goto @return;
				}else{
					extension3(extpos,'p','r','m');
					TxtBotapr.Text=Marshal.PtrToStringUni(P_nombrebaseCEx);
					Tfapr.Indice=TipoFichero.AerotriFotos;
					Tfapr.actualiza();
					trabajo.ficheros.aproximadas=Marshal.StringToHGlobalUni(TxtBotapr.Text);
					trabajo.tipoficheros.tfapr=0;
				}
				if(returned==(int)ATCalculaRelativaCodes.partialerror){
					MessageBoxAT.Show(mensaje+"\n\n" + get_texto(Si_desea_continuar));
					goto @return;
				}
				if(returned==(int)ATCalculaRelativaCodes.manyblocks){
					if(ShowMessageWait(mensaje+"\n\n"+get_texto(Desea_continuar_con_el_ajuste),Globales.Textos.YesNo(idioma),1)!=1) goto @return;
				}
				if(trabajo.tipoficheros.tffot!=0){	//trabajo ya se ha guardado. Lo podemos modificar.
					extension3(extpos,'f','t','m');	//Store the .ftm here for the block adjustment
					Marshal.FreeHGlobal(trabajo.ficheros.fotos);
					trabajo.ficheros.fotos=Marshal.StringToHGlobalUni(Marshal.PtrToStringUni(P_nombrebaseCEx));
					trabajo.tipoficheros.tffot=0;
				}
			}
			//------------Fin-----------

			//Ajuste del bloque
			aparams=get_absoluta_calldata();
			returned=prepara_trabajo_absoluta(&trabajo,aparams,1);
			if(returned!=0){
				MessageBoxAT.Show(get_texto((Textos.Cods)((int)PREPARA_ABSOLUTA_BASE+returned)));
				goto @return;
			}
			set_message(get_texto(Esperando_a_que_termine_el_cálculo));
			this.lblinfo.Text=get_texto(Realizando_el_ajuste_del_bloque);
			lblinfo.Refresh();
			try{
				InterComAerotri.Buffer_to *plog;
				if(log_file.id==(IntPtr)(-1)) plog=(Buffer_to*)0;
				else plog=&log_file;
	recalcula:	returned=calcula_absoluta(this.Handle,0x490, plog,aparams,&infoajbloque, P_mensaje, (byte)idioma);
				mensaje=Marshal.PtrToStringUni(P_mensaje);
				if(returned==(int)CalculaAbsoluta.fewcontrol_gps){
					if(ShowMessageWait(mensaje+"\n\n"+get_texto(Desea_calcular_en_sistema_arbitrario),Globales.Textos.YesNo(idioma),1)==1){change_absparams(aparams,1,1); goto recalcula;}
				}
			}catch(System.DllNotFoundException){
				returned=-4;
				mensaje=get_texto(No_se_ha_podido_abrir_ajbloque);
			}catch(SEHException SE){
				mensaje="Excepción no controlada en el ajuste del bloque";
				returned=-3;
			}finally{
				set_message(mensaje_pordefecto);
			}

			lblinfo.Text="";
			lblinfo.Refresh();
			lblinfo.ForeColor=Label.DefaultForeColor;
			if(returned!=-1 && returned!=(int)CalculaAbsoluta.fewcontrol_gps){
				if(returned>=(int)CalculaAbsoluta.minorerr_unknown){
					mensaje=get_texto(Cálculo_terminado)+"\n\n"+mensaje;
					returned=0;
				}
				MessageBoxAT.Show(mensaje);
			}
			//Fin ajuste del bloque
			if(cuando_puedas_cierrate){
				if(returned==0) InterComAerotri.free_plist(infoajbloque.plist);
				goto @return;
			}

			if(returned==0 && enlaces.EnlaceGrafico!=null){
			   void* hwnd=PanelesSub.varias.get_enlace_hwnd(enlaces.EnlaceGrafico);
			   if(hwnd!=null){ //No lo tomamos de trabajo.configsalida.fich_dibujo.hwnd porque mientra ha podido cerrarse
				//extension3(extpos,'g','r','a');
				//string graf=Marshal.PtrToStringUni(P_nombrebaseCEx);
				//SendMessage(enlaces.EnlaceGrafico,carga_grafico,graf);
			}}
			if(returned<0) goto @return;

			if(returned==0 && muestra_html.b && (CSalida.S.SalidaF1&(ushort)2)!=0){
				extension4(extpos,'h','t','m','l');
				try{System.Diagnostics.Process.Start(Marshal.PtrToStringUni(P_nombrebaseCEx));}
				catch(SystemException){}
			}

			int retmin=(int)CalculaAbsoluta.error_ficherof;
			if(returned<retmin || returned>(int)CalculaAbsoluta.error_ficherof){
				/*if(Tffot.Indice!=TipoFichero.AerotriFotos && (trabajo.ficheros.generar &1)!=0){	//Do not replace
					IntPtr P_fichero=Marshal.StringToHGlobalUni(TxtBotfot.Text+new string('\0',4));
					ushort *ext=pointat((ushort*)P_fichero.ToPointer());
					extension3(ext,'f','t','m');
					Tffot.Indice=TipoFichero.AerotriFotos;
					Tffot.actualiza();
					TxtBotfot.Text=Marshal.PtrToStringUni(P_fichero);
					Marshal.FreeHGlobal(P_fichero);
				}*/
			}
			if(returned<retmin || returned>(int)CalculaAbsoluta.error_ficheroapr){
				if(returned==0 && (CSalida.S.SalidaF0&0x100)!=0){
					extension3(extpos,'a','j','s');
					TxtBotapr.Text=Marshal.PtrToStringUni(P_nombrebaseCEx);
					Chkaprajs.Checked=true;
				}else if(Tfapr.Indice!=TipoFichero.Aerotriccpp && (trabajo.ficheros.generar &2)!=0){
					IntPtr P_fichero=Marshal.StringToHGlobalUni(TxtBotapr.Text+new string('\0',4));
					ushort *ext=pointat((ushort*)P_fichero.ToPointer());
					extension3(ext,'p','r','m');
					TxtBotapr.Text=Marshal.PtrToStringUni(P_fichero);
					Marshal.FreeHGlobal(P_fichero);
				}else
					goto no_prm;
				Tfapr.Indice=TipoFichero.Aerotriccpp;
				Tfapr.actualiza();
				no_prm:;
			}
			if(returned<retmin || returned>(int)CalculaAbsoluta.error_ficheroapy){
				if(trabajo.ficheros.apoyo!=IntPtr.Zero && Tfapy.Indice!=TipoFichero.AerotriApoyo && (trabajo.ficheros.generar &4)!=0){
					IntPtr P_fichero=Marshal.StringToHGlobalUni(TxtBotapy.Text+new string('\0',4));
					ushort *ext=pointat((ushort*)P_fichero.ToPointer());
					extension3(ext,'p','y','m');
					Tfapy.Indice=TipoFichero.AerotriApoyo;
					Tfapy.actualiza();
					TxtBotapy.Text=Marshal.PtrToStringUni(P_fichero);
					Marshal.FreeHGlobal(P_fichero);
				}
			}
			if(returned<retmin || returned>(int)CalculaAbsoluta.error_ficherogps){
				/*if(trabajo.ficheros.gpsins!=IntPtr.Zero && Tfgps.tipof!=0 && (trabajo.ficheros.generar &8)){
					IntPtr P_fichero=Marshal.StringToHGlobalUni(TxtBotgps.Text+new string('\0',4));
					ushort *ext=pointat((ushort*)P_fichero.ToPointer());
					extension3(ext,'g','p','n');
					Tfgps.tipof=0;
					Tfgps.actualiza();
					TxtBotgps.Text=Marshal.PtrToStringUni(P_fichero);
					Marshal.FreeHGlobal(P_fichero);
				}*/
			}

			CSalida.S.SalidaF0=trabajo.configsalida.SalidaF0;
			CSalida.S.SalidaF1=trabajo.configsalida.SalidaF1;
			if((CSalida.S.SalidaF1&1)!=0 && enlaces.EnlaceEdTexto!=null && (returned==0 || returned==(int)CalculaAbsoluta.error_ajuste)){
				string[] argv=new string[3];
				argv[0]="-g";		argv[1]="Aerotri";
				extension3(extpos,'i','n','f');
				argv[2]=Marshal.PtrToStringUni(P_nombrebaseCEx);

				malditopuntoNETEditorT.annade_ficheros(enlaces.EnlaceEdTexto, argv);
			}
			if(returned!=0 && returned!=16) goto @return;

			if(returned==16 || (CSalida.S.SalidaF1&8 | CSalida.S.SalidaF0&4)!=0 || (ChkAutoCalib.Checked && (CSalida.S.SalidaF1&0x200)!=0)){
				string s, sf;
				StreamWriter fbat;
				extension3(extpos,'b','a','t');
				s=Marshal.PtrToStringUni(P_nombrebaseCEx);
				sf=Path.GetFileNameWithoutExtension(s);
				try{
					fbat=new StreamWriter(s,false,System.Text.Encoding.Default);
#if DEBUG
						AppPath=@"C:\Program Files (x86)\Aerotri\2012\";
#endif
					if(returned==16){
						fbat.WriteLine("\""+AppPath+"unAerotri2012.exe\"");
					}
					fbat.WriteLine("SET TEXMFCNF="+AppPath+@"tex\web2c\");
					string texcmd="\""+AppPath+@"tex\web2c\Aerotripdftex.exe"" """+sf;
					if((CSalida.S.SalidaF1&8)!=0) fbat.WriteLine(texcmd+".tex\"");
					if((CSalida.S.SalidaF0&4)!=0) fbat.WriteLine(texcmd+"_res.tex\"");
					if(ChkAutoCalib.Checked && (CSalida.S.SalidaF1&0x200)!=0) fbat.WriteLine(texcmd+"_int.tex\"");
					if(!Chklog.Checked || !FLog1.Chkpdfs.Checked){
						if((CSalida.S.SalidaF1&8)!=0) fbat.WriteLine("del \""+sf+".log"+"\"");
						if((CSalida.S.SalidaF0&4)!=0) fbat.WriteLine("del \""+sf+"_res.log"+"\"");
						if(ChkAutoCalib.Checked && (CSalida.S.SalidaF1&0x200)!=0) fbat.WriteLine("del \""+sf+"_int.log"+"\"");
					}
					fbat.Close();
					string sdir=Path.GetDirectoryName(s);
					if(sdir!=String.Empty) Environment.CurrentDirectory=Path.GetDirectoryName(s);
					System.Diagnostics.Process.Start(s);
				}catch(System.IO.IOException){}
#if DEBUG
					AppPath=Application.StartupPath+"\\";
#endif
			}

			if((CSalida.S.SalidaF1&4)!=0 && enlaces.EnlaceEdDatos!=null){
				malditopuntoNETEditorD.Remuestra(enlaces.EnlaceEdDatos, &infoajbloque);
			}
			InterComAerotri.free_plist(infoajbloque.plist);

		@return:
			if(rparams!=IntPtr.Zero) ATtrabajos_free(rparams);
			if(aparams!=IntPtr.Zero) ATtrabajos_free(aparams);
			libera_trabajo(trabajo);
			if(P_mensaje!=IntPtr.Zero) Marshal.FreeHGlobal(P_mensaje);
			if(P_nombrebaseCEx!=IntPtr.Zero) Marshal.FreeHGlobal(P_nombrebaseCEx);
			if(log_file.id!=(IntPtr)(-1)) InterComAerotri.toclose(&log_file);
			calculando=false;
			ahora_no_se_puede_cerrar=0;
			fin_calculando_enable();
			return;
		}

		void calculando_disable(){
			Calcular.Enabled=false;
			PanelMenu1.Enabled=false;
			GroupBox1.Enabled=false;
			TxtBotint.Enabled=false;
		}
		void fin_calculando_enable(){
			PanelMenu1.Enabled=true;
			GroupBox1.Enabled=true;
			TxtBotint.Enabled=true;
			Calcular.Enabled=true;
		}
		internal void Recalcular(object sender){
			this.BeginInvoke(new EventHandler(Calcular_Click), new object[]{this,EventArgs.Empty});
		}

		unsafe static ushort* pointat(ushort* fichero){
			ushort *ext, fin;
			ext=fichero; while(*ext!='\0') ext++;
			fin=ext;
			while(*ext!='.' && ext!=fichero) ext--;
			if(*ext!='.' || fin-ext>4) ext=fin;
			return ext;
		}
		unsafe static void extension3(ushort *ext, ushort x1, ushort x2, ushort x3){
			*ext++='.'; *ext++=x1; *ext++=x2; *ext++=x3; *ext='\0';
		}
		unsafe static void extension4(ushort *ext, ushort x1, ushort x2, ushort x3, ushort x4){
			*ext++='.'; *ext++=x1; *ext++=x2; *ext++=x3; *ext++=x4; *ext='\0';
		}
#endregion

		protected override void colores(){
			base.colores();
			TabPrincipal.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
			TabAvanzado.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
			TabSalida.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
			Calcular.BackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			TxtBotapr.T.Text1.BackColor=Globales.Colores.NETColor(Globales.Colores.cOpcional);
			TxtBotapy.T.Text1.BackColor=Globales.Colores.NETColor(Globales.Colores.cOpcional);
			TxtBotgps.T.Text1.BackColor=Globales.Colores.NETColor(Globales.Colores.cOpcional);
			BotAproximados.T.BackColor=Globales.Colores.NETColor(Globales.Colores.cFlatPopUp);
			txtsigmaf.T.BackColor=Globales.Colores.NETColor(Globales.Colores.cOpcional);
			foreach(Control G in GBoxPrecisiones.Controls){if(G is GroupBox){
				foreach(Control T in G.Controls){if(T is LTFloatPos) ((LTFloatPos)T).T.BackColor=Globales.Colores.NETColor(Globales.Colores.cOpcional);}
			}}
			foreach(Control G in TabSalida.Controls){if(G is GroupBox){
				foreach(Control p in G.Controls){
					if(p is Botonppp) p.BackColor=Globales.Colores.NETColor(Globales.Colores.cFlatPopUp);
					else if(p is LabelBotppp) ((LabelControl)p).T.BackColor=Globales.Colores.NETColor(Globales.Colores.cFlatPopUp);
				}
			}}
			SetTitleFont(TabControl1,Globales.Fuentes.FontTitle2);
			foreach(Control G in TabPrincipal.Controls){
				if(G.GetType()==typeof(GroupBox)) SetTitleFont(G,Globales.Fuentes.FontTitle2);
			}
			SetTitleFont(GroupBox1,new Font(GroupBox1.Font.FontFamily,2));
			foreach(Control G in TabAvanzado.Controls){
				if(G.GetType()==typeof(GroupBox)) SetTitleFont(G,Globales.Fuentes.FontTitle2);
			}
			foreach(Control G in TabSalida.Controls){
				if(G.GetType()==typeof(GroupBox)) SetTitleFont(G,Globales.Fuentes.FontTitle2);
			}
		}
		void SetTitleFont(Control C, Font fuente){
			Font f;
			try{f=C.Controls[0].Font;}
			catch(Exception){f=C.Font;}
			foreach(Control c in C.Controls){c.Font=f;}
			C.Font=fuente;
		}

#region etiquetas_idiomas
		protected override void update_idioma(){
			base.update_idioma();

			AAcercade.Text= get_texto(Acercade);
			ManualPath=get_texto(Manualpath);
			FormAcercade1.titulo=get_texto(Acercade);
			FormAcercade1.cabecera=get_texto(FullTitle);
			switch(idioma){
				case Globales.Idioma.Esp: FormAcercade1.fecha="26 de agosto de 2016"; break;
				case Globales.Idioma.Eng: FormAcercade1.fecha="26th August, 2016"; break;
				case Globales.Idioma.It: FormAcercade1.fecha="26 agosto 2016"; break;
				default: goto case Globales.Idioma.Esp;
			}

			AAbrirTrabajo.Text=get_texto(AbrirTrabajo);
			AGuardarTrabajo.Text=get_texto(GuardarTrabajo);
			AGuardarConfiguracion.Text=get_texto(Guardarconfiguración);
			PanelMenu1.gLabels("Herramientas").Text=get_texto(Herramientas);
			HTrFicheros.Text=get_texto(Transformación_de_ficheros);
			HTFotogramas.Text=get_texto(Fotogramas);
			//HTAprApoyo.Text=get_texto(Valores_aproximados_y_apoyo);
			HTGpsIns.Text=get_texto(GPS_INS_ccpp);
			HTInterna.Text=get_texto(Archivos_de_cámara);
			HVCmd.Text=get_texto(Ventana_de_comandos);
			HModelos.Text=get_texto(Unión_de_modelos);
			CSensor.Text=get_texto(Sensor);
			CSconico.Text=get_texto(Cónico);
			CSmodelo.Text=get_texto(Modelo_local);

			TabPrincipal.Text=get_texto(Datos_de_entrada);
			TabAvanzado.Text=get_texto(Config_cálculo);
			TabSalida.Text=get_texto(Ficheros_de_salida);
			TxtBotfot.L.Text=get_texto(Fichero_fotogramas);
			TxtBotapr.L.Text=get_texto(Fichero_valores_aproximados);
			TxtBotapy.L.Text=get_texto(Fichero_apoyo);
			TxtBotgps.L.Text=get_texto(Fichero_gps);
			TxtBotint.L.Text=get_texto(Fichero_cámara);
			Fotfolder0.L.Text=get_texto(Un_fichero);
			Fotfolder1.L.Text=get_texto(Una_carpeta);
			Chkaprajs.Text=get_texto(Son_ya_ajustados);

			GBoxPrecisiones.Text=get_texto(Precisiones);
			txtsigmaf.L.Text=get_texto(Fotocoordenadas);
			GroupBox4.Text=get_texto(Apoyo);
			txtsigmaXY.L.Text=get_texto(Planimetría);
			txtsigmaZ.L.Text=get_texto(Altimetría);
			GroupBox5.Text=get_texto(GPS);
			txtsigmaGPSXY.L.Text=get_texto(Planimetría);
			txtsigmaGPSZ.L.Text=get_texto(Altimetría);
			GroupBox6.Text=get_texto(INS);

			GroupBoxEstimador.Text=get_texto(Estimador);
			Rob0.Text=get_texto(MMcc);
			Rob1.Text=get_texto(Robusto);
			GroupBox10.Text=get_texto(Puntos_de_apoyo);
			Fijos.Text=get_texto(Textos.Cods.Fijos);
			Variables.Text=get_texto(Textos.Cods.Variables);

			GroupBoxSistema.Text=get_texto(Sistema_de_coordenadas);
			BotAproximados.L.Text=get_texto(Config_valores_aproximados);
			Label25.Text=get_texto(Estimador_robusto);
			//Comestimador.Items[1]=get_texto(Robusto_fuerte);
			//Comestimador.Items[2]=get_texto(Robusto_débil);
			LabelCalib.Text=get_texto(Autocalibración);
			LabelConjuntas.Text=get_texto(Tratamiento_de_las_coordenadas)+":";
			ListConjuntasxy.L.Text=get_texto(Fotocoordenadas_xy)+":";
			ListConjuntasXY.L.Text=get_texto(Apoyo_XY)+":";
			ListConjuntasplaniZ.L.Text=get_texto(Apoyo_PlaniZ)+":";
			string ss=get_texto(Individual);
			ListConjuntasxy.T.Items[0]=ss;
			ListConjuntasXY.T.Items[0]=ss;
			ListConjuntasplaniZ.T.Items[0]=ss;
			ss=get_texto(Conjunto);
			ListConjuntasxy.T.Items[1]=ss;
			ListConjuntasXY.T.Items[1]=ss;
			ListConjuntasplaniZ.T.Items[1]=ss;
			GroupBoxGPS.Text=get_texto(GPS_INS);
			Labeltdgps.Text=get_texto(Errores_sistemáticos)+":";
			nombres_tdgps[0]=get_texto(Offset);
			nombres_tdgps[1]=get_texto(No_error);
			nombres_tdgps[2]=get_texto(Constante);
			nombres_tdgps[3]=get_texto(Lineal);
			Chkfillgps.Text=get_texto(Calcular_fotos_intermedias);
			Chkinterp_resgps.Text=get_texto(Interpolar_residuos);
			LabelDifIns.Text=get_texto(Diferencia_INS_kappa);
			Chkcamaragirada.Text=get_texto(Cámara_girada);
			Chkfotosgiradas.Text=get_texto(Fotos_giradas);

			GBoxEscalaRes.Text=get_texto(Escala_marcas_residuos);
			GSgeneral.Text=get_texto(Opciones_generales);
			LBotpdf.L.Text=get_texto(Ficheros_pdf);
			LBotmm.L.Text=get_texto(Símbolos_unidades);
			LBotdec.L.Text=get_texto(Cifras_decimales);
			LBotpares.L.Text=get_texto(Pares);
			GSinformacion.Text=get_texto(Ficheros_de_información);
			Chkinf.Text=get_texto(Texto)+" (.inf)";
			Chkbnf.Text=get_texto(Binario)+" (.bnf)";
			Chkpdf.Text=get_texto(Hoja_pdf)+" (.pdf)";
			GSajs.Text=get_texto(Valores_ajustados);
			Chkajs.Text="Aerotri"+" (.ajs)";
			Chkoe.Text=get_texto(Centros_puros)+" (.eo)";
			GSautocalib.Text=get_texto(Autocalibración);
			Chkintint.Text="Aerotri"+" (_ajs.int)";
			Chkintpdf.Text=get_texto(Hoja_pdf_int)+" (_int.pdf)";
			Chkintgra.Text=get_texto(Gráfico)+" (_int.gra)";
			Chkintini.Text=get_texto(Archivo_ini)+" (_int.ini)";
			Chkintcmr.Text="Image Master"+" (_int.cmr)";
			ChkintDigi.Text="Digi"+" (.cam)";
			GSotros.Text=get_texto(Otros_ficheros);
			Chkres.Text=get_texto(Residuos)+" (.res)";
			Chkinc.Text=get_texto(Incrementos)+" (.inc)";
			Chkrespdf.Text=get_texto(Residuos_elevados)+" (_res.pdf)";
			Chkstd.Text=get_texto(Estadísticas)+" (.std)";
			Chklog.Text=get_texto(Ficheros_log)+" (.log)";
			Chkgrares.Text=get_texto(Gráfico_de_residuos)+" (_res.gra)";

			SoloRel.Text=get_texto(Sólo_valores_aproximados);
			Ajcompleto.Text=get_texto(Ajuste_completo);
			Calcular.Text=get_texto(Textos.Cods.Calcular);

			lbltdgps.Text=nombres_tdgps[(byte)(datosgps.tdgps+1)]+"/"+nombres_tdgps[(byte)(datosgps.tdins+1)];

			Tffot.set_textos(Globales.FileTypes.GetShortNames(TipoFiltro.FotogramasLeer,idioma));
			Tfint.set_textos(Globales.FileTypes.GetShortNames(TipoFiltro.InternaLeer,idioma));
			Tfapr.set_textos(Globales.FileTypes.GetShortNames(TipoFiltro.Aproximadas,idioma));
			Tfapy.set_textos(Globales.FileTypes.GetShortNames(TipoFiltro.Apoyo,idioma));
			Tfgps.set_textos(Globales.FileTypes.GetShortNames(TipoFiltro.GPSLeer,idioma));
			Tffot.actualiza(); Tfapr.actualiza();
			Tfapy.actualiza(); Tfgps.actualiza();
			Tfint.actualiza();
			ControlSistema.set_idioma(idioma);

			if(FormAutoCalib1.Visible) FormAutoCalib1.set_idioma(idioma);
			if(FPdf1.Visible) FPdf1.set_idioma(idioma);
			if(FUni1.Visible) FUni1.set_idioma(idioma);
			if(FDec1.Visible) FDec1.set_idioma(idioma);
			if(FPares1.Visible) FPares1.set_idioma(idioma);
			if(FInf1.Visible) FInf1.set_idioma(idioma);
			if(FBnf1.Visible) FBnf1.set_idioma(idioma);
			if(FDigi1.Visible) FDigi1.set_idioma(idioma);
			if(FImaster1.Visible) FImaster1.set_idioma(idioma);
			if(FStd1.Visible) FStd1.set_idioma(idioma);
			if(FLog1.Visible) FLog1.set_idioma(idioma);
		}
#endregion

		private string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
		internal string get_global_texto(Globales.Textos.Cods i){
			return Globales.Textos.get_texto(i,idioma);
		}
		internal string get_texto(short i,string s){
			return Globales.Textos.get_texto(i,s,idioma);
		}
		internal bool CheckExtension(string filename, TipoFichero supposed_filetype, TipoFiltro tipofiltro){
			return Methods.CheckExtension(MessageBoxAT,filename,supposed_filetype,tipofiltro,idioma);
		}
	}

	internal class malditopuntoNETEditorT{
		unsafe internal static void annade_ficheros(void* enlace, string[] args){
			EditorT.PanelEditorT Panel=(EditorT.PanelEditorT)PanelesSub.varias.get_Panel(enlace);
			if(Panel==null) return;
			//The documentation is still wrong. The handle of the form has already been created,
			//so Panel.BeginInvoke or Panel.ParentForm.BeginInvoke should work, at any rate
			//behave equally. They do not work nor do they behave in the same way. Cursed be the
			//.NET implementation of threads, controls and Windows' handles and its documenting
			//based on a false "internaly is not exactly like this, but it is exposed to the outside as if it were".
			if(!Panel.IsHandleCreated) Panel.rannade_ficheros(args);
			else{
				Panel.BeginInvoke(Panel.rannade_ficheros,new object[]{args});
			}
		}
	}
	internal class malditopuntoNETEditorD{
		//not used
		/*internal static void set_delegado(PanelesSub.PanelSubordinado panel, PanelAerotri este){
			((EditorD.PanelEditorD)panel).HazAlgo+=new EditorD.EventSender(este.Recalcular);
		}*/
		unsafe internal static void Remuestra(void* enlace,EditorD.InterComEditorD.FicheroBnf *datos){
			EditorD.PanelEditorD Panel=(EditorD.PanelEditorD)PanelesSub.varias.get_Panel(enlace);
			if(Panel==null) return;
			Panel.ParentForm.CreateControl();
			if(!Panel.IsHandleCreated) Panel.Call_remuestra(datos);
			else{
				System.IntPtr p= new IntPtr((void*)datos);
				Panel./*Begin*/Invoke(Panel.dRemuestra,new object[]{p});	//BeginInvoke da excepción en Release (pero no en Debug)
			}
		}
	}
}
