﻿using Globales;

namespace Modelos{
	internal static class Textos{
		public enum Cods : uint{
			UniondeModelos,
			Modelos,
			Opciones,
			InfoSalida,
			Sinescala,
			RotacionesGrandes,
			Forzar_var_apriori,
			Acercade,
			Manualpath,
			FullTitle,
			Ficherodereferencia,
			Ficheroatransformar,
			Precisiones,
			Coordenadas_fijas,
			Igual_que_referencia,
			Fotogramas,
			Puntos,
			Planimetría,
			Altimetría,
			Transformar,
			Parámetros,
			Ccpp,
			Residuos,
			En_sistema_referencia,
			En_sistema_atransformar,
			Puntos_con_mayor_residuo,
			Puntos_de_control,
			Parámetros_transformación,
			Puntos_transformados,
			Fichero_valores_ajustados,
			Fichero_de_información,

			Debe_indicar_referencia,
			Debe_indicar_atransformar,
			Precisión_errónea,
			Fref_fotos_plani,
			Fref_fotos_alti,
			Fref_puntos_plani,
			Fref_puntos_alti,
			Ftrans_fotos_plani,
			Ftrans_fotos_alti,
			Ftrans_puntos_plani,
			Ftrans_puntos_alti,

			Valor_erroneo_percent,
			NTEXTOS
		}

		private static readonly string[] esp,eng,it;
		private static readonly string[][] textos;

		static Textos(){
			textos=new string[(int)Idioma.NIDIOMAS][];
			esp=new string[(int)Cods.NTEXTOS];
			eng=new string[(int)Cods.NTEXTOS];
			it=new string[(int)Cods.NTEXTOS];
			setup_esp();
			setup_eng();
			setup_it();

			textos[(int)Idioma.Esp]=esp;
			textos[(int)Idioma.Eng]=eng;
			textos[(int)Idioma.It]=it;
		}

		public static string get_texto(Cods cod, Idioma idioma){
			string[] t=textos[(int)idioma];
				if(t==null) t=textos[(int)Idioma.Esp];
			string s=t[(int)cod];
				if(s==null) s=textos[(int)Idioma.Esp][(int)cod];
			return s;
		}

		static void setup_esp(){
			esp[(int)Cods.UniondeModelos]="Unión de Modelos";
			esp[(int)Cods.Modelos]="Modelos";
			esp[(int)Cods.Opciones]="Opciones";
			esp[(int)Cods.InfoSalida]="Información de salida...";
			esp[(int)Cods.Sinescala]="Sin factor de escala";
			esp[(int)Cods.RotacionesGrandes]="Rotaciones Ω y Φ grandes";
			esp[(int)Cods.Forzar_var_apriori]="Forzar el uso de las varianzas a priori";
			esp[(int)Cods.Acercade]="Acerca de Unión de Modelos";
			esp[(int)Cods.Manualpath]="Manuales_html\\esp\\Modelos.htm";
			esp[(int)Cods.FullTitle]="Transformación de coordenadas entre modelos";
			esp[(int)Cods.Ficherodereferencia]="Fichero de referencia";
			esp[(int)Cods.Ficheroatransformar]="Fichero a transformar";
			esp[(int)Cods.Precisiones]="  Precisiones";
			esp[(int)Cods.Coordenadas_fijas]="Coordenadas fijas";
			esp[(int)Cods.Igual_que_referencia]="Igual que el fichero de referencia";
			esp[(int)Cods.Fotogramas]="Fotogramas";
			esp[(int)Cods.Puntos]="Puntos";
			esp[(int)Cods.Planimetría]="Planimetría";
			esp[(int)Cods.Altimetría]="Altimetría";
			esp[(int)Cods.Transformar]="Transformar";
			esp[(int)Cods.Parámetros]="Parámetros";
			eng[(int)Cods.Ccpp]="Centros de proyección";
			esp[(int)Cods.Residuos]="Residuos";
			esp[(int)Cods.En_sistema_referencia]="En el sistema de referencial";
			esp[(int)Cods.En_sistema_atransformar]="En el sistema a transformar";
			esp[(int)Cods.Puntos_con_mayor_residuo]="Puntos con mayor residuo";
			esp[(int)Cods.Puntos_de_control]="Puntos de control";
			esp[(int)Cods.Parámetros_transformación]="Parámetros de transformación";
			esp[(int)Cods.Puntos_transformados]="Puntos transformados";
			esp[(int)Cods.Fichero_valores_ajustados]="Fichero de valores ajustados";
			esp[(int)Cods.Fichero_de_información]="Fichero de información";

			esp[(int)Cods.Debe_indicar_referencia]="Debe indicar algún fichero de referencia";
			esp[(int)Cods.Debe_indicar_atransformar]="Debe indicar algún fichero a transformar";
			esp[(int)Cods.Precisión_errónea]="Valor de precisión erróneo:";
			esp[(int)Cods.Fref_fotos_plani]="Fichero de referencia, fotogramas, planimetría";
			esp[(int)Cods.Fref_fotos_alti]="Fichero de referencia, fotogramas, altimetría";
			esp[(int)Cods.Fref_puntos_plani]="Fichero de referencia, puntos, planimetría";
			esp[(int)Cods.Fref_puntos_alti]="Fichero de referencia, puntos, altimetría";
			esp[(int)Cods.Ftrans_fotos_plani]="Fichero a transformar, fotogramas, planimetría";
			esp[(int)Cods.Ftrans_fotos_alti]="Fichero a transformar, fotogramas, altimetría";
			esp[(int)Cods.Ftrans_puntos_plani]="Fichero a transformar, puntos, planimetría";
			esp[(int)Cods.Ftrans_puntos_alti]="Fichero a transformar, puntos, altimetría";

			esp[(int)Cods.Valor_erroneo_percent]="Valor de % erróneo";
		}
		static void setup_eng(){
			eng[(int)Cods.UniondeModelos]="Model Union";
			eng[(int)Cods.Modelos]="Models";
			eng[(int)Cods.Opciones]="Options";
			eng[(int)Cods.InfoSalida]="Output information...";
			eng[(int)Cods.Sinescala]="Without scale factor";
			eng[(int)Cods.RotacionesGrandes]="Large Ω and Φ rotations";
			eng[(int)Cods.Forzar_var_apriori]="Force the use of a priori variances";
			eng[(int)Cods.Acercade]="About Model Union";
			eng[(int)Cods.Manualpath]="Manuales_html\\eng\\Models.htm";
			eng[(int)Cods.FullTitle]="Coordinate transform amongst models";
			eng[(int)Cods.Ficherodereferencia]="Reference file";
			eng[(int)Cods.Ficheroatransformar]="File to be transformed";
			eng[(int)Cods.Precisiones]="  Precisions";
			eng[(int)Cods.Coordenadas_fijas]="Fixed coordinates";
			eng[(int)Cods.Igual_que_referencia]="Equal to the reference file's";
			eng[(int)Cods.Fotogramas]="Photographs";
			eng[(int)Cods.Puntos]="Points";
			eng[(int)Cods.Planimetría]="Planimetric";
			eng[(int)Cods.Altimetría]="Altimetric";
			eng[(int)Cods.Transformar]="Transform";
			eng[(int)Cods.Parámetros]="Parameters";
			eng[(int)Cods.Ccpp]="Projection centres";
			eng[(int)Cods.Residuos]="Residuals";
			eng[(int)Cods.En_sistema_referencia]="In the reference system";
			eng[(int)Cods.En_sistema_atransformar]="In the system to be transformed";
			eng[(int)Cods.Puntos_con_mayor_residuo]="Points with highest residuals";
			eng[(int)Cods.Puntos_de_control]="Control points";
			eng[(int)Cods.Parámetros_transformación]="Transformation parameters";
			eng[(int)Cods.Puntos_transformados]="Transformed points";
			eng[(int)Cods.Fichero_valores_ajustados]="Adjusted values file";
			eng[(int)Cods.Fichero_de_información]="Information file";

			eng[(int)Cods.Debe_indicar_referencia]="A reference file has to be specified";
			eng[(int)Cods.Debe_indicar_atransformar]="A file to be transformed has to be specified";
			eng[(int)Cods.Precisión_errónea]="Wrong precision value:";
			eng[(int)Cods.Fref_fotos_plani]="Reference file, photographs, planimetric";
			eng[(int)Cods.Fref_fotos_alti]="Reference file, photographs, altimetric";
			eng[(int)Cods.Fref_puntos_plani]="Reference file, points, planimetric";
			eng[(int)Cods.Fref_puntos_alti]="Reference file, points, altimetric";
			eng[(int)Cods.Ftrans_fotos_plani]="File to be transformed, photographs, planimetric";
			eng[(int)Cods.Ftrans_fotos_alti]="File to be transformed, photographs, altimetric";
			eng[(int)Cods.Ftrans_puntos_plani]="File to be transformed, points, planimetric";
			eng[(int)Cods.Ftrans_puntos_alti]="File to be transformed, points, altimetric";

			eng[(int)Cods.Valor_erroneo_percent]="Wrong value for %";
		}
		static void setup_it(){
			it[(int)Cods.UniondeModelos]="Unione di Modelli";
			it[(int)Cods.Modelos]="Modelli";
			it[(int)Cods.Opciones]="Opzioni";
			it[(int)Cods.InfoSalida]="Informazione d'uscita...";
			it[(int)Cods.Sinescala]="Senza fattore di scala";
			it[(int)Cods.RotacionesGrandes]="Rotazioni Ω e Φ grandi";
			it[(int)Cods.Forzar_var_apriori]="Forzare l'uso delle varianze a priori";
			it[(int)Cods.Acercade]="Su Unione di Modelli";
			it[(int)Cods.Manualpath]="Manuales_html\\it\\Modelli.htm";
			it[(int)Cods.FullTitle]="Trasformazione di coordinate fra modelli";
			it[(int)Cods.Ficherodereferencia]="File di riferimento";
			it[(int)Cods.Ficheroatransformar]="File da trasformare";
			it[(int)Cods.Precisiones]="  Precisioni";
			it[(int)Cods.Coordenadas_fijas]="Coordinate fisse";
			it[(int)Cods.Igual_que_referencia]="Uguale che il file di riferimento";
			it[(int)Cods.Fotogramas]="Fotogrammi";
			it[(int)Cods.Puntos]="Punti";
			it[(int)Cods.Planimetría]="Planimetria";
			it[(int)Cods.Altimetría]="Altimetria";
			it[(int)Cods.Transformar]="Trasforma";
			it[(int)Cods.Parámetros]="Parametri";
			it[(int)Cods.Ccpp]="Centri di proiezione";
			it[(int)Cods.Residuos]="Residui";
			it[(int)Cods.En_sistema_referencia]="Nel sistema di riferimento";
			it[(int)Cods.En_sistema_atransformar]="Nel sistema da trasformare";
			it[(int)Cods.Puntos_con_mayor_residuo]="Punti con maggiori residui";
			it[(int)Cods.Puntos_de_control]="Punti di controllo";
			it[(int)Cods.Parámetros_transformación]="Parametri di trasformazione";
			it[(int)Cods.Puntos_transformados]="Punti trasformati";
			it[(int)Cods.Fichero_valores_ajustados]="File di valori compensati";
			it[(int)Cods.Fichero_de_información]="File d'informazione";

			it[(int)Cods.Debe_indicar_referencia]="Deve indicare un file di riferimento";
			it[(int)Cods.Debe_indicar_atransformar]="Deve indicare un file da trasformare";
			it[(int)Cods.Precisión_errónea]="Valore di precisione erroneo:";
			it[(int)Cods.Fref_fotos_plani]="File di riferimento, fotogrammi, planimetria";
			it[(int)Cods.Fref_fotos_alti]="File di riferimento, fotogrammi, altimetria";
			it[(int)Cods.Fref_puntos_plani]="File di riferimento, punti, planimetria";
			it[(int)Cods.Fref_puntos_alti]="File di riferimento, punti, altimetria";
			it[(int)Cods.Ftrans_fotos_plani]="File da trasformare, fotogrammi, planimetria";
			it[(int)Cods.Ftrans_fotos_alti]="File da trasformare, fotogrammi, altimetria";
			it[(int)Cods.Ftrans_puntos_plani]="File da trasformare, punti, planimetria";
			it[(int)Cods.Ftrans_puntos_alti]="File da trasformare, punti, altimetria";

			it[(int)Cods.Valor_erroneo_percent]="Valore di % erroneo";
		}
	}
}
