using System;
using System.Windows.Forms;
using System.Drawing;

namespace ControlesAt{
	public interface IMessageBoxAT{
		MessageBoxAT MessageBox{get;}
	}

	public class MessageBoxAT : Object{
		protected class FormMessageBox : FormTools{
			public FormMessageBox(){
				PanelTop.BotMin.Parent=null;
				this.TopMost=true;
				this.StartPosition= FormStartPosition.CenterScreen;
				this.BackColor=Globales.Colores.NETColor(Globales.Colores.cFlatPopUp);
				DefaultCerrar();
			}
			public void DefaultCerrar(){this.AcceptButton=PanelTop.BotCerrar;}
			public Color TopBackColor{
				get{return PanelTop.BackColor;}
				set{PanelTop.BackColor=value;}
			}
		}
		protected FormMessageBox Form1;
		public Form Owner{set{Form1.Owner=value;}}
		public Icon Icono{	set{Form1.Icon=value;}}
		public String Caption{set{Form1.Text=value;}}
		public BaseLabel Label1;
		protected ContainerControl PanelBotones;
		protected BotAceptar[] Botones;
		public Color BackColor{get{return Form1.BackColor;}
									set{Form1.BackColor=value;}}
		public Color CaptionBackColor{get{return Form1.TopBackColor;}
												set{Form1.TopBackColor=value;}}
		public Color BotBackColor;

		public int MinWidth;
		public int MaxWidth;
		public int returnedButton;

		public MessageBoxAT(){
			Form1= new FormMessageBox();
			Label1= new BaseLabel();
			Label1.RefLocation= new Point(0,0);
			Label1.Margins= new Margenes(20,20,14,18);
			Label1.Autoref=false;
			Label1.TextAlign= new TwoDimAlignment(0.5F,0);
			Label1.InterlineSpace=1;
			PanelBotones= new ContainerControl();
			MinWidth=100;
			MaxWidth=600;
			Form1.Controls.Add(Label1);
			Form1.Controls.Add(PanelBotones);
			Botones=new BotAceptar[0];
			BotBackColor=Globales.Colores.NETColor(Globales.Colores.cBoton);
			Form1.Activated+=new EventHandler(Form1_Activated);
			Form1.Closing+=new System.ComponentModel.CancelEventHandler(Form1_Closing);
			//Form1.TopMost=false;			//these three pieces of absurd code are to work around another
		}
		protected void Form1_Activated(object sender,EventArgs e){
			Form1.TopMost=true;			 //.NET bug. In this way "only" the first time the message window is shown
			((Control)Form1.AcceptButton).Focus();
		}
		protected void Form1_Closing(object sender,System.ComponentModel.CancelEventArgs e){
			e.Cancel=true;
			Form1.TopMost=false;			//can the bug be exhibited. The commented line makes no difference
			Label1.Text="";
			Label1.AutoSizex=true;
			for(int i=0;i<Botones.Length;i++){
				PanelBotones.Controls.Remove(Botones[i]);
			}
			Botones=new BotAceptar[0];
			Form1.Hide();
		}

		//DefaultButton comienza en 1
		public void Show(string Message, string[] Buttons, int DefaultButton){
			int i,n=Buttons.Length;
			if(n==0) goto end;
			Botones=new BotAceptar[n];
			for(i=0;i<n;i++){
				Botones[i]=new BotAceptar();
				Botones[i].TabIndex=i;
				Botones[i].BackColor=BotBackColor;
				Botones[i].Text=Buttons[i];
				Botones[i].Click+=new EventHandler(Boton_Click);
			}
			returnedButton=DefaultButton;	//delayed setting of the AcceptButton
		   end:
			Show(Message);
		}
		unsafe public void Show(char* mensaje){
			Show(new string(mensaje));
		}
		public void Show(string Message){
			if(Form1.Visible) Form1.Hide();
			Label1.MaxWidth=240;
			Label1.Text=Message;
			if(Label1.Lines>4){
				int k=6;
				while(Label1.MaxWidth+60<=MaxWidth){
					Label1.MaxWidth+=60;
					if(Label1.Lines<=k) break;
					k++;
				}
			}
			if(Label1.Width<MinWidth){
				Label1.AutoSizex=false;
				Label1.Width=MinWidth;
			}
			if(Botones.Length!=0){
				int wd=Botones[0].Width+24;
				int nbots=Label1.Width/wd;
				if(nbots==0) nbots=1;
				if(nbots==1 && Botones.Length>1) nbots=2;
				if(nbots>Label1.Width/wd){
					Label1.AutoSizex=false;
					Label1.Width=nbots*wd;
				}
				float dx=(float)Label1.Width/nbots;
				float x0=(float)(Label1.Width-nbots*Botones[0].Width)/(2*nbots)+0.5F;
				float x;

				int pos=4;
				int i,j,k=0;
				for(i=Botones.Length-nbots+1;i>0;i-=nbots, pos+=40){
					for(j=0,x=x0;j<nbots;j++,k++,x+=dx){
						Botones[k].Location=new Point((int)x,pos);
					}
				}
				if(k!=Botones.Length){
					i=Botones.Length-k;
					x=((float)Label1.Width-i*dx)*0.5F+x0;
					for(;k<Botones.Length;k++,x+=dx)
						Botones[k].Location=new Point((int)x,pos);
					pos+=40;
				}
				PanelBotones.Location=new Point(0,Label1.Height);
				PanelBotones.Size=new Size(Label1.Width,pos);
				PanelBotones.Controls.AddRange(Botones);
				Form1.ClientSize=new Size(Label1.Width,PanelBotones.Bottom);
				Form1.AcceptButton=Botones[returnedButton-1];
			}else{
				Form1.DefaultCerrar();
				Form1.ClientSize=Label1.Size;
			}
			returnedButton=0;
			Form1.ShowDialog();
		}
		private void Boton_Click(object sender,EventArgs e){
			int i;
			for(i=0;i<Botones.Length;i++){
				if((Control)sender==(Control)Botones[i]) break;
			}
			returnedButton=i+1;
			this.Form1.Close();
		}
	}
}
