using System;
using System.Drawing;
using System.Windows.Forms;

namespace ControlesAt{
	public class MasMenos : Label, IButtonControl{
		public DialogResult DialogResult{
			get{return DialogResult.OK;}
			set{}
		}
		public void NotifyDefault(bool value){}

		private bool state;
		public bool State{
			get{return state;}
			set{state=value; this.Invalidate();}
		}
		public Color OffColor, OnColor;

		public MasMenos(){
			this.BorderStyle=BorderStyle.FixedSingle;
			OffColor= Color.Empty;
			OnColor= Globales.Colores.NETColor(Globales.Colores.cAceptarFormLabel);
			State=false;
		}
		protected override Size DefaultSize{
			get{return new Size(9,9);}
		}
		protected override void OnResize(EventArgs e){
			this.Size= this.DefaultSize;
		}

		protected override void OnMouseEnter(EventArgs e){
			base.OnMouseEnter(e);
			this.BackColor=OnColor;
		}
		protected override void OnMouseLeave(EventArgs e){
			this.BackColor=OffColor;
			base.OnMouseLeave(e);
		}

		protected override void OnPaint(PaintEventArgs e){//Bug del .NET.
			base.OnPaint(e);
			System.Drawing.Pen p;
			p= new Pen(this.ForeColor,1);
			e.Graphics.DrawLine(p,1,3,5,3);
			if(!state) e.Graphics.DrawLine(p,3,1,3,5);
			p.Dispose();
		}
		protected override void OnClick(EventArgs e){
			State=!state;
			base.OnClick (e);
		}

		public void PerformClick(){
			this.OnClick(EventArgs.Empty);
		}
	}
}
