using System;
using System.Windows.Forms;
using System.Drawing;
using static Globales.FileTypes;

namespace ControlesAt{
	/// <summary>
	/// Label con flecha que se despliega y muestra distintas opciones para el tipo de fichero
	/// Cada elemento tiene un texto (el tipo de fichero) y un entero que se emplea para que
	/// el cdigo que emplee un Labeltf identifique el tipo de fichero de que se trata.
	/// </summary>
	public class Labeltf : System.Windows.Forms.Panel
	{
		private struct LabeltfItem{
			internal MenuItem m;
			public int indice;
		}
		private System.Windows.Forms.Label Label1;
		private System.Windows.Forms.Label fl;
		private System.Windows.Forms.ContextMenu popmenu;

		private LabeltfItem[] Items;
		private EventHandler Handler_pop_Click;
		internal byte tipof;
		public readonly byte n;
		public int Indice_int{
			get{return Items[tipof].indice;}
			set{
				for(byte i=0;i<Items.Length;i++){
					if(Items[i].indice==value){
						tipof=i;
						break;
				}	}
			}
		}
		public TipoFichero Indice{
			get{return (TipoFichero)Items[tipof].indice;}
			set{Indice_int=(int)value;}
		}

		public EventVoid IndexChanged;
		static Font	ThisFont= new Font("Georgia", 8.25F),
						FlechaFont= new Font("Marlett", 12F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, (byte)2);
		static EventHandler	MouseEnterE= new EventHandler(Labeltf_MouseEnter),
									MouseLeaveE= new EventHandler(Labeltf_MouseLeave);

		public Labeltf(byte _n){
			if(_n!=0) n=_n;
			else n=1;
			InitializeComponent();
			tipof=0;
			colores();
			IndexChanged=new EventVoid(actualiza);
		}
		public Labeltf(TipoFichero[] tipos) : this((byte)tipos.Length){
			if(tipos.Length==0) return;
			set_indices(tipos);
		}

	#region InitializeComponent
		private void InitializeComponent()
		{
			Label1= new Label();
			fl= new Label();
			//
			// Label1
			//
			Label1.Dock= DockStyle.Fill;
			Label1.FlatStyle= FlatStyle.System;
			Label1.Font= ThisFont;
			Label1.Location= new Point(0, 0);
			Label1.Size= new Size(76, 16);
			Label1.TabIndex= 0;
			Label1.TextAlign= ContentAlignment.TopCenter;
			Label1.MouseEnter+= MouseEnterE;
			Label1.MouseLeave+= MouseLeaveE;
			Label1.MouseDown+= new MouseEventHandler(Labeltf_MouseDown);
			//
			// fl
			//
			fl.Dock= DockStyle.Right;
			fl.FlatStyle=FlatStyle.System;
			fl.Font= FlechaFont;
			fl.Location= new Point(72, 0);
			fl.Size= new Size(14, 16);
			fl.TabIndex= 1;
			fl.Text= "6";
			fl.MouseEnter+= MouseEnterE;
			fl.MouseLeave+= new EventHandler(Labeltf_MouseLeave);
			fl.MouseDown+= new MouseEventHandler(Labeltf_MouseDown);
			//
			// popmenu
			//
			popmenu= new System.Windows.Forms.ContextMenu();
			Items=new LabeltfItem[n];
			Handler_pop_Click=new EventHandler(pop_Click);
			for(byte i=0;i<n;i++){
				Items[i].m=new MenuItem("",Handler_pop_Click);
				Items[i].m.Index=i;
				popmenu.MenuItems.Add(Items[i].m);
			}
			//
			// Labeltf
			//
			this.Controls.Add(Label1);
			this.Controls.Add(fl);
		}
		protected override Size DefaultSize{
			get{return new Size(88, 16);}
		}

		#endregion

		public void set_indices(int[] indices){
			byte t=n;
			if(indices.Length<n) t=(byte)indices.Length;
			for(byte i=0;i<t;i++)
				Items[i].indice=indices[i];
		}
		public void set_indices(TipoFichero[] indices){
			byte t=n;
			if(indices.Length<n) t=(byte)indices.Length;
			for(byte i=0;i<t;i++)
				Items[i].indice=(int)indices[i];
		}
		public void set_texto(byte i, string texto){
			if(i>=n) return;
			popmenu.MenuItems[i].Text=texto;
		}
		public void set_textos(string[] textos){
			byte t=n;
			if(textos.Length<n) t=(byte)textos.Length;
			for(byte i=0;i<t;i++)
				Items[i].m.Text=textos[i];
		}
		public void set_enabled(byte i, bool state){
			if(i>n) return;
			popmenu.MenuItems[i].Enabled=state;
			if(tipof==i) Label1.Enabled=state;
		}

		public void actualiza(){
			Label1.Text=popmenu.MenuItems[tipof].Text;
			if(Label1.Enabled==false) Label1.Enabled=true;
		}

	#region Colores y pinchar
		static void Labeltf_MouseEnter(object sender,System.EventArgs e){
			((Control)sender).Parent.BackColor=Globales.Colores.NETColor(Globales.Colores.color3);
		}
		static void Labeltf_MouseLeave(object sender,System.EventArgs e){
			((Control)sender).Parent.BackColor=((Control)sender).Parent.Parent.BackColor;
		}
		void Labeltf_MouseDown(object sender,MouseEventArgs e){
			if(e.Button != MouseButtons.Left) return;
			popmenu.Show(Label1, new Point(0, 0));
		}
	#endregion

		void pop_Click(Object sender,EventArgs e){
			byte i;
			for(i=0;i<n;i++){
				if(sender.Equals(popmenu.MenuItems[i])) break;
			}
			if(i==n) return;
			if(tipof!=i){
				tipof=i;
				IndexChanged();	//Llama a actualiza
			}
		}

		void colores(){
			this.BackColor=Globales.Colores.NETColor(Globales.Colores.cForm);
			this.fl.ForeColor=Globales.Colores.NETColor(Globales.Colores.cCasiNegro);
		}
	}
}
