using System.Windows.Forms;
using System.Drawing;

namespace ControlesAt{
	public class ProcessKeys{
		public static void HandleInteger(object sender,KeyPressEventArgs e){
			if(e.KeyChar>26 && (e.KeyChar<'0' || e.KeyChar>'9') && e.KeyChar!=127 && e.KeyChar!='\b') e.Handled=true;
		}
		public static void HandleFloat(object sender,KeyPressEventArgs e){
			if(e.KeyChar>26 && (e.KeyChar<'0' || e.KeyChar>'9') && e.KeyChar!=127 && e.KeyChar!='\b'
				&& e.KeyChar!='-' && e.KeyChar!='+' && e.KeyChar!='.' && e.KeyChar!=',') e.Handled=true;
		}
		public static void HandleFloatPos(object sender,KeyPressEventArgs e){
			if(e.KeyChar>26 && (e.KeyChar<'0' || e.KeyChar>'9') && e.KeyChar!=127 && e.KeyChar!='\b'
				&& e.KeyChar!='+' && e.KeyChar!='.' && e.KeyChar!=',') e.Handled=true;
		}
		public static KeyPressEventHandler GetHandlerFromType(char type){
			switch(type){
				case ' ': return null;
				case 'I': return new KeyPressEventHandler(ProcessKeys.HandleInteger);
				case 'F':  return new KeyPressEventHandler(ProcessKeys.HandleFloat);
				case 'f': return new KeyPressEventHandler(ProcessKeys.HandleFloatPos);
			}
			throw(new System.ArgumentException("Unknown specification for the type of HandledTextBox","type"));
		}
	}

	public class HandledTextBox : TextBox{
		public KeyPressEventHandler process_input;
		public HandledTextBox(char type){
			process_input=ProcessKeys.GetHandlerFromType(type);
		}
		public HandledTextBox(){process_input=null;}
		public HandledTextBox(KeyPressEventHandler process_handler){
			process_input=process_handler;
		}
		protected override void OnKeyPress(KeyPressEventArgs e){
			if(process_input!=null) process_input(this,e);
			base.OnKeyPress(e);
		}
	}

	public class TextBoxFocus : HandledTextBox{
		public TextBoxFocus() : base(){initializeb();}
		public TextBoxFocus(char type) : base(type){initializeb();}
		public TextBoxFocus(KeyPressEventHandler p) : base(p){initializeb();}
		protected void initializeb(){
			this.AutoSize= false;
			this.TextAlign= HorizontalAlignment.Right;
		}
		protected override Size DefaultSize{
			get{return new Size(76,19);}
		}
		protected override void OnGotFocus(System.EventArgs e){
			base.OnGotFocus(e);
			this.SelectAll();
		}
	}
	public class TextBoxSingle : TextBoxFocus{
		public TextBoxSingle() : base(){initializeb();}
		public TextBoxSingle(char type) : base(type){initializeb();}
		public TextBoxSingle(KeyPressEventHandler p) : base(p){initializeb();}
		protected new void initializeb(){
			this.BorderStyle=BorderStyle.FixedSingle;
		}
		protected override Size DefaultSize{
			get{return new Size(36,17);}
		}
	}

	public class IntegerTextBox : TextBoxFocus{public IntegerTextBox() : base('I'){}}
	public class IntegerTextSingle : TextBoxSingle{public IntegerTextSingle() : base('I'){}}
	public class IntegerTextPlano : TextBoxPlano{public IntegerTextPlano() : base('I'){}}

	public class FloatTextBox : TextBoxFocus{public FloatTextBox() : base('F'){}}
	public class FloatTextSingle : TextBoxSingle{public FloatTextSingle() : base('F'){}}
	public class FloatTextPlano : TextBoxPlano{public FloatTextPlano() : base('F'){}}

	public class FloatPosTextBox : TextBoxFocus{public FloatPosTextBox() : base('f'){}}
	public class FloatPosTextSingle : TextBoxSingle{public FloatPosTextSingle() : base('f'){}}
	public class FloatPosTextPlano : TextBoxPlano{public FloatPosTextPlano() : base('f'){}}
}