using System;
using System.Windows.Forms;
using System.Drawing;

namespace ControlesAt{
	public abstract class LabelControl : System.Windows.Forms.ContainerControl{	//Internal, pero el compilador no deja
		public LabelRight L;
		public Control T;
		protected int baseline, oddline, evenline;
		protected int topsep;
		private bool ignore;
		protected int separacion;
		protected abstract short defaultsep{get;}
		public int Separacion{
			get{return separacion;}
			set{if(separacion==value) return;
				int d=value-separacion;
				this.Left-=d; separacion=value;
				this.Width+=d;
			}
		}
		//.NET fix
		protected virtual Point Tget_Location(){return T.Location;}	protected virtual void Tset_Location(Point value){T.Location=value;}
		protected int Tget_Left(){return Tget_Location().X;}	protected virtual void Tset_Left(int value){T.Left=value;}
		protected int Tget_Top(){return Tget_Location().Y;}	protected virtual void Tset_Top(int value){T.Top=value;}

		protected virtual Size Tget_Size(){return T.Size;}			protected virtual void Tset_Size(Size value){T.Size=value;}
		protected int Tget_Width(){return Tget_Size().Width;}	protected virtual void Tset_Width(int value){T.Width=value;}
		protected int Tget_Height(){return Tget_Size().Height;}	protected virtual void Tset_Height(int value){T.Height=value;}
		//
		public int TextWidth{
			get{return Tget_Width();}
			set{if(Tget_Width()==value) return;
				int d=value-T.Width;
				ignore=true; Tset_Width(value); ignore=false;
				this.Width+=d;
			}
		}
		public Point TextLocation{
			get{return new Point(this.Location.X+T.Location.X, this.Location.Y+T.Location.Y);}
			set{this.Location= new Point(value.X-separacion-L.Width, value.Y-T.Location.Y);}
		}
		public override string Text{
			get{return T.Text;}
			set{T.Text=value;}
		}

		public new event EventHandler TextChanged;
		public new event EventHandler Click;
		protected void internalTextChanged(object sender,EventArgs e){
			if(TextChanged!=null) TextChanged(this,e);
		}
		protected void internalClick(object sender,EventArgs e){
			if(Click!=null) Click(this,e);
		}

		protected abstract void CreaT();
		protected abstract void SetDefaultLines();
	#region Constructores
		public LabelControl(){create(defaultsep,int.MinValue);}
		public LabelControl(short sep){create(sep,int.MinValue);}
		public LabelControl(int _TextWidth){create(defaultsep, _TextWidth);}
		public LabelControl(int _TextWidth, short sep){create(sep, _TextWidth);}
		void create(short sep, int Twidth){
			L=new LabelRight();
			CreaT();
			separacion=sep;
			if(Twidth!=int.MinValue) Tset_Width(Twidth);
			initializeb();
		}
	#endregion
		protected void initializeb(){
			SetDefaultLines();
			L.TabIndex=0;
			T.TabIndex=1;

			Tset_Location(new Point(L.Width+separacion,0));
			this.Width=Tget_Left()+Tget_Width();
			this.Height=Tget_Height();
			L.RefLocation=new Point(L.Width,baseline);
			L.LocationChanged+=new EventHandler(L_LocationChanged);
			if(!(baseline==oddline && oddline==evenline)) L.LinesChanged+=new EventHandler(L_LinesChanged);
			L.SizeChanged+=new EventHandler(set_Heigth);
			T.SizeChanged+=new EventHandler(set_Heigth);
			ignore=false;
			this.Controls.Add(L);
			this.Controls.Add(T);

			System.Reflection.EventInfo Ev;
			Type tipo=T.GetType();
			Ev=tipo.GetEvent("TextChanged");		if(Ev!=null) Ev.AddEventHandler(T,new EventHandler(internalTextChanged));
			Ev=tipo.GetEvent("Click");				if(Ev!=null) Ev.AddEventHandler(T,new EventHandler(internalClick));
			initializec();
		}
		protected virtual void initializec(){}

		protected void L_LinesChanged(object sender,EventArgs e){
			int posy;
			if(L.Lines<=1) posy=baseline;
			else if((L.Lines&1)!=0) posy=oddline;
			else posy=evenline;
			L.RefLocation= new Point(L.RefLocation.X, posy+Tget_Top());
		}
		protected void L_LocationChanged(object sender,EventArgs e){
			if(ignore) return;
			ignore=true;
			int dif=L.Left;
			this.Left+=dif;	this.Width-=dif;		T.Left-=dif;

			dif=Math.Min(L.Top,Tget_Top());
			if(dif!=0){this.Top+=dif;	T.Top-=dif;}
			L.RefLocation= new Point(L.Width, L.RefLocation.Y-dif);
			this.Height=Math.Max(L.Top+L.Height,Tget_Top()+Tget_Height());

			Region a;
			a= new Region(new Rectangle(L.Location, L.Size));
			a.Union(new Rectangle(Tget_Location(), Tget_Size()));
			this.Region=a;
			ignore=false;
		}
		protected void set_Heigth(object sender,EventArgs e){
			if(L.Location!= ((Control)L).Location) return;	//L_LocationChanged is about to be called
			this.Height=Math.Max(L.Top+L.Height,Tget_Top()+Tget_Height());
		}
	}
	public class LabelLabel : LabelControl{
		public new Label T{
			set{base.T=value;}
			get{return (Label)base.T;}
		}
		protected override void CreaT(){
			T=new Label();
		}
		protected static int _defaultsep=2;
		protected override short defaultsep{get{return (short)_defaultsep;}}
		public static int DefaultSep(){return _defaultsep;}
		public static int DefaultSep(int s){
			int t=_defaultsep;	_defaultsep=s;	return t;
		}
		protected override void SetDefaultLines(){
			baseline=oddline=evenline=11;
		}
		public LabelLabel() : base(){}
		public LabelLabel(short sep) : base(sep){}
		public LabelLabel(int _TextWidth) : base(_TextWidth){}
		public LabelLabel(int _TextWidth, short sep) : base(_TextWidth, sep){}
	}
	public class LabelTexto : LabelControl{
		public new TextBoxFocus T{
			set{base.T=value;}
			get{return (TextBoxFocus)base.T;}
		}
		protected override void CreaT(){
			T=new TextBoxFocus();
		}
		protected static int _defaultsep=6;
		protected override short defaultsep{get{return (short)_defaultsep;}}
		public static int DefaultSep(){return _defaultsep;}
		public static int DefaultSep(int s){
			int t=_defaultsep;	_defaultsep=s;	return t;
		}
		protected override void SetDefaultLines(){
			baseline=oddline=evenline=13;
		}
		public LabelTexto() : base(){}
		public LabelTexto(short sep) : base(sep){}
		public LabelTexto(int _TextWidth) : base(_TextWidth){}
		public LabelTexto(int _TextWidth, short sep) : base(_TextWidth, sep){}
	}
	public class LabelTextoSingle : LabelTexto{
		protected override void CreaT(){
			T=new TextBoxSingle();
		}
		protected override void SetDefaultLines(){
			baseline=oddline=evenline=12;
		}
		public LabelTextoSingle() : base(){}
		public LabelTextoSingle(short sep) : base(sep){}
		public LabelTextoSingle(int _TextWidth) : base(_TextWidth){}
		public LabelTextoSingle(int _TextWidth, short sep) : base(_TextWidth, sep){}
	}
	public class LabelTextoPlano : LabelControl{
		public new TextBoxPlano T{
			set{base.T=value;}
			get{return (TextBoxPlano)base.T;}
		}
		protected override void CreaT(){
			T=new TextBoxPlano();
		}
		protected override Point Tget_Location(){return T.Location+new Size(0,-2);}
		protected override void Tset_Location(Point value){T.Location=value+new Size(0,2);}
		protected override void Tset_Top(int Y){T.Top=Y+2;}
		protected override Size Tget_Size(){return T.Size+new Size(3,2);}
		protected override void Tset_Size(Size value){T.Size=value-new Size(3,2);}
		protected override void Tset_Width(int W){T.Width=W-3;}
		protected override void Tset_Height(int H){T.Height=H-2;}

		protected static int _defaultsep=6;
		protected override short defaultsep{get{return (short)_defaultsep;}}
		public static int DefaultSep(){return _defaultsep;}
		public static int DefaultSep(int s){
			int t=_defaultsep;	_defaultsep=s;	return t;
		}
		protected override void SetDefaultLines(){
			baseline=oddline=evenline=12;
		}
		public LabelTextoPlano() : base(){}
		public LabelTextoPlano(short sep) : base(sep){}
		public LabelTextoPlano(int _TextWidth) : base(_TextWidth){}
		public LabelTextoPlano(int _TextWidth, short sep) : base(_TextWidth, sep){}
	}
	public class LTInteger : LabelTexto{
		protected override void CreaT(){
			T=new IntegerTextBox();
		}
		public LTInteger() : base(){}
		public LTInteger(short sep) : base(sep){}
		public LTInteger(int _TextWidth) : base(_TextWidth){}
		public LTInteger(int _TextWidth, short sep) : base(_TextWidth, sep){}
		protected override void SetDefaultLines(){
			base.SetDefaultLines();
			evenline--;	//Numbers do not have descenders but ascend like capitals
		}
	}
	public class LTIntegerSingle : LabelTextoSingle{
		protected override void CreaT(){
			T=new IntegerTextSingle();
		}
		public LTIntegerSingle() : base(){}
		public LTIntegerSingle(short sep) : base(sep){}
		public LTIntegerSingle(int _TextWidth) : base(_TextWidth){}
		public LTIntegerSingle(int _TextWidth, short sep) : base(_TextWidth, sep){}
		protected override void SetDefaultLines(){
			base.SetDefaultLines();
			evenline--;
		}
	}
	public class LTIntegerPlano : LabelTextoPlano{
		protected override void CreaT(){
			T=new IntegerTextPlano();
		}
		public LTIntegerPlano() : base(){}
		public LTIntegerPlano(short sep) : base(sep){}
		public LTIntegerPlano(int _TextWidth) : base(_TextWidth){}
		public LTIntegerPlano(int _TextWidth, short sep) : base(_TextWidth, sep){}
		protected override void SetDefaultLines(){
			base.SetDefaultLines();
			evenline--;
		}
	}
	public class LTFloat : LabelTexto{
		protected override void CreaT(){
			T=new FloatTextBox();
		}
		public LTFloat() : base(){}
		public LTFloat(short sep) : base(sep){}
		public LTFloat(int _TextWidth) : base(_TextWidth){}
		public LTFloat(int _TextWidth, short sep) : base(_TextWidth, sep){}
		protected override void SetDefaultLines(){
			base.SetDefaultLines();
			evenline--;
		}
	}
	public class LTFloatPos : LabelTexto{
		protected override void CreaT(){
			T=new FloatPosTextBox();
		}
		public LTFloatPos() : base(){}
		public LTFloatPos(short sep) : base(sep){}
		public LTFloatPos(int _TextWidth) : base(_TextWidth){}
		public LTFloatPos(int _TextWidth, short sep) : base(_TextWidth, sep){}
		protected override void SetDefaultLines(){
			base.SetDefaultLines();
			evenline--;
		}
	}
	public class LTFloatPosSingle : LabelTextoSingle{
		protected override void CreaT(){
			T=new FloatPosTextSingle();
		}
		public LTFloatPosSingle() : base(){}
		public LTFloatPosSingle(short sep) : base(sep){}
		public LTFloatPosSingle(int _TextWidth) : base(_TextWidth){}
		public LTFloatPosSingle(int _TextWidth, short sep) : base(_TextWidth, sep){}
		protected override void SetDefaultLines(){
			base.SetDefaultLines();
			evenline--;
		}
	}
	public class LTFloatPosPlano : LabelTextoPlano{
		protected override void CreaT(){
			T=new FloatPosTextPlano();
		}
		public LTFloatPosPlano() : base(){}
		public LTFloatPosPlano(short sep) : base(sep){}
		public LTFloatPosPlano(int _TextWidth) : base(_TextWidth){}
		public LTFloatPosPlano(int _TextWidth, short sep) : base(_TextWidth, sep){}
		protected override void SetDefaultLines(){
			base.SetDefaultLines();
			evenline--;
		}
	}

	public class LabelSelectorUD : LabelControl{
		public new DomainUpDown T{
			get{return ((DomainUpDownFixed)base.T).L;}
		}
		protected override void CreaT(){
			base.T=new DomainUpDownFixed();
		}
		protected static int _defaultsep=6;
		protected override short defaultsep{get{return (short)_defaultsep;}}
		public static int DefaultSep(){return _defaultsep;}
		public static int DefaultSep(int s){
			int t=_defaultsep;	_defaultsep=s;	return t;
		}
		protected override void SetDefaultLines(){
			baseline=oddline=evenline=12;
		}
		public LabelSelectorUD() : base(){}
		public LabelSelectorUD(short sep) : base(sep){}
		public LabelSelectorUD(int _TextWidth) : base(_TextWidth){}
		public LabelSelectorUD(int _TextWidth, short sep) : base(_TextWidth, sep){}
	}

	public class LabelTxtBotAbrir : LabelControl{
		public new TxtBotAbrir T{
			get{return (TxtBotAbrir)base.T;}
			set{base.T=value;}
		}
		protected override void CreaT(){
			T=new TxtBotAbrir();
		}
		protected static int _defaultsep=4;
		protected override short defaultsep{get{return (short)_defaultsep;}}
		public static int DefaultSep(){return _defaultsep;}
		public static int DefaultSep(int s){
			int t=_defaultsep;	_defaultsep=s;	return t;
		}
		protected override void SetDefaultLines(){
			baseline=oddline=evenline=13;
			L.MaxWidth=108;
		}
		public LabelTxtBotAbrir() : base(){}
		public LabelTxtBotAbrir(short sep) : base(sep){}
		public LabelTxtBotAbrir(int _TextWidth) : base(_TextWidth){}
		public LabelTxtBotAbrir(int _TextWidth, short sep) : base(_TextWidth, sep){}
	}

	public class LabelBotppp : LabelControl{
		public new Botonppp T{
			get{return (Botonppp)base.T;}
			set{base.T=value;}
		}
		protected override void CreaT(){
			T=new Botonppp();
		}
		protected static int _defaultsep=8;
		protected override short defaultsep{get{return (short)_defaultsep;}}
		public static int DefaultSep(){return _defaultsep;}
		public static int DefaultSep(int s){
			int t=_defaultsep;	_defaultsep=s;	return t;
		}
		protected override void SetDefaultLines(){
			baseline=oddline=evenline=11;
		}
		public LabelBotppp() : base(){}
		public LabelBotppp(short sep) : base(sep){}
		public LabelBotppp(int _TextWidth) : base(_TextWidth){}
		public LabelBotppp(int _TextWidth, short sep) : base(_TextWidth, sep){}
	}

	public class CheckSquare : CheckBox{
		public CheckSquare(){this.Width=13;}
	}
	public class RadioSquare : RadioButton{
		public RadioSquare(){this.Width=13;}
	}

	public class LabelCheck : LabelControl{
		public new CheckBox T{
			get{return (CheckBox)base.T;}
			set{base.T=value;}
		}
		protected override void CreaT(){
			T=new CheckSquare();
		}
		protected static int _defaultsep=4;
		protected override short defaultsep{get{return (short)_defaultsep;}}
		public static int DefaultSep(){return _defaultsep;}
		public static int DefaultSep(int s){
			int t=_defaultsep;	_defaultsep=s;	return t;
		}
		protected override void SetDefaultLines(){
			baseline=oddline=evenline=14;
		}
		public LabelCheck() : base(){}
		public LabelCheck(short sep) : base(sep){}
		public LabelCheck(int _TextWidth) : base(_TextWidth){}
		public LabelCheck(int _TextWidth, short sep) : base(_TextWidth, sep){}
		protected override void initializec(){
			T.CheckedChanged+=new EventHandler(internalCheckedChanged);
		}
		public bool Checked{
			get{return T.Checked;}
			set{T.Checked=value;}
		}
		public override string Text{
			get{return L.Text;}
			set{L.Text=value;}
		}
		public event EventHandler CheckedChanged;
		protected void internalCheckedChanged(object sender,EventArgs e){
			if(CheckedChanged!=null) CheckedChanged(this,e);
		}
	}

	public class LabelRadio : LabelControl{
		public new RadioButton T{
			get{return (RadioButton)base.T;}
			set{base.T=value;}
		}
		protected override void CreaT(){
			T=new RadioSquare();
		}
		protected static int _defaultsep=4;
		protected override short defaultsep{get{return (short)_defaultsep;}}
		public static int DefaultSep(){return _defaultsep;}
		public static int DefaultSep(int s){
			int t=_defaultsep;	_defaultsep=s;	return t;
		}
		protected override void SetDefaultLines(){
			baseline=oddline=evenline=14;
		}
		public LabelRadio() : base(){}
		public LabelRadio(short sep) : base(sep){}
		public LabelRadio(int _TextWidth) : base(_TextWidth){}
		public LabelRadio(int _TextWidth, short sep) : base(_TextWidth, sep){}
		protected override void initializec(){
			T.CheckedChanged+=new EventHandler(internalCheckedChanged);
		}
		public bool Checked{
			get{return T.Checked;}
			set{T.Checked=value;}
		}
		public override string Text{
			get{return L.Text;}
			set{L.Text=value;}
		}
		public event EventHandler CheckedChanged;
		protected void internalCheckedChanged(object sender,EventArgs e){
			if(CheckedChanged!=null) CheckedChanged(this,e);
		}
	}
}
