using System.Runtime.InteropServices;

namespace EditorD{
namespace InterComEditorD{
	public struct int2{
		public uint n1,n2;
	}
	public struct int4{
		public uint n1,n2,n3,n4;
	}
	public struct PuntoXYZ{
		public double X, Y, Z;
	}
	public struct Matriz33{
		public double
			m00,m01,m02,
			m10,m11,m12,
			m20,m21,m22;
	}
	unsafe public struct PuntoM{
		public byte* nom;
		public PuntoXYZ P;
		public byte bbb;
		public uint peso;
	}
	unsafe public struct CentroProy{
		public PuntoXYZ P;
		public Matriz33 M;
		public byte* nom;
		public byte bbb1, bbb2;
		public byte b;
		public uint peso;
	}
	unsafe public struct PuntoGPSINS{
		public PuntoXYZ P;
		public Matriz33 M;
		public byte* nom;
		public double t;
		public PuntoXYZ offset;
		public byte bg, bi;
		public uint grupo;
		public byte tipoGPS, tipoINS;
		public byte param;
		public uint peso;
	}
	unsafe public struct GrupoGPSINS{
		public byte* nom;
		public byte tipoGPS, tipoINS;
		public byte param;
		public double tiempo0;
		public PuntoXYZ offset,
							despl,
							deriva;
		public Matriz33 desplins;
		public PuntoXYZ derivains;
		public uint n;
		public byte bg, bi;
		public uint peso;
	};

	unsafe public struct NamedPointer{
		public uint tipo;
		public byte* name;
		public uint n;	//Nmero de elementos
		public void* p;
	}
	unsafe public struct Namedn{
		public byte* name;
		public uint n;
	}

	public struct Precisiones{
		public float im;
		public float pXY, pZ;
		public float gpsXY, gpsZ;
		public float insWF, insK;
	}
	public struct DecimalesAj{
		sbyte f;	//Slo se usa para los parmetros de autocalibracin
		sbyte pxy, pz;	//puntos xy, z
		sbyte cpxy, cpz, cpg, rot;	//centros de proyeccin xy, z, giros, matriz de rotacin
	}
	unsafe public struct BnfVarios{
		public char* ficherof,
					ficheroapr,
					ficheroapy,
					ficherogps,
					ficheroint;
		public struct __1_{
			public byte mar, prm, pym, gpm, inm;
		}public __1_ tipos_fich;

		public byte uni;
		public ControlesAt.SistemadeCoordenadas.Sistema sis;
		public byte estimador;	//0: mm.cc.; 1: Aerotri_0
		public struct __2_{
			public uint ncp, npm, npy, ngruposgps,ngps, ngruposins,nins, ngruposcalib;
		}public __2_ ncalc;

		public Precisiones apriori;		//Los valores para magnitudes angulares,
		public Precisiones aposteriori;	//INSWF e INSK, estn en radianes
		float sigma_aposteriori;	/*En relacin a los valores a priori*/
		public struct __3_{
			public float foto, apoyo, gps, ins;
		}public __3_ redun_parciales;
		public uint nobs;
		public uint nincog;
		public DecimalesAj decj;
	}

	unsafe public struct FicheroBnf{
		public uint plist;
		public NamedPointer* punteros;
		public Namedn* enes;
		public BnfVarios *varios;
	};

	public struct DecimalesResiduos{
		public sbyte im;
		public sbyte p;
		public sbyte gps;
		public sbyte ins;
	}

	public struct C12{	//byte[12]
		public byte c0,c1,c2,c3,c4,c5,c6,c7,c8,c9,c10,c11;
	}
	public struct C4{	//byte[4]
		public byte c0,c1,c2,c3;
	}
	unsafe public struct BnfFila_ResporFoto{
		public sbyte* f1_fotograma;
		public sbyte* f2_punto;
		public C12 f3_resx;
		public C12 f4_resy;
		public C4 f5_tipo; //XYZ
		public float f6_res_norm_x;
		public float f7_res_norm_y;
		public C4 f8_aviso; //!!
		public float v_resx;
		public float v_resy;
		public uint v_orden_def;
		public uint v_orden_res;
		public uint v_orden_res_norm;
	}
	unsafe public struct BnfTabla_ResporFoto{
		public BnfFila_ResporFoto* filas;
		public uint n;
	}

	unsafe public struct BnfFila_ResporPunto{
		public sbyte* f1_punto;
		public sbyte* f2_fotograma;
		public C12 f3_resx;
		public C12 f4_resy;
		public float f5_res_norm_x;
		public float f6_res_norm_y;
		public float v_resx;
		public float v_resy;
		public uint v_orden_def;
		public uint v_orden_res;
		public uint v_orden_res_norm;
	}
	unsafe public struct BnfTabla_ResporPunto{
		public BnfFila_ResporPunto* filas;
		public uint n;
	}

	unsafe public struct BnfFila_ResApoyo{
		public sbyte* f1_punto;
		public C12 f2_resx;
		public C12 f3_resy;
		public C12 f4_resz;
		public float f5_res_norm_x;
		public float f6_res_norm_y;
		public float f7_res_norm_z;
		public float v_resx;
		public float v_resy;
		public float v_resz;
		public uint v_orden_def;
		public uint v_orden_res;
		public uint v_orden_res_norm;
	};
	unsafe public struct BnfTabla_ResApoyo{
		public BnfFila_ResApoyo* filas;
		public uint n;
	}

	unsafe public struct BnfFila_ResGPS{
		public sbyte* f1_grupo;
		public sbyte* f2_centroproy;
		public C12 f3_resx;
		public C12 f4_resy;
		public C12 f5_resz;
		public C12 f6_resw;
		public C12 f7_resfi;
		public C12 f8_resk;
		public float f9_res_norm_x;
		public float f10_res_norm_y;
		public float f11_res_norm_z;
		public float f12_res_norm_w;
		public float f13_res_norm_fi;
		public float f14_res_norm_k;
	};
	unsafe public struct BnfTabla_ResGPS{
		public BnfFila_ResGPS* filas;
		public uint n;
	}

	internal class FuncionesC{
		[DllImport("ATcrt.dll")] unsafe public static extern void free_plist(uint k);
		[DllImport("infobinario.dll")] unsafe public static extern int lee_ficherobnf(System.IntPtr fichero, FicheroBnf *datos);
		[DllImport("infobinario.dll")] unsafe public static extern void free_filas(System.IntPtr filas);
		[DllImport("infobinario.dll")] unsafe public static extern int rellena_res_porfotos(BnfTabla_ResporFoto *tabla, int dec, uint llena_nombres, uint ncp,uint* orden_cp, uint* p_cp_acum,int4* mafp, CentroProy* centros,PuntoM* puntosM, float* L,float* L_norm,uint* pm_ppios, PuntoM* puntosA);
		[DllImport("infobinario.dll")] unsafe public static extern int rellena_res_porpuntos(BnfTabla_ResporPunto *tabla, int dec, uint llena_nombres, uint npm,uint* orden_pm, uint* pm_ppios,int2* p_en_cp, int4* mafp, uint ntot, CentroProy* centros,PuntoM* puntosM, float* L,float* L_norm, PuntoM* puntosA);
		[DllImport("infobinario.dll")] unsafe public static extern int rellena_res_apoyo(BnfTabla_ResApoyo *tabla, int dec, PuntoM* punpmA, uint npy, uint fijas,uint* pA_a_pM, float* Lp,float* Lp_norm, PuntoM* punpmC,uint npc,uint* pC_a_pM, float* Lpc, float* Lpc_norm);
		[DllImport("infobinario.dll")] unsafe public static extern int rellena_res_gpsins(BnfTabla_ResGPS* tabla, int decgps, int decins, GrupoGPSINS* grupos, uint ngrupos, uint* grupos_acum, PuntoGPSINS* gpss, float* Lgps, float* Lgps_norm, float* Lins, float* Lins_norm, float fccpi);
	}
}
}
