using System.Runtime.InteropServices;

namespace Calibracion{
	public class InterComCalibracion{
		public struct Valores1{		//float (casi) siempre vale
			public double Tx;
			public double Ty;
			public double giro;
			public double esc;
			public double esc_x;
			public double delta;
		}
		public struct ValoresExterna{
			public double X;
			public double Y;
			public double Z;
			public double W;
			public double PHI;
			public double K;
		}
		public struct ValoresInterna{
			public double f;
			public double x;
			public double y;
		}

		public struct ConfigDistorsion{
			public float semidiag;
			public byte modelo_poli;
			public byte modelo_asim;
			public byte condicion;
			public float r1;
			public uint param_radsim;
			public uint param_tansim;
			public uint param_asim1;
			public uint param_asim2;
		}

		public struct ConfigGrafico{
			public uint nx,ny;
			public uint rednx,npy;
			public uint redny,npx;
		}
		public struct ConfigSalida{
			public struct __0_{
				public System.IntPtr P_unip;
				public System.IntPtr P_unif;
				public System.IntPtr P_unit;
			}public __0_ General;
		}
		public class CConfigGrafico{public ConfigGrafico S;}

		unsafe public struct Buffer_to{
			public System.IntPtr id;
			public	int error_code;
			public char* pbase;
			public char *top;		//The allocated memory will exceed top
			public char *ptr;
			public char *backPtr;	//Point to the top of the allocated; for writing backwards. Actually, there is still one more uint above, set to 0.
			public uint flushedchars;	//need not be accessible by the user
			public uint flt_flags;
			public byte prec;	//negative values are not implemented, and I will likely never do.
			public sbyte fillchar;
			public sbyte maschar;	//normally '\0', '+' or ' '
		};

		[DllImport("ATcrt.dll", CallingConvention=CallingConvention.Cdecl)] unsafe public static extern int toopen(System.IntPtr fichero, Buffer_to* buf);
		[DllImport("ATcrt.dll", CallingConvention=CallingConvention.Cdecl)] unsafe public static extern void toclose(Buffer_to *buf);
		[DllImport("ATcrt.dll", CallingConvention=CallingConvention.Cdecl)] unsafe public static extern int towrite_string(Buffer_to *buf, sbyte* s);

		[DllImport("AjCalibracion.dll")]
		unsafe public static extern int mainCalibracion(System.IntPtr hwnd_main,void* log_file,uint log_level,  System.IntPtr foto, uint mar, System.IntPtr apoyo, uint apy,
																float ratio, uint calcula1, uint calculaE, uint calculaI, double* val1, double* valE, double* valI,
																ConfigDistorsion* config_distorsion, ConfigSalida Salida, ConfigGrafico config_grafico, int uni, System.IntPtr mensaje, uint idioma);
	}
}
