using System.Runtime.InteropServices;
using ControlesAt.SistemadeCoordenadas;

namespace Aerotri{
	unsafe public static class InterComAerotri{
		public struct Estimador{
			public byte _f_dens, _peso1, _p_precision;
			public byte dividir_r;
			public byte def_tau;
			public float par1, par2;
			public System.IntPtr f_dens, f_peso, p_precision;
			public float ksigma;
			public float kpeso;
		}
		public struct Estimador_complejo{
			public byte TipoUsuario;
			public Estimador Ef, Eapy, Egps, Eins;
		}
		public struct Precisiones{
			public float f;
			public float pXY, pZ;
			public float gpsXY, gpsZ;
			public float insWF, insK;
		};
		public struct Conjuntas{
			public byte xy;			//bool
			public byte XY;			//bool
			public byte planiZ;		//bool
			public Conjuntas(byte a, byte b, byte c){
				xy=a;
				XY=b;
				planiZ=c;
			}
		}
		public struct Profundidad{
			public byte uff, uf3,u33;
		}
		public struct Profundidades{
			public Profundidad elim,
									directo,
									inverso;
		}

		public struct Decimales{
			public sbyte f;
			public sbyte p;
			public sbyte gps;
			public sbyte ins;
		}
		public struct ConfigSalida{
			public const ushort MASK_SalidaFo=0x3F3F,
											MASK_SalidaF1=0x1F0F,
											MASK_InfR=0x3F,
											MASK_InfP=0x1FF,
											MASK_StdR=1,
											MASK_StdP=0xFF;
			public const byte MASK_FichDigi=0x1F,
										MASK_FichIMaster=0xF;
			public ushort SalidaF0;
			public ushort SalidaF1;
			public struct __0_{
				public byte idioma;
				public byte rel_paths;
				private short yy;
				public System.UInt32 uniim_l, uniim_m, uniim_h;
				public System.UInt32 unif_l, unif_m, unif_h;
				public System.UInt32 unit_l, unit_m, unit_h;
				public Decimales decres;
				public Decimales decajs;
				public sbyte decrot;
			}public __0_ General;
			public struct __6_{
				public byte nmin;	//mnimo n puntos para formar un par
				public byte modo;	//0: ppales; 1: secund., 2: todos los pares.
				public byte brev;
			}public __6_ ParesPasadas;
			public struct __4_{
				public byte flags;
				public System.IntPtr P_ruta1;
				public System.IntPtr P_ruta2;
				public float px;
				public float py;
			}public __4_ SalidaDigi;
			public struct __5_{
				public byte flags;
				public System.IntPtr P_ruta1;
				public System.IntPtr P_ruta2;
			}public __5_ SalidaImaster;
			public struct __1_{
				public ushort Residuos;
				public ushort ParamPrec;
			}public __1_ SalidaInf;
			public struct __2_{
				public ushort ResRed;
				public ushort Precisiones;
			}public __2_ SalidaStd;
			public struct __3_{
				private short xxx;	//255: igual que el principal
			}public __3_ SalidaPdf;
			public struct __7_{
				public void* hwnd;					//Para ir dibujando mientras se calcula, para clculos grandes.
				public byte ConfigDibujo;			//byte0: si se dibuja con los valores aproximados; byte1: si se dibuja con el resultado del ajuste alterno
				public System.IntPtr* cfilenames_main;	//Ficheros con las configuraciones, para leer en tiempo de ejecucin e incluir en el grfico
				public System.IntPtr* cfilenames_residuos;
			}public __7_ fich_dibujo;
		}
		public class CConfigSalida{//La C no es de "Clase" es de Chapuza. Para poder salvar uno de los varios
			public ConfigSalida S;//agujeros del lenguaje, el de poder pasar referencias a estructuras
									//(si est dentro de una clase no deja !!) y poder asignarlas hay que hacer esto.
		}							//Pero no hay que llamarle Chapuza, hay que llamarle encapsular.

		public struct ValoresAproximados{
			public byte usa_gps;	//0: no; 1: slo pasadas; 2: s.
			public byte force_mmcc;	//forces a plain least squares adjustment (not yet used)
			private const ushort yy=0;
			public uint hacha;
			public uint maximof;
			public uint mult_contra;
		}

		public struct Buffer_to{
			public System.IntPtr id;
			public	int error_code;
			public char* pbase;
			public char *top;		//The allocated memory will exceed top
			public char *ptr;
			public char *backPtr;	//Point to the top of the allocated; for writing backwards. Actually, there is still one more uint above, set to 0.
			public uint flushedchars;	//need not be accessible by the user
			public uint flt_flags;
			public struct Prec{
				sbyte absol;
				byte signi;
			}
			public Prec prec;
			public sbyte fillchar;
			public sbyte maschar;	//normally '\0', '+' or ' '
		}

		public struct Modos{
			public byte modo_ajuste;	//0, normal; 1, solo valores aproximados; 4, simulacin
			public byte modo_toma, modo_medida;
		}
		public struct Ficheros{
			public System.IntPtr fotos,
						aproximadas,
						apoyo,
						gpsins,
						camara;
			public byte generar;
		}
		public struct TipoFicheros{
			public byte tffot, tfapr, tfapy, tfgps, tfint,
							tdapr;
		}
		public struct DatosGPS{
			public byte tdgps, tdins;	//255 (Offset), 0,1,2
			public byte signoins;		//bool
		}
		public struct SistemaTrabajo{
			public uint nsistema;	//0 Rectangular, etc.
			public byte elipsoide;
			public float ondulacion;
			public ElipsoideOtro elip;
			public Tierra tierra;
			public ValoresSistemas valoressistemas; 
		}

		public struct Opciones{
			public byte unigiros;	//0 rad, 1 gon, 2 sex
			public byte reescribe_cpp;
			public byte estimador;		//De entre la lista de seleccionables
			public byte bgirok;	//Si un giro de 180 respecto al INS significa que la foto fue girada
			public byte fijas;
			public byte completo;
			public byte interp_gps;		//byte
			public byte interp_resgps;	//bool
			public byte escalaresiduos;
			public fixed float residuos_escala[20];
		}

		public struct AutoClibCheckeds{
			public byte f;
			public byte pp;
			public byte distorsion;
			public struct __0_{
				public byte radsim;
				public byte tansim;
				public byte asimetricas;
			}public __0_ componentes;
		}
		public struct AutoCalibTrabajo{
			public byte existe;
			public AutoClibCheckeds selected;
			public Calibracion.InterComCalibracion.ConfigDistorsion config_dist;
		}

		public struct SalidaTrabajo{
			public byte log_ajuste;
			public byte log_pdfs;
			private const ushort _x=0;
			public uint log_level;
			public byte muestra_html;
		}

		public struct Trabajo{
			public byte sensor;	//0, cnico; 1, modelo local (usar siempre 0)
			public Modos modos;
			public Ficheros ficheros;
			public TipoFicheros tipoficheros;
			public DatosGPS datosgps;
			public Conjuntas conjuntas;
			public AutoCalibTrabajo autocalib;
			public ValoresAproximados valoresaproximados;
			public Precisiones apriori;	//0 signfica texto vaco (o errneo)
			public Opciones opciones;
			public SistemaTrabajo sistema;
			public ConfigSalida configsalida;
			public SalidaTrabajo salidatrabajo;
		}

		public enum ATCalculaRelativaCodes{
			OK=0,
			pro_noopen=1,	//No se puede abrir el fichero de proceso
			error_ficherof,		//Error en la lectura del fichero de fotogramas
			unafoto,				//No hay ninguna foto o solamente una (con al menos tres puntos medidos)
			repetido,				//Hay una foto repetida / hay una foto con un punto repetido
			fewpoints,			//No hay ningn par de fotos con al menos 5 puntos en comn
			error_camara,		//Error en la lectura del fichero de interna

			partialerror,		//Algn ajuste lleg a dar error
			error_ajuste,		//Error en el ajuste (>10000*vmin)
			manyblocks,		//No es posible unir todos los fotogramas en un nico bloque

			minorerr_write=101 //Error en la escritura del fichero de valores aproximados
		};
		public enum CalculaAbsoluta{
			OK=0,
			UnknownError=-10,
			NadaqueCalcular=1,	//No hay nada que calcular
			error_ficherof,			//Error en la lectura del fichero de fotogramas
			error_ficheroint,		//Error en la lectura del fichero de cmara
			error_ficheroapr,		//Error en la lectura del fichero de valores aproximados
			error_ficheroapy,		//Error en la lectura del fichero de apoyo
			error_ficherogps,		//Error en la lectura del fichero de GPS
			internamala,			//El fichero de interna no se corresponde, por mucho, con el fichero de fotogramas

			demo_notallowed,		//En la versin demo. Sobrepasado el lmite de fotogramas
			fewpoints,				//Puntos insuficientes para calcular (menos de 3 puntos)
			bad,						//Error que no permite calcular (p. ej., un punto fuera de la Tierra);
			error_ajuste,				//Error en el ajuste del bloque
			fewcontrol_gps,		/*Se ha indicado fichero de apoyo o de GPS pero hay insuficientes puntos
								de unos u otros para definir un sistema de coordenadas 3D. Normalmente
								se debe a que se indica el fichero que no es o a una diferencia en los nombres
								(p.ej.  213 frente a 00213).
								Si la bandera APARAMS_flags0_Semilibre est a 1 se ignora esta circunstancia
								y el ajuste continua en un sistema total o parcialmente arbitrario. Por tanto
								si APARAMS_flags0_Semilibre est a 1 la funcin nunca devolver este cdigo.*/

			//>=100: El clculo se termin correctamente, pero hubo algn error
			minorerr_unknown=100,	//Error desconocido
			minorerr_write,				//Error en la escritura de algn fichero de resultados
		};

		public struct OpcionesFormato{
			public byte var_formato;	//Aerotri_ccpp: 0: sin marcar, 1: prm, 2: pym
											//PATB_ori: 0/1
		}

		[DllImport("kernel32.dll", CharSet = CharSet.Auto)] public static extern int GetLongPathName(string name,System.Text.StringBuilder longname,int length);

#if DEBUG
		[DllImport("ATcrtd.dll", CallingConvention=CallingConvention.Cdecl)] public static extern void free_plist(uint k);
		[DllImport("ATcrtd.dll", CallingConvention=CallingConvention.Cdecl)] public static extern void relative_path16(System.IntPtr relpath, uint buf_size, System.IntPtr pathref, System.IntPtr filename);

		[DllImport("ATcrtd.dll", CallingConvention=CallingConvention.Cdecl)] public static extern int toopen(System.IntPtr fichero, Buffer_to* buf);
		[DllImport("ATcrtd.dll", CallingConvention=CallingConvention.Cdecl)] public static extern void toclose(Buffer_to *buf);
		[DllImport("ATcrtd.dll", CallingConvention=CallingConvention.Cdecl)] public static extern int towrite_string(Buffer_to *buf, sbyte* s);
#else
		[DllImport("ATcrt.dll", CallingConvention=CallingConvention.Cdecl)] public static extern void free_plist(uint k);
		[DllImport("ATcrt.dll", CallingConvention=CallingConvention.Cdecl)] public static extern void relative_path16(System.IntPtr relpath, uint buf_size, System.IntPtr pathref, System.IntPtr filename);

		[DllImport("ATcrt.dll", CallingConvention=CallingConvention.Cdecl)] public static extern int toopen(System.IntPtr fichero, Buffer_to* buf);
		[DllImport("ATcrt.dll", CallingConvention=CallingConvention.Cdecl)] public static extern void toclose(Buffer_to *buf);
		[DllImport("ATcrt.dll", CallingConvention=CallingConvention.Cdecl)] public static extern int towrite_string(Buffer_to *buf, sbyte* s);
#endif
		[DllImport("aerotri_trabajos.dll", CallingConvention=CallingConvention.Cdecl)]	public static extern System.IntPtr get_relativa_params();
		[DllImport("aerotri_trabajos.dll", CallingConvention=CallingConvention.Cdecl)]	public static extern System.IntPtr get_absoluta_calldata();
		[DllImport("aerotri_trabajos.dll", CallingConvention=CallingConvention.Cdecl)]	public static extern void ATtrabajos_free(System.IntPtr p);

		[DllImport("aerotri_trabajos.dll", CallingConvention=CallingConvention.Cdecl)]	public static extern int lee_trabajoAT(System.IntPtr ficherot, Trabajo *trabajo);
		[DllImport("aerotri_trabajos.dll", CallingConvention=CallingConvention.Cdecl)]	public static extern void libera_trabajoAT(Trabajo *trabajo);
		[DllImport("aerotri_trabajos.dll", CallingConvention=CallingConvention.Cdecl)]	public static extern int escribe_trabajoAT(System.IntPtr ficherot, Trabajo *trabajo, uint modo);
		[DllImport("aerotri_trabajos.dll", CallingConvention=CallingConvention.Cdecl)]	public static extern int calcula_trabajoAT(System.IntPtr hwnd, int log_code, Trabajo *trabajo, uint allow_empty, System.IntPtr mensaje, uint idioma);

		[DllImport("aerotri_trabajos.dll", CallingConvention=CallingConvention.Cdecl)]	public static extern int prepara_trabajo_relativa(Trabajo *trabajo, System.IntPtr P_rparams);
		[DllImport("aerotri_trabajos.dll", CallingConvention=CallingConvention.Cdecl)]	public static extern int prepara_trabajo_absoluta(Trabajo *trabajo, System.IntPtr P_aparams, uint allow_empty);
		[DllImport("aerotri_trabajos.dll", CallingConvention=CallingConvention.Cdecl)]	public static extern void change_absparams(System.IntPtr aparams, uint kind, uint valor);
		[DllImport("aerotri_trabajos.dll", CallingConvention=CallingConvention.Cdecl)]	public static extern int calcula_relativa(System.IntPtr hwnd_main,int log_code,System.IntPtr P_rparams, void *pinfomalos, System.IntPtr mensaje, uint idioma);
		[DllImport("aerotri_trabajos.dll", CallingConvention=CallingConvention.Cdecl)]	public static extern int calcula_absoluta(System.IntPtr hwnd_main,int log_code,Buffer_to* log_file,System.IntPtr P_aparams, EditorD.InterComEditorD.FicheroBnf *fichbnf, System.IntPtr mensaje, uint idioma);

		[DllImport("transformacion.dll")] public static extern int transforma_terreno_a_local(System.IntPtr ficheroapr1, uint prm1, ControlesAt.SistemadeCoordenadas.Sistema* sis1, System.IntPtr ficheroapr2, uint prm2, uint escala, System.IntPtr mensaje, uint idioma);

		[DllImport("transfficheros.dll", CallingConvention=CallingConvention.Cdecl)] public static extern int Trficheros_fotogramas(System.IntPtr ficherof1,uint mar1, System.IntPtr ficherof2,uint mar2, System.IntPtr P_mensaje, uint idioma);
		[DllImport("transfficheros.dll", CallingConvention=CallingConvention.Cdecl)] public static extern int Trficheros_puntos(System.IntPtr ficherof1,uint apr1, System.IntPtr ficherof2,uint apr2, uint prec2, System.IntPtr P_mensaje, uint idioma);
		[DllImport("transfficheros.dll", CallingConvention=CallingConvention.Cdecl)] public static extern int Trficheros_ccpp(System.IntPtr ficherof1,uint apr1,uint signoins, System.IntPtr ficherof2,uint apr2, OpcionesFormato opts, System.IntPtr P_mensaje, uint idioma);
		[DllImport("transfficheros.dll", CallingConvention=CallingConvention.Cdecl)] public static extern int Trficheros_camara(System.IntPtr ficherof1,uint inm1, System.IntPtr ficherof2,uint inm2, System.IntPtr mensaje, uint idioma);
	}
}
