using System;
using System.Windows.Forms;
using System.Drawing;

namespace ControlesAt
{
	public struct Grados{
		public Int16 o;
		public UInt16 i,ii,f;	//La f son 4 digitos "packed" 00 00, aunque el cuarto lo desprecio
		public static Grados ToGrados(int milliseconds){
			Grados g;
			bool b;
			int r;

			if(milliseconds<0){b=true; milliseconds=-milliseconds;}
			else b=false;
			milliseconds=Math.DivRem(milliseconds,10,out r); g.f=(ushort)(r<<4);
			milliseconds=Math.DivRem(milliseconds,10,out r); g.f|=(ushort)(r<<8);
			milliseconds=Math.DivRem(milliseconds,10,out r); g.f|=(ushort)(r<<12);
			milliseconds=Math.DivRem(milliseconds,60,out r); g.ii=(ushort)r;
			g.o=(short)Math.DivRem(milliseconds,60,out r); g.i=(ushort)r;
			if(b) g.o=(short)-g.o;
			return g;
		}
		public static Grados ToGrados(double v){
			v*=3600*1000;
			if(v>0) v+=0.5;
			else if(v<0) v-=0.5;
			return ToGrados((int)v);
		}

		public int ToMilliseconds(){
			int v;
			v=((f>>4)&0xF);
			v+=((f>>8)&0xF)*10;
			v+=((f>>12)&0xF)*100;
			v+=ii*1000;
			v+=i*60*1000;
			if(o<0) v=-v;
			v+=o*3600*1000;
			return v;
		}
		public double ToDouble(){
			return (double)this.ToMilliseconds()/(double)(3600*1000);
		}
		public static UInt16 fraccion(string s){
			char[] c=s.ToCharArray();
			if(c.Length==0) return 0;
			UInt16 f;
			f=(ushort)((c[0]-'0')<<12);
			if(c.Length>1){
				f|=(ushort)((c[1]-'0')<<8);
			   if(c.Length>2){
				f|=(ushort)((c[2]-'0')<<4);
			}}
			return f;
		}
		public static string textofraccion(UInt16 f){
			return new string(new char[]{ (char)(((f>>12)&0xF)+'0'), (char)(((f>>8)&0xF)+'0'), (char)(((f>>4)&0xF)+'0') });
		}
	}
	public class LabelTextoGrado : LabelTexto{
		public LabelTextoGrado() : base(){}
		public LabelTextoGrado(short sep) : base(sep){}

		private ControlesAt.BaseLabel Labelo, Labeli, Labelii;
		private ControlesAt.IntegerTextPlano Ti,Tii,Tfraccion;
		private ControlesAt.FloatTextPlano To;
		protected override void CreaT(){
			base.CreaT();
			T.Size= new Size(84,19);
		}
		protected override void initializec(){
			To= new FloatTextPlano();	Labelo= new BaseLabel();
			Ti= new IntegerTextPlano();	Labeli= new BaseLabel();
			Tii= new IntegerTextPlano();	Labelii= new BaseLabel();
			Tfraccion= new IntegerTextPlano();
			//
			Labelo.RefLocation= new Point(18,0);	Labelo.Text="";		Labelo.TabIndex=1;
			Labeli.RefLocation= new Point(37,0);	Labeli.Text="'";		Labeli.TabIndex=3;
			Labelii.RefLocation= new Point(54,0);	Labelii.Text="''";		Labelii.TabIndex=5;
			To.Location=new Point(0,1);		To.Size=new Size(18,15);	To.TabIndex=0;
			Ti.Location=new Point(23,1);		Ti.Size=new Size(14,15);	Ti.TabIndex=2;
			Tii.Location=new Point(40,1);		Tii.Size=new Size(14,15);	Tii.TabIndex=4;
			Tfraccion.Location=new Point(59,1);	Tfraccion.Size=new Size(20,15);	Tfraccion.TabIndex=6;
			//
			T.TabStop=false;
			T.BackColor= System.Drawing.SystemColors.Window;
			T.Controls.AddRange(new Control[]{Labelo,Labeli,Labelii});
			T.Controls.AddRange(new Control[]{To,Ti,Tii,Tfraccion});
		}
		private new string Text;
		public Grados Valor{
			get{Grados grados;
				grados.o=Convert.ToInt16(To.Text);
				grados.i=Convert.ToUInt16(Ti.Text);
				grados.ii=Convert.ToUInt16(Tii.Text);
				grados.f=Grados.fraccion(Tfraccion.Text);
				return grados;
			}
			set{To.Text=value.o.ToString();
				Ti.Text=value.i.ToString();
				Tii.Text=value.ii.ToString();
				Tfraccion.Text=Grados.textofraccion(value.f);
			}
		}
	}
}
