using System;
using System.Windows.Forms;
using System.Drawing;
using ControlesAt;

namespace Aerotri{
using static Textos.Cods;

	public class FormtdGPS : ControlesAt.FormLabelMove	{
		private ControlesAt.BaseLabel Label2;
		private ControlesAt.BaseLabel Label14, Label15;
		private ControlesAt.BaseLabel Labelt0, LabeltO,
											Labelt1, Labelt2;
		internal new ContainerControl Panel1;
		internal RadioButton	Optgps0, OptgpsOffset, Optgps1, Optgps2;
		internal ContainerControl Panel2;
		internal RadioButton	Optins0, OptinsOffset, Optins1, Optins2;

		private RadioButton[] optgps, optins;
		internal static readonly string[] Strings={"O","0","1","2"};

		PanelAerotri PanelPadre;
		public FormtdGPS(PanelAerotri Form1) : base(Form1){
			InitializeComponent();
			PanelPadre=Form1;
		}

	#region InitializeComponent
		private void InitializeComponent()
		{
			Label2= new BaseLabel();
			Label14= new BaseLabel();
			Label15= new BaseLabel();
			Labelt0= new BaseLabel();
			LabeltO= new BaseLabel();
			Labelt1= new BaseLabel();
			Labelt2= new BaseLabel();
			Panel1= new ContainerControl();
			Optgps0= new RadioButton();		OptgpsOffset= new RadioButton();
			Optgps1= new RadioButton();		Optgps2= new RadioButton();
			Panel2= new ContainerControl();
			Optins0= new RadioButton();		OptinsOffset= new RadioButton();
			Optins1= new RadioButton();		Optins2= new RadioButton();

			optgps=new RadioButton[3];
			optins=new RadioButton[3];
			optgps[0]= Optgps0;		optins[0]=Optins0;
			optgps[1]= Optgps1;		optins[1]=Optins1;
			optgps[2]= Optgps2;		optins[2]=Optins2;
			//
			// Label2
			//
			Label2.Font= new Font("Franklin Gothic Medium", 11.25F, System.Drawing.FontStyle.Regular);
			Label2.TextAlign= new TwoDimAlignment(0.5F,0);
			Label2.RefLocation= new Point(144, 20);
			Label2.TabIndex= 3;
			//
			// Label14
			//
			Label14.Font= new Font("Franklin Gothic Medium", 11.25F, System.Drawing.FontStyle.Regular);
			Label14.TextAlign= new TwoDimAlignment(0.5F,0);
			Label14.RefLocation= new Point(56, 52);
			Label14.TabIndex= 4;
			Label14.Text= "GPS";
			//
			// Label15
			//
			Label15.Font= Label14.Font;
			Label15.TextAlign= new TwoDimAlignment(0.5F,0);
			Label15.RefLocation= new Point(232, 52);
			Label15.TabIndex= 5;
			Label15.Text= "INS";
			//
			// Labelt0...
			//
			Labelt0.Font= new Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular);
			Labelt0.TextAlign= new TwoDimAlignment(0.5F,0);
			LabeltO.Font=Labelt1.Font=Labelt2.Font= Labelt0.Font;
			LabeltO.TextAlign=Labelt1.TextAlign=Labelt2.TextAlign= Labelt0.TextAlign;
			//
			Labelt0.RefLocation= new Point(144, 84);		Labelt0.TabIndex= 8;
			LabeltO.RefLocation= new Point(144, 112);	LabeltO.TabIndex= 9;
			Labelt1.RefLocation= new Point(144, 140);		Labelt1.TabIndex= 10;
			Labelt2.RefLocation= new Point(144, 168);		Labelt2.TabIndex= 11;
			//
			// Panel1
			//
			Panel1.Controls.AddRange(optgps);
			//Panel1.Controls.Add(OptgpsOffset);
			Panel1.Location= new Point(42, 72);
			Panel1.Size= new Size(32, 124);
			Panel1.TabIndex= 6;
			//
			// Optgps0, 1...
			//
			Size optsize= new Size(24,24);
			Optgps0.Location= new Point(8, 8);		Optgps0.Size= optsize;		Optgps0.TabIndex= 0;
			OptgpsOffset.Location= new Point(8, 36);	Optgps1.Size= optsize;		Optgps1.TabIndex= 1;
			Optgps1.Location= new Point(8, 64);		Optgps1.Size= optsize;		Optgps1.TabIndex= 2;
			Optgps2.Location= new Point(8, 92);		Optgps2.Size= optsize;		Optgps2.TabIndex= 3;
			//
			// Panel2
			//
			Panel2.Controls.AddRange(optins);
			Panel2.Controls.Add(OptinsOffset);
			Panel2.Location= new Point(218, 72);
			Panel2.Size= new Size(32, 152);
			Panel2.TabIndex= 7;
			//
			// Optins0, 1...
			//
			Optins0.Location= new Point(8, 8);		Optins0.Size= optsize;		Optins0.TabIndex= 0;
			OptinsOffset.Location= new Point(8, 36); Optins1.Size= optsize;		Optins1.TabIndex= 1;
			Optins1.Location= new Point(8, 64);		Optins1.Size= optsize;		Optins1.TabIndex= 2;
			Optins2.Location= new Point(8, 92);		Optins2.Size= optsize;		Optins2.TabIndex= 3;
			//
			// Aceptar, Cancelar
			//
			Aceptar.Location= new Point(54, 212);
			Cancelar.Location= new Point(174, 212);
			//
			// FormtdGPS
			//
			this.ClientSize= new Size(288, 260);
			this.Controls.Add(this.Panel2);
			this.Controls.Add(this.Panel1);
			this.Controls.AddRange(new Control[]{
				Label2,
				Label14,	Label15,
				Labelt0,	LabeltO,
				Labelt1,	Labelt2
			});
		}
	#endregion

		protected override void OnLoad(EventArgs e){
			this.Top=PanelPadre.ParentForm.Top;
			this.Left=PanelPadre.ParentForm.Left + PanelPadre.ParentForm.Width-this.Width+20;

			if(PanelPadre.datosgps.tdgps==(byte)255) OptgpsOffset.Checked=true;		else optgps[PanelPadre.datosgps.tdgps].Checked=true;
			if(PanelPadre.datosgps.tdins==(byte)255) OptinsOffset.Checked=true;		else optins[PanelPadre.datosgps.tdins].Checked=true;

			base.OnLoad(e);
		}

		protected override void Aceptar_Click(object sender,System.EventArgs e){
			byte i,j;
			if(OptgpsOffset.Checked){
				i=PanelPadre.datosgps.tdgps=(byte)255;
			}else{
				for(i=0;i<3;i++){
				 if(optgps[i].Checked){
					PanelPadre.datosgps.tdgps= i;
					break;
				}}
			}
			if(OptinsOffset.Checked)
				j=PanelPadre.datosgps.tdins=(byte)255;
			else{
				for(j=0;j<3;j++){
				 if(optins[j].Checked){
					PanelPadre.datosgps.tdins= j;
					break;
				}}
			}
			this.Hide();
		}

		protected override void update_idioma(){
			base.update_idioma();
			Label2.Text=get_texto(Errores_sistemticos_GPS);
			Labelt0.Text=get_texto(Sin_errores_0);
			LabeltO.Text=get_texto(Permanente_Offset);
			Labelt1.Text=get_texto(Constante_1);
			Labelt2.Text=get_texto(Lineal_2);
		}
		string get_texto(Textos.Cods cod){return Textos.get_texto(cod,idioma);}
	}
}
